/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.build.widget.PieceSlot;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.imports.ImportAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class Importer {
    protected ImportAction action;
    protected File file;

    protected static void insertComponent(Buildable child, Buildable parent) {
        child.build(null);
        if (child instanceof PieceSlot) {
            ((PieceSlot)child).updateGpId(GameModule.getGameModule());
        }
        child.addTo(parent);
        parent.add(child);
    }

    protected Map getMainMap() {
        return GameModule.getGameModule().getAllDescendantComponentsOf(Map.class).iterator().next();
    }

    protected LayeredPieceCollection getLayeredPieceCollection() {
        LayeredPieceCollection collection;
        Map map = this.getMainMap();
        List<LayeredPieceCollection> l = map.getComponentsOf(LayeredPieceCollection.class);
        if (l.isEmpty()) {
            collection = new LayeredPieceCollection();
            Importer.insertComponent(collection, map);
            collection.setAttribute("property", "Layer");
        } else {
            assert (l.size() == 1);
            collection = l.get(0);
        }
        return collection;
    }

    protected void load(File f) throws IOException {
        this.file = f;
    }

    public abstract void writeToArchive() throws IOException;

    public void importFile(ImportAction action, File f) throws IOException {
        this.action = action;
        this.load(f);
    }

    public static String stripExtension(String s) {
        if (s.equals(".") || s.equals("..")) {
            return s;
        }
        int index = s.lastIndexOf(46);
        int pathIdx = s.lastIndexOf(File.separatorChar);
        if (index == -1 || index < pathIdx) {
            return s;
        }
        return s.substring(0, index);
    }

    public static String readWindowsFileName(InputStream in) throws IOException {
        char ch;
        StringBuilder sb = new StringBuilder();
        do {
            if ((ch = (char)in.read()) == '\\') {
                sb.append(File.separatorChar);
                continue;
            }
            if (ch == '\u0000') continue;
            sb.append(ch);
        } while (ch != '\u0000');
        return sb.toString();
    }

    public static String readNullTerminatedString(InputStream in, int maxLen) throws IOException {
        StringBuilder sb = maxLen == 0 ? new StringBuilder() : new StringBuilder(maxLen);
        for (int i = 0; maxLen == 0 || i < maxLen; ++i) {
            char ch = (char)in.read();
            if (ch >= ' ' && ch <= '~') {
                sb.append(ch);
                continue;
            }
            if (ch == '\u0000') break;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String readNullTerminatedString(InputStream in) throws IOException {
        return Importer.readNullTerminatedString(in, 0);
    }

    public static String getUniqueImageFileName(String s, String ext) {
        Object t = s;
        int index = 0;
        ArchiveWriter writer = GameModule.getGameModule().getArchiveWriter();
        try {
            while (writer.contains(writer.getImagePrefix() + (String)t + ext)) {
                t = s + "(" + ++index + ")";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (String)t + ext;
    }

    public static String getUniqueImageFileName(String s) {
        return Importer.getUniqueImageFileName(s, ".png");
    }

    public static String getFileName(String s) {
        if (s.equals(".") || s.equals("..")) {
            return s;
        }
        int pathIdx = s.lastIndexOf(File.separatorChar);
        return s.substring(pathIdx + 1);
    }

    public static String getExtension(String s) {
        if (s.equals(".") || s.equals("..")) {
            return "";
        }
        int extIdx = s.lastIndexOf(46);
        int pathIdx = s.lastIndexOf(File.separatorChar);
        if (extIdx == -1 || extIdx < pathIdx || extIdx >= s.length() - 1) {
            return "";
        }
        return s.substring(extIdx + 1);
    }

    public static String forceExtension(String s, String ext) {
        if (s.equals(".") || s.equals("..")) {
            return s;
        }
        return Importer.stripExtension(s) + "." + ext;
    }

    public abstract boolean isValidImportFile(File var1) throws IOException;
}

