/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.DieManager;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.i18n.Resources;
import org.apache.commons.lang3.ArrayUtils;

public class InternetDiceButton
extends DiceButton
implements GameComponent,
CommandEncoder {
    protected static DieManager dieManager;
    private static final String COMMAND_PREFIX = "SEMAIL\t";
    public static final String DETAILS = "rollDetails";

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.InternetDiceButton.component_type");
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        Class<?>[] c = super.getAttributeTypes();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != DiceButton.ReportFormatConfig.class) continue;
            c[i] = InternetReportFormatConfig.class;
        }
        return c;
    }

    @Override
    protected void DR() {
        this.reportFormat.setProperty("name", this.getLocalizedConfigureName());
        dieManager.roll(this.nDice, this.nSides, this.plus, this.reportTotal, this.getLocalizedConfigureName(), this.reportFormat);
    }

    @Override
    public void addTo(Buildable parent) {
        this.initDieManager();
        dieManager.addDieButton(this);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        super.addTo(parent);
    }

    protected void initDieManager() {
        if (dieManager == null) {
            dieManager = new DieManager();
            dieManager.build(null);
        }
    }

    @Override
    public void removeFrom(Buildable b) {
        dieManager.removeDieButton(this);
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        super.removeFrom(b);
    }

    @Override
    public void setup(boolean gameStarting) {
    }

    @Override
    public Command getRestoreCommand() {
        return new SetSecondaryEmail(dieManager.getServer().getSecondaryEmail());
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        return new SetSecondaryEmail(command.substring(COMMAND_PREFIX.length()));
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof SetSecondaryEmail)) {
            return null;
        }
        return COMMAND_PREFIX + ((SetSecondaryEmail)c).msg;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.html", "InternetDiceButton");
    }

    public static class InternetReportFormatConfig
    extends DiceButton.ReportFormatConfig {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            FormattedStringConfigurer config = (FormattedStringConfigurer)super.getConfigurer(c, key, name);
            config.setOptions((String[])ArrayUtils.add((Object[])config.getOptions(), (Object)InternetDiceButton.DETAILS));
            return config;
        }
    }

    private static class SetSecondaryEmail
    extends Command {
        private final String msg;

        private SetSecondaryEmail(String s) {
            this.msg = s;
        }

        @Override
        protected void executeCommand() {
            dieManager.setSecondaryEmail(this.msg);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

