/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractFolder;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.GlobalCommandTarget;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.FormattedStringExpression;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

public class DeckGlobalKeyCommand
extends MassKeyCommand {
    public DeckGlobalKeyCommand() {
        this.globalCommand = new DeckGlobalCommand(this);
        this.globalCommand.setReportSingle(true);
        this.setConfigureName("");
        this.setShowDisabledOptions(false);
    }

    public DeckGlobalKeyCommand(String code) {
        this();
        this.decode(code);
    }

    public DeckGlobalKeyCommand(String code, PropertySource source) {
        this(code);
        this.propertySource = source;
        this.globalCommand.setPropertySource(source);
    }

    public DeckGlobalKeyCommand(MassKeyCommand gkc) {
        super(gkc);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DeckGlobalKeyCommand.component_type");
    }

    @Override
    public GlobalCommandTarget.GKCtype getGKCtype() {
        return GlobalCommandTarget.GKCtype.DECK;
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        if (parent instanceof Map) {
            this.map = (Map)parent;
        }
        if (parent instanceof PropertySource) {
            this.propertySource = (PropertySource)((Object)parent);
        }
        ((DrawPile)parent).addGlobalKeyCommand(this);
        this.globalCommand.setPropertySource(this.propertySource);
    }

    @Override
    public void removeFrom(Buildable parent) {
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        ((DrawPile)parent).removeGlobalKeyCommand(this);
    }

    public KeyCommand getKeyCommand(Deck deck) {
        return new DeckKeyCommand(this.getLocalizedConfigureName(), null, deck);
    }

    @Override
    public PieceFilter getFilter() {
        if (this.propertiesFilter == null || this.propertiesFilter.getExpression() == null || this.propertiesFilter.getExpression().length() == 0) {
            return null;
        }
        return super.getFilter();
    }

    public void apply(Deck deck) {
        GameModule.getGameModule().sendAndLog(((DeckGlobalCommand)this.globalCommand).apply(deck, this.getFilter()));
    }

    public String encode() {
        SequenceEncoder se = new SequenceEncoder('|');
        se.append(this.getConfigureName()).append(this.getAttributeValueString("hotkey")).append(this.getAttributeValueString("filter")).append(this.getAttributeValueString("deckCount")).append(this.getAttributeValueString("reportFormat")).append(this.getLocalizedConfigureName()).append(this.getAttributeValueString("target")).append(this.getAttributeValueString("reportSingle"));
        return se.getValue();
    }

    public void decode(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, '|');
        this.setConfigureName(sd.nextToken(""));
        this.setAttribute("hotkey", sd.nextNamedKeyStroke('A'));
        this.setAttribute("filter", sd.nextToken(null));
        this.setAttribute("deckCount", sd.nextToken("0"));
        this.setAttribute("reportFormat", sd.nextToken(""));
        this.localizedName = sd.nextToken(this.getConfigureName());
        this.setAttribute("target", sd.nextToken(""));
        this.setAttribute("reportSingle", sd.nextBoolean(true));
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.menu_command"), Resources.getString("Editor.GlobalKeyCommand.global_key_command"), Resources.getString("Editor.GlobalKeyCommand.pre_select"), Resources.getString("Editor.DeckGlobalKeyCommand.matching_properties"), Resources.getString("Editor.DeckGlobalKeyCommand.affects"), Resources.getString("Editor.report_format"), Resources.getString("Editor.MassKey.suppress")};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", "hotkey", "target", "filter", "deckCount", "reportFormat", "reportSingle"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, NamedKeyStroke.class, GlobalCommandTarget.class, PropertyExpression.class, DeckPolicyConfig2.class, MassKeyCommand.ReportFormatConfig.class, Boolean.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String key) {
        if (key.equals("target")) {
            return () -> false;
        }
        return () -> true;
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> l = new ArrayList<String>(super.getExpressionList());
        l.add(this.propertiesFilter.getExpression());
        return l;
    }

    @Override
    public List<String> getFormattedStringList() {
        ArrayList<String> l = new ArrayList<String>(super.getFormattedStringList());
        l.add(this.reportFormat.getFormat());
        return l;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>(super.getNamedKeyStrokeList());
        l.add(NamedHotKeyConfigurer.decode(this.getAttributeValueString("hotkey")));
        return l;
    }

    public static class DeckGlobalCommand
    extends GlobalCommand {
        public DeckGlobalCommand(RecursionLimiter.Loopable l) {
            super(l);
        }

        @Override
        public String getComponentTypeName() {
            return "Deck Global Command";
        }

        public Command apply(Deck d, PieceFilter filter) {
            Command c;
            String howManyFromDeck = this.getSelectFromDeckExpression();
            if ("-1".equals(howManyFromDeck)) {
                this.setSelectFromDeck(-1);
            } else if ("0".equals(howManyFromDeck)) {
                this.setSelectFromDeck(0);
            } else {
                int deckNum;
                FormattedStringExpression deckExpression = new FormattedStringExpression(howManyFromDeck);
                String deckVal = deckExpression.tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.fixed_number_of_pieces");
                deckVal = Expression.createExpression(deckVal).tryEvaluate(this.source, (Auditable)this.owner, "Editor.GlobalKeyCommand.fixed_number_of_pieces");
                try {
                    deckNum = Integer.parseInt(deckVal);
                }
                catch (NumberFormatException e) {
                    deckNum = 0;
                }
                this.setSelectFromDeck(Math.max(0, deckNum));
            }
            String reportText = this.reportFormat.getText(this.source, (Auditable)this, "Editor.report_format");
            if (reportText.length() > 0) {
                c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + reportText);
                c.execute();
            } else {
                c = new NullCommand();
            }
            GlobalCommand.Visitor visitor = new GlobalCommand.Visitor(this, c, filter, this.keyStroke);
            DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(visitor);
            dispatcher.accept(d);
            visitor.getTracker().repaint();
            c = visitor.getCommand();
            return c;
        }
    }

    class DeckKeyCommand
    extends KeyCommand {
        private static final long serialVersionUID = 1L;
        protected Deck deck;

        public DeckKeyCommand(String name, KeyStroke key, Deck deck) {
            super(name, key, (GamePiece)deck);
            this.deck = deck;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeckGlobalKeyCommand.this.apply(this.deck);
        }
    }

    public static class DeckPolicyConfig2
    extends MassKeyCommand.DeckPolicyConfig {
        public DeckPolicyConfig2() {
            this.typeConfig.setValidValues(new String[]{"All pieces", "Fixed number of pieces"}, new String[]{"Editor.GlobalKeyCommand.all_pieces", "Editor.GlobalKeyCommand.fixed_number_of_pieces"});
        }
    }
}

