/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AbstractFolder;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameState;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.ChangePropertyButton;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.NotNullConfigureName;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.TemporaryToolBar;
import VASSAL.tools.ToolBarComponent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JToolBar;

public class GlobalProperty
extends AbstractConfigurable
implements ToolBarComponent,
GameComponent,
CommandEncoder,
PropertySource,
MutableProperty {
    public static final String NAME = "name";
    public static final String INITIAL_VALUE = "initialValue";
    public static final String DESCRIPTION = "description";
    public static final String NUMERIC = "isNumeric";
    public static final String MIN_VALUE = "min";
    public static final String MAX_VALUE = "max";
    public static final String WRAP = "wrap";
    protected static final String COMMAND_PREFIX = "GlobalProperty\t";
    protected TemporaryToolBar tempToolbar = new TemporaryToolBar();
    protected String description = "";
    protected String initialValue = "";
    protected boolean numeric;
    protected String minValue;
    protected String maxValue;
    protected boolean wrap;
    protected VisibilityCondition numericVisibility;
    protected FormattedString format = new FormattedString();
    protected PropertySource propertySource;
    protected MutableProperty.Impl property = new MutableProperty.Impl("", this);
    protected MutablePropertiesContainer parentContainer;

    public GlobalProperty() {
        this.numericVisibility = this::isNumeric;
    }

    public GlobalProperty(GlobalProperty p) {
        this();
        this.setConfigureName(p.getConfigureName());
        this.description = p.description;
        this.initialValue = p.initialValue;
        this.numeric = p.numeric;
        this.minValue = p.minValue;
        this.maxValue = p.maxValue;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.GlobalProperty.initial_value"), Resources.getString("Editor.description_label"), Resources.getString("Editor.GlobalProperty.is_numeric"), Resources.getString("Editor.GlobalProperty.minimum_value"), Resources.getString("Editor.GlobalProperty.maximum_value"), Resources.getString("Editor.GlobalProperty.wrap_around")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, Boolean.class, String.class, String.class, Boolean.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, INITIAL_VALUE, DESCRIPTION, NUMERIC, MIN_VALUE, MAX_VALUE, WRAP};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
            this.property.setPropertyName(this.getConfigureName());
        } else if (INITIAL_VALUE.equals(key)) {
            this.initialValue = (String)value;
            if (this.initialValue == null) {
                this.initialValue = "";
            }
            this.property.setPropertyValue(this.initialValue);
        } else if (DESCRIPTION.equals(key)) {
            this.description = (String)value;
        } else if (NUMERIC.equals(key)) {
            this.numeric = Boolean.TRUE.equals(value) || "true".equals(value);
        } else if (MIN_VALUE.equals(key)) {
            this.minValue = (String)value;
        } else if (MAX_VALUE.equals(key)) {
            this.maxValue = (String)value;
        } else if (WRAP.equals(key)) {
            this.wrap = Boolean.TRUE.equals(value) || "true".equals(value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (INITIAL_VALUE.equals(key)) {
            return this.initialValue;
        }
        if (DESCRIPTION.equals(key)) {
            return this.description;
        }
        if (NUMERIC.equals(key)) {
            return String.valueOf(this.numeric);
        }
        if (MIN_VALUE.equals(key)) {
            return String.valueOf(this.minValue);
        }
        if (MAX_VALUE.equals(key)) {
            return String.valueOf(this.maxValue);
        }
        if (WRAP.equals(key)) {
            return String.valueOf(this.wrap);
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of(MIN_VALUE, MAX_VALUE, WRAP).contains(name)) {
            return this.numericVisibility;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.property.removeFromContainer();
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalProperties.html");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{ChangePropertyButton.class};
    }

    @Override
    public void addTo(Buildable parent) {
        GameModule gm;
        GameState gs;
        this.validator = new NotNullConfigureName(this);
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        if (parent != null) {
            this.parentContainer = (MutablePropertiesContainer)((Object)parent);
            this.property.addTo(this.parentContainer);
            this.tempToolbar.setDelegate((ToolBarComponent)((Object)parent));
            this.propertySource = (PropertySource)((Object)parent);
        }
        if (!(gs = (gm = GameModule.getGameModule()).getGameState()).getGameComponents().contains(this)) {
            gs.addGameComponent(this);
            gm.addCommandEncoder(this);
            this.setAllAttributesUntranslatable();
        }
    }

    @Override
    public JToolBar getToolBar() {
        return this.tempToolbar.getToolBar();
    }

    @Override
    public void setup(boolean gameStarting) {
        if (!gameStarting) {
            this.property.setPropertyValue(this.initialValue);
        }
    }

    @Override
    public Command getRestoreCommand() {
        return new SetGlobalProperty(this, "", this.property.getPropertyValue());
    }

    @Override
    public Command decode(String command) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(command, ';');
        String prefix = sd.nextToken("");
        if (!prefix.equals(COMMAND_PREFIX)) {
            return null;
        }
        String propertyId = sd.nextToken("");
        if (!propertyId.equals(this.getPropertyId())) {
            return null;
        }
        String newValue = sd.nextToken("");
        String containerId = sd.nextToken("");
        if (containerId.length() != 0 && !containerId.equals(this.parentContainer.getMutablePropertiesContainerId())) {
            return null;
        }
        return new SetGlobalProperty(this, this.property.getPropertyValue(), newValue);
    }

    protected String getPropertyId() {
        return this.getConfigureName();
    }

    protected String getContainerId() {
        return this.parentContainer == null ? "" : this.parentContainer.getMutablePropertiesContainerId();
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof SetGlobalProperty)) {
            return null;
        }
        SetGlobalProperty sgp = (SetGlobalProperty)c;
        if (!sgp.getTargetName().equals(this.getPropertyId())) {
            return null;
        }
        if (!this.getContainerId().equals(sgp.getProperty().getContainerId())) {
            return null;
        }
        SequenceEncoder se = new SequenceEncoder(COMMAND_PREFIX, ';');
        se.append(this.getPropertyId()).append(sgp.newValue).append(this.getContainerId());
        return se.getValue();
    }

    public int getMaxValue() {
        int max = 100;
        if (this.maxValue != null) {
            this.format.setFormat(this.maxValue);
            try {
                max = Integer.parseInt(this.format.getText((PropertySource)this, (Auditable)this, "Editor.GlobalProperty.minimum_value"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return max;
    }

    public int getMinValue() {
        int min = 0;
        if (this.minValue != null) {
            this.format.setFormat(this.minValue);
            try {
                min = Integer.parseInt(this.format.getText((PropertySource)this, (Auditable)this, "Editor.GlobalProperty.maximum_value"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return min;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getProperty(Object key) {
        return this.propertySource == null ? null : this.propertySource.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        return this.propertySource == null ? null : this.propertySource.getLocalizedProperty(key);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GlobalProperty.component_type");
    }

    @Override
    public void addMutablePropertyChangeListener(PropertyChangeListener l) {
        this.property.addMutablePropertyChangeListener(l);
    }

    @Override
    public void removeMutablePropertyChangeListener(PropertyChangeListener l) {
        this.property.removeMutablePropertyChangeListener(l);
    }

    public void setPropertyName(String name) {
        this.property.setPropertyName(name);
    }

    @Override
    public Command setPropertyValue(String newValue) {
        return this.property.setPropertyValue(newValue);
    }

    @Override
    public String getPropertyValue() {
        return this.property.getPropertyValue();
    }

    @Override
    public MutablePropertiesContainer getParent() {
        return this.parentContainer;
    }

    @Override
    public List<String> getExpressionList() {
        return List.of(this.initialValue, this.minValue, this.maxValue);
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.property.getName());
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.description);
    }

    public static class SetGlobalProperty
    extends Command {
        protected String newValue;
        protected String oldValue;
        protected GlobalProperty target;
        protected String targetName;

        public SetGlobalProperty(GlobalProperty target, String oldV, String newV) {
            this.oldValue = oldV;
            this.newValue = newV;
            this.target = target;
        }

        public String getTargetName() {
            if (this.target == null) {
                return "";
            }
            String targetName = this.target.getPropertyId();
            return targetName == null ? "" : targetName;
        }

        public GlobalProperty getProperty() {
            return this.target;
        }

        @Override
        protected void executeCommand() {
            this.target.property.setPropertyValue(this.newValue);
        }

        @Override
        protected Command myUndoCommand() {
            return new SetGlobalProperty(this.target, this.newValue, this.oldValue);
        }
    }
}

