/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.chat.Compressor;
import VASSAL.chat.InviteCommand;
import VASSAL.chat.InviteEncoder;
import VASSAL.chat.LockableChatServerConnection;
import VASSAL.chat.LockableRoom;
import VASSAL.chat.MainRoomChecker;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.PrivateChatEncoder;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.Room;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.SoundEncoder;
import VASSAL.chat.SynchEncoder;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.node.LockableNodeRoomControls;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.NodePlayer;
import VASSAL.chat.node.NodeRoom;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.InviteAction;
import VASSAL.chat.ui.KickAction;
import VASSAL.chat.ui.LockableRoomTreeRenderer;
import VASSAL.chat.ui.PrivateMessageAction;
import VASSAL.chat.ui.RoomInteractionControlsInitializer;
import VASSAL.chat.ui.SendSoundAction;
import VASSAL.chat.ui.ShowProfileAction;
import VASSAL.chat.ui.SimpleStatusControlsInitializer;
import VASSAL.chat.ui.SynchAction;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.i18n.Resources;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.version.VersionUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;

public class NodeClient
implements LockableChatServerConnection,
PlayerEncoder,
ChatControlsInitializer,
SocketWatcher {
    public static final String ZIP_HEADER = "!ZIP!";
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected NodePlayer me;
    protected SimpleRoom currentRoom;
    protected String defaultRoomName = "Main Room";
    protected NodeRoom[] allRooms = new NodeRoom[0];
    protected String moduleName;
    protected String playerId;
    protected MainRoomChecker checker = new MainRoomChecker();
    protected int compressionLimit = 1000;
    protected CommandEncoder encoder;
    protected RoomInteractionControlsInitializer roomControls;
    protected SimpleStatusControlsInitializer playerStatusControls;
    protected SoundEncoder soundEncoder;
    protected PrivateChatEncoder privateChatEncoder;
    protected SynchEncoder synchEncoder;
    protected InviteEncoder inviteEncoder;
    protected PropertyChangeListener nameChangeListener;
    protected PropertyChangeListener profileChangeListener;
    protected NodeRoom pendingSynchToRoom;
    private SocketHandler sender;
    protected final String host;
    protected final int port;
    protected final WelcomeMessageServer welcomer;

    public NodeClient(String moduleName, String playerId, CommandEncoder encoder, String host, int port, WelcomeMessageServer welcomer) {
        this.host = host;
        this.port = port;
        this.encoder = encoder;
        this.welcomer = welcomer;
        this.playerId = playerId;
        this.moduleName = moduleName;
        this.me = new NodePlayer(playerId);
        this.roomControls = new LockableNodeRoomControls(this);
        this.roomControls.addPlayerActionFactory(ShowProfileAction.factory());
        this.roomControls.addPlayerActionFactory(SynchAction.factory(this));
        PrivateChatManager privateChatManager = new PrivateChatManager(this);
        this.roomControls.addPlayerActionFactory(PrivateMessageAction.factory(this, privateChatManager));
        this.roomControls.addPlayerActionFactory(SendSoundAction.factory(this, Resources.getString("Chat.send_wakeup"), "wakeUpSound", "phone1.wav"));
        this.roomControls.addPlayerActionFactory(InviteAction.factory(this));
        this.roomControls.addPlayerActionFactory(KickAction.factory(this));
        this.playerStatusControls = new SimpleStatusControlsInitializer(this);
        this.synchEncoder = new SynchEncoder(this, this);
        this.privateChatEncoder = new PrivateChatEncoder(this, privateChatManager);
        this.soundEncoder = new SoundEncoder(this);
        this.inviteEncoder = new InviteEncoder(this);
        this.nameChangeListener = e -> {
            SimplePlayer p = (SimplePlayer)this.getUserInfo();
            p.setName((String)e.getNewValue());
            this.setUserInfo(p);
        };
        this.profileChangeListener = e -> {
            SimplePlayer p = (SimplePlayer)this.getUserInfo();
            SimpleStatus s = (SimpleStatus)p.getStatus();
            s = new SimpleStatus(s.isLooking(), s.isAway(), (String)e.getNewValue(), s.getClient(), s.getIp(), s.getModuleVersion(), s.getCrc(), s.getCombinedCrc());
            p.setStatus(s);
            this.setUserInfo(p);
        };
    }

    @Override
    public void setConnected(boolean connect) {
        if (connect) {
            if (!this.isConnected()) {
                try {
                    NodePlayer oldPlayer = this.me;
                    this.me = new NodePlayer(this.playerId);
                    this.setUserInfo(oldPlayer);
                    this.initializeConnection();
                    Command welcomeMessage = this.welcomer.getWelcomeMessage();
                    if (welcomeMessage != null) {
                        welcomeMessage.execute();
                    }
                    this.registerNewConnection();
                }
                catch (IOException e) {
                    this.propSupport.firePropertyChange("Status", null, Resources.getString("Chat.unable_to_establish", e.getMessage()));
                }
            }
        } else {
            if (this.isConnected()) {
                this.closeConnection();
            }
            this.currentRoom = null;
            this.allRooms = new NodeRoom[0];
        }
        this.propSupport.firePropertyChange("Connected", null, this.isConnected() ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerNewConnection() {
        NodeClient nodeClient = this;
        synchronized (nodeClient) {
            String username;
            if (this.sender == null) {
                return;
            }
            String path = new SequenceEncoder(this.moduleName, '/').append(this.defaultRoomName).getValue();
            this.send(Protocol.encodeRegisterCommand(this.me.getId(), path, new PropertiesEncoder(this.me.toProperties()).getStringValue()));
            if (GameModule.getGameModule() != null && (username = (String)GameModule.getGameModule().getPrefs().getValue("Login")) != null) {
                this.send(Protocol.encodeLoginCommand(username));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeConnection() throws UnknownHostException, IOException {
        Socket s = new Socket(this.host, this.port);
        NodeClient nodeClient = this;
        synchronized (nodeClient) {
            this.sender = new SocketHandler(s, this);
            this.sender.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() {
        SocketHandler s;
        NodeClient nodeClient = this;
        synchronized (nodeClient) {
            s = this.sender;
            this.sender = null;
        }
        s.close();
    }

    @Override
    public boolean isConnected() {
        return this.sender != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void socketClosed(SocketHandler handler) {
        NodeClient nodeClient = this;
        synchronized (nodeClient) {
            if (this.sender != null) {
                this.propSupport.firePropertyChange("Status", null, Resources.getString("Server.lost_connection"));
                this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
                this.propSupport.firePropertyChange("Connection Lost", null, Boolean.TRUE);
                this.sender = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String command) {
        NodeClient nodeClient = this;
        synchronized (nodeClient) {
            this.sender.writeLine(command);
        }
    }

    public void setDefaultRoomName(String defaultRoomName) {
        this.defaultRoomName = defaultRoomName;
    }

    @Override
    public String getDefaultRoomName() {
        return this.defaultRoomName;
    }

    @Override
    public boolean isDefaultRoom(Room r) {
        return r != null && r.getName().equals(this.getDefaultRoomName());
    }

    protected void sendStats() {
        if (this.isConnected()) {
            this.send(Protocol.encodeStatsCommand(new PropertiesEncoder(this.me.toProperties()).getStringValue()));
        }
    }

    @Override
    public void sendToOthers(Command c) {
        this.sendToOthers(this.encoder.encode(c));
    }

    public void sendToAll(String msg) {
        if (this.currentRoom != null) {
            String path = new SequenceEncoder(this.moduleName, '/').append(this.currentRoom.getName()).getValue();
            this.forward(path, msg);
        }
    }

    public void forward(String receipientPath, String msg) {
        if (this.isConnected() && this.currentRoom != null && msg != null) {
            if (((String)(msg = this.checker.filter((String)msg, this.defaultRoomName, this.currentRoom.getName()))).length() > this.compressionLimit) {
                try {
                    msg = ZIP_HEADER + Base64.encodeBase64String((byte[])Compressor.compress(((String)msg).getBytes(StandardCharsets.UTF_8)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.send(Protocol.encodeForwardCommand(receipientPath, (String)msg));
        }
    }

    public void sendToOthers(String msg) {
        if (this.currentRoom != null) {
            String path = new SequenceEncoder(this.moduleName, '/').append(this.currentRoom.getName()).append("~" + this.me.getId()).getValue();
            this.forward(path, msg);
        }
    }

    @Override
    public void sendTo(Player recipient, Command c) {
        String path = new SequenceEncoder(this.moduleName, '/').append("*").append(recipient.getId()).getValue();
        this.forward(path, this.encoder.encode(c));
    }

    @Override
    public void doKick(Player kickee) {
        this.send(Protocol.encodeKickCommand(kickee.getId()));
    }

    @Override
    public boolean isKickable(Player kickee) {
        String owner;
        Room room;
        return kickee != null && (room = this.getRoom()) instanceof LockableRoom && ((LockableRoom)((Object)room)).isLocked() && room instanceof NodeRoom && ((NodeRoom)room).contains(kickee) && (owner = ((NodeRoom)room).getOwner()) != null && owner.equals(this.getUserInfo().getId()) && !owner.equals(kickee.getId());
    }

    @Override
    public boolean isInvitable(Player invitee) {
        String owner;
        Room room;
        return invitee != null && (room = this.getRoom()) instanceof NodeRoom && !((NodeRoom)room).contains(invitee) && (owner = ((NodeRoom)room).getOwner()) != null && owner.equals(this.getUserInfo().getId()) && !owner.equals(invitee.getId());
    }

    @Override
    public void sendInvite(Player invitee) {
        this.sendTo(invitee, new InviteCommand(this.me.getName(), this.me.getId(), this.getRoom().getName()));
    }

    @Override
    public void doInvite(String playerId, String roomName) {
        for (Room room : this.getAvailableRooms()) {
            String owner;
            if (!room.getName().equals(roomName) || !(room instanceof NodeRoom) || (owner = ((NodeRoom)room).getOwner()) == null || !owner.equals(playerId)) continue;
            this.setRoom(room, playerId);
            return;
        }
    }

    @Override
    public Room getRoom() {
        return this.currentRoom;
    }

    @Override
    public Room[] getAvailableRooms() {
        return this.allRooms;
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(propertyName, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    @Override
    public Player getUserInfo() {
        return this.me;
    }

    public NodePlayer getMyInfo() {
        return this.me;
    }

    @Override
    public void setUserInfo(Player p) {
        this.me.setName(p.getName());
        this.me.setStatus(p.getStatus());
        this.sendStats();
        this.propSupport.firePropertyChange("Player", null, this.me);
    }

    @Override
    public void lockRoom(LockableRoom r) {
        NodeRoom n;
        if (r instanceof NodeRoom && (n = (NodeRoom)r).getOwner().equals(this.me.getId())) {
            n.toggleLock();
            this.sendRoomInfo(n);
            this.propSupport.firePropertyChange("AvailableRooms", null, this.allRooms);
        }
    }

    public void sendRoomInfo(NodeRoom r) {
        Node dummy = new Node(null, r.getName(), new PropertiesEncoder(r.getInfo()).getStringValue());
        if (this.isConnected()) {
            String msg = Protocol.encodeRoomsInfo(new Node[]{dummy});
            this.send(msg);
        }
    }

    @Override
    public void setRoom(Room r) {
        this.setRoom(r, null);
    }

    public void setRoom(Room r, String password) {
        if (this.isConnected()) {
            String newRoom = r.getName();
            String newPath = new SequenceEncoder(this.moduleName, '/').append(newRoom).getValue();
            String msg = Protocol.encodeJoinCommand(newPath, password);
            this.send(msg);
            if (r instanceof NodeRoom) {
                NodeRoom room = (NodeRoom)r;
                if (newRoom.equals(this.defaultRoomName)) {
                    GameModule.getGameModule().setGameFileMode(GameModule.GameFileMode.NEW_GAME);
                    GameModule.getGameModule().getGameState().setup(false);
                } else if (!room.isOwner(this.me)) {
                    this.pendingSynchToRoom = room;
                    GameModule.getGameModule().warn(Resources.getString("Chat.synchronize_pending"));
                }
            }
        }
    }

    public void handleMessageFromServer(String msg) {
        Node n = Protocol.decodeListCommand(msg);
        if (n != null) {
            Node mod = n.getChild(this.moduleName);
            if (mod != null) {
                this.updateRooms(mod);
            }
            if (this.pendingSynchToRoom != null) {
                new SynchAction(this.pendingSynchToRoom.getOwningPlayer(), this).actionPerformed(null);
                GameModule.getGameModule().warn(Resources.getString("Chat.synchronize_complete"));
                GameModule gm = GameModule.getGameModule();
                Chatter chatter = gm.getChatter();
                String playerName = this.getUserInfo().getName();
                ArrayList<String> errors = new ArrayList<String>();
                boolean compatible = this.checkCompatibility(this.pendingSynchToRoom, errors);
                Command chat = new Chatter.DisplayText(chatter, "-!<b> &lt;" + playerName + "&gt; " + Resources.getString("Chat.joining_room_chat", this.pendingSynchToRoom.getName()));
                this.pendingSynchToRoom = null;
                if (!compatible) {
                    for (String error : errors) {
                        chat = chat.append(new Chatter.DisplayText(chatter, "-?<b> &lt;" + playerName + "&gt;  " + error));
                    }
                }
                chat = chat.append(new Chatter.DisplayText(chatter, compatible ? "-!<b> " + Resources.getString("Chat.join_ok", playerName) : "-!<b> " + Resources.getString("Chat.join_not_ok", playerName)));
                chat.execute();
                gm.sendAndLog(chat);
            }
        } else {
            Properties p = Protocol.decodeRoomsInfo(msg);
            if (p != null) {
                for (NodeRoom aRoom : this.allRooms) {
                    String infoString = p.getProperty(aRoom.getName());
                    if (infoString == null || infoString.length() <= 0) continue;
                    try {
                        Properties info = new PropertiesEncoder(infoString).getProperties();
                        aRoom.setInfo(info);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.propSupport.firePropertyChange("Room", null, this.currentRoom);
                this.propSupport.firePropertyChange("AvailableRooms", null, this.allRooms);
            } else if (Protocol.decodeRegisterRequest(msg)) {
                this.registerNewConnection();
            } else {
                if (msg.startsWith(ZIP_HEADER)) {
                    try {
                        msg = new String(Compressor.decompress(Base64.decodeBase64((String)msg.substring(ZIP_HEADER.length()))), StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.propSupport.firePropertyChange("Msg", null, msg);
            }
        }
    }

    @Override
    public void handleMessage(String msg) {
        this.handleMessageFromServer(msg);
    }

    protected void updateRooms(Node module) {
        Node[] roomNodes = module.getChildren();
        Object[] rooms = new NodeRoom[roomNodes.length];
        int defaultRoomIndex = -1;
        for (int i = 0; i < roomNodes.length; ++i) {
            Node[] playerNodes = roomNodes[i].getChildren();
            Player[] players = new NodePlayer[playerNodes.length];
            boolean containsMe = false;
            for (int j = 0; j < playerNodes.length; ++j) {
                players[j] = new NodePlayer(playerNodes[j].getId());
                if (((NodePlayer)players[j]).equals(this.me)) {
                    containsMe = true;
                }
                try {
                    Properties p = new PropertiesEncoder(playerNodes[j].getInfo()).getProperties();
                    ((NodePlayer)players[j]).setInfo(p);
                    if (!((NodePlayer)players[j]).equals(this.me)) continue;
                    this.me.setInfo(p);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            rooms[i] = new NodeRoom(roomNodes[i].getId(), players);
            if (!((SimpleRoom)rooms[i]).getName().equals(this.defaultRoomName)) {
                ((NodeRoom)rooms[i]).lock();
            }
            try {
                if (roomNodes[i].getInfo() != null) {
                    ((NodeRoom)rooms[i]).setInfo(new PropertiesEncoder(roomNodes[i].getInfo()).getProperties());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (containsMe) {
                this.currentRoom = rooms[i];
            }
            if (!this.defaultRoomName.equals(((SimpleRoom)rooms[i]).getName())) continue;
            defaultRoomIndex = i;
        }
        if (defaultRoomIndex < 0) {
            this.allRooms = (NodeRoom[])ArrayUtils.addFirst((Object[])rooms, (Object)new NodeRoom(this.defaultRoomName));
        } else {
            this.allRooms = rooms;
            NodeRoom swap = this.allRooms[0];
            this.allRooms[0] = this.allRooms[defaultRoomIndex];
            this.allRooms[defaultRoomIndex] = swap;
        }
    }

    @Override
    public Player stringToPlayer(String s) {
        NodePlayer p = null;
        try {
            PropertiesEncoder propEncoder = new PropertiesEncoder(s);
            p = new NodePlayer(null);
            p.setInfo(propEncoder.getProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p;
    }

    @Override
    public String playerToString(Player p) {
        Properties props = ((NodePlayer)p).toProperties();
        return new PropertiesEncoder(props).getStringValue();
    }

    @Override
    public void initializeControls(ChatServerControls controls) {
        this.playerStatusControls.initializeControls(controls);
        this.roomControls.initializeControls(controls);
        controls.setRoomControlsVisible(true);
        GameModule g = GameModule.getGameModule();
        g.addCommandEncoder(this.synchEncoder);
        g.addCommandEncoder(this.privateChatEncoder);
        g.addCommandEncoder(this.soundEncoder);
        g.addCommandEncoder(this.inviteEncoder);
        this.me.setName((String)g.getPrefs().getValue("RealName"));
        g.getPrefs().getOption("RealName").addPropertyChangeListener(this.nameChangeListener);
        SimpleStatus s = (SimpleStatus)this.me.getStatus();
        s = new SimpleStatus(s.isLooking(), s.isAway(), (String)g.getPrefs().getValue("Profile"), Info.getVersion(), s.getIp(), g.getGameVersion() + (String)(g.getArchiveWriter() == null ? "" : " " + Resources.getString("Editor.NodeClient.editing")), Long.toHexString(g.getCrc()), Long.toHexString(g.getCombinedCrc()));
        this.me.setStatus(s);
        g.getPrefs().getOption("Profile").addPropertyChangeListener(this.profileChangeListener);
        controls.getRoomTree().setCellRenderer(new LockableRoomTreeRenderer());
    }

    @Override
    public void uninitializeControls(ChatServerControls controls) {
        this.roomControls.uninitializeControls(controls);
        this.playerStatusControls.uninitializeControls(controls);
        GameModule g = GameModule.getGameModule();
        g.removeCommandEncoder(this.synchEncoder);
        g.removeCommandEncoder(this.privateChatEncoder);
        g.removeCommandEncoder(this.soundEncoder);
        g.removeCommandEncoder(this.inviteEncoder);
        g.getPrefs().getOption("RealName").removePropertyChangeListener(this.nameChangeListener);
        g.getPrefs().getOption("Profile").removePropertyChangeListener(this.profileChangeListener);
    }

    @Deprecated(since="2020-03-01")
    public void checkCompatibility(NodeRoom targetRoom, boolean compatible, List<String> errors) {
        compatible = this.checkCompatibility(targetRoom, errors);
    }

    public boolean checkCompatibility(NodeRoom targetRoom, List<String> errors) {
        errors.clear();
        boolean compatible = true;
        if (this.defaultRoomName.equals(targetRoom.getName()) || targetRoom.getOwningPlayer() == null) {
            return compatible;
        }
        SimpleStatus ownerStatus = (SimpleStatus)targetRoom.getOwningPlayer().getStatus();
        SimpleStatus myStatus = (SimpleStatus)this.getUserInfo().getStatus();
        if (!VersionUtils.truncateToMinorVersion(ownerStatus.getClient()).equals(VersionUtils.truncateToMinorVersion(myStatus.getClient()))) {
            errors.add(Resources.getString("Chat.bad_vassal", myStatus.getClient(), ownerStatus.getClient()));
            compatible = false;
        }
        String myVersion = NodeClient.cleanVersion(myStatus.getModuleVersion());
        String ownerVersion = NodeClient.cleanVersion(ownerStatus.getModuleVersion());
        if (!ownerVersion.equals(myVersion)) {
            errors.add(Resources.getString("Chat.bad_module", myVersion, ownerVersion));
            compatible = false;
        }
        return compatible;
    }

    public static String cleanVersion(String version) {
        String editingString = " " + Resources.getString("Editor.NodeClient.editing");
        return version.endsWith(editingString) ? version.substring(0, version.length() - editingString.length()) : version;
    }
}

