/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.FontConfigurer;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.i18n.Resources;

public class FontStyle
extends AbstractConfigurable {
    protected static final String NAME = "name";
    protected static final String STYLE = "style";
    protected OutlineFont font;

    public FontStyle() {
        this.setConfigureName("Default");
        this.font = new OutlineFont("Dialog", 0, 12, false);
    }

    public FontStyle(String name, OutlineFont f) {
        this.setConfigureName(name);
        this.font = f;
    }

    public OutlineFont getFont() {
        return this.font;
    }

    public boolean isOutline() {
        return this.font.isOutline();
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.FontStyle.style_name"), Resources.getString("Editor.FontStyle.font_style")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, FontStyleConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, STYLE};
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)o);
        } else if (STYLE.equals(key)) {
            if (o instanceof String) {
                o = FontConfigurer.decode((String)o);
            }
            this.font = (OutlineFont)o;
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (STYLE.equals(key)) {
            return FontConfigurer.encode(this.font);
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceImageDefinitions.html", "FontStyles");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.FontStyle.component_type");
    }

    @Override
    public void addTo(Buildable parent) {
        this.setAllAttributesUntranslatable();
    }

    public static class FontStyleConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FontConfigurer(key, name, ((FontStyle)c).font);
        }
    }
}

