/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.counters.ActionButton;
import VASSAL.counters.Deck;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.KeyCommandSubMenu;
import VASSAL.counters.PieceFinder;
import VASSAL.tools.NamedKeyManager;
import java.awt.Font;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MenuDisplayer
extends MouseAdapter
implements Buildable {
    @Deprecated(since="2022-08-08", forRemoval=true)
    public static final Font POPUP_MENU_FONT = new Font("Dialog", 0, 10);
    protected Map map;
    protected PieceFinder targetSelector;

    @Override
    public void addTo(Buildable b) {
        this.targetSelector = this.createTargetSelector();
        this.map = (Map)b;
        this.map.addLocalMouseListener(this);
    }

    protected PieceFinder createTargetSelector() {
        return new PieceFinder.PieceInStack(){

            @Override
            public Object visitDeck(Deck d) {
                Point pos = d.getPosition();
                Point p = new Point(this.pt.x - pos.x, this.pt.y - pos.y);
                if (d.getShape().contains(p)) {
                    return d;
                }
                return null;
            }
        };
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public Element getBuildElement(Document doc) {
        return doc.createElement(this.getClass().getName());
    }

    @Override
    public void build(Element e) {
    }

    protected static String getMenuText(KeyCommand keyCommand) {
        return keyCommand.getLocalizedMenuText();
    }

    protected static JMenuItem makeMenuItem(KeyCommand keyCommand) {
        JMenuItem item = new JMenuItem(keyCommand.isMenuSeparator() ? "<separator>" : MenuDisplayer.getMenuText(keyCommand));
        if (!NamedKeyManager.isNamed(keyCommand.getKeyStroke())) {
            item.setAccelerator(keyCommand.getKeyStroke());
        }
        item.addActionListener(keyCommand);
        item.setEnabled(keyCommand.isEnabled());
        return item;
    }

    public static JPopupMenu createPopup(GamePiece target) {
        return MenuDisplayer.createPopup(target, false);
    }

    public static JPopupMenu createPopup(GamePiece target, boolean global) {
        JPopupMenu popup = new JPopupMenu();
        KeyCommand[] c = (KeyCommand[])target.getProperty("KeyCommands");
        if (c != null) {
            String menu_item;
            ArrayList<JMenu> commands = new ArrayList<JMenu>();
            ArrayList<KeyStroke> strokes = new ArrayList<KeyStroke>();
            HashMap<KeyCommandSubMenu, JMenu> subMenus = new HashMap<KeyCommandSubMenu, JMenu>();
            HashMap<String, ArrayList> commandNames = new HashMap<String, ArrayList>();
            if (target instanceof Deck && c.length == 1 && (menu_item = c[0].getName()) != null && (menu_item.equals(((Deck)target).getDrawMultipleMessage()) || menu_item.equals(((Deck)target).getDrawSpecificMessage()))) {
                c[0].actionPerformed(new ActionEvent(popup, 0, ""));
                return null;
            }
            for (KeyCommand keyCommand : c) {
                keyCommand.setGlobal(global);
                KeyStroke stroke = keyCommand.getKeyStroke();
                JMenuItem item = null;
                if (keyCommand instanceof KeyCommandSubMenu) {
                    JMenu subMenu = new JMenu(MenuDisplayer.getMenuText(keyCommand));
                    subMenus.put((KeyCommandSubMenu)keyCommand, subMenu);
                    item = subMenu;
                    commands.add((JMenu)item);
                    strokes.add(KeyStroke.getKeyStroke('\u0000'));
                } else if (strokes.contains(stroke) && !keyCommand.isMenuSeparator()) {
                    String commandName;
                    JMenuItem command = (JMenuItem)commands.get(strokes.indexOf(stroke));
                    Action action = command.getAction();
                    if (action != null && ((commandName = (String)command.getAction().getValue("Name")) == null || commandName.length() < keyCommand.getName().length())) {
                        item = MenuDisplayer.makeMenuItem(keyCommand);
                        commands.set(strokes.indexOf(stroke), (JMenu)item);
                    }
                } else {
                    strokes.add(stroke != null && !keyCommand.isMenuSeparator() ? stroke : KeyStroke.getKeyStroke('\u0000'));
                    item = MenuDisplayer.makeMenuItem(keyCommand);
                    commands.add((JMenu)item);
                }
                if (keyCommand.getName() == null || keyCommand.getName().length() <= 0 || item == null) continue;
                ArrayList l = commandNames.computeIfAbsent(keyCommand.getName(), k -> new ArrayList());
                l.add(item);
            }
            for (Map.Entry entry : subMenus.entrySet()) {
                KeyCommandSubMenu menuCommand = (KeyCommandSubMenu)entry.getKey();
                JMenu subMenu = (JMenu)entry.getValue();
                Iterator<String> it2 = menuCommand.getCommands();
                while (it2.hasNext()) {
                    ArrayList matchingCommands = (ArrayList)commandNames.get(it2.next());
                    if (matchingCommands == null) continue;
                    for (JMenuItem item : matchingCommands) {
                        subMenu.add(item);
                        commands.remove(item);
                    }
                }
            }
            for (JMenuItem jMenuItem : commands) {
                String text = jMenuItem.getText();
                if ("<separator>".equals(text)) {
                    popup.addSeparator();
                    continue;
                }
                if (text == null || text.isBlank()) continue;
                popup.add(jMenuItem);
            }
        }
        return popup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybePopup(e, false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybePopup(e, true);
    }

    protected void maybePopup(MouseEvent e) {
        this.maybePopup(e, false);
    }

    protected void maybePopup(MouseEvent e, boolean specialLaunchAllowed) {
        EventFilter filter;
        GamePiece p = this.map.findPiece(e.getPoint(), this.targetSelector);
        if (p == null) {
            return;
        }
        if (!e.isPopupTrigger()) {
            if (e.isAltDown() || e.isShiftDown() || !specialLaunchAllowed) {
                return;
            }
            if (this.map.getPieceMover().getBreachedThreshold()) {
                return;
            }
            if (this.map.getKeyBufferer().isLasso()) {
                return;
            }
            Point epos = e.getPoint();
            Point rel = this.map.positionOf(p);
            epos.translate(-rel.x, -rel.y);
            Shape s = p.getShape();
            if (!s.contains(epos)) {
                return;
            }
            List<GamePiece> actionButtons = ActionButton.matchingTraits(p, epos);
            boolean anyMenu = false;
            for (GamePiece trait : actionButtons) {
                ActionButton action = (ActionButton)trait;
                if (!action.isLaunchPopupMenu()) continue;
                anyMenu = true;
                break;
            }
            if (!anyMenu) {
                return;
            }
        }
        if ((filter = (EventFilter)p.getProperty("selectEventFilter")) != null && filter.rejectEvent(e)) {
            return;
        }
        JPopupMenu popup = MenuDisplayer.createPopup(p, true);
        if (popup != null) {
            popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent evt) {
                    MenuDisplayer.this.map.repaint();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                    MenuDisplayer.this.map.repaint();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                }
            });
            Point pt = this.map.mapToComponent(e.getPoint());
            if (this.map.getView().isShowing()) {
                KeyBuffer.getBuffer().setClickPoint(e.getPoint());
                popup.show(this.map.getView(), pt.x, pt.y);
            }
        }
        e.consume();
    }
}

