/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.TabWidget;
import VASSAL.build.widget.WidgetMap;
import VASSAL.i18n.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.w3c.dom.Element;

public class MapWidget
extends Widget {
    protected JPanel panel = new JPanel();
    protected JComponent mapHolder;
    protected WidgetMap map;
    protected Buildable parent;
    protected JTabbedPane tab;

    public MapWidget() {
        this.panel.setLayout(new BorderLayout());
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.MapWidget.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChartWindow.html", "Map");
    }

    @Override
    public void build(Element e) {
        if (e == null) {
            WidgetMap map = new WidgetMap();
            map.build(null);
            map.addTo(this);
            this.add(map);
        } else {
            super.build(e);
        }
        this.rebuild();
    }

    @Override
    public Component getComponent() {
        if (this.tab == null && this.parent instanceof TabWidget) {
            this.tab = (JTabbedPane)((TabWidget)this.parent).getComponent();
            if (this.tab.getClientProperty(TabSwitcher.class) == null) {
                TabSwitcher switcher = new TabSwitcher(this.tab);
                this.tab.putClientProperty(TabSwitcher.class, switcher);
                this.tab.setDropTarget(new DropTarget(this.tab, 2, switcher));
            }
        }
        return this.panel;
    }

    @Override
    public void addTo(Buildable b) {
        super.addTo(b);
        this.parent = b;
    }

    @Override
    public void add(Buildable b) {
        if (b instanceof WidgetMap) {
            if (this.mapHolder != null) {
                this.panel.remove(this.mapHolder);
                this.mapHolder = null;
            }
            this.map = (WidgetMap)b;
            this.mapHolder = this.map.getLayeredPane();
            this.panel.add((Component)this.mapHolder, "Center");
            this.panel.add((Component)this.map.getToolBar(), "North");
            this.panel.revalidate();
        }
        super.add(b);
    }

    @Override
    public void remove(Buildable b) {
        if (b instanceof WidgetMap) {
            this.panel.remove(this.mapHolder);
            this.panel.remove(this.map.getToolBar());
            this.mapHolder = null;
        }
        super.remove(b);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.description_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName", "description"};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if ("entryName".equals(key)) {
            this.setConfigureName((String)value);
        } else if ("description".equals(key)) {
            this.description = (String)value;
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if ("entryName".equals(key)) {
            return this.getConfigureName();
        }
        if ("description".equals(key)) {
            return this.description;
        }
        return null;
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public WidgetMap getMap() {
        return this.map;
    }

    protected static class TabSwitcher
    implements DropTargetListener {
        protected JTabbedPane tab;

        public TabSwitcher(JTabbedPane tab) {
            this.tab = tab;
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            if (this.tab != null) {
                Point p = e.getLocation();
                int tabNumber = this.tab.getUI().tabForCoordinate(this.tab, p.x, p.y);
                if (tabNumber >= 0 && tabNumber != this.tab.getSelectedIndex()) {
                    this.tab.setSelectedIndex(tabNumber);
                    this.tab.repaint();
                }
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }
    }
}

