/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.configure.ConfigureTree;
import VASSAL.i18n.Resources;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ChooseComponentDialog
extends JDialog
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private Configurable target;
    private final Class<? extends Buildable> targetClass;
    private final JButton okButton;
    private final ConfigureTree tree;

    public ChooseComponentDialog(Frame owner, Class<? extends Buildable> targetClass) {
        super(owner, true);
        this.targetClass = targetClass;
        this.setDefaultCloseOperation(2);
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.tree = new ConfigureTree(GameModule.getGameModule(), null, null, true){
            private static final long serialVersionUID = 1L;

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
        this.tree.addTreeSelectionListener(this);
        this.add(new ScrollPane(this.tree));
        Box b = Box.createHorizontalBox();
        this.okButton = new JButton(Resources.getString("General.ok"));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(e -> this.dispose());
        JButton cancelButton = new JButton(Resources.getString("General.cancel"));
        cancelButton.addActionListener(e -> {
            this.target = null;
            this.dispose();
        });
        b.add(this.okButton);
        b.add(cancelButton);
        this.add(b);
        SwingUtils.setDefaultButtons(this.getRootPane(), this.okButton, cancelButton);
        this.pack();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object selected;
        boolean enabled = false;
        this.target = null;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (enabled = this.isValidTarget(selected = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()))) {
            this.target = (Configurable)selected;
        }
        this.okButton.setEnabled(enabled);
    }

    protected boolean isValidTarget(Object selected) {
        return this.targetClass.isInstance(selected);
    }

    public Configurable getTarget() {
        return this.target;
    }
}

