/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.launch.GameModuleAction;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.UsernameAndPasswordDialog;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

public class LoadModuleAction
extends GameModuleAction {
    private static final long serialVersionUID = 1L;
    private File moduleFile;
    protected FileChooser fc;

    public LoadModuleAction(Component comp) {
        super(Resources.getString("Main.play_module"), comp);
    }

    public LoadModuleAction(File moduleFile) {
        super(Resources.getString("Main.play_module"), (Component)null);
        this.moduleFile = moduleFile;
    }

    @Override
    public void performAction(ActionEvent e) throws IOException {
        this.actionCancelled = true;
        File target = this.moduleFile;
        if (target == null) {
            File f;
            if (this.fc == null) {
                this.fc = FileChooser.createFileChooser(this.comp, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
            }
            if (this.fc.showOpenDialog() == 0 && (f = this.fc.getSelectedFile()) != null && f.exists()) {
                target = f;
            }
            if (target == null) {
                return;
            }
        }
        this.loadModule(target);
        this.actionCancelled = false;
    }

    protected void loadModule(File f) throws IOException {
        GameModule.init(new GameModule(new DataArchive(f.getPath())));
        Localization.getInstance().translate();
        GameModule m = GameModule.getGameModule();
        new ExtensionsLoader().addTo(m);
        this.showWizardOrPlayerWindow(m);
    }

    private void showWizardOrPlayerWindow(GameModule module) {
        Boolean showWizard = (Boolean)Prefs.getGlobalPrefs().getValue("welcomeWizard");
        if (Boolean.TRUE.equals(showWizard)) {
            module.getWizardSupport().showWelcomeWizard();
        } else {
            module.getPlayerWindow().setVisible(true);
            if (!module.isRealName() || !module.isNonBlankPassword()) {
                new UsernameAndPasswordDialog(module.getPlayerWindow()).setVisible(true);
            }
        }
    }
}

