/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.EditablePiece;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.AuditableException;
import VASSAL.script.expression.Expression;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.concurrent.ConcurrentSoftHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FormattedString
implements RecursionLimiter.Loopable {
    private static final Map<Pair<String, PropertySource>, FSData> CACHE = new ConcurrentSoftHashMap<Pair<String, PropertySource>, FSData>();
    private FSData fsdata;
    protected Map<String, String> props;

    public static boolean isDynamic(String text) {
        return text != null && (StringUtils.countMatches((CharSequence)text, (CharSequence)"$") > 1 || text.trim().startsWith("{"));
    }

    private static FSData dataOf(String fs, PropertySource dp) {
        return CACHE.computeIfAbsent((Pair<String, PropertySource>)Pair.of((Object)fs, (Object)dp), p -> new FSData((String)p.getLeft(), (PropertySource)p.getRight()));
    }

    public FormattedString() {
        this("");
    }

    public FormattedString(String s) {
        this(s, GameModule.getGameModule());
    }

    public FormattedString(PropertySource defaultProperties) {
        this("", defaultProperties);
    }

    public FormattedString(String formatString, PropertySource defaultProperties) {
        this.fsdata = FormattedString.dataOf(formatString, defaultProperties);
    }

    public void setFormat(String fs) {
        this.fsdata = FormattedString.dataOf(fs, this.fsdata.defaultProperties);
    }

    public String getFormat() {
        return this.fsdata.formatString;
    }

    public void setProperty(String name, String value) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(name.intern(), value != null ? value.intern() : null);
    }

    public void clearProperties() {
        if (this.props != null) {
            this.props.clear();
        }
    }

    public void setDefaultProperties(PropertySource defaultProperties) {
        this.fsdata = FormattedString.dataOf(this.fsdata.formatString, defaultProperties);
    }

    public PropertySource getDefaultProperties() {
        return this.fsdata.defaultProperties;
    }

    @Deprecated(since="2021-12-01")
    public String getText() {
        return this.getText(this.fsdata.defaultProperties, false, null, null);
    }

    public String getText(Auditable owner, String fieldKey) {
        return this.getText(this.fsdata.defaultProperties, false, owner, AuditTrail.create(owner, this.getFormat(), Resources.getString(fieldKey)));
    }

    @Deprecated(since="2021-12-01")
    public String getLocalizedText() {
        return this.getText(this.fsdata.defaultProperties, true, null, null);
    }

    public String getLocalizedText(Auditable owner, String fieldKey) {
        return this.getText(this.fsdata.defaultProperties, true, owner, AuditTrail.create(owner, this.getFormat(), Resources.getString(fieldKey)));
    }

    @Deprecated(since="2021-12-01")
    public String getText(PropertySource ps) {
        return this.getText(ps, false, null, null);
    }

    public String getText(PropertySource ps, Auditable owner, String fieldKey) {
        return this.getText(ps, false, owner, AuditTrail.create(owner, this.fsdata.formatString, Resources.getString(fieldKey)));
    }

    public String getText(PropertySource ps, Auditable owner, AuditTrail audit) {
        return this.getText(ps, false, owner, audit);
    }

    @Deprecated(since="2021-12-01")
    public String getText(PropertySource ps, boolean localized) {
        return this.getText(ps, localized, null, null);
    }

    @Deprecated(since="2021-12-01")
    public String getText(PropertySource ps, String def) {
        return this.getText(ps, def, null, (AuditTrail)null);
    }

    public String getText(PropertySource ps, String def, Auditable owner, String fieldKey) {
        return this.getText(ps, def, owner, AuditTrail.create(owner, this.getFormat(), Resources.getString(fieldKey)));
    }

    public String getText(PropertySource ps, String def, Auditable owner, AuditTrail audit) {
        String s = this.getText(ps, false, owner, audit);
        if (s == null || s.length() == 0) {
            s = def;
        }
        return s;
    }

    public String getLocalizedText(PropertySource ps, Auditable owner, String fieldKey) {
        return this.getText(ps, true, owner, AuditTrail.create(owner, this.fsdata.formatString, Resources.getString(fieldKey)));
    }

    public String getLocalizedText(PropertySource ps, Auditable owner, AuditTrail audit) {
        return this.getText(ps, true, owner, audit);
    }

    @Deprecated(since="2021-12-01")
    public String getLocalizedText(PropertySource ps) {
        return this.getLocalizedText(ps, null, (AuditTrail)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(PropertySource ps, boolean localized, Auditable owner, AuditTrail audit) {
        PropertySource source = ps == null ? this.fsdata.defaultProperties : ps;
        try {
            RecursionLimiter.startExecution(this);
            String string = this.fsdata.format.tryEvaluate(source, this.props, localized, owner, audit);
            return string;
        }
        catch (RecursionLimitException e) {
            ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.possible_infinite_string_loop"), this.fsdata.format.getExpression(), e));
            String string = "";
            return string;
        }
        finally {
            RecursionLimiter.endExecution();
        }
    }

    public int getTextAsInt(PropertySource ps, String description, EditablePiece source) {
        AuditTrail audit = AuditTrail.create((Auditable)ps, this, description);
        return this.getTextAsInt(ps, description, source, ps, audit);
    }

    public int getTextAsInt(PropertySource ps, String description, EditablePiece source, Auditable owner, AuditTrail audit) {
        int result = 0;
        String value = this.getText(ps, "0", (Auditable)source, audit);
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(source, Resources.getString("Error.non_number_error"), FormattedString.debugInfo(this, value, description), (Throwable)new AuditableException(ps, audit)));
        }
        return result;
    }

    public int getTextAsInt(PropertySource ps, String description, AbstractConfigurable source) {
        int result = 0;
        AuditTrail audit = AuditTrail.create((Auditable)ps, this, description);
        String value = this.getText(ps, "0", (Auditable)source, audit);
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(source, Resources.getString("Error.non_number_error"), FormattedString.debugInfo(this, value, description), (Throwable)new AuditableException(ps, audit)));
        }
        return result;
    }

    public static String debugInfo(FormattedString fs, String value, String description) {
        return description + (String)(value.equals(fs.getFormat()) ? "" : "[" + fs.getFormat() + "]") + "=" + value;
    }

    public String debugInfo(String value, String description) {
        return FormattedString.debugInfo(this, value, description);
    }

    public int hashCode() {
        return this.fsdata.formatString == null ? 0 : this.fsdata.formatString.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FormattedString other = (FormattedString)obj;
        return Objects.equals(this.fsdata.formatString, other.fsdata.formatString);
    }

    @Override
    public String getComponentTypeName() {
        return Resources.getString("Editor.FormattedString.component_type");
    }

    @Override
    public String getComponentName() {
        return Resources.getString("Editor.FormattedString.component_type");
    }

    private static class FSData {
        public final String formatString;
        public final Expression format;
        public final PropertySource defaultProperties;

        public FSData(String fs, PropertySource dp) {
            this.formatString = fs;
            this.format = Expression.createExpression(fs);
            this.defaultProperties = dp;
        }
    }
}

