/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.ThisMachine;
import org.litesoft.p2pchat.UserDialog;

public abstract class AbstractP2PChat {
    private static final String VERSION = "0.2";
    private static final int DEFAULTPORT = 11581;

    protected static String getTitle() {
        return "P2PChat ver 0.2";
    }

    protected static void dumpHelp(String problem) {
        System.out.println(AbstractP2PChat.getTitle());
        System.out.println();
        System.out.println(problem);
        System.out.println();
        System.out.println("This program takes 1-n arguments:");
        System.out.println("   1st - Chatname");
        System.out.println("   nth - our Address and/or port");
        System.out.println("         peer(s) Address and optional port");
        System.out.println();
        System.out.println("   An Address is a standard dotted address (eg 192.168.1.5)");
        System.out.println("   A Port is a simple integer (default: 11581)");
        System.out.println("   A colon (':') seperates the address and port (eg 192.168.1.5:5432)");
        System.out.println("   Our Address and/or port is indictaed by being surrounded by square");
        System.out.println("      brackets (eg [192.168.1.5:5432])");
        System.exit(0);
    }

    protected abstract UserDialog getUserDialog(MyInfo var1);

    protected void init(String[] args) {
        Pars parser = new Pars();
        String error = parser.parse(args);
        if (error != null) {
            AbstractP2PChat.dumpHelp(error);
        }
        try {
            UserDialog userDialog = this.getUserDialog(parser.zMyInfo);
            PendingPeerManager ppm = new PendingPeerManager(userDialog);
            PeerInfo[] initialPeers = parser.zInitialPeers;
            if (initialPeers != null) {
                for (int i = 0; i < initialPeers.length; ++i) {
                    ppm.addNewPeer(initialPeers[i]);
                }
            }
            ServerSocket serverSocket = this.getServerSocket(parser.zMyInfo.getPort());
            new ActivePeerManager(parser.zMyInfo, userDialog, ppm);
            while (true) {
                ppm.addNewPeer(serverSocket.accept());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private ServerSocket getServerSocket(int pPort) {
        try {
            return new ServerSocket(pPort);
        }
        catch (IOException e) {
            AbstractP2PChat.dumpHelp("Unable to Open Socket Listener on Port number(" + pPort + ").  Error: " + e.getMessage());
            return null;
        }
    }

    private static class Pars {
        public MyInfo zMyInfo = null;
        public PeerInfo[] zInitialPeers = null;

        private Pars() {
        }

        public String parse(String[] args) {
            if (args == null || args.length == 0) {
                return "Not enough parameters.";
            }
            String chatName = args[0].trim();
            if (chatName.length() == 0) {
                return "No chatname specified.";
            }
            for (int i = 1; i < args.length; ++i) {
                String s = args[i];
                String err = s.startsWith("[") && s.endsWith("]") ? this.parseMyInfo(chatName, s.substring(1, s.length() - 1)) : this.parsePeerInfo(s);
                if (err == null) continue;
                return err;
            }
            if (this.zMyInfo == null) {
                this.zMyInfo = new MyInfo(chatName, (String)null, 11581);
            }
            return null;
        }

        private String parseMyInfo(String pChatName, String pParm) {
            if (this.zMyInfo != null) {
                return "My Info (" + String.valueOf(this.zMyInfo) + ") already given.";
            }
            Port ap = new Port();
            String err = ap.parse(pParm);
            if (err != null) {
                return err;
            }
            this.zMyInfo = new MyInfo(pChatName, ap.zAddress, ap.zPort);
            return null;
        }

        private String parsePeerInfo(String pParm) {
            Port ap = new Port();
            String err = ap.parse(pParm);
            if (err != null) {
                return err;
            }
            if (ap.zAddress == null) {
                return "Peer Address not found in: " + pParm;
            }
            if (this.zInitialPeers == null) {
                this.zInitialPeers = new PeerInfo[1];
            } else {
                PeerInfo[] temp = new PeerInfo[this.zInitialPeers.length + 1];
                System.arraycopy(this.zInitialPeers, 0, temp, 0, this.zInitialPeers.length);
                this.zInitialPeers = temp;
            }
            this.zInitialPeers[this.zInitialPeers.length - 1] = new PeerInfo(null, ap.zAddress, ap.zPort);
            return null;
        }

        private static class Port {
            public String zAddress = null;
            public int zPort = 11581;

            private Port() {
            }

            public String parse(String pParm) {
                IllegalArgument.ifNull("Parm", pParm);
                pParm = pParm.trim();
                int colonAt = pParm.indexOf(58);
                if (colonAt != -1) {
                    String err = this.parseAddress(pParm.substring(0, colonAt));
                    if (null != err) {
                        return "Invalid Address in (" + pParm + "): " + err;
                    }
                    err = this.parsePort(pParm.substring(colonAt + 1));
                    if (null != err) {
                        return "Invalid Port in (" + pParm + "): " + err;
                    }
                    return null;
                }
                if (this.isAllDigits(pParm)) {
                    String err = this.parsePort(pParm);
                    if (null != err) {
                        return "Port (" + pParm + ") Invalid: " + err;
                    }
                } else {
                    String err = this.parseAddress(pParm);
                    if (null != err) {
                        return "Address (" + pParm + ") Invalid: " + err;
                    }
                }
                return null;
            }

            private String parsePort(String pParm) {
                try {
                    this.zPort = Integer.parseInt(pParm.trim());
                }
                catch (NumberFormatException e) {
                    return "Not a number.";
                }
                if (this.zPort < 1024 || this.zPort >= 131072) {
                    return "Not within range. Must be a 16 bit value greater then 1024";
                }
                return null;
            }

            private String parseAddress(String pParm) {
                int commaAt;
                if ((pParm = pParm.trim()).length() == 0) {
                    this.zAddress = MyInfo.getIPs();
                    return null;
                }
                while (-1 != (commaAt = pParm.indexOf(44))) {
                    String err = this.parseAnAddress(pParm.substring(0, commaAt));
                    if (err != null) {
                        return err;
                    }
                    pParm = pParm.substring(commaAt + 1).trim();
                }
                return this.parseAnAddress(pParm);
            }

            private String parseAnAddress(String pParm) {
                int dotAt = pParm.lastIndexOf(46);
                if (dotAt == -1) {
                    return "No dot ('.') in: " + pParm;
                }
                String lastField = pParm.substring(dotAt + 1);
                if (this.isAllDigits(lastField)) {
                    return this.parseDirectAddress(pParm);
                }
                if (lastField.length() == 0) {
                    return "No TLD in: " + pParm;
                }
                if (-1 != pParm.indexOf(32)) {
                    return "Illegal Domain Reference in: " + pParm;
                }
                String[] directAddresses = this.convertAddressDomainToDirects(pParm);
                if (directAddresses == null) {
                    return "Unresolvable Domain Reference: " + pParm;
                }
                for (int i = 0; i < directAddresses.length; ++i) {
                    this.addAddress(directAddresses[i]);
                }
                return null;
            }

            private void addAddress(String pAddress) {
                this.zAddress = this.zAddress == null ? pAddress : this.zAddress + "," + pAddress;
            }

            private boolean isAllDigits(String pParm) {
                if (pParm.length() == 0) {
                    return false;
                }
                int i = pParm.length();
                while (i-- > 0) {
                    if (Character.isDigit(pParm.charAt(i))) continue;
                    return false;
                }
                return true;
            }

            private String[] convertAddressDomainToDirects(String pParm) {
                InetAddress[] addresses;
                try {
                    addresses = InetAddress.getAllByName(pParm);
                }
                catch (UnknownHostException e) {
                    return null;
                }
                if (addresses == null || addresses.length == 0) {
                    return null;
                }
                String[] retval = new String[addresses.length];
                for (int i = 0; i < addresses.length; ++i) {
                    retval[i] = addresses[i].toString();
                }
                return retval;
            }

            private String parseDirectAddress(String pParm) {
                String s;
                Dots da = new Dots(pParm);
                for (int i = 0; i < da.zParts.length; ++i) {
                    if (this.isAllDigits(da.zParts[i])) continue;
                    return "Non-Numeric (" + da.zParts[i] + ") Dotted Address in: " + pParm;
                }
                if (da.zParts.length > 4) {
                    return "Too Many Parts in Address: " + pParm;
                }
                if (da.zParts.length == 4) {
                    this.addAddress(da.toString());
                    return null;
                }
                int i = 0;
                while (null != (s = ThisMachine.getIPAddress(i))) {
                    Dots us = new Dots(s);
                    us.overlayFrom(da);
                    this.addAddress(us.toString());
                    ++i;
                }
                return null;
            }
        }

        private static class Dots {
            public String[] zParts = null;

            public Dots(String pParm) {
                int dotAt;
                if (pParm == null) {
                    return;
                }
                this.zParts = new String[0];
                while (pParm.startsWith(".")) {
                    pParm = pParm.substring(1);
                }
                if (pParm.length() == 0) {
                    return;
                }
                while (-1 != (dotAt = pParm.indexOf(46))) {
                    this.addPart(pParm.substring(0, dotAt));
                    pParm = pParm.substring(dotAt + 1);
                }
                this.addPart(pParm);
            }

            private void addPart(String pPart) {
                if (this.zParts.length == 0) {
                    this.zParts = new String[1];
                } else {
                    String[] temp = new String[this.zParts.length + 1];
                    System.arraycopy(this.zParts, 0, temp, 1, this.zParts.length);
                    this.zParts = temp;
                }
                this.zParts[0] = pPart;
            }

            public void overlayFrom(Dots pParm) {
                if (pParm != null) {
                    for (int i = 0; i < pParm.zParts.length; ++i) {
                        this.zParts[i] = pParm.zParts[i];
                    }
                }
            }

            public String toString() {
                if (this.zParts.length == 0) {
                    return "No Address";
                }
                StringBuffer sb = new StringBuffer(16);
                int i = this.zParts.length;
                while (i-- > 0) {
                    sb.append('.');
                    sb.append(this.zParts[i]);
                }
                return sb.toString().substring(1);
            }
        }
    }
}

