/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.Logger;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.ModuleManagerUpdateHelper;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.LogFileFilter;
import VASSAL.tools.io.ObfuscatingOutputStream;
import VASSAL.tools.io.ZipWriter;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.Dialogs;
import VASSAL.tools.version.VersionUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicLogger
implements Logger,
Buildable,
GameComponent,
CommandEncoder {
    public static final String BEGIN = "begin_log";
    public static final String END = "end_log";
    public static final String LOG = "LOG\t";
    public static final String UNDO = "UNDO\t";
    public static final String PROMPT_NEW_LOG = "PromptNewLog";
    public static final String PROMPT_NEW_LOG_START = "PromptNewLogAtStart";
    public static final String PROMPT_NEW_LOG_END = "PromptNewLogEnd";
    public static final String PROMPT_LOG_COMMENT = "promptLogComment";
    protected static final String STEP_ICON = "/images/StepForward16.gif";
    protected static final String UNDO_ICON = "/images/Undo16.gif";
    protected List<Command> logInput;
    protected List<Command> logOutput;
    protected int nextInput = 0;
    protected int nextUndo = -1;
    protected int dontUndoPast = 0;
    protected Command beginningState;
    protected File outputFile;
    protected Action stepAction = new StepAction();
    protected SaveMetaData metadata;
    private boolean multiPlayer = false;
    private NamedHotKeyConfigurer stepKeyConfig;
    private NamedHotKeyConfigurer undoKeyConfig;
    private boolean undoInProgress = false;
    protected Action undoAction = new UndoAction();
    protected Action endLogAction = new AbstractAction(Resources.getString("BasicLogger.end_logfile")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (BasicLogger.this.beginningState != null) {
                    BasicLogger.this.write();
                    GameModule.getGameModule().warn(Resources.getString("BasicLogger.logfile_written"));
                    GameModule.getGameModule().setGameFileMode(GameModule.GameFileMode.LOGGED_GAME);
                }
                BasicLogger.this.newLogAction.setEnabled(true);
                BasicLogger.this.outputFile = null;
                BasicLogger.this.beginningState = null;
            }
            catch (IOException ex) {
                WriteErrorDialog.error(ex, BasicLogger.this.outputFile);
            }
        }
    };
    protected Action newLogAction = new AbstractAction(Resources.getString("BasicLogger.begin_logfile")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicLogger.this.beginOutput();
        }
    };

    public BasicLogger() {
        this.stepAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.endLogAction.setEnabled(false);
        this.newLogAction.setEnabled(false);
        this.logInput = new ArrayList<Command>();
        this.logOutput = new ArrayList<Command>();
    }

    @Override
    public void build(Element e) {
    }

    public List<NamedKeyStroke> getNamedKeyStrokes() {
        ArrayList<NamedKeyStroke> list = new ArrayList<NamedKeyStroke>();
        if (this.stepKeyConfig != null) {
            list.add(this.stepKeyConfig.getValueNamedKeyStroke());
        }
        if (this.undoKeyConfig != null) {
            list.add(this.undoKeyConfig.getValueNamedKeyStroke());
        }
        return list;
    }

    @Override
    public void addTo(Buildable b) {
        GameModule mod = GameModule.getGameModule();
        mod.addCommandEncoder(this);
        mod.getGameState().addGameComponent(this);
        MenuManager mm = MenuManager.getInstance();
        this.newLogAction.putValue("MnemonicKey", Resources.getString("BasicLogger.begin_logfile.shortcut").charAt(0));
        mm.addAction("BasicLogger.begin_logfile", this.newLogAction);
        this.endLogAction.putValue("MnemonicKey", Resources.getString("BasicLogger.end_logfile.shortcut").charAt(0));
        mm.addAction("BasicLogger.end_logfile", this.endLogAction);
        JButton button = mod.getToolBar().add(this.undoAction);
        button.setFocusable(false);
        button.setToolTipText(Resources.getString("BasicLogger.undo_last_move"));
        button.setAlignmentY(0.0f);
        button = mod.getToolBar().add(this.stepAction);
        button.setToolTipText(Resources.getString("BasicLogger.step_forward_tooltip"));
        button.setAlignmentY(0.0f);
        NamedKeyStrokeListener undoKeyListener = new NamedKeyStrokeListener((ActionListener)this.undoAction, null);
        mod.addKeyStrokeListener(undoKeyListener);
        NamedKeyStrokeListener stepKeyListener = new NamedKeyStrokeListener((ActionListener)this.stepAction, NamedKeyStroke.of(34, 0));
        mod.addKeyStrokeListener(stepKeyListener);
        KeyStrokeListener newLogKeyListener = new KeyStrokeListener(this.newLogAction, KeyStroke.getKeyStroke(87, 512));
        mod.addKeyStrokeListener(newLogKeyListener);
        IconConfigurer stepIconConfig = new IconConfigurer("stepIcon", Resources.getString("BasicLogger.step_forward_button"), STEP_ICON);
        stepIconConfig.setValue(STEP_ICON);
        GlobalOptions.getInstance().addOption(stepIconConfig);
        stepIconConfig.addPropertyChangeListener(evt -> this.stepAction.putValue("SmallIcon", stepIconConfig.getIconValue()));
        stepIconConfig.fireUpdate();
        this.stepKeyConfig = new NamedHotKeyConfigurer("stepHotKey", Resources.getString("BasicLogger.step_forward_hotkey"), stepKeyListener.getNamedKeyStroke());
        GlobalOptions.getInstance().addOption(this.stepKeyConfig);
        this.stepKeyConfig.addPropertyChangeListener(evt -> {
            stepKeyListener.setKeyStroke(this.stepKeyConfig.getValueNamedKeyStroke());
            if (stepKeyListener.getKeyStroke() != null) {
                this.stepAction.putValue("ShortDescription", Resources.getString("BasicLogger.step_forward_tooltip2", NamedHotKeyConfigurer.getString(stepKeyListener.getKeyStroke())));
            } else {
                this.stepAction.putValue("ShortDescription", Resources.getString("BasicLogger.step_forward_tooltip3"));
            }
        });
        this.stepKeyConfig.fireUpdate();
        IconConfigurer undoIconConfig = new IconConfigurer("undoIcon", Resources.getString("BasicLogger.undo_icon"), UNDO_ICON);
        undoIconConfig.setValue(UNDO_ICON);
        GlobalOptions.getInstance().addOption(undoIconConfig);
        undoIconConfig.addPropertyChangeListener(evt -> this.undoAction.putValue("SmallIcon", undoIconConfig.getIconValue()));
        undoIconConfig.fireUpdate();
        this.undoKeyConfig = new NamedHotKeyConfigurer("undoHotKey", Resources.getString("BasicLogger.undo_hotkey"), undoKeyListener.getNamedKeyStroke());
        GlobalOptions.getInstance().addOption(this.undoKeyConfig);
        this.undoKeyConfig.addPropertyChangeListener(evt -> {
            undoKeyListener.setKeyStroke(this.undoKeyConfig.getValueNamedKeyStroke());
            if (undoKeyListener.getKeyStroke() != null) {
                this.undoAction.putValue("ShortDescription", Resources.getString("BasicLogger.undo_tooltip2", NamedHotKeyConfigurer.getString(undoKeyListener.getKeyStroke())));
            } else {
                this.undoAction.putValue("ShortDescription", Resources.getString("BasicLogger.undo_last_move"));
            }
        });
        this.undoKeyConfig.fireUpdate();
        BooleanConfigurer logOptionStart = new BooleanConfigurer(PROMPT_NEW_LOG_START, Resources.getString("BasicLogger.prompt_new_log_before"), Boolean.TRUE);
        mod.getPrefs().addOption(Resources.getString("Prefs.general_tab"), logOptionStart);
        BooleanConfigurer logOptionEnd = new BooleanConfigurer(PROMPT_NEW_LOG_END, Resources.getString("BasicLogger.prompt_new_log_after"), Boolean.TRUE);
        mod.getPrefs().addOption(Resources.getString("Prefs.general_tab"), logOptionEnd);
        BooleanConfigurer logOptionComment = new BooleanConfigurer(PROMPT_LOG_COMMENT, Resources.getString("BasicLogger.enable_comments"), Boolean.TRUE);
        mod.getPrefs().addOption(Resources.getString("Prefs.general_tab"), logOptionComment);
    }

    @Override
    public Element getBuildElement(Document doc) {
        return doc.createElement(this.getClass().getName());
    }

    @Override
    public void add(Buildable b) {
    }

    public void remove(Buildable b) {
    }

    public void setMultiPlayer(boolean multiPlayer) {
        this.multiPlayer = multiPlayer;
    }

    public boolean isMultiPlayer() {
        return this.multiPlayer;
    }

    @Override
    public void setup(boolean startingGame) {
        this.newLogAction.setEnabled(startingGame);
        if (startingGame) {
            this.logOutput.clear();
            this.nextInput = 0;
            this.nextUndo = -1;
            this.dontUndoPast = 0;
            this.beginningState = null;
        } else {
            if (this.endLogAction.isEnabled() && this.beginningState != null && JOptionPane.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("BasicLogger.save_log"), Resources.getString("BasicLogger.unsaved_log"), 0) == 0) {
                try {
                    this.write();
                }
                catch (IOException e) {
                    WriteErrorDialog.error(e, this.outputFile);
                }
            }
            this.logInput.clear();
            this.beginningState = null;
            this.undoAction.setEnabled(false);
            this.endLogAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.outputFile = null;
        }
    }

    public boolean isLogging() {
        return this.outputFile != null;
    }

    public boolean isReplaying() {
        return this.nextInput < this.logInput.size();
    }

    @Override
    public Command getRestoreCommand() {
        return new MultiplayerStateCommand(this.isMultiPlayer());
    }

    public void enableDrawing(boolean show) {
    }

    protected void step() {
        if (!this.isReplaying()) {
            return;
        }
        GameModule g = GameModule.getGameModule();
        Command c = this.logInput.get(this.nextInput++);
        c.execute();
        g.sendAndLog(c);
        this.stepAction.setEnabled(this.isReplaying());
        if (!this.isReplaying() && GameModule.GameFileMode.REPLAYING_GAME.equals((Object)g.getGameFileMode())) {
            g.setGameFileMode(GameModule.GameFileMode.REPLAYED_GAME);
        }
        if (!this.isReplaying()) {
            this.queryNewLogFile(false);
        }
    }

    public void queryNewLogFile(boolean atStart) {
        this.queryNewLogFile(atStart, false);
    }

    public void queryNewLogFile(boolean atStart, boolean fastForwarded) {
        String prompt;
        String prefName;
        GameModule g = GameModule.getGameModule();
        if (this.isLogging() || !g.getGameState().isSaveEnabled()) {
            return;
        }
        if (atStart) {
            prefName = PROMPT_NEW_LOG_START;
            prompt = fastForwarded ? Resources.getString("BasicLogger.append_commencing") : Resources.getString("BasicLogger.replay_commencing");
        } else {
            prefName = PROMPT_NEW_LOG_END;
            String string = prompt = fastForwarded ? Resources.getString("BasicLogger.fast_forward_completed") : Resources.getString("BasicLogger.replay_completed");
        }
        if (Boolean.TRUE.equals(g.getPrefs().getValue(prefName)) || atStart && fastForwarded) {
            Object[] options = new Object[]{Resources.getString("General.yes"), Resources.getString("General.no"), Resources.getString("BasicLogger.dont_prompt_again")};
            int result = JOptionPane.showOptionDialog(g.getPlayerWindow(), Resources.getString("BasicLogger.start_new_log_file", prompt), "", 1, 3, null, options, options[0]);
            if (result == 0) {
                this.beginOutput();
            } else if (result == 2) {
                g.getPrefs().setValue(prefName, Boolean.FALSE);
            }
        }
    }

    public void write() throws IOException {
        if (!this.logOutput.isEmpty()) {
            Command log = this.beginningState;
            for (Command c : this.logOutput) {
                log.append(new LogCommand(c, this.logInput, this.stepAction));
            }
            String logString = GameModule.getGameModule().encode(log);
            try (ZipWriter zw = new ZipWriter(this.outputFile);){
                try (ObfuscatingOutputStream out = new ObfuscatingOutputStream(new BufferedOutputStream(zw.write("savedGame")));){
                    ((OutputStream)out).write(logString.getBytes(StandardCharsets.UTF_8));
                }
                this.metadata.save(zw);
            }
            GameModule.getGameModule().getGameState().setModified(false);
            this.undoAction.setEnabled(false);
            ModuleManagerUpdateHelper.sendGameUpdate(this.outputFile);
        }
        this.endLogAction.setEnabled(false);
    }

    private File getSaveFile() {
        AbstractMetaData md;
        int index;
        Object name;
        GameModule g = GameModule.getGameModule();
        FileChooser fc = g.getFileChooser();
        fc.addChoosableFileFilter(new LogFileFilter());
        Object object = name = fc.getSelectedFile() == null ? null : fc.getSelectedFile().getName();
        if (name != null && (index = ((String)name).lastIndexOf(46)) > 0) {
            name = ((String)name).substring(0, index) + ".vlog";
            fc.setSelectedFile(new File(fc.getSelectedFile().getParent(), (String)name));
        }
        if (fc.showSaveDialog() != 0) {
            return null;
        }
        File file = fc.getSelectedFile();
        if (!file.getName().endsWith(".vlog")) {
            file = new File(file.getParent(), file.getName() + ".vlog");
        }
        if (file.exists() && (md = MetaDataFactory.buildMetaData(file)) instanceof SaveMetaData && Info.hasOldFormat(md.getVassalVersion())) {
            int result = Dialogs.showConfirmDialog(g.getPlayerWindow(), Resources.getString("Warning.log_will_be_updated_title"), Resources.getString("Warning.log_will_be_updated_heading"), Resources.getString("Warning.log_will_be_updated_message", file.getPath(), VersionUtils.truncateToMinorVersion(Info.getVersion())), 2, 2);
            switch (result) {
                case -1: 
                case 2: {
                    return null;
                }
            }
        }
        return file;
    }

    protected void beginOutput() {
        this.outputFile = this.getSaveFile();
        if (this.outputFile == null) {
            return;
        }
        GameModule gm = GameModule.getGameModule();
        this.logOutput.clear();
        this.beginningState = gm.getGameState().getRestoreCommand();
        if (this.beginningState == null) {
            return;
        }
        this.dontUndoPast = 0;
        this.undoAction.setEnabled(false);
        this.endLogAction.setEnabled(true);
        gm.setGameFile(this.outputFile.getName(), GameModule.GameFileMode.LOGGING_GAME);
        GameModule.getGameModule().warn(Resources.getString("BasicLogger.logging_begun"));
        this.newLogAction.setEnabled(false);
        this.metadata = new SaveMetaData();
    }

    public void blockUndo(int block) {
        this.dontUndoPast = this.nextUndo + block;
        this.undoAction.setEnabled(false);
    }

    protected void undo() {
        Command lastInput;
        if (this.nextUndo < this.dontUndoPast) {
            return;
        }
        Command lastOutput = this.logOutput.get(this.nextUndo);
        Command command = lastInput = this.nextInput > this.logInput.size() || this.nextInput < 1 ? null : this.logInput.get(this.nextInput - 1);
        if (lastInput == lastOutput) {
            while (this.nextInput-- > this.dontUndoPast) {
                this.stepAction.setEnabled(true);
                if (this.logInput.get(this.nextInput).getUndoCommand() == null) continue;
            }
        }
        while (this.nextUndo-- > this.dontUndoPast && this.logOutput.get(this.nextUndo).getUndoCommand() == null) {
        }
        this.undoAction.setEnabled(this.nextUndo >= this.dontUndoPast);
        Command undo = new UndoCommand(true).append(lastOutput.getUndoCommand()).append(new UndoCommand(false));
        undo.execute();
        GameModule.getGameModule().getServer().sendToOthers(undo);
        this.logOutput.add(undo);
    }

    public boolean isUndoInProgress() {
        return this.undoInProgress;
    }

    public void setUndoInProgress(boolean undoInProgress) {
        this.undoInProgress = undoInProgress;
    }

    @Override
    public void log(Command c) {
        if (c != null && c.isLoggable()) {
            this.logOutput.add(c);
            if (c.getUndoCommand() != null && !c.getUndoCommand().isNull()) {
                this.nextUndo = this.logOutput.size() - 1;
            }
        }
        this.undoAction.setEnabled(this.nextUndo >= this.dontUndoPast);
    }

    public boolean hasMoreCommands() {
        return this.nextInput < this.logInput.size();
    }

    @Override
    public String encode(Command c) {
        if (c instanceof LogCommand) {
            return LOG + GameModule.getGameModule().encode(((LogCommand)c).getLoggedCommand());
        }
        if (c instanceof UndoCommand) {
            return UNDO + ((UndoCommand)c).isInProgress();
        }
        return null;
    }

    @Override
    public Command decode(String command) {
        if (command.startsWith(LOG)) {
            Command logged = GameModule.getGameModule().decode(command.substring(LOG.length()));
            if (logged == null) {
                return null;
            }
            return new LogCommand(logged, this.logInput, this.stepAction);
        }
        if (command.startsWith(UNDO)) {
            String inProgress = command.substring(UNDO.length());
            return new UndoCommand("true".equals(inProgress));
        }
        return null;
    }

    public class StepAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StepAction() {
            URL iconURL = this.getClass().getResource(BasicLogger.STEP_ICON);
            if (iconURL != null) {
                this.putValue("SmallIcon", new ImageIcon(iconURL));
            } else {
                this.putValue("Name", Resources.getString("BasicLogger.step"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicLogger.this.step();
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            URL iconURL = this.getClass().getResource(BasicLogger.UNDO_ICON);
            if (iconURL != null) {
                this.putValue("SmallIcon", new ImageIcon(iconURL));
            } else {
                this.putValue("Name", Resources.getString("BasicLogger.undo"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicLogger.this.undo();
        }
    }

    private static class MultiplayerStateCommand
    extends Command {
        boolean state;

        MultiplayerStateCommand(boolean state) {
            this.state = state;
        }

        @Override
        protected void executeCommand() {
            Logger log = GameModule.getGameModule().getLogger();
            if (log instanceof BasicLogger) {
                ((BasicLogger)log).setMultiPlayer(this.state);
            }
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class LogCommand
    extends Command {
        protected Command logged;
        protected List<Command> logInput;
        protected Action stepAction;

        public LogCommand(Command c, List<Command> logInput, Action stepAction) {
            if (c instanceof LogCommand) {
                throw new UnsupportedOperationException(Resources.getString("BasicLogger.cant_log"));
            }
            this.logInput = logInput;
            this.stepAction = stepAction;
            this.logged = c;
            for (Command sub : c.getSubCommands()) {
                this.append(new LogCommand(sub, logInput, stepAction));
            }
            this.logged.stripSubCommands();
        }

        @Override
        protected void executeCommand() {
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }

        public Command getLoggedCommand() {
            return this.logged;
        }

        @Override
        public void execute() {
            Command c = this.assembleCommand();
            this.logInput.add(c);
            this.stepAction.setEnabled(true);
        }

        protected Command assembleCommand() {
            Command c = this.logged;
            for (Command sub : this.getSubCommands()) {
                c.append(((LogCommand)sub).assembleCommand());
            }
            return c;
        }
    }

    public static class UndoCommand
    extends Command {
        private final boolean inProgress;

        public UndoCommand(boolean inProgress) {
            this.inProgress = inProgress;
        }

        public boolean isInProgress() {
            return this.inProgress;
        }

        @Override
        protected void executeCommand() {
            GameModule.getGameModule().getBasicLogger().setUndoInProgress(this.inProgress);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

