/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractFolder;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.folder.DeckSubFolder;
import VASSAL.build.module.map.DeckGlobalKeyCommand;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.deck.DeckKeyCommand;
import VASSAL.build.module.map.deck.DeckSendKeyCommand;
import VASSAL.build.module.map.deck.DeckSortKeyCommand;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.widget.CardSlot;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.ComponentDescription;
import VASSAL.configure.Configurer;
import VASSAL.configure.GamePieceFormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedExpressionConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.Deck;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.UniqueIdManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JPopupMenu;

public class DrawPile
extends SetupStack
implements PropertySource,
PropertyNameSource,
ComponentDescription {
    public static final String DESCRIPTION = "description";
    protected Deck dummy = new Deck(GameModule.getGameModule());
    protected boolean reshufflable;
    protected Deck myDeck;
    protected PropertySource source;
    protected String description;
    private final VisibilityCondition colorVisibleCondition = () -> this.dummy.isDrawOutline();
    private final VisibilityCondition reshuffleVisibleCondition = () -> this.reshufflable;
    private final VisibilityCondition faceDownFormatVisibleCondition = () -> this.dummy.getFaceDownOption().equals(USE_MENU) || this.dummy.getFaceDownOption().equals(USE_MENU_UP);
    private final VisibilityCondition reverseFormatVisibleCondition = () -> this.dummy.isReversible();
    private final VisibilityCondition shuffleFormatVisibleCondition = () -> this.dummy.getShuffleOption().equals(USE_MENU);
    private final VisibilityCondition expressionCountingVisibleCondition = () -> this.dummy.doesExpressionCounting();
    private final VisibilityCondition hotkeyOnEmptyVisibleCondition = () -> this.dummy.isHotkeyOnEmpty();
    private final VisibilityCondition selectionAllowedVisibleCondition = () -> this.dummy.isAllowSelectDraw();
    private final VisibilityCondition restrictExpressionVisibleCondition = () -> this.dummy.isRestrictOption();
    private final VisibilityCondition drawMultipleMessageVisibleCondition = () -> this.dummy.isAllowMultipleDraw();
    private final VisibilityCondition drawSpecificMessageVisibleCondition = () -> this.dummy.isAllowSelectDraw();
    private final VisibilityCondition faceUpDownMessageVisibleCondition = () -> USE_MENU.equals(this.dummy.getFaceDownOption()) || USE_MENU_UP.equals(this.dummy.getFaceDownOption());
    private final VisibilityCondition saveVisibleCondition = () -> this.dummy.isPersistable();
    private final VisibilityCondition ownersVisibleCondition = () -> this.dummy.isRestrictAccess();
    protected static final UniqueIdManager idMgr = new UniqueIdManager("Deck");
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String ALLOW_MULTIPLE = "allowMultiple";
    public static final String ALLOW_SELECT = "allowSelect";
    public static final String SELECT_DISPLAY_PROPERTY = "selectDisplayProperty";
    public static final String SELECT_SORT_PROPERTY = "selectSortProperty";
    public static final String FACE_DOWN = "faceDown";
    public static final String DRAW_FACE_UP = "drawFaceUp";
    public static final String FACE_DOWN_REPORT_FORMAT = "faceDownFormat";
    public static final String SHUFFLE = "shuffle";
    public static final String SHUFFLE_REPORT_FORMAT = "shuffleFormat";
    public static final String SHUFFLE_HOTKEY = "shuffleHotkey";
    public static final String SHUFFLE_COMMAND = "shuffleCommand";
    public static final String REVERSIBLE = "reversible";
    public static final String REVERSE_REPORT_FORMAT = "reverseFormat";
    public static final String REVERSE_HOTKEY = "reverseHotkey";
    public static final String REVERSE_COMMAND = "reverseCommand";
    public static final String DRAW = "draw";
    public static final String COLOR = "color";
    public static final String MAXSTACK = "maxStack";
    public static final String EXPRESSIONCOUNTING = "expressionCounting";
    public static final String COUNTEXPRESSIONS = "countExpressions";
    public static final String RESHUFFLABLE = "reshufflable";
    public static final String RESHUFFLE_COMMAND = "reshuffleCommand";
    public static final String RESHUFFLE_TARGET = "reshuffleTarget";
    public static final String RESHUFFLE_MESSAGE = "reshuffleMessage";
    public static final String RESHUFFLE_HOTKEY = "reshuffleHotkey";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String CAN_SAVE = "canSave";
    public static final String HOTKEY_ON_EMPTY = "hotkeyOnEmpty";
    public static final String EMPTY_HOTKEY = "emptyHotkey";
    public static final String RESTRICT_OPTION = "restrictOption";
    public static final String RESTRICT_EXPRESSION = "restrictExpression";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String USE_MENU = "Via right-click Menu";
    public static final String USE_MENU_UP = "MenuDefaultUp";
    public static final String COMMAND_NAME = "commandName";
    public static final String DECK_NAME = "deckName";
    public static final String DRAW_MULTIPLE_MESSAGE = "drawMultipleMessage";
    public static final String DRAW_SPECIFIC_MESSAGE = "drawSpecificMessage";
    public static final String FACE_UP_MESSAGE = "faceUpMessage";
    public static final String FACE_DOWN_MESSAGE = "faceDownMessage";
    public static final String FACE_UP_HOTKEY = "faceUpHotkey";
    public static final String FACE_DOWN_HOTKEY = "faceDownHotkey";
    public static final String FACE_FLIP_HOTKEY = "faceFlipHotkey";
    public static final String FACE_UP_REPORT_FORMAT = "faceUpReportFormat";
    public static final String SAVE_MESSAGE = "saveMessage";
    public static final String LOAD_MESSAGE = "loadMessage";
    public static final String SAVE_HOTKEY = "saveHotkey";
    public static final String LOAD_HOTKEY = "loadHotkey";
    public static final String SAVE_REPORT_FORMAT = "saveReportFormat";
    public static final String LOAD_REPORT_FORMAT = "loadReportFormat";
    public static final String DECK_RESTRICT_ACCESS = "deckRestrictAccess";
    public static final String DECK_OWNERS = "deckOwners";

    @Override
    public void addTo(Buildable parent) {
        super.addTo(parent);
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        idMgr.add(this);
        this.setAttributeTranslatable("name", true);
        if (parent instanceof PropertySource) {
            this.source = (PropertySource)((Object)parent);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getConfigureName() {
        return this.name;
    }

    protected JPopupMenu buildPopup() {
        JPopupMenu popup = new JPopupMenu();
        return popup.getComponentCount() > 0 ? popup : null;
    }

    public void addGlobalKeyCommand(DeckGlobalKeyCommand globalCommand) {
        this.dummy.addGlobalKeyCommand(globalCommand);
    }

    public void removeGlobalKeyCommand(DeckGlobalKeyCommand globalCommand) {
        this.dummy.removeGlobalKeyCommand(globalCommand);
    }

    public static DrawPile findDrawPile(String id) {
        return (DrawPile)idMgr.findInstance(id);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", DESCRIPTION, "owningBoard", "x", "y", WIDTH, HEIGHT, ALLOW_MULTIPLE, DRAW_MULTIPLE_MESSAGE, ALLOW_SELECT, DRAW_SPECIFIC_MESSAGE, SELECT_DISPLAY_PROPERTY, SELECT_SORT_PROPERTY, FACE_DOWN, FACE_FLIP_HOTKEY, FACE_UP_MESSAGE, FACE_UP_HOTKEY, FACE_UP_REPORT_FORMAT, FACE_DOWN_MESSAGE, FACE_DOWN_HOTKEY, FACE_DOWN_REPORT_FORMAT, DRAW_FACE_UP, SHUFFLE, SHUFFLE_COMMAND, SHUFFLE_REPORT_FORMAT, SHUFFLE_HOTKEY, REVERSIBLE, REVERSE_COMMAND, REVERSE_REPORT_FORMAT, REVERSE_HOTKEY, DRAW, COLOR, HOTKEY_ON_EMPTY, EMPTY_HOTKEY, RESHUFFLABLE, RESHUFFLE_COMMAND, RESHUFFLE_MESSAGE, RESHUFFLE_HOTKEY, RESHUFFLE_TARGET, CAN_SAVE, SAVE_MESSAGE, SAVE_HOTKEY, SAVE_REPORT_FORMAT, LOAD_MESSAGE, LOAD_HOTKEY, LOAD_REPORT_FORMAT, MAXSTACK, EXPRESSIONCOUNTING, COUNTEXPRESSIONS, RESTRICT_OPTION, RESTRICT_EXPRESSION, DECK_RESTRICT_ACCESS, DECK_OWNERS};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.description_label"), Resources.getString("Editor.DrawPile.owning_board"), Resources.getString("Editor.x_position"), Resources.getString("Editor.y_position"), Resources.getString("Editor.width"), Resources.getString("Editor.height"), Resources.getString("Editor.DrawPile.multi_draw"), Resources.getString("Editor.DrawPile.draw_multiple_message"), Resources.getString("Editor.DrawPile.specific_draw"), Resources.getString("Editor.DrawPile.draw_specific_message"), Resources.getString("Editor.DrawPile.list_cards"), Resources.getString("Editor.DrawPile.sort_cards"), Resources.getString("Editor.DrawPile.facedown"), Resources.getString("Editor.DrawPile.face_flip_hotkey"), Resources.getString("Editor.DrawPile.face_up_message"), Resources.getString("Editor.DrawPile.face_up_hotkey"), Resources.getString("Editor.DrawPile.face_up_report"), Resources.getString("Editor.DrawPile.face_down_message"), Resources.getString("Editor.DrawPile.face_down_hotkey"), Resources.getString("Editor.DrawPile.facedown_report"), Resources.getString("Editor.DrawPile.faceup"), Resources.getString("Editor.DrawPile.reshuffle"), Resources.getString("Editor.DrawPile.reshuffle_text"), Resources.getString("Editor.DrawPile.reshuffle_report"), Resources.getString("Editor.DrawPile.reshuffle_key"), Resources.getString("Editor.DrawPile.reverse"), Resources.getString("Editor.DrawPile.reverse_text"), Resources.getString("Editor.DrawPile.reverse_report"), Resources.getString("Editor.DrawPile.reverse_key"), Resources.getString("Editor.DrawPile.outline"), Resources.getString("Editor.DrawPile.color"), Resources.getString("Editor.DrawPile.empty_key"), Resources.getString("Editor.DrawPile.empty_keyfrom"), Resources.getString("Editor.DrawPile.send_deck"), Resources.getString("Editor.DrawPile.send_text"), Resources.getString("Editor.DrawPile.send_report"), Resources.getString("Editor.DrawPile.send_key"), Resources.getString("Editor.DrawPile.send_deck_name"), Resources.getString("Editor.DrawPile.saved"), Resources.getString("Editor.DrawPile.save_message"), Resources.getString("Editor.DrawPile.save_key"), Resources.getString("Editor.DrawPile.save_report"), Resources.getString("Editor.DrawPile.load_message"), Resources.getString("Editor.DrawPile.load_key"), Resources.getString("Editor.DrawPile.load_report"), Resources.getString("Editor.DrawPile.maxdisplay"), Resources.getString("Editor.DrawPile.perform_express"), Resources.getString("Editor.DrawPile.count_express"), Resources.getString("Editor.DrawPile.restrict_drag"), Resources.getString("Editor.DrawPile.match_express"), Resources.getString("Editor.DrawPile.deck_restrict_access"), Resources.getString("Editor.DrawPile.deck_owners")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, SetupStack.OwningBoardPrompt.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, String.class, Boolean.class, String.class, PiecePropertyConfig.class, String.class, Prompt2.class, NamedKeyStroke.class, String.class, NamedKeyStroke.class, FormattedStringConfig.class, String.class, NamedKeyStroke.class, FormattedStringConfig.class, Boolean.class, Prompt.class, String.class, FormattedStringConfig.class, NamedKeyStroke.class, Boolean.class, String.class, FormattedStringConfig.class, NamedKeyStroke.class, Boolean.class, Color.class, Boolean.class, NamedKeyStroke.class, Boolean.class, String.class, FormattedStringConfig.class, NamedKeyStroke.class, AssignedDeckPrompt.class, Boolean.class, String.class, NamedKeyStroke.class, FormattedStringConfig.class, String.class, NamedKeyStroke.class, FormattedStringConfig.class, Integer.class, Boolean.class, String[].class, Boolean.class, PropertyExpression.class, Boolean.class, String[].class};
    }

    public boolean isReshufflable() {
        return "true".equals(this.getAttributeValueString(RESHUFFLABLE));
    }

    @Override
    public String getAttributeValueString(String key) {
        if (WIDTH.equals(key)) {
            return String.valueOf(this.dummy.getSize().width);
        }
        if (HEIGHT.equals(key)) {
            return String.valueOf(this.dummy.getSize().height);
        }
        if (FACE_DOWN.equals(key)) {
            return this.dummy.getFaceDownOption();
        }
        if (DRAW_FACE_UP.equals(key)) {
            return String.valueOf(this.dummy.isDrawFaceUp());
        }
        if (SHUFFLE.equals(key)) {
            return this.dummy.getShuffleOption();
        }
        if (REVERSIBLE.equals(key)) {
            return String.valueOf(this.dummy.isReversible());
        }
        if (ALLOW_MULTIPLE.equals(key)) {
            return String.valueOf(this.dummy.isAllowMultipleDraw());
        }
        if (ALLOW_SELECT.equals(key)) {
            return String.valueOf(this.dummy.isAllowSelectDraw());
        }
        if (SELECT_DISPLAY_PROPERTY.equals(key)) {
            return this.dummy.getSelectDisplayProperty();
        }
        if (SELECT_SORT_PROPERTY.equals(key)) {
            return this.dummy.getSelectSortProperty();
        }
        if (DRAW.equals(key)) {
            return String.valueOf(this.dummy.isDrawOutline());
        }
        if (COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.dummy.getOutlineColor());
        }
        if (MAXSTACK.equals(key)) {
            return String.valueOf(this.dummy.getMaxStack());
        }
        if (EXPRESSIONCOUNTING.equals(key)) {
            return String.valueOf(this.dummy.doesExpressionCounting());
        }
        if (COUNTEXPRESSIONS.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.dummy.getCountExpressions());
        }
        if (RESHUFFLABLE.equals(key)) {
            return String.valueOf(this.reshufflable || this.dummy.getReshuffleCommand().length() > 0 || this.dummy.getReshuffleTarget().length() > 0 || this.dummy.getReshuffleMsgFormat().length() > 0 || this.dummy.getReshuffleKey() != NamedKeyStroke.NULL_KEYSTROKE);
        }
        if (RESHUFFLE_COMMAND.equals(key)) {
            return this.dummy.getReshuffleCommand();
        }
        if (RESHUFFLE_TARGET.equals(key)) {
            return this.dummy.getReshuffleTarget();
        }
        if (RESHUFFLE_MESSAGE.equals(key)) {
            return this.dummy.getReshuffleMsgFormat();
        }
        if (RESHUFFLE_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getReshuffleKey());
        }
        if (SHUFFLE_COMMAND.equals(key)) {
            return this.dummy.getShuffleCommand();
        }
        if (SHUFFLE_REPORT_FORMAT.equals(key)) {
            return this.dummy.getShuffleMsgFormat();
        }
        if (SHUFFLE_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getShuffleKey());
        }
        if (REVERSE_COMMAND.equals(key)) {
            return this.dummy.getReverseCommand();
        }
        if (REVERSE_REPORT_FORMAT.equals(key)) {
            return this.dummy.getReverseMsgFormat();
        }
        if (REVERSE_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getReverseKey());
        }
        if (FACE_DOWN_REPORT_FORMAT.equals(key)) {
            return this.dummy.getFaceDownMsgFormat();
        }
        if (CAN_SAVE.equals(key)) {
            return String.valueOf(this.dummy.isPersistable());
        }
        if (HOTKEY_ON_EMPTY.equals(key)) {
            return String.valueOf(this.dummy.isHotkeyOnEmpty());
        }
        if (EMPTY_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getNamedEmptyKey());
        }
        if (RESTRICT_OPTION.equals(key)) {
            return String.valueOf(this.dummy.isRestrictOption());
        }
        if (RESTRICT_EXPRESSION.equals(key)) {
            return this.dummy.getRestrictExpression().getExpression();
        }
        if (DRAW_MULTIPLE_MESSAGE.equals(key)) {
            return this.dummy.getDrawMultipleMessage();
        }
        if (DRAW_SPECIFIC_MESSAGE.equals(key)) {
            return this.dummy.getDrawSpecificMessage();
        }
        if (FACE_UP_MESSAGE.equals(key)) {
            return this.dummy.getFaceUpMessage();
        }
        if (FACE_DOWN_MESSAGE.equals(key)) {
            return this.dummy.getFaceDownMessage();
        }
        if (FACE_UP_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getFaceUpKey());
        }
        if (FACE_FLIP_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getFaceFlipKey());
        }
        if (FACE_DOWN_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getFaceDownKey());
        }
        if (FACE_UP_REPORT_FORMAT.equals(key)) {
            return this.dummy.getFaceUpMsgFormat();
        }
        if (SAVE_MESSAGE.equals(key)) {
            return this.dummy.getSaveMessage();
        }
        if (SAVE_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getSaveKey());
        }
        if (SAVE_REPORT_FORMAT.equals(key)) {
            return this.dummy.getSaveReport();
        }
        if (LOAD_MESSAGE.equals(key)) {
            return this.dummy.getLoadMessage();
        }
        if (LOAD_HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.dummy.getLoadKey());
        }
        if (LOAD_REPORT_FORMAT.equals(key)) {
            return this.dummy.getLoadReport();
        }
        if (DECK_RESTRICT_ACCESS.equals(key)) {
            return String.valueOf(this.dummy.isRestrictAccess());
        }
        if (DECK_OWNERS.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.dummy.getOwners());
        }
        if (DESCRIPTION.equals(key)) {
            return this.description;
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (value == null) {
            return;
        }
        if (WIDTH.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.dummy.getSize().width = (Integer)value;
        } else if (HEIGHT.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.dummy.getSize().height = (Integer)value;
        } else if (FACE_DOWN.equals(key)) {
            this.dummy.setFaceDownOption((String)value);
        } else if (DRAW_FACE_UP.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setDrawFaceUp(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setDrawFaceUp("true".equals(value));
            }
        } else if (CAN_SAVE.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setPersistable(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setPersistable("true".equals(value));
            }
        } else if (SHUFFLE.equals(key)) {
            this.dummy.setShuffleOption((String)value);
        } else if (REVERSIBLE.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setReversible(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setReversible("true".equals(value));
            }
        } else if (ALLOW_MULTIPLE.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setAllowMultipleDraw(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setAllowMultipleDraw("true".equals(value));
            }
        } else if (ALLOW_SELECT.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setAllowSelectDraw(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setAllowSelectDraw("true".equals(value));
            }
        } else if (SELECT_DISPLAY_PROPERTY.equals(key)) {
            this.dummy.setSelectDisplayProperty((String)value);
        } else if (SELECT_SORT_PROPERTY.equals(key)) {
            this.dummy.setSelectSortProperty((String)value);
        } else if (DRAW.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setDrawOutline(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setDrawOutline("true".equals(value));
            }
        } else if (COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.dummy.setOutlineColor((Color)value);
        }
        if (MAXSTACK.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.dummy.setMaxStack((Integer)value);
        }
        if (EXPRESSIONCOUNTING.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setExpressionCounting(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setExpressionCounting("true".equals(value));
            }
        }
        if (COUNTEXPRESSIONS.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.dummy.setCountExpressions(value);
        } else if (RESHUFFLABLE.equals(key)) {
            boolean bl = this.reshufflable = "true".equals(value) || Boolean.TRUE.equals(value);
            if (!this.reshufflable) {
                this.dummy.setReshuffleCommand("");
                this.dummy.setReshuffleKey(NamedKeyStroke.NULL_KEYSTROKE);
                this.dummy.setReshuffleTarget("");
                this.dummy.setReshuffleMsgFormat("");
            }
        } else if (RESHUFFLE_COMMAND.equals(key)) {
            this.dummy.setReshuffleCommand((String)value);
        } else if (RESHUFFLE_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.dummy.setReshuffleKey((NamedKeyStroke)value);
        } else if (RESHUFFLE_TARGET.equals(key)) {
            this.dummy.setReshuffleTarget((String)value);
        } else if (RESHUFFLE_MESSAGE.equals(key)) {
            this.dummy.setReshuffleMsgFormat((String)value);
        } else if (REVERSE_COMMAND.equals(key)) {
            this.dummy.setReverseCommand((String)value);
        } else if (REVERSE_REPORT_FORMAT.equals(key)) {
            this.dummy.setReverseMsgFormat((String)value);
        } else if (REVERSE_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.dummy.setReverseKey((NamedKeyStroke)value);
        } else if (SHUFFLE_COMMAND.equals(key)) {
            this.dummy.setShuffleCommand((String)value);
        } else if (SHUFFLE_REPORT_FORMAT.equals(key)) {
            this.dummy.setShuffleMsgFormat((String)value);
        } else if (SHUFFLE_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.dummy.setShuffleKey((NamedKeyStroke)value);
        } else if (FACE_DOWN_REPORT_FORMAT.equals(key)) {
            this.dummy.setFaceDownMsgFormat((String)value);
        } else if ("name".equals(key)) {
            this.dummy.setDeckName((String)value);
            super.setAttribute(key, value);
        } else if (HOTKEY_ON_EMPTY.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setHotkeyOnEmpty(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setHotkeyOnEmpty("true".equals(value));
            }
        } else if (EMPTY_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.dummy.setEmptyKey((NamedKeyStroke)value);
        } else if (RESTRICT_OPTION.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setRestrictOption(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setRestrictOption("true".equals(value));
            }
        } else if (RESTRICT_EXPRESSION.equals(key)) {
            if (value instanceof String) {
                value = new PropertyExpression((String)value);
            }
            this.dummy.setRestrictExpression((PropertyExpression)value);
        } else if (DRAW_MULTIPLE_MESSAGE.equals(key)) {
            this.dummy.setDrawMultipleMessage((String)value);
        } else if (DRAW_SPECIFIC_MESSAGE.equals(key)) {
            this.dummy.setDrawSpecificMessage((String)value);
        } else if (FACE_UP_MESSAGE.equals(key)) {
            this.dummy.setFaceUpMessage((String)value);
        } else if (FACE_DOWN_MESSAGE.equals(key)) {
            this.dummy.setFaceDownMessage((String)value);
        } else if (FACE_UP_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.dummy.setFaceUpKey((NamedKeyStroke)value);
        } else if (FACE_FLIP_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.dummy.setFaceFlipKey((NamedKeyStroke)value);
        } else if (FACE_DOWN_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.dummy.setFaceDownKey((NamedKeyStroke)value);
        } else if (FACE_UP_REPORT_FORMAT.equals(key)) {
            this.dummy.setFaceUpMsgFormat((String)value);
        } else if (SAVE_MESSAGE.equals(key)) {
            this.dummy.setSaveMessage((String)value);
        } else if (SAVE_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.dummy.setSaveKey((NamedKeyStroke)value);
        } else if (SAVE_REPORT_FORMAT.equals(key)) {
            this.dummy.setSaveReport((String)value);
        } else if (LOAD_MESSAGE.equals(key)) {
            this.dummy.setLoadMessage((String)value);
        } else if (LOAD_HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.dummy.setLoadKey((NamedKeyStroke)value);
        } else if (LOAD_REPORT_FORMAT.equals(key)) {
            this.dummy.setLoadReport((String)value);
        } else if (DECK_RESTRICT_ACCESS.equals(key)) {
            if (value instanceof Boolean) {
                this.dummy.setRestrictAccess(Boolean.TRUE.equals(value));
            } else {
                this.dummy.setRestrictAccess("true".equals(value));
            }
        } else if (DECK_OWNERS.equals(key)) {
            if (value instanceof String) {
                this.dummy.setOwners(StringArrayConfigurer.stringToArray((String)value));
            } else if (value instanceof String[]) {
                this.dummy.setOwners(value);
            }
        } else if (DESCRIPTION.equals(key)) {
            this.description = (String)value;
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (COLOR.equals(name)) {
            return this.colorVisibleCondition;
        }
        if (List.of(RESHUFFLE_COMMAND, RESHUFFLE_MESSAGE, RESHUFFLE_TARGET, RESHUFFLE_HOTKEY).contains(name)) {
            return this.reshuffleVisibleCondition;
        }
        if (FACE_DOWN_REPORT_FORMAT.equals(name)) {
            return this.faceDownFormatVisibleCondition;
        }
        if (List.of(SHUFFLE_REPORT_FORMAT, SHUFFLE_HOTKEY, SHUFFLE_COMMAND).contains(name)) {
            return this.shuffleFormatVisibleCondition;
        }
        if (List.of(REVERSE_REPORT_FORMAT, REVERSE_HOTKEY, REVERSE_COMMAND).contains(name)) {
            return this.reverseFormatVisibleCondition;
        }
        if (COUNTEXPRESSIONS.equals(name)) {
            return this.expressionCountingVisibleCondition;
        }
        if (EMPTY_HOTKEY.equals(name)) {
            return this.hotkeyOnEmptyVisibleCondition;
        }
        if (SELECT_DISPLAY_PROPERTY.equals(name) || SELECT_SORT_PROPERTY.equals(name)) {
            return this.selectionAllowedVisibleCondition;
        }
        if (RESTRICT_EXPRESSION.equals(name)) {
            return this.restrictExpressionVisibleCondition;
        }
        if (DRAW_MULTIPLE_MESSAGE.equals(name)) {
            return this.drawMultipleMessageVisibleCondition;
        }
        if (DRAW_SPECIFIC_MESSAGE.equals(name)) {
            return this.drawSpecificMessageVisibleCondition;
        }
        if (List.of(FACE_DOWN_MESSAGE, FACE_UP_MESSAGE, FACE_DOWN_HOTKEY, FACE_UP_HOTKEY, FACE_FLIP_HOTKEY, FACE_DOWN_REPORT_FORMAT, FACE_UP_REPORT_FORMAT).contains(name)) {
            return this.faceUpDownMessageVisibleCondition;
        }
        if (List.of(SAVE_MESSAGE, SAVE_HOTKEY, SAVE_REPORT_FORMAT, LOAD_MESSAGE, LOAD_HOTKEY, LOAD_REPORT_FORMAT).contains(name)) {
            return this.saveVisibleCondition;
        }
        if (DECK_OWNERS.equals(name)) {
            return this.ownersVisibleCondition;
        }
        return null;
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{DeckSubFolder.class, CardSlot.class, DeckGlobalKeyCommand.class, DeckSortKeyCommand.class, DeckSendKeyCommand.class};
    }

    public Point getPosition() {
        Point p = new Point(this.pos);
        Board b = this.getMap().getBoardByName(this.owningBoardName);
        if (b == null) {
            p.translate(this.getMap().getEdgeBuffer().width, this.getMap().getEdgeBuffer().height);
        } else {
            p.translate(b.bounds().x, b.bounds().y);
        }
        return p;
    }

    @Override
    public Map getMap() {
        return super.getMap();
    }

    public Rectangle boundingBox() {
        return this.myDeck == null ? null : this.myDeck.boundingBox();
    }

    public Command addToContents(GamePiece p) {
        return this.addToContents(p, true);
    }

    public Command addToContents(GamePiece p, boolean checkAccessibility) {
        if (this.myDeck != null && this.myDeck.indexOf(p) >= 0) {
            return new NullCommand();
        }
        if (this.myDeck != null && checkAccessibility && !this.myDeck.isAccessible()) {
            return new NullCommand();
        }
        return this.getMap().placeOrMerge(p, this.myDeck == null ? this.getPosition() : this.myDeck.getPosition());
    }

    public Deck makeDeck() {
        this.myDeck = new Deck(GameModule.getGameModule(), this.getDeckType());
        this.myDeck.setPropertySource(this.source);
        this.myDeck.setFaceDown(!NEVER.equals(this.dummy.getFaceDownOption()) && !USE_MENU_UP.equals(this.dummy.getFaceDownOption()));
        return this.myDeck;
    }

    @Override
    protected Stack initializeContents() {
        Stack s = super.initializeContents();
        this.myDeck = new Deck(GameModule.getGameModule(), this.getDeckType());
        this.myDeck.setPropertySource(this.source);
        s.asList().forEach(gamePiece -> this.myDeck.add((GamePiece)gamePiece));
        this.myDeck.setFaceDown(!NEVER.equals(this.dummy.getFaceDownOption()) && !USE_MENU_UP.equals(this.dummy.getFaceDownOption()));
        return this.myDeck;
    }

    public void setDeck(Deck deck) {
        this.myDeck = deck;
    }

    public Deck getDeck() {
        return this.myDeck;
    }

    @Override
    protected boolean placeNonStackingSeparately() {
        return false;
    }

    public String getDeckType() {
        return this.dummy.getType();
    }

    public Dimension getSize() {
        return this.dummy.getSize();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Deck.html");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DrawPile.deck");
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData myI18nData = super.getI18nData();
        myI18nData.setAttributeTranslatable(SELECT_DISPLAY_PROPERTY, false);
        myI18nData.setAttributeTranslatable(SELECT_SORT_PROPERTY, false);
        return myI18nData;
    }

    @Override
    public Object getProperty(Object key) {
        if (this.source != null) {
            return this.source.getProperty(key);
        }
        return null;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (this.source != null) {
            return this.source.getLocalizedProperty(key);
        }
        return null;
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.getConfigureName() + "_numPieces");
        for (String ce : this.dummy.getCountExpressions()) {
            l.add(this.getConfigureName() + "_" + new Deck.CountExpression(ce).getName());
        }
        if (this.dummy.isRestrictAccess()) {
            l.addAll(Arrays.asList(this.dummy.getOwners()));
        }
        return l;
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> l = new ArrayList<String>(super.getExpressionList());
        if (this.dummy != null) {
            if (this.dummy.isRestrictOption()) {
                l.add(this.dummy.getRestrictExpression().getExpression());
            }
            if (this.dummy.doesExpressionCounting()) {
                l.addAll(Arrays.asList(this.dummy.getCountExpressions()));
            }
            l.add(this.dummy.getSelectDisplayProperty());
            l.add(this.dummy.getSelectSortProperty());
        }
        return l;
    }

    @Override
    public List<String> getFormattedStringList() {
        if (this.dummy != null) {
            ArrayList<String> l = new ArrayList<String>();
            if (USE_MENU.equals(this.dummy.getShuffleOption())) {
                l.add(this.dummy.getShuffleMsgFormat());
            }
            if (this.isReshufflable()) {
                l.add(this.dummy.getReshuffleMsgFormat());
            }
            if (this.dummy.isReversible()) {
                l.add(this.dummy.getReverseMsgFormat());
            }
            if (this.dummy.isPersistable()) {
                l.add(this.dummy.getSaveReport());
                l.add(this.dummy.getLoadReport());
            }
            if (USE_MENU.equals(this.dummy.getFaceDownOption()) || USE_MENU_UP.equals(this.dummy.getFaceDownOption())) {
                l.add(this.dummy.getFaceDownMsgFormat());
                l.add(this.dummy.getFaceUpMsgFormat());
            }
            return l;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getPropertyList() {
        if (this.dummy != null) {
            return List.of(this.dummy.getSelectDisplayProperty(), this.dummy.getSelectSortProperty());
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getMenuTextList() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.dummy != null) {
            if (USE_MENU.equals(this.dummy.getShuffleOption())) {
                l.add(this.dummy.getShuffleCommand());
            }
            if (this.isReshufflable()) {
                l.add(this.dummy.getReshuffleCommand());
            }
            if (this.dummy.isReversible()) {
                l.add(this.dummy.getReverseCommand());
            }
            if (this.dummy.isPersistable()) {
                l.add(this.dummy.getSaveMessage());
                l.add(this.dummy.getLoadMessage());
            }
            if (USE_MENU.equals(this.dummy.getFaceDownOption()) || USE_MENU_UP.equals(this.dummy.getFaceDownOption())) {
                l.add(this.dummy.getFaceDownMessage());
                l.add(this.dummy.getFaceUpMessage());
            }
        }
        return l;
    }

    @Override
    public void setup(boolean gameStarting) {
        super.setup(gameStarting);
        if (this.myDeck != null) {
            if (gameStarting) {
                this.myDeck.addListeners();
            } else {
                this.myDeck.removeListeners();
            }
        }
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        if (this.dummy != null) {
            ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>();
            l.add(this.dummy.getNamedEmptyKey());
            if (USE_MENU.equals(this.dummy.getShuffleOption())) {
                l.add(this.dummy.getShuffleKey());
            }
            if (this.isReshufflable()) {
                l.add(this.dummy.getReshuffleKey());
            }
            if (this.dummy.isReversible()) {
                l.add(this.dummy.getReverseKey());
            }
            if (this.dummy.isPersistable()) {
                l.add(this.dummy.getSaveKey());
                l.add(this.dummy.getLoadKey());
            }
            if (USE_MENU.equals(this.dummy.getFaceDownOption()) || USE_MENU_UP.equals(this.dummy.getFaceDownOption())) {
                l.add(this.dummy.getFaceDownKey());
                l.add(this.dummy.getFaceUpKey());
                l.add(this.dummy.getFaceFlipKey());
            }
            return l;
        }
        return Collections.emptyList();
    }

    public List<DeckKeyCommand> getDeckKeyCommands() {
        return this.getAllDescendantComponentsOf(DeckKeyCommand.class);
    }

    public static class PiecePropertyConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new GamePieceFormattedStringConfigurer(key, name);
        }
    }

    public static class Prompt2
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{DrawPile.ALWAYS, DrawPile.NEVER, DrawPile.USE_MENU, DrawPile.USE_MENU_UP};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.always", "Editor.never", "Editor.DrawPile.use_menu_down", "Editor.DrawPile.use_menu_up"};
        }
    }

    public static class FormattedStringConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedExpressionConfigurer(key, name, new String[]{DrawPile.DECK_NAME, DrawPile.COMMAND_NAME});
        }
    }

    public static class Prompt
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{DrawPile.ALWAYS, DrawPile.NEVER, DrawPile.USE_MENU};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.always", "Editor.never", "Editor.DrawPile.use_menu"};
        }
    }

    public static class AssignedDeckPrompt
    extends TranslatableStringEnum {
        public static final String NONE = "<none>";
        public static final String NONE_NAME = Resources.getString("Editor.DrawPile.none");

        @Override
        public boolean isDisplayNames() {
            return true;
        }

        @Override
        public String[] getValidValues(AutoConfigurable target) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(NONE);
            for (GameComponent g : GameModule.getGameModule().getGameState().getGameComponents()) {
                if (!(g instanceof Map)) continue;
                for (DrawPile dp : ((Map)g).getComponentsOf(DrawPile.class)) {
                    if (dp.getConfigureName() == null) continue;
                    l.add(dp.getConfigureName());
                }
            }
            return l.toArray(new String[0]);
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(NONE_NAME);
            for (GameComponent g : GameModule.getGameModule().getGameState().getGameComponents()) {
                if (!(g instanceof Map)) continue;
                for (DrawPile dp : ((Map)g).getComponentsOf(DrawPile.class)) {
                    if (dp.getLocalizedConfigureName() == null) continue;
                    l.add(dp.getLocalizedConfigureName());
                }
            }
            return l.toArray(new String[0]);
        }
    }
}

