/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Zoomer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.SendToLocation;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import java.awt.Point;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class MoveCameraButton
extends AbstractToolbarItem {
    public static final String MOVE_CAMERA_MODE = "moveCameraMode";
    public static final String ZOOM = "zoom";
    public static final String BOARD_NAME = "boardName";
    public static final String X_POS = "xPos";
    public static final String Y_POS = "yPos";
    public static final String ZONE_NAME = "zoneName";
    public static final String GRID_LOCATION = "gridLocation";
    public static final String REGION_NAME = "regionName";
    public static final String PROPERTY_FILTER = "propertyFilter";
    public static final String X_OFFSET = "xOffset";
    public static final String Y_OFFSET = "yOffset";
    protected String moveCameraMode = "L";
    protected FormattedString zoom = new FormattedString("");
    protected FormattedString board = new FormattedString("");
    protected FormattedString x = new FormattedString("");
    protected FormattedString y = new FormattedString("");
    protected FormattedString gridLocation = new FormattedString("");
    protected FormattedString zone = new FormattedString("");
    protected FormattedString region = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("0");
    protected FormattedString yOffset = new FormattedString("0");
    protected PropertyExpression propertyFilter = new PropertyExpression("");
    protected Map map;

    public MoveCameraButton() {
        this.setNameKey("");
        this.setLaunchButton(this.makeLaunchButton(Resources.getString("Editor.MoveCameraButton.move_camera_tooltip"), Resources.getString("Editor.MoveCameraButton.move_camera"), "/images/recenter.gif", e -> this.moveCamera()));
    }

    private void offsetDest(Point dest) {
        int dy;
        int dx;
        String dxString = this.xOffset.getText((PropertySource)this.map, "0", (Auditable)this, AuditTrail.create((Auditable)this, this.xOffset.getFormat(), "X Offset"));
        String dyString = this.xOffset.getText((PropertySource)this.map, "0", (Auditable)this, AuditTrail.create((Auditable)this, this.yOffset.getFormat(), "Y Offset"));
        try {
            dx = Integer.parseInt(dxString);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(this, Resources.getString("Error.non_number_error"), this.xOffset.debugInfo(dxString, "X Offset")));
            return;
        }
        try {
            dy = Integer.parseInt(dyString);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataWarning(new BadDataReport(this, Resources.getString("Error.non_number_error"), this.yOffset.debugInfo(dyString, "Y Offset")));
            return;
        }
        dest.x += dx;
        dest.y += dy;
    }

    private Point getDestination() {
        SendToLocation.Destination dest = SendToLocation.getSendLocation(this.map, this, this.moveCameraMode, null, this.board, this.zone, this.region, this.gridLocation, this.x, this.y, this.propertyFilter, this.map, this.map.getCenter());
        if (dest.point != null) {
            this.offsetDest(dest.point);
        }
        return dest.point;
    }

    private void moveCamera() {
        Point dest = this.getDestination();
        if (dest != null) {
            String zoomString = this.zoom.getText((PropertySource)this.map, (Auditable)this, "Editor.MoveCameraButton.zoom");
            if (!zoomString.strip().isEmpty()) {
                Zoomer zoomer;
                double toZoom;
                try {
                    toZoom = Double.parseDouble(zoomString);
                }
                catch (NumberFormatException e) {
                    ErrorDialog.dataWarning(new BadDataReport(this, Resources.getString("Error.non_number_error"), Resources.getString("Editor.MoveCameraButton.zoom") + ": " + zoomString, (Throwable)e));
                    toZoom = 0.0;
                }
                if (toZoom > 0.0 && (zoomer = this.map.getZoomer()) != null) {
                    zoomer.setZoomFactor(toZoom);
                }
            }
            this.map.centerAt(dest);
        }
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.MoveCameraButton.component_type");
    }

    @Override
    public void addTo(Buildable parent) {
        this.map = (Map)parent;
        this.map.getToolBar().add(this.getLaunchButton());
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String key) {
        if (List.of(MOVE_CAMERA_MODE, X_OFFSET, Y_OFFSET, ZOOM).contains(key)) {
            return () -> true;
        }
        if (BOARD_NAME.equals(key)) {
            return () -> "G".equals(this.moveCameraMode) || "L".equals(this.moveCameraMode);
        }
        if (ZONE_NAME.equals(key)) {
            return () -> "Z".equals(this.moveCameraMode);
        }
        if (REGION_NAME.equals(key)) {
            return () -> "R".equals(this.moveCameraMode);
        }
        if (GRID_LOCATION.equals(key)) {
            return () -> "G".equals(this.moveCameraMode);
        }
        if (X_POS.equals(key) || Y_POS.equals(key)) {
            return () -> "G".equals(this.moveCameraMode) || "L".equals(this.moveCameraMode);
        }
        if (PROPERTY_FILTER.equals(key)) {
            return () -> "A".equals(this.moveCameraMode) || "C".equals(this.moveCameraMode) || "N".equals(this.moveCameraMode);
        }
        return super.getAttributeVisibility(key);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.MoveCameraButton.move_camera_mode"), Resources.getString("Editor.MoveCameraButton.board"), Resources.getString("Editor.MoveCameraButton.zone"), Resources.getString("Editor.MoveCameraButton.region"), Resources.getString("Editor.MoveCameraButton.grid"), Resources.getString("Editor.MoveCameraButton.x"), Resources.getString("Editor.MoveCameraButton.y"), Resources.getString("Editor.MoveCameraButton.x_offset"), Resources.getString("Editor.MoveCameraButton.y_offset"), Resources.getString("Editor.MoveCameraButton.property_filter"), Resources.getString("Editor.MoveCameraButton.zoom")});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{MOVE_CAMERA_MODE, BOARD_NAME, ZONE_NAME, REGION_NAME, GRID_LOCATION, X_POS, Y_POS, X_OFFSET, Y_OFFSET, PROPERTY_FILTER, ZOOM});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{DestConfig.class, EmptyFormatConfig.class, EmptyFormatConfig.class, EmptyFormatConfig.class, EmptyFormatConfig.class, EmptyFormatConfig.class, EmptyFormatConfig.class, EmptyFormatConfig.class, EmptyFormatConfig.class, PropertyExpression.class, EmptyFormatConfig.class});
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (MOVE_CAMERA_MODE.equals(key)) {
            if (value instanceof String) {
                this.moveCameraMode = (String)value;
            }
        } else if (BOARD_NAME.equals(key)) {
            this.board.setFormat((String)value);
        } else if (ZONE_NAME.equals(key)) {
            this.zone.setFormat((String)value);
        } else if (REGION_NAME.equals(key)) {
            this.region.setFormat((String)value);
        } else if (GRID_LOCATION.equals(key)) {
            this.gridLocation.setFormat((String)value);
        } else if (X_POS.equals(key)) {
            this.x.setFormat((String)value);
        } else if (Y_POS.equals(key)) {
            this.y.setFormat((String)value);
        } else if (X_OFFSET.equals(key)) {
            this.xOffset.setFormat((String)value);
        } else if (Y_OFFSET.equals(key)) {
            this.yOffset.setFormat((String)value);
        } else if (PROPERTY_FILTER.equals(key)) {
            this.propertyFilter.setExpression((String)value);
        } else if (ZOOM.equals(key)) {
            this.zoom.setFormat((String)value);
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (MOVE_CAMERA_MODE.equals(key)) {
            return this.moveCameraMode;
        }
        if (BOARD_NAME.equals(key)) {
            return this.board.getFormat();
        }
        if (ZONE_NAME.equals(key)) {
            return this.zone.getFormat();
        }
        if (REGION_NAME.equals(key)) {
            return this.region.getFormat();
        }
        if (GRID_LOCATION.equals(key)) {
            return this.gridLocation.getFormat();
        }
        if (X_POS.equals(key)) {
            return this.x.getFormat();
        }
        if (Y_POS.equals(key)) {
            return this.y.getFormat();
        }
        if (X_OFFSET.equals(key)) {
            return this.xOffset.getFormat();
        }
        if (Y_OFFSET.equals(key)) {
            return this.yOffset.getFormat();
        }
        if (PROPERTY_FILTER.equals(key)) {
            return this.propertyFilter.getExpression();
        }
        if (ZOOM.equals(key)) {
            return this.zoom.getFormat();
        }
        return super.getAttributeValueString(key);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "MoveCameraButton");
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.map.getToolBar().remove(this.getLaunchButton());
    }

    public static class DestConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return SendToLocation.DEST_OPTIONS;
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return SendToLocation.DEST_KEYS;
        }
    }

    public static class EmptyFormatConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedExpressionConfigurer(key, name, new String[0]);
        }
    }
}

