/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.deck;

import VASSAL.build.GameModule;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.deck.AbstractDeckKeyCommand;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.Deck;
import VASSAL.counters.KeyCommand;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.FormattedStringExpression;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class DeckSendKeyCommand
extends AbstractDeckKeyCommand {
    public static final String TARGET_DECK = "targetDeck";
    public static final String VARIABLE_DECK = "variableDeck";
    public static final String DECK_EXPRESSION = "deckExpression";
    public static final String SEND_MATCHING = "sendMatching";
    public static final String MATCH_EXPRESSION = "matchExpression";
    public static final String LIMIT_TOTAL = "limitTotal";
    public static final String LIMIT_EXPRESSION = "limitExpression";
    public static final String STOP = "stop";
    public static final String STOP_EXPRESSION = "stopExpression";
    public static final String STOP_INCLUDE = "stopAlso";
    public static final String ORDER = "order";
    public static final String SENT_COUNT = "sentCount";
    public static final String APPLY_ON_MOVE = "applyOnMove";
    private NamedKeyStrokeListener sendListener;
    private String targetDeck = "";
    private boolean variableDeck = false;
    private final FormattedString deckExpression = new FormattedString("{}");
    private boolean sendMatching = false;
    private final FormattedString matchExpression = new FormattedString("{}");
    private boolean limitTotal = false;
    private final FormattedString limitExpression = new FormattedString("{}");
    private boolean stop = false;
    private final FormattedString stopExpresson = new FormattedString("{}");
    private boolean stopInclude;
    private boolean applyOnMove = false;

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DeckSendKeyCommand.component_type");
    }

    public String getTargetDeck() {
        return this.targetDeck;
    }

    public NamedKeyStrokeListener getSendListener() {
        return this.sendListener;
    }

    public boolean isVariableDeck() {
        return this.variableDeck;
    }

    public FormattedString getDeckExpression() {
        return this.deckExpression;
    }

    public boolean isSendMatching() {
        return this.sendMatching;
    }

    public FormattedString getMatchExpression() {
        return this.matchExpression;
    }

    public boolean isLimitTotal() {
        return this.limitTotal;
    }

    public FormattedString getLimitExpression() {
        return this.limitExpression;
    }

    public boolean isStop() {
        return this.stop;
    }

    public FormattedString getStopExpresson() {
        return this.stopExpresson;
    }

    public boolean isStopInclude() {
        return this.stopInclude;
    }

    public boolean isApplyOnMove() {
        return this.applyOnMove;
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{VARIABLE_DECK, TARGET_DECK, DECK_EXPRESSION, SEND_MATCHING, MATCH_EXPRESSION, LIMIT_TOTAL, LIMIT_EXPRESSION, STOP, STOP_EXPRESSION, STOP_INCLUDE, APPLY_ON_MOVE});
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.DeckSendKeyCommand.variable_deck"), Resources.getString("Editor.DeckSendKeyCommand.deck_name"), Resources.getString("Editor.DeckSendKeyCommand.deck_expression"), Resources.getString("Editor.DeckSendKeyCommand.send_matching"), Resources.getString("Editor.DeckSendKeyCommand.send_expression"), Resources.getString("Editor.DeckSendKeyCommand.limit"), Resources.getString("Editor.DeckSendKeyCommand.limit_expression"), Resources.getString("Editor.DeckSendKeyCommand.stop"), Resources.getString("Editor.DeckSendKeyCommand.stop_expression"), Resources.getString("Editor.DeckSendKeyCommand.stop_include"), Resources.getString("Editor.DeckSendKeyCommand.order"), Resources.getString("Editor.DeckSendKeyCommand.apply_on_move")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{Boolean.class, DrawPile.AssignedDeckPrompt.class, FormattedStringExpression.class, Boolean.class, FormattedStringExpression.class, Boolean.class, FormattedStringExpression.class, Boolean.class, FormattedStringExpression.class, Boolean.class, Boolean.class});
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (TARGET_DECK.equals(key)) {
            this.targetDeck = (String)value;
        } else if (VARIABLE_DECK.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.variableDeck = (Boolean)value;
        } else if (DECK_EXPRESSION.equals(key)) {
            this.deckExpression.setFormat((String)value);
        } else if (SEND_MATCHING.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.sendMatching = (Boolean)value;
        } else if (MATCH_EXPRESSION.equals(key)) {
            this.matchExpression.setFormat((String)value);
        } else if (LIMIT_TOTAL.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.limitTotal = (Boolean)value;
        } else if (LIMIT_EXPRESSION.equals(key)) {
            this.limitExpression.setFormat((String)value);
        } else if (STOP.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.stop = (Boolean)value;
        } else if (STOP_EXPRESSION.equals(key)) {
            this.stopExpresson.setFormat((String)value);
        } else if (STOP_INCLUDE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.stopInclude = (Boolean)value;
        } else if (APPLY_ON_MOVE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.applyOnMove = (Boolean)value;
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (TARGET_DECK.equals(key)) {
            return this.targetDeck;
        }
        if (VARIABLE_DECK.equals(key)) {
            return String.valueOf(this.variableDeck);
        }
        if (DECK_EXPRESSION.equals(key)) {
            return this.deckExpression.getFormat();
        }
        if (SEND_MATCHING.equals(key)) {
            return String.valueOf(this.sendMatching);
        }
        if (MATCH_EXPRESSION.equals(key)) {
            return this.matchExpression.getFormat();
        }
        if (LIMIT_TOTAL.equals(key)) {
            return String.valueOf(this.limitTotal);
        }
        if (LIMIT_EXPRESSION.equals(key)) {
            return this.limitExpression.getFormat();
        }
        if (STOP.equals(key)) {
            return String.valueOf(this.stop);
        }
        if (STOP_EXPRESSION.equals(key)) {
            return this.stopExpresson.getFormat();
        }
        if (STOP_INCLUDE.equals(key)) {
            return String.valueOf(this.stopInclude);
        }
        if (APPLY_ON_MOVE.equals(key)) {
            return String.valueOf(this.applyOnMove);
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (DECK_EXPRESSION.equals(name)) {
            return () -> this.variableDeck;
        }
        if (TARGET_DECK.equals(name)) {
            return () -> !this.variableDeck;
        }
        if (MATCH_EXPRESSION.equals(name)) {
            return () -> this.sendMatching;
        }
        if (LIMIT_EXPRESSION.equals(name)) {
            return () -> this.limitTotal;
        }
        if (STOP_EXPRESSION.equals(name)) {
            return () -> this.stop;
        }
        if (STOP_INCLUDE.equals(name)) {
            return () -> this.stop;
        }
        return null;
    }

    @Override
    public List<KeyCommand> getKeyCommands(final Deck deck) {
        return List.of(new KeyCommand(this.getConfigureName(), NamedKeyStroke.NULL_KEYSTROKE, deck){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DeckSendKeyCommand.this.doSend(deck);
            }
        });
    }

    @Override
    public void registerListeners(Deck deck) {
        if (this.sendListener == null && this.keyStroke != null && !this.keyStroke.isNull()) {
            this.sendListener = new NamedKeyStrokeListener(e -> this.doSend(deck));
            this.sendListener.setKeyStroke(this.keyStroke);
            GameModule.getGameModule().addKeyStrokeListener(this.sendListener);
        }
    }

    @Override
    public void deregisterListeners() {
        if (this.sendListener != null) {
            GameModule.getGameModule().removeKeyStrokeListener(this.sendListener);
        }
    }

    private void doSend(Deck deck) {
        GameModule.getGameModule().sendAndLog(deck.extendedSend(this));
        deck.repaintMap();
    }

    @Override
    public String[] getAdditionalReportProperties() {
        return (String[])ArrayUtils.addAll((Object[])super.getAdditionalReportProperties(), (Object[])new String[]{TARGET_DECK, SENT_COUNT});
    }

    @Override
    public List<String> getExpressionList() {
        if (!this.variableDeck) {
            return List.of(this.deckExpression.getFormat(), this.matchExpression.getFormat(), this.limitExpression.getFormat());
        }
        return Collections.emptyList();
    }
}

