/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.build.module.PieceWindow;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.ScrollPane;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListWidget
extends Widget
implements ListSelectionListener {
    private JPanel panel;
    private JSplitPane split;
    private JList<Widget> list;
    private final DefaultListModel<Widget> widgets = new DefaultListModel();
    private CardLayout layout;
    private JPanel multiPanel;
    private int width;
    private int height;
    private int divider;
    private static final String DIVIDER = "divider";
    public static final String SCALE = "scale";
    protected double scale = 1.0;
    private final Map<Object, String> keys = new HashMap<Object, String>();
    private int count = 0;

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ListWidget.component_type");
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    protected boolean isMainPiecePalette() {
        Widget w = this;
        while ((w = w.getParent()) != null) {
            if (!(w instanceof PieceWindow)) continue;
            return ((PieceWindow)w).shouldDockIntoMainWindow();
        }
        return false;
    }

    @Override
    public Component getComponent() {
        if (this.panel == null) {
            this.rebuild();
            this.panel = new JPanel();
            this.split = new JSplitPane();
            this.split.setResizeWeight(1.0);
            this.list = new JList<Widget>(this.widgets);
            this.layout = new CardLayout();
            this.multiPanel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.multiPanel.setLayout(this.layout);
            for (Buildable b : this.getBuildables()) {
                Widget w = (Widget)b;
                this.multiPanel.add(this.getKey(w), w.getComponent());
            }
            this.list.setModel(this.widgets);
            this.list.addListSelectionListener(this);
            this.list.setCellRenderer(new Widget.MyCellRenderer());
            this.list.setFixedCellWidth(80);
            this.list.setVisibleRowCount(3);
            this.split.setLeftComponent(this.multiPanel);
            this.split.setRightComponent(new ScrollPane(this.list));
            if (this.width > 0 && this.height > 0) {
                int grabWidth = this.isMainPiecePalette() ? this.width / 2 : this.width;
                int grabHeight = this.isMainPiecePalette() ? this.height / 2 : this.height;
                this.split.setPreferredSize(new Dimension(grabWidth, grabHeight));
            }
            if (this.divider > 0) {
                this.split.setDividerLocation(this.divider);
            }
        }
        return this.split;
    }

    @Override
    public void add(Buildable b) {
        if (b instanceof Widget) {
            Widget w = (Widget)b;
            this.widgets.addElement(w);
            if (this.panel != null) {
                this.multiPanel.add(this.getKey(w), w.getComponent());
                this.list.revalidate();
            }
        }
        super.add(b);
    }

    @Override
    public void remove(Buildable b) {
        if (b instanceof Widget) {
            this.widgets.removeElement(b);
        }
        super.remove(b);
    }

    private String getKey(Object o) {
        String s = this.keys.get(o);
        if (s == null) {
            s = String.valueOf(this.count++);
            this.keys.put(o, s);
        }
        return s;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Widget selected = this.list.getSelectedValue();
        if (selected != null) {
            this.layout.show(this.multiPanel, this.getKey(selected));
        }
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName", "description", SCALE, "width", "height", DIVIDER};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.description_label"), Resources.getString("Editor.ListWidget.image_scale")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, Double.class};
    }

    @Override
    public void setAttribute(String name, Object value) {
        if ("entryName".equals(name)) {
            this.setConfigureName((String)value);
        } else if ("width".equals(name)) {
            this.width = Integer.parseInt((String)value);
        } else if ("height".equals(name)) {
            this.height = Integer.parseInt((String)value);
        } else if (DIVIDER.equals(name)) {
            this.divider = Integer.parseInt((String)value);
        } else if (SCALE.equals(name)) {
            if (value instanceof String) {
                value = Double.valueOf((String)value);
            }
            this.scale = (Double)value;
            if (this.scale < 0.01) {
                this.scale = 0.01;
            } else if (this.scale >= 4.0) {
                this.scale = 4.0;
            }
        } else if ("description".equals(name)) {
            this.description = (String)value;
        }
    }

    @Override
    public String getAttributeValueString(String name) {
        if ("entryName".equals(name)) {
            return this.getConfigureName();
        }
        if ("width".equals(name)) {
            return String.valueOf(this.split == null ? this.width : this.split.getWidth());
        }
        if ("height".equals(name)) {
            return String.valueOf(this.split == null ? this.height : this.split.getHeight());
        }
        if (DIVIDER.equals(name)) {
            return String.valueOf(this.split == null ? this.divider : this.split.getDividerLocation());
        }
        if (SCALE.equals(name)) {
            return String.valueOf(this.scale);
        }
        if ("description".equals(name)) {
            return this.description;
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (SCALE.equals(name)) {
            return this::hasScalablePieces;
        }
        return super.getAttributeVisibility(name);
    }
}

