/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.DummyClient;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.Room;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.command.Command;
import VASSAL.i18n.Resources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;

public class HybridClient
implements ChatServerConnection,
PlayerEncoder,
ChatControlsInitializer {
    protected ChatServerConnection delegate;
    protected String defaultRoom = Resources.getString("Chat.main_room");
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected ChatServerControls controls;
    protected Icon currentIcon;
    protected String currentText;

    public HybridClient() {
        this.setDelegate(new DummyClient());
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(propertyName, l);
        if (this.delegate != null) {
            this.delegate.addPropertyChangeListener(propertyName, l);
        }
    }

    @Override
    public Room[] getAvailableRooms() {
        return this.delegate.getAvailableRooms();
    }

    @Override
    public Room getRoom() {
        return this.delegate.getRoom();
    }

    @Override
    public Player getUserInfo() {
        return this.delegate.getUserInfo();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public void sendTo(Player recipient, Command c) {
        this.delegate.sendTo(recipient, c);
    }

    @Override
    public void sendToOthers(Command c) {
        this.delegate.sendToOthers(c);
    }

    @Override
    public void setConnected(boolean connect) {
        this.delegate.setConnected(connect);
    }

    public ChatServerConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public void setRoom(Room r) {
        this.delegate.setRoom(r);
    }

    @Override
    public void setUserInfo(Player p) {
        this.delegate.setUserInfo(p);
    }

    @Override
    public Player stringToPlayer(String s) {
        if (this.delegate instanceof PlayerEncoder) {
            return ((PlayerEncoder)((Object)this.delegate)).stringToPlayer(s);
        }
        return null;
    }

    @Override
    public String playerToString(Player p) {
        if (this.delegate instanceof PlayerEncoder) {
            return ((PlayerEncoder)((Object)this.delegate)).playerToString(p);
        }
        return null;
    }

    protected void fireStatus(String msg) {
        this.propSupport.firePropertyChange(new PropertyChangeEvent(this, "Status", null, msg));
    }

    public void setDelegate(ChatServerConnection newDelegate) {
        PropertyChangeListener[] listeners;
        if (this.delegate != null && this.delegate.isConnected()) {
            throw new IllegalStateException(Resources.getString("Server.error1"));
        }
        ChatServerConnection oldDelegate = this.delegate;
        if (oldDelegate != null) {
            newDelegate.setUserInfo(oldDelegate.getUserInfo());
        }
        for (PropertyChangeListener listener : listeners = this.propSupport.getPropertyChangeListeners()) {
            newDelegate.addPropertyChangeListener(((PropertyChangeListenerProxy)listener).getPropertyName(), listener);
        }
        if (this.controls != null) {
            if (this.delegate instanceof ChatControlsInitializer) {
                ((ChatControlsInitializer)((Object)this.delegate)).uninitializeControls(this.controls);
            }
            if (newDelegate instanceof ChatControlsInitializer) {
                ((ChatControlsInitializer)((Object)newDelegate)).initializeControls(this.controls);
            }
        }
        this.delegate = newDelegate;
    }

    @Override
    public void initializeControls(ChatServerControls controls) {
        this.controls = controls;
        if (this.delegate instanceof ChatControlsInitializer) {
            ((ChatControlsInitializer)((Object)this.delegate)).initializeControls(controls);
            controls.setRoomControlsVisible(true);
        }
        controls.updateClientDisplay(this.currentIcon, this.currentText);
    }

    @Override
    public void uninitializeControls(ChatServerControls controls) {
        if (this.delegate instanceof ChatControlsInitializer) {
            ((ChatControlsInitializer)((Object)this.delegate)).uninitializeControls(controls);
        }
    }

    public void updateDisplayControls(Icon icon, String text) {
        if (this.controls != null) {
            this.controls.updateClientDisplay(icon, text);
        }
        this.currentIcon = icon;
        this.currentText = text;
    }
}

