/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.node.OfficialNodeClientFactory;
import VASSAL.chat.peer2peer.P2PClientFactory;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.menu.MacOSXMenuManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;

public class ServerConfigurer
extends Configurer {
    private static final String CONNECTED = Resources.getString("Server.please_disconnect");
    private static final String DISCONNECTED = Resources.getString("Server.select_server_type");
    private static final String P2P_BUTTON = Resources.getString("Server.direct");
    private static final String OFFICIAL_BUTTON = Resources.getString("Server.official");
    private static final String ENCODING = "UTF-8";
    protected JComponent controls;
    private final HybridClient client;
    private JRadioButton officialButton;
    private JRadioButton p2pButton;
    private JLabel header;

    public ServerConfigurer(String key, String name, HybridClient client) {
        super(key, name, new Properties());
        this.client = client;
        client.addPropertyChangeListener("Connected", e -> this.enableControls(Boolean.TRUE.equals(e.getNewValue())));
        this.getControls();
        this.setValue(this.buildLegacyProperties());
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel((LayoutManager)new MigLayout());
            this.header = new JLabel(DISCONNECTED);
            this.controls.add((Component)this.header, "wrap");
            ButtonGroup group = new ButtonGroup();
            this.p2pButton = new JRadioButton(P2P_BUTTON);
            this.p2pButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.noUpdate = true;
                    this.setValue(this.buildPeerProperties());
                    this.noUpdate = false;
                }
            });
            group.add(this.p2pButton);
            this.controls.add((Component)this.p2pButton, "wrap");
            this.officialButton = new JRadioButton(OFFICIAL_BUTTON);
            this.officialButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.noUpdate = true;
                    this.setValue(this.buildLegacyProperties());
                    this.noUpdate = false;
                }
            });
            this.controls.add(this.officialButton);
            group.add(this.officialButton);
        }
        return this.controls;
    }

    private void enableControls(boolean connected) {
        this.p2pButton.setEnabled(!connected);
        this.officialButton.setEnabled(!connected);
        this.header.setText(connected ? CONNECTED : DISCONNECTED);
    }

    protected Properties buildPeerProperties() {
        Properties p = new Properties();
        p.setProperty("type", "peer2peer");
        return p;
    }

    protected Properties buildLegacyProperties() {
        Properties p = new Properties();
        p.setProperty("type", "official");
        return p;
    }

    @Override
    public String getValueString() {
        String s = "";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Properties p = (Properties)this.getValue();
            if (p != null) {
                p.store(out, null);
            }
            s = new String(out.toByteArray(), ENCODING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (!this.noUpdate && o instanceof Properties && this.controls != null) {
            Properties p = (Properties)o;
            String type = p.getProperty("type", "official");
            if ("official".equals(type)) {
                this.officialButton.setSelected(true);
            } else if ("peer2peer".equals(type)) {
                this.p2pButton.setSelected(true);
            }
        }
        if (this.client != null && !CONNECTED.equals(this.header.getText())) {
            this.client.setDelegate(ChatServerFactory.build(this.getServerInfo()));
        }
    }

    @Override
    public void setValue(String s) {
        Properties p = new Properties();
        try {
            p.load(new ByteArrayInputStream(s.getBytes(ENCODING)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setValue(p);
    }

    private Properties getServerInfo() {
        Properties p = (Properties)this.getValue();
        return p == null ? new Properties() : new Properties(p);
    }

    public static void main(String[] args) {
        ChatServerFactory.register("official", new OfficialNodeClientFactory());
        ChatServerFactory.register("peer2peer", new P2PClientFactory());
        new MacOSXMenuManager();
        HybridClient c = new HybridClient();
        ServerConfigurer config = new ServerConfigurer("server", "server", c);
        JFrame f = new JFrame();
        f.getContentPane().add(config.getControls());
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }
}

