/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.peer2peer.AcceptPeerThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PeerReader;
import org.litesoft.p2pchat.PeerWriter;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.UserDialog;

public class UnitTest
implements UserDialog {
    private final String id;

    public UnitTest(String id) {
        this.id = id;
    }

    public static void main(String[] args) throws Exception {
        Properties p = new Properties();
        if ("true".equals(p.getProperty("reader"))) {
            UnitTest.testPeer();
        }
        if ("true".equals(p.getProperty("manager"))) {
            UnitTest.testPeerManager();
        }
        if ("true".equals(p.getProperty("managers"))) {
            UnitTest.testPeerManagers();
        }
    }

    private static void testPeerManager() throws InterruptedException, IOException {
        UnitTest.startSocketReader(5555);
        UnitTest d = new UnitTest("Client");
        PendingPeerManager ppm = new PendingPeerManager(d);
        ActivePeerManager apm = new ActivePeerManager(new MyInfo("TestClient", 5556), d, ppm);
        PeerInfo info = new PeerInfo("SocketReader", "localhost", 5555);
        info.setID("SocketReader");
        ppm.addNewPeer(info);
        Thread.sleep(10000L);
        apm.sendToAllCHAT("A message");
        apm.getPeerListenerByID("1").close();
        System.err.println("Closed peer");
    }

    private static void testPeerManagers() throws InterruptedException, IOException {
        UnitTest serverDialog = new UnitTest("Server");
        PendingPeerManager serverPpm = new PendingPeerManager(serverDialog);
        new AcceptPeerThread(5555, serverPpm).start();
        UnitTest d = new UnitTest("Client");
        PendingPeerManager ppm = new PendingPeerManager(d);
        ActivePeerManager apm = new ActivePeerManager(new MyInfo("Client", 5556), d, ppm);
        PeerInfo info = new PeerInfo("Server", "localhost", 5555);
        info.setID("Server");
        ppm.addNewPeer(info);
        Thread.sleep(5000L);
        apm.sendToAllCHAT("A message");
        apm.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testPeer() throws InterruptedException, IOException {
        UnitTest.startSocketReader(5555);
        Socket s = new Socket("localhost", 5555);
        System.err.println("Created reader " + String.valueOf(reader));
        try (PeerReader reader = new PeerReader(s.getInputStream());){
            System.err.println("Created writer" + String.valueOf(writer));
            try (PeerWriter writer = new PeerWriter(s.getOutputStream());){
                writer.writeLine("A message");
                Thread.sleep(2000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startSocketReader(int port) throws InterruptedException {
        Object lock = new Object();
        Runnable runnable = () -> {
            try {
                ServerSocket server;
                Object object = lock;
                synchronized (object) {
                    server = new ServerSocket(port);
                    lock.notifyAll();
                }
                Socket s = server.accept();
                try (PeerReader reader = null;){
                    String msg;
                    reader = new PeerReader(s.getInputStream());
                    do {
                        System.err.println((msg = reader.readLine()) == null ? "" : msg);
                    } while (msg != null);
                    System.err.println("Done");
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        Object object = lock;
        synchronized (object) {
            new Thread(runnable).start();
            lock.wait();
        }
    }

    @Override
    public void setActivePeerManager(ActivePeerManager pActivePeerManager) {
    }

    @Override
    public void setPendingPeerManager(PendingPeerManager pPendingPeerManager) {
    }

    @Override
    public void showUnrecognized(PeerInfo pPeerInfo, String pBadMessage) {
        System.err.println(String.valueOf(this) + "Unrecognized " + String.valueOf(pPeerInfo));
    }

    @Override
    public void showStreamsFailed(PeerInfo pPeerInfo) {
        System.err.println(String.valueOf(this) + "Streams Failed " + String.valueOf(pPeerInfo));
    }

    @Override
    public void showConnectFailed(PeerInfo pPeerInfo) {
        System.err.println(String.valueOf(this) + "Connect Failed " + String.valueOf(pPeerInfo));
    }

    @Override
    public void showConnect(PeerInfo pPeerInfo) {
        System.err.println(String.valueOf(this) + "Connect " + String.valueOf(pPeerInfo));
    }

    @Override
    public void showDisconnect(PeerInfo pPeerInfo) {
        System.err.println(String.valueOf(this) + "Disconnect " + String.valueOf(pPeerInfo));
    }

    @Override
    public void showCHAT(PeerInfo pPeerInfo, String pMessage) {
        System.err.println(String.valueOf(this) + "Chat " + String.valueOf(pPeerInfo));
    }

    @Override
    public void showPMSG(PeerInfo pPeerInfo, String pMessage) {
        System.err.println(String.valueOf(this) + "Private Chat " + String.valueOf(pPeerInfo));
    }

    @Override
    public void showNAME(PeerInfo pPeerInfo) {
        System.err.println(String.valueOf(this) + "Name " + String.valueOf(pPeerInfo));
    }

    @Override
    public void showHELO(PeerInfo pPeerInfo) {
        System.err.println(String.valueOf(this) + "Hello " + String.valueOf(pPeerInfo));
    }

    public String toString() {
        return this.id + ": ";
    }
}

