/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SavedGameUpdater;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SavedGameUpdaterDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private DefaultListModel<File> savedGamesModel;
    private final SavedGameUpdater updater = new SavedGameUpdater();
    private Properties oldPieceInfo;
    private final JFileChooser fc;
    private static final String VERSION_KEY = "moduleVerion";
    private static final String MODULE_NAME_KEY = "moduleName";
    private JButton updateButton;
    private JTextField versionField;

    public SavedGameUpdaterDialog(Frame owner) throws HeadlessException {
        super(owner, false);
        this.setTitle(Resources.getString("Editor.SavedGameUpdaterDialog.title"));
        this.initComponents();
        this.fc = new JFileChooser();
        this.fc.setCurrentDirectory(GameModule.getGameModule().getFileChooser().getCurrentDirectory());
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        Box versionBox = Box.createHorizontalBox();
        versionBox.add(new JLabel(Resources.getString("Editor.SavedGameUpdaterDialog.module_version")));
        this.versionField = new JTextField(8);
        this.versionField.setEditable(false);
        this.versionField.setMaximumSize(new Dimension(this.versionField.getMaximumSize().width, this.versionField.getPreferredSize().height));
        versionBox.add(this.versionField);
        JButton importButton = new JButton(Resources.getString("Editor.SavedGameUpdaterDialog.import_gamepiece"));
        importButton.addActionListener(e -> this.importPieceInfo());
        versionBox.add(importButton);
        this.add(versionBox);
        JButton exportButton = new JButton(Resources.getString("Editor.SavedGameUpdaterDialog.export_gamepiece"));
        exportButton.addActionListener(e -> this.exportPieceInfo());
        Box importExportBox = Box.createHorizontalBox();
        importExportBox.add(importButton);
        importExportBox.add(exportButton);
        this.add(importExportBox);
        Box savedGamesBox = Box.createHorizontalBox();
        Box left = Box.createVerticalBox();
        left.add(new JLabel(Resources.getString("Editor.SavedGameUpdaterDialog.saved_games")));
        JButton chooseGamesButton = new JButton(Resources.getString("Editor.SavedGameUpdaterDialog.choose"));
        chooseGamesButton.addActionListener(e -> this.chooseSavedGames());
        left.add(chooseGamesButton);
        savedGamesBox.add(left);
        this.savedGamesModel = new DefaultListModel();
        JList<File> savedGamesList = new JList<File>(this.savedGamesModel);
        savedGamesList.setVisibleRowCount(5);
        savedGamesList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((File)value).getName());
                return this;
            }
        });
        savedGamesBox.add(new ScrollPane(savedGamesList));
        this.add(savedGamesBox);
        Box buttonsBox = Box.createHorizontalBox();
        this.updateButton = new JButton(Resources.getString("Editor.SavedGameUpdaterDialog.update_games"));
        this.updateButton.addActionListener(e -> this.updateGames());
        this.updateButton.setEnabled(false);
        buttonsBox.add(this.updateButton);
        JButton helpButton = new JButton(Resources.getString("Editor.SavedGameUpdaterDialog.help"));
        HelpFile hf = null;
        try {
            hf = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "SavedGameUpdater.html"));
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
        }
        helpButton.addActionListener(new ShowHelpAction(hf.getContents(), null));
        buttonsBox.add(helpButton);
        JButton closeButton = new JButton(Resources.getString("Editor.SavedGameUpdaterDialog.close"));
        closeButton.addActionListener(e -> this.dispose());
        buttonsBox.add(closeButton);
        this.add(buttonsBox);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void updateGames() {
        this.updateButton.setEnabled(false);
        Runnable runnable = () -> {
            int n = this.savedGamesModel.size();
            for (int i = 0; i < n; ++i) {
                try {
                    File savedGame = this.savedGamesModel.getElementAt(i);
                    this.updater.updateSavedGame(this.oldPieceInfo, savedGame);
                    GameModule.getGameModule().warn(Resources.getString("Editor.SavedGameUpdaterDialog.updated_message", savedGame.getName(), this.versionField.getText(), GameModule.getGameModule().getGameVersion()));
                    continue;
                }
                catch (IOException e) {
                    Runnable showError = () -> this.showErrorMessage(e, Resources.getString("Editor.SavedGameUpdaterDialog.fail"), Resources.getString("Editor.SavedGameUpdaterDialog.unable"));
                    try {
                        SwingUtilities.invokeAndWait(showError);
                        continue;
                    }
                    catch (InterruptedException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
            }
            this.updateButton.setEnabled(true);
        };
        new Thread(runnable).start();
    }

    private void chooseSavedGames() {
        File[] selectedFiles;
        this.fc.setMultiSelectionEnabled(true);
        if (1 != this.fc.showOpenDialog(this) && (selectedFiles = this.fc.getSelectedFiles()) != null) {
            this.savedGamesModel.clear();
            for (File selectedFile : selectedFiles) {
                this.savedGamesModel.addElement(selectedFile);
            }
        }
    }

    private void exportPieceInfo() {
        this.fc.setMultiSelectionEnabled(false);
        if (1 != this.fc.showSaveDialog(this)) {
            Properties p = this.updater.getPieceSlotsMap();
            p.put(MODULE_NAME_KEY, GameModule.getGameModule().getGameName());
            p.put(VERSION_KEY, GameModule.getGameModule().getGameVersion());
            try (OutputStream fout = Files.newOutputStream(this.fc.getSelectedFile().toPath(), new OpenOption[0]);
                 BufferedOutputStream out = new BufferedOutputStream(fout);){
                p.store(out, null);
            }
            catch (IOException e) {
                this.showErrorMessage(e, Resources.getString("Editor.SavedGameUpdaterDialog.ex_fail"), Resources.getString("Editor.SavedGameUpdaterDialog.ex_unable"));
            }
        }
    }

    private void importPieceInfo() {
        this.fc.setMultiSelectionEnabled(false);
        if (1 != this.fc.showOpenDialog(this)) {
            this.oldPieceInfo = new Properties();
            try (InputStream fin = Files.newInputStream(this.fc.getSelectedFile().toPath(), new OpenOption[0]);
                 BufferedInputStream in = new BufferedInputStream(fin);){
                this.oldPieceInfo.load(in);
                String moduleVersion = this.oldPieceInfo.getProperty(VERSION_KEY);
                String moduleName = this.oldPieceInfo.getProperty(MODULE_NAME_KEY);
                if (!GameModule.getGameModule().getGameName().equals(moduleName)) {
                    this.showErrorMessage(null, Resources.getString("Editor.SavedGameUpdaterDialog.im_fail"), Resources.getString("Editor.SavedGameUpdaterDialog.im_wrong", moduleName));
                    this.oldPieceInfo = null;
                    this.versionField.setText(null);
                } else if (GameModule.getGameModule().getGameVersion().equals(moduleVersion)) {
                    this.showErrorMessage(null, Resources.getString("Editor.SavedGameUpdaterDialog.im_fail"), Resources.getString("Editor.SavedGameUpdaterDialog.im_current", moduleVersion));
                    this.oldPieceInfo = null;
                    this.versionField.setText(null);
                } else {
                    this.versionField.setText(moduleVersion);
                }
            }
            catch (IOException e) {
                this.showErrorMessage(e, Resources.getString("Editor.SavedGameUpdaterDialog.im_fail"), Resources.getString("Editor.SavedGameUpdaterDialog.im_unable"));
                this.oldPieceInfo = null;
            }
            catch (IllegalArgumentException e) {
                this.showErrorMessage(e, Resources.getString("Editor.SavedGameUpdaterDialog.im_fail"), Resources.getString("Editor.SavedGameUpdaterDialog.im_malformed"));
                this.oldPieceInfo = null;
            }
        }
        this.updateButton.setEnabled(this.oldPieceInfo != null);
    }

    private void showErrorMessage(Exception e, String title, String defaultMessage) {
        String msg;
        String string = msg = e == null ? null : e.getMessage();
        if (msg == null) {
            msg = defaultMessage;
        }
        JOptionPane.showMessageDialog(this, msg, title, 0);
    }
}

