/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.RemovePiece;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Delete
extends Decorator
implements TranslatablePiece {
    public static final String ID = "delete;";
    protected KeyCommand[] keyCommands;
    protected KeyCommand deleteCommand;
    protected String commandName;
    protected NamedKeyStroke key;
    protected String description = "";

    public Delete() {
        this(ID + Resources.getString("Editor.Delete.delete") + ";D", null);
    }

    public Delete(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken();
        this.key = st.nextNamedKeyStroke('D');
        this.description = st.nextToken("");
        this.keyCommands = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.key).append(this.description);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.keyCommands == null) {
            this.deleteCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.keyCommands = this.commandName.length() > 0 && this.key != null && !this.key.isNull() ? new KeyCommand[]{this.deleteCommand} : KeyCommand.NONE;
        }
        this.deleteCommand.setEnabled(this.getMap() != null);
        return this.keyCommands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command c = null;
        Command c1 = null;
        this.myGetKeyCommands();
        if (this.deleteCommand.matches(stroke)) {
            GamePiece outer = Decorator.getOutermost(this);
            if (this.getParent() != null) {
                GamePiece next = this.getParent().getPieceBeneath(outer);
                if (next == null) {
                    next = this.getParent().getPieceAbove(outer);
                }
                if (next != null) {
                    GamePiece selected = next;
                    Runnable runnable = () -> {
                        if (GameModule.getGameModule().getGameState().getPieceForId(selected.getId()) != null) {
                            KeyBuffer.getBuffer().add(selected);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
            if (GameModule.getGameModule().isMatSupport()) {
                Mat mat;
                String matName;
                MatCargo cargo;
                if (Boolean.TRUE.equals(outer.getProperty("IsCargo")) && (cargo = (MatCargo)Decorator.getDecorator(outer, MatCargo.class)) != null) {
                    c1 = cargo.makeClearMatCommand();
                }
                if ((matName = (String)outer.getProperty("MatName")) != null && !"".equals(matName) && (mat = (Mat)Decorator.getDecorator(outer, Mat.class)) != null) {
                    c1 = mat.makeRemoveAllCargoCommand();
                }
            }
            c = Delete.putOldProperties(Decorator.getOutermost(this));
            c = c.append(new RemovePiece(outer));
            c.execute();
            if (c1 != null) {
                c = c1.append(c);
            }
        }
        return c;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.key);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.commandName);
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.Delete.trait_description", this.description);
        s = (String)s + this.getCommandDesc(this.commandName, this.key);
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Delete.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePiece.html", "Delete");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, Resources.getString("Editor.Delete.delete_command_description"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Delete)) {
            return false;
        }
        Delete c = (Delete)o;
        if (!Objects.equals(this.commandName, c.commandName)) {
            return false;
        }
        return Objects.equals(this.key, c.key);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer nameInput;
        private final NamedHotKeyConfigurer keyInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer descInput;

        public Ed(Delete p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.nameInput = new StringConfigurer(p.commandName);
            this.nameInput.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.nameInput);
            this.keyInput = new NamedHotKeyConfigurer(p.key);
            this.controls.add("Editor.keyboard_command", (Configurer)this.keyInput);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameInput.getValueString()).append(this.keyInput.getValueString()).append(this.descInput.getValueString());
            return Delete.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

