/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameState;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.CompoundPieceCollection;
import VASSAL.build.module.map.PieceCollection;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.command.Command;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.StateMergeable;
import VASSAL.search.AbstractImageFinder;
import VASSAL.search.ImageSearchTarget;
import VASSAL.tools.EnumeratedIterator;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;

public class Stack
extends AbstractImageFinder
implements GamePiece,
StateMergeable {
    public static final String TYPE = "stack";
    public static final String HAS_LAYER_MARKER = "@@";
    public static final int LAYER_NOT_SET = -1;
    protected static final int INCR = 5;
    protected GamePiece[] contents = new GamePiece[5];
    protected int pieceCount = 0;
    protected Map map;
    protected Point pos = new Point(0, 0);
    protected int layer = -1;
    private boolean expanded = false;
    private String id;
    private static StackMetrics defaultMetrics;

    public Stack() {
        this(null);
    }

    public Stack(GamePiece p) {
        if (p != null) {
            this.setMap(p.getMap());
            this.setPosition(new Point(p.getPosition()));
            this.add(p);
        }
    }

    public Iterator<GamePiece> getPiecesIterator() {
        return new AllPieceIterator();
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Enumeration<GamePiece> getPieces() {
        return new EnumeratedIterator<GamePiece>(new AllPieceIterator());
    }

    public List<GamePiece> asList() {
        return new ArrayList<GamePiece>(Arrays.asList(this.contents).subList(0, this.pieceCount));
    }

    public Iterator<GamePiece> getPiecesReverseIterator() {
        return new ReversePieceIterator();
    }

    public Iterator<GamePiece> getPiecesInVisibleOrderIterator() {
        return new VisibleOrderIterator();
    }

    public int getLayer() {
        return this.layer;
    }

    public void remove(GamePiece p) {
        this.removePieceAt(this.indexOf(p));
        p.setParent(null);
        if (this.getMap() != null) {
            this.getMap().repaint();
        }
    }

    protected void removePieceAt(int index) {
        this.removePieceAt(index, false);
    }

    protected void removePieceAt(int index, boolean suppressDeckCounts) {
        if (index >= 0 && index < this.pieceCount) {
            --this.pieceCount;
            for (int i = index; i < this.pieceCount; ++i) {
                this.contents[i] = this.contents[i + 1];
            }
            this.expanded = this.expanded && this.pieceCount > 1;
        }
    }

    public Command pieceRemoved(GamePiece p) {
        return null;
    }

    protected void insertPieceAt(GamePiece p, int index) {
        this.insertPieceAt(p, index, false);
    }

    protected void insertPieceAt(GamePiece p, int index, boolean suppressDeckCounts) {
        if (index < 0) {
            index = 0;
        } else if (index > this.pieceCount) {
            index = this.pieceCount;
        }
        if (this.pieceCount >= this.contents.length) {
            GamePiece[] newContents = new GamePiece[this.contents.length + 5];
            System.arraycopy(this.contents, 0, newContents, 0, this.pieceCount);
            this.contents = newContents;
        }
        for (int i = this.pieceCount; i > index; --i) {
            this.contents[i] = this.contents[i - 1];
        }
        this.contents[index] = p;
        ++this.pieceCount;
    }

    public void removeAll() {
        this.pieceCount = 0;
        this.expanded = false;
    }

    public int indexOf(GamePiece p) {
        int index = -1;
        for (int i = 0; i < this.pieceCount; ++i) {
            if (p != this.contents[i]) continue;
            index = i;
            break;
        }
        return index;
    }

    public GamePiece getPieceAt(int index) {
        return this.contents[index];
    }

    public void add(GamePiece c) {
        PieceCollection p;
        Map m;
        if (this.pieceCount == 0 && this.layer == -1 && (m = this.getMap()) != null && (p = m.getPieceCollection()) instanceof CompoundPieceCollection) {
            this.layer = ((CompoundPieceCollection)p).getLayerForPiece(c);
        }
        this.insert(c, this.pieceCount);
    }

    public void insertChild(GamePiece child, int index) {
        if (child.getParent() != null) {
            child.getParent().remove(child);
        } else if (child.getMap() != null) {
            child.getMap().removePiece(child);
        }
        child.setParent(this);
        if (child instanceof Stack) {
            throw new IllegalStateException("Cannot insert a stack into another stack");
        }
        this.insertPieceAt(child, index);
    }

    public int getPieceCount() {
        return this.pieceCount;
    }

    public int getMaximumVisiblePieceCount() {
        return this.pieceCount;
    }

    public void insert(GamePiece p, int pos) {
        if (p == null) {
            return;
        }
        pos = Math.max(pos, 0);
        pos = Math.min(pos, this.pieceCount);
        int index = this.indexOf(p);
        if (index >= 0) {
            boolean origExpanded = this.isExpanded();
            if (pos > index) {
                this.insertPieceAt(p, pos + 1, true);
                this.removePieceAt(index, true);
            } else {
                this.removePieceAt(index, true);
                this.insertPieceAt(p, pos, true);
            }
            this.setExpanded(origExpanded);
        } else {
            this.insertChild(p, pos);
        }
    }

    public Command pieceAdded(GamePiece p) {
        return null;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        if (obs instanceof Map.View) {
            ((Map.View)obs).getMap().getStackMetrics().draw(this, g, x, y, obs, zoom);
        } else {
            this.getDefaultMetrics().draw(this, g, x, y, obs, zoom);
        }
    }

    public String getName(boolean localized) {
        StringBuilder val = new StringBuilder();
        PieceIterator visibleFilter = PieceIterator.visible(this.getPiecesReverseIterator());
        while (visibleFilter.hasMoreElements()) {
            GamePiece p = visibleFilter.nextPiece();
            val.append(localized ? p.getLocalizedName() : p.getName());
            if (val.length() <= 0 || !visibleFilter.hasMoreElements()) continue;
            val.append(", ");
        }
        return val.toString();
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    @Override
    public String getLocalizedName() {
        return this.getName(true);
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r = new Rectangle();
        Rectangle[] childBounds = new Rectangle[this.getPieceCount()];
        Map map = this.getMap();
        if (map != null) {
            map.getStackMetrics().getContents(this, null, null, childBounds, 0, 0);
            this.asList().stream().filter(PieceIterator.VISIBLE).forEach(p -> {
                int idx = this.indexOf((GamePiece)p);
                if (idx >= 0) {
                    r.add(childBounds[idx]);
                }
            });
        }
        return r;
    }

    @Override
    public Shape getShape() {
        Area a = new Area();
        Shape[] childBounds = new Shape[this.getPieceCount()];
        StackMetrics metrics = this.getMap() == null ? this.getDefaultMetrics() : this.getMap().getStackMetrics();
        metrics.getContents(this, null, childBounds, null, 0, 0);
        this.asList().stream().filter(PieceIterator.VISIBLE).forEach(p -> {
            int idx = this.indexOf((GamePiece)p);
            if (idx >= 0) {
                a.add(new Area(childBounds[idx]));
            }
        });
        return a;
    }

    public void selectNext(GamePiece c) {
        KeyBuffer.getBuffer().remove(c);
        if (this.pieceCount > 1 && this.indexOf(c) >= 0) {
            int newSelectedIndex = this.indexOf(c) == this.pieceCount - 1 ? this.pieceCount - 2 : this.indexOf(c) + 1;
            for (int i = 0; i < this.pieceCount; ++i) {
                if (this.indexOf(this.contents[i]) != newSelectedIndex) continue;
                KeyBuffer.getBuffer().add(this.contents[i]);
                return;
            }
        }
    }

    public GamePiece getPieceBeneath(GamePiece p) {
        int index = this.indexOf(p);
        while (index-- > 0) {
            if (Boolean.TRUE.equals(this.contents[index].getProperty("Invisible"))) continue;
            return this.contents[index];
        }
        return null;
    }

    public GamePiece getPieceAbove(GamePiece p) {
        int index = this.indexOf(p);
        while (++index < this.getPieceCount()) {
            if (Boolean.TRUE.equals(this.contents[index].getProperty("Invisible"))) continue;
            return this.contents[index];
        }
        return null;
    }

    public GamePiece topPiece() {
        for (int i = this.pieceCount - 1; i >= 0; --i) {
            if (Boolean.TRUE.equals(this.contents[i].getProperty("Invisible"))) continue;
            return this.contents[i];
        }
        return null;
    }

    public GamePiece topPiece(String playerId) {
        for (int i = this.pieceCount - 1; i >= 0; --i) {
            String hiddenBy = (String)this.contents[i].getProperty("hiddenBy");
            if (hiddenBy != null && !hiddenBy.equals(playerId)) continue;
            return this.contents[i];
        }
        return null;
    }

    public GamePiece bottomPiece(String playerId) {
        for (int i = 0; i < this.pieceCount; ++i) {
            String hiddenBy = (String)this.contents[i].getProperty("hiddenBy");
            if (hiddenBy != null && !hiddenBy.equals(playerId)) continue;
            return this.contents[i];
        }
        return null;
    }

    public GamePiece bottomPiece() {
        for (int i = 0; i < this.pieceCount; ++i) {
            if (Boolean.TRUE.equals(this.contents[i].getProperty("Invisible"))) continue;
            return this.contents[i];
        }
        return null;
    }

    public int nVisible() {
        return (int)this.asList().stream().filter(PieceIterator.VISIBLE).count();
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        GamePiece p = this.topPiece();
        if (p != null) {
            return p.keyEvent(stroke);
        }
        return null;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean b) {
        this.expanded = b && this.getPieceCount() > 1;
    }

    @Override
    public String getState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getMap() == null ? "null" : this.getMap().getIdentifier()).append(this.getPosition().x).append(this.getPosition().y);
        for (int i = 0; i < this.pieceCount; ++i) {
            se.append(this.contents[i].getId());
        }
        se.append(HAS_LAYER_MARKER + this.layer);
        return se.getValue();
    }

    @Override
    public void setState(String s) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        String mapId = st.nextToken();
        if ("null".equals(mapId)) {
            this.setPosition(new Point(0, 0));
        } else {
            this.setPosition(new Point(st.nextInt(0), st.nextInt(0)));
        }
        this.pieceCount = 0;
        GameState gs = GameModule.getGameModule().getGameState();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            GamePiece child = gs.getPieceForId(token);
            if (child != null) {
                this.insertChild(child, this.pieceCount);
                continue;
            }
            if (!token.startsWith(HAS_LAYER_MARKER)) continue;
            this.layer = Integer.parseInt(token.substring(HAS_LAYER_MARKER.length()));
        }
        Map m = null;
        if (!"null".equals(mapId) && (m = Map.getMapById(mapId)) == null) {
            ErrorDialog.dataWarning(new BadDataReport("Could not find map", mapId, null));
        }
        if (m != this.getMap()) {
            if (m != null) {
                m.addPiece(this);
            } else {
                this.setMap(null);
            }
        }
    }

    @Override
    public void mergeState(String newState, String oldState) {
        String mergedState = newState;
        if (!oldState.equals(this.getState())) {
            SequenceEncoder.Decoder stNew = new SequenceEncoder.Decoder(newState, ';');
            SequenceEncoder.Decoder stOld = new SequenceEncoder.Decoder(oldState, ';');
            SequenceEncoder merge = new SequenceEncoder(';');
            merge.append(stNew.nextToken());
            stOld.nextToken();
            merge.append(stNew.nextToken());
            stOld.nextToken();
            merge.append(stNew.nextToken());
            stOld.nextToken();
            ArrayList<String> newContents = new ArrayList<String>();
            while (stNew.hasMoreTokens()) {
                newContents.add(stNew.nextToken());
            }
            ArrayList<String> oldContents = new ArrayList<String>();
            while (stOld.hasMoreTokens()) {
                oldContents.add(stOld.nextToken());
            }
            int j = this.getPieceCount();
            for (int i = 0; i < j; ++i) {
                String id = this.getPieceAt(i).getId();
                if (newContents.contains(id) || oldContents.contains(id)) continue;
                int index = i == 0 ? -1 : newContents.indexOf(this.getPieceAt(i - 1).getId());
                newContents.add(index + 1, id);
            }
            for (String s : newContents) {
                merge.append(s);
            }
            mergedState = merge.getValue();
        }
        this.setState(mergedState);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void setProperty(Object key, Object val) {
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public void setPropertyOnContents(Object key, Object val) {
        this.asList().forEach(gamePiece -> gamePiece.setProperty(key, val));
    }

    @Override
    public Object getProperty(Object key) {
        return null;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        return this.getProperty(key);
    }

    @Override
    public void setMap(Map map) {
        this.map = map;
    }

    @Override
    public Map getMap() {
        return this.map;
    }

    @Override
    public Point getPosition() {
        return new Point(this.pos);
    }

    @Override
    public void setPosition(Point p) {
        this.pos = p;
    }

    @Override
    public Stack getParent() {
        return null;
    }

    @Override
    public void setParent(Stack s) {
        if (s != null) {
            ErrorDialog.dataWarning(new BadDataReport("Cannot add stack to another stack", this.toString(), null));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public static void setDefaultMetrics(StackMetrics s) {
        defaultMetrics = s;
    }

    public StackMetrics getStackMetrics(Map m) {
        return m == null ? this.getDefaultMetrics() : m.getStackMetrics();
    }

    public StackMetrics getStackMetrics() {
        return this.getStackMetrics(this.getMap());
    }

    public StackMetrics getDefaultMetrics() {
        if (defaultMetrics == null) {
            Stack.setDefaultMetrics(new StackMetrics());
        }
        return defaultMetrics;
    }

    @Override
    public void addImageNamesRecursively(Collection<String> s) {
        Iterator<GamePiece> i = this.getPiecesIterator();
        while (i.hasNext()) {
            GamePiece p = i.next();
            if (!(p instanceof ImageSearchTarget)) continue;
            ((ImageSearchTarget)((Object)p)).addImageNamesRecursively(s);
        }
    }

    private class AllPieceIterator
    implements Iterator<GamePiece> {
        private int index = 0;
        private final GamePiece[] p;

        public AllPieceIterator() {
            this.p = Arrays.copyOf(Stack.this.contents, Stack.this.pieceCount);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.p.length;
        }

        @Override
        public GamePiece next() {
            return this.p[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReversePieceIterator
    implements Iterator<GamePiece> {
        private int index;
        private final GamePiece[] p;

        public ReversePieceIterator() {
            this.index = Stack.this.pieceCount - 1;
            this.p = Arrays.copyOf(Stack.this.contents, Stack.this.pieceCount);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public GamePiece next() {
            return this.p[this.index--];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class VisibleOrderIterator
    implements Iterator<GamePiece> {
        private GamePiece next;
        private int index;
        private boolean doingSelected;

        public VisibleOrderIterator() {
            this.index = Stack.this.pieceCount - 1;
            this.doingSelected = true;
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public GamePiece next() {
            GamePiece ret = this.next;
            this.next = this.findNext();
            return ret;
        }

        private GamePiece findNext() {
            GamePiece ret = null;
            while (this.index >= 0) {
                GamePiece p;
                if (!(this.doingSelected ^ !Boolean.TRUE.equals((p = Stack.this.getPieceAt(this.index--)).getProperty("Selected")))) continue;
                ret = p;
                break;
            }
            if (ret == null && this.doingSelected) {
                this.doingSelected = false;
                this.index = Stack.this.pieceCount - 1;
                ret = this.findNext();
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

