/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.AbstractConfigurable;
import VASSAL.configure.Configurer;
import VASSAL.counters.EditablePiece;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.Expression;
import VASSAL.tools.FormattedString;
import java.util.ArrayList;
import java.util.List;

public class AuditTrail {
    private Auditable source;
    private final List<String> messages;
    private static Boolean enabled;
    private static boolean reportingInProgress;

    public static boolean isEnabled() {
        if (AuditTrail.isReportingInProgress()) {
            return false;
        }
        if (enabled == null) {
            Configurer option = Prefs.getGlobalPrefs().getOption("badDataAuditTrails");
            if (option == null) {
                return false;
            }
            enabled = (Boolean)Prefs.getGlobalPrefs().getValue("badDataAuditTrails");
            option.addPropertyChangeListener(e -> {
                enabled = (Boolean)e.getNewValue();
            });
        }
        return enabled;
    }

    public static boolean isReportingInProgress() {
        return reportingInProgress;
    }

    public static void setReportingInProgress(boolean reportingInProgress) {
        AuditTrail.reportingInProgress = reportingInProgress;
    }

    public static AuditTrail create(Auditable source, String originalExpression, String comment) {
        return AuditTrail.isEnabled() ? new AuditTrail(source, originalExpression, comment) : null;
    }

    public static AuditTrail create(Auditable source, Expression originalExpression, String comment) {
        return AuditTrail.create(source, originalExpression.getExpression(), comment);
    }

    public static AuditTrail create(Auditable source, FormattedString originalExpression, String comment) {
        return AuditTrail.create(source, originalExpression.getFormat(), comment);
    }

    public static AuditTrail create(Auditable source, String originalExpression) {
        return AuditTrail.create(source, originalExpression, "");
    }

    public static AuditTrail create(Auditable source, Expression originalExpression) {
        return AuditTrail.create(source, originalExpression.getExpression(), "");
    }

    public static AuditTrail create(Auditable source, FormattedString originalExpression) {
        return AuditTrail.create(source, originalExpression.getFormat(), "");
    }

    public static AuditTrail create(Auditable source) {
        return AuditTrail.create(source, "", "");
    }

    public AuditTrail(AuditTrail audit) {
        this.source = audit.source;
        this.messages = new ArrayList<String>(audit.messages);
    }

    public AuditTrail(Auditable source, String originalExpression, String sourceField) {
        this.messages = new ArrayList<String>();
        this.setSource(source);
        if (sourceField != null && !sourceField.isEmpty()) {
            this.addMessage(Resources.getString("Audit.source_field", sourceField));
        }
        this.setExpression(originalExpression);
    }

    public void setExpression(String expression) {
        if (expression != null && !expression.isEmpty()) {
            this.addMessage(Resources.getString("Audit.expression", expression));
        }
    }

    public AuditTrail(Auditable source, String sourceField) {
        this(source, "", sourceField);
    }

    public void addMessage(String message) {
        if (message != null && !message.isEmpty()) {
            this.messages.add(message);
        }
    }

    public void setSource(Auditable source) {
        this.source = source;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Expression Audit:");
        if (this.source != null) {
            boolean origReportingState = AuditTrail.isReportingInProgress();
            AuditTrail.setReportingInProgress(true);
            if (this.source instanceof EditablePiece) {
                sb.append("\n   ").append(Resources.getString("Audit.source_type", "Piece Trait")).append("\n   ").append(Resources.getString("Audit.source_name", this.source.getComponentName())).append("\n   ").append(Resources.getString("Audit.source_description", this.source.getComponentTypeName()));
            }
            if (this.source instanceof AbstractConfigurable) {
                sb.append("\n   ").append(Resources.getString("Audit.source_type", this.source.getComponentTypeName())).append("\n   ").append(Resources.getString("Audit.source_name", this.source.getComponentName()));
            }
            AuditTrail.setReportingInProgress(origReportingState);
        }
        for (String message : this.messages) {
            sb.append("\n   ").append(message);
        }
        return sb.toString();
    }

    static {
        reportingInProgress = false;
    }
}

