/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.io.CompositeInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class RereadableInputStream
extends InputStream {
    private InputStream src;
    private boolean marked;
    private ByteArrayOutputStream savedBytes;

    public RereadableInputStream(InputStream src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.src = src;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.savedBytes = new ByteArrayOutputStream(readlimit);
        this.marked = true;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.marked) {
            throw new IOException("Cannot reset unmarked stream");
        }
        this.src = new CompositeInputStream(new ByteArrayInputStream(this.savedBytes.toByteArray()), this.src);
        this.marked = false;
    }

    @Override
    public int available() throws IOException {
        return this.src.available();
    }

    @Override
    public int read() throws IOException {
        int result = this.src.read();
        if (this.marked) {
            this.savedBytes.write(result);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.src.read(b, off, len);
        if (count > 0 && this.marked) {
            this.savedBytes.write(b, off, count);
        }
        return count;
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }
}

