/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.opcache;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.concurrent.ConcurrentSoftHashMap;
import VASSAL.tools.opcache.Op;
import VASSAL.tools.opcache.OpFailedException;
import VASSAL.tools.opcache.OpObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingWorker;

public class OpCache {
    protected final ConcurrentMap<Key<?>, Future<?>> cache = new ConcurrentSoftHashMap();
    private static final Future<Void> failure = new Future<Void>(){

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public Void get() throws ExecutionException {
            throw new ExecutionException(new OpFailedException());
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws ExecutionException {
            throw new ExecutionException(new OpFailedException());
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    };
    private final BlockingQueue<Runnable> requestQueue = new LinkedBlockingQueue<Runnable>();
    private final Ex threadPool = new Ex(2, 2, 60L, TimeUnit.SECONDS, this.requestQueue);

    public <V> V get(Key<V> key) {
        try {
            return this.get(key, null);
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            ErrorDialog.bug(e);
            return null;
        }
    }

    public <V> V get(Key<V> key, OpObserver<V> obs) throws CancellationException, InterruptedException, ExecutionException {
        Future<V> fut = this.getFuture(key, obs);
        if (obs == null || fut.isDone()) {
            try {
                return fut.get();
            }
            catch (CancellationException e) {
                this.cache.remove(key, fut);
                throw (CancellationException)new CancellationException().initCause(e);
            }
            catch (InterruptedException e) {
                this.cache.remove(key, fut);
                throw (InterruptedException)new InterruptedException().initCause(e);
            }
            catch (ExecutionException e) {
                this.cache.replace(key, fut, failure);
                throw new ExecutionException(e);
            }
        }
        return null;
    }

    public <V> Future<V> getFuture(Key<V> key, OpObserver<V> obs) throws ExecutionException {
        Future<V> fut = (Request<V>)this.cache.get(key);
        if (fut == null) {
            if (obs == null) {
                Result res = new Result();
                fut = this.cache.putIfAbsent(key, res);
                if (fut == null) {
                    Object val = null;
                    try {
                        val = key.op.eval();
                    }
                    catch (Throwable t) {
                        res.fail();
                        this.cache.put(key, failure);
                        throw new ExecutionException(t);
                    }
                    finally {
                        res.set(val);
                    }
                    fut = res;
                }
            } else {
                Request<V> req = new Request<V>(key, obs);
                fut = this.cache.putIfAbsent(key, req);
                if (fut == null) {
                    this.threadPool.submit(req);
                    fut = req;
                }
            }
        } else if (obs == null && fut instanceof Runnable && this.requestQueue.remove(fut)) {
            ((Runnable)((Object)fut)).run();
        }
        return fut;
    }

    public <V> V getIfDone(Key<V> key) {
        Future fut = (Future)this.cache.get(key);
        if (fut != null && fut.isDone()) {
            try {
                return fut.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
    }

    private static class Ex
    extends ThreadPoolExecutor {
        public Ex(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        public <V> Future<V> submit(SwingWorker<V, ?> req) {
            this.execute(req);
            return req;
        }
    }

    public static class Key<V> {
        public final Op<V> op;
        public final int version;
        public final List<Key<?>> deps = new ArrayList();
        private final int hash;

        public Key(Op<V> op, int version) {
            this.op = op;
            this.version = version;
            for (Op<?> dop : op.getSources()) {
                this.deps.add(dop.newKey());
            }
            this.hash = op.hashCode() ^ version ^ this.deps.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Key k = (Key)o;
            return this.version == k.version && this.op.equals(k.op) && this.deps.equals(k.deps);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getClass().getName() + "[op=" + String.valueOf(this.op) + ",version=" + this.version + "]";
        }
    }

    private static final class Result<V>
    implements Future<V> {
        private static final long serialVersionUID = 1L;
        private V value = null;
        private boolean failed = false;
        private final CountDownLatch done = new CountDownLatch(1);

        private Result() {
        }

        public void set(V value) {
            this.value = value;
            this.done.countDown();
        }

        public void fail() {
            this.failed = true;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.done.getCount() == 0L;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            this.done.await();
            if (this.failed) {
                throw new ExecutionException(new OpFailedException());
            }
            return this.value;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.done.await(timeout, unit)) {
                if (this.failed) {
                    throw new ExecutionException(new OpFailedException());
                }
                return this.value;
            }
            throw new TimeoutException();
        }
    }

    private class Request<V>
    extends SwingWorker<V, Void> {
        private final Key<V> key;
        private final OpObserver<V> obs;

        public Request(Key<V> key, OpObserver<V> obs) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            if (obs == null) {
                throw new IllegalArgumentException();
            }
            this.key = key;
            this.obs = obs;
        }

        @Override
        protected V doInBackground() throws Exception {
            return this.key.op.eval();
        }

        @Override
        protected void done() {
            block7: {
                try {
                    Object val = this.get();
                    if (this.obs != null) {
                        this.obs.succeeded(this.key.op, val);
                    }
                }
                catch (CancellationException e) {
                    OpCache.this.cache.remove(this.key, this);
                    if (this.obs != null) {
                        this.obs.cancelled(this.key.op, e);
                    }
                }
                catch (InterruptedException e) {
                    OpCache.this.cache.remove(this.key, this);
                    if (this.obs != null) {
                        this.obs.interrupted(this.key.op, e);
                    }
                }
                catch (ExecutionException e) {
                    OpCache.this.cache.replace(this.key, this, failure);
                    if (this.obs == null) break block7;
                    this.obs.failed(this.key.op, e);
                }
            }
        }
    }
}

