/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.map.DeckGlobalKeyCommand;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.build.module.map.deck.DeckKeyCommand;
import VASSAL.build.module.map.deck.DeckSendKeyCommand;
import VASSAL.build.module.map.deck.SortParameter;
import VASSAL.build.module.map.deck.SortParameterComparator;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.counters.Stack;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Deck
extends Stack
implements PlayerRoster.SideChangeListener {
    public static final String ID = "deck;";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String USE_MENU = "Via right-click Menu";
    public static final String USE_MENU_UP = "MenuDefaultUp";
    public static final String NO_USER = "nobody";
    protected static final StackMetrics deckStackMetrics = new StackMetrics(false, 2, 2, 2, 2);
    protected boolean drawOutline = true;
    protected Color outlineColor = Color.black;
    protected Dimension size = new Dimension(40, 40);
    protected boolean shuffle = true;
    protected String faceDownOption = "Always";
    protected String shuffleOption = "Always";
    protected String shuffleCommand = "";
    protected boolean allowMultipleDraw = false;
    protected boolean allowSelectDraw = false;
    protected boolean reversible = false;
    protected String reshuffleCommand = "";
    protected String reshuffleTarget;
    protected String reshuffleMsgFormat;
    protected NamedKeyStrokeListener reshuffleListener;
    protected NamedKeyStroke reshuffleKey;
    protected String reverseMsgFormat;
    protected String reverseCommand;
    protected NamedKeyStroke reverseKey;
    protected NamedKeyStrokeListener reverseListener;
    protected String shuffleMsgFormat;
    protected NamedKeyStrokeListener shuffleListener;
    protected NamedKeyStroke shuffleKey;
    protected String faceDownMsgFormat;
    protected boolean drawFaceUp;
    protected boolean persistable;
    protected FormattedString selectDisplayProperty = new FormattedString("$BasicName$");
    protected String selectSortProperty = "";
    protected MutableProperty.Impl countProperty = new MutableProperty.Impl("", this);
    protected List<MutableProperty.Impl> expressionProperties = new ArrayList<MutableProperty.Impl>();
    protected String deckName;
    protected String localizedDeckName;
    protected boolean faceDown;
    protected int dragCount = 0;
    protected int maxStack = 10;
    protected CountExpression[] countExpressions = new CountExpression[0];
    protected boolean expressionCounting = false;
    protected List<GamePiece> nextDraw = null;
    protected KeyCommand[] commands;
    protected List<DeckGlobalKeyCommand> globalCommands = new ArrayList<DeckGlobalKeyCommand>();
    protected boolean hotkeyOnEmpty;
    protected NamedKeyStroke emptyKey;
    protected boolean restrictOption;
    protected PropertyExpression restrictExpression = new PropertyExpression();
    protected PropertySource propertySource;
    protected String drawMultipleMessage;
    protected String drawSpecificMessage;
    protected String faceUpMessage;
    protected String faceDownMessage;
    protected String faceUpMsgFormat;
    protected NamedKeyStroke faceUpKey;
    protected NamedKeyStroke faceDownKey;
    protected NamedKeyStroke faceFlipKey;
    protected String saveMessage = Resources.getString("General.save");
    protected NamedKeyStroke saveKey;
    protected String saveReport;
    protected String loadMessage = Resources.getString("General.load");
    protected NamedKeyStroke loadKey;
    protected String loadReport;
    protected NamedKeyStrokeListener faceUpListener;
    protected NamedKeyStrokeListener faceDownListener;
    protected NamedKeyStrokeListener faceFlipListener;
    protected NamedKeyStrokeListener saveListener;
    protected NamedKeyStrokeListener loadListener;
    protected boolean restrictAccess;
    protected String[] owners;
    protected DrawPile myPile;
    protected CommandEncoder commandEncoder = new CommandEncoder(){

        @Override
        public Command decode(String command) {
            if (!command.startsWith("DECK\t")) {
                return null;
            }
            return new LoadDeckCommand(Deck.this);
        }

        @Override
        public String encode(Command c) {
            if (!(c instanceof LoadDeckCommand)) {
                return null;
            }
            return "DECK\t";
        }
    };
    private final GameModule gameModule;

    protected void sendEmptyKey() {
        this.gameModule.fireKeyStroke(this.emptyKey);
    }

    @Deprecated(since="2021-12-01", forRemoval=true)
    public Deck() {
        this(GameModule.getGameModule());
    }

    public Deck(GameModule gameModule) {
        this(gameModule, ID);
    }

    public Deck(GameModule gameModule, String type) {
        this.gameModule = gameModule;
        this.mySetType(type);
    }

    public Deck(GameModule gameModule, String type, PropertySource source) {
        this(gameModule, type);
        this.propertySource = source;
    }

    @Override
    public String getComponentTypeName() {
        return Resources.getString("Editor.DrawPile.deck");
    }

    @Override
    public String getComponentName() {
        return this.deckName;
    }

    public void setPropertySource(PropertySource source) {
        this.propertySource = source;
        if (this.globalCommands != null) {
            for (DeckGlobalKeyCommand globalCommand : this.globalCommands) {
                globalCommand.setPropertySource(this.propertySource);
            }
        }
    }

    public String[] getOwners() {
        return this.owners;
    }

    public void setOwners(String[] o) {
        this.owners = o;
    }

    public boolean isRestrictAccess() {
        return this.restrictAccess;
    }

    public void setRestrictAccess(boolean b) {
        this.restrictAccess = b;
    }

    @Override
    public void sideChanged(String oldSide, String newSide) {
        this.updateCountsAll();
    }

    public void addGlobalKeyCommand(DeckGlobalKeyCommand globalCommand) {
        this.globalCommands.add(globalCommand);
    }

    public void removeGlobalKeyCommand(DeckGlobalKeyCommand globalCommand) {
        this.globalCommands.remove(globalCommand);
    }

    protected String[] getGlobalCommands() {
        String[] commands = new String[this.globalCommands.size()];
        for (int i = 0; i < this.globalCommands.size(); ++i) {
            commands[i] = this.globalCommands.get(i).encode();
        }
        return commands;
    }

    protected void setGlobalCommands(String[] commands) {
        this.globalCommands = new ArrayList<DeckGlobalKeyCommand>(commands.length);
        for (String command : commands) {
            this.globalCommands.add(new DeckGlobalKeyCommand(command, this.propertySource));
        }
    }

    private void updateCountsAll() {
        if (!this.doesExpressionCounting() || this.getMap() == null) {
            return;
        }
        for (int index = 0; index < this.countExpressions.length; ++index) {
            this.expressionProperties.get(index).setPropertyValue("0");
        }
        this.asList().stream().filter(Objects::nonNull).forEach(p -> this.updateCounts((GamePiece)p, true));
    }

    private void updateCounts(int index) {
        if (!this.doesExpressionCounting()) {
            return;
        }
        if (index >= 0 && index < this.getPieceCount()) {
            GamePiece p = this.getPieceAt(index);
            if (p == null) {
                this.updateCountsAll();
            } else {
                this.updateCounts(p, false);
            }
        } else {
            this.updateCountsAll();
        }
    }

    private void updateCounts(GamePiece p, boolean increase) {
        if (!this.doesExpressionCounting() || this.getMap() == null) {
            return;
        }
        for (int index = 0; index < this.countExpressions.length; ++index) {
            String mapProperty;
            MutableProperty.Impl prop = this.expressionProperties.get(index);
            FormattedString formatted = new FormattedString(this.countExpressions[index].getExpression());
            String evaluated = formatted.getText((PropertySource)p, (Auditable)this, "Editor.DrawPile.count_express");
            if (!"true".equals(evaluated) && ("false".equals(evaluated) || !PropertiesPieceFilter.parse(evaluated).accept(p)) || (mapProperty = prop.getPropertyValue()) == null) continue;
            int newValue = Integer.decode(mapProperty);
            newValue = increase ? ++newValue : --newValue;
            prop.setPropertyValue(String.valueOf(newValue));
        }
    }

    protected void fireNumCardsProperty() {
        this.countProperty.setPropertyValue(String.valueOf(this.pieceCount));
    }

    @Override
    protected void insertPieceAt(GamePiece p, int index) {
        this.insertPieceAt(p, index, false);
    }

    @Override
    protected void insertPieceAt(GamePiece p, int index, boolean suppressDeckCounts) {
        super.insertPieceAt(p, index, suppressDeckCounts);
        if (!suppressDeckCounts) {
            this.updateCounts(p, true);
            this.fireNumCardsProperty();
        }
    }

    @Override
    protected void removePieceAt(int index) {
        this.removePieceAt(index, false);
    }

    @Override
    protected void removePieceAt(int index, boolean suppressDeckCounts) {
        int startCount = this.pieceCount;
        if (!suppressDeckCounts) {
            this.updateCounts(index);
        }
        super.removePieceAt(index, suppressDeckCounts);
        if (!suppressDeckCounts) {
            GameModule gm;
            this.fireNumCardsProperty();
            if (this.hotkeyOnEmpty && this.emptyKey != null && startCount > 0 && this.pieceCount == 0 && !(gm = GameModule.getGameModule()).getBasicLogger().isUndoInProgress()) {
                gm.getDeckManager().addEmptyDeck(this);
            }
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.updateCountsAll();
        this.fireNumCardsProperty();
    }

    @Override
    public void setMap(Map map) {
        if (map != this.getMap()) {
            this.countProperty.removeFromContainer();
            if (map != null) {
                this.countProperty.addTo(map);
            }
            for (MutableProperty.Impl prop : this.expressionProperties) {
                prop.removeFromContainer();
                if (map == null) continue;
                prop.addTo(map);
            }
        }
        super.setMap(map);
        this.updateCountsAll();
        this.fireNumCardsProperty();
    }

    public void addListeners() {
        if (this.shuffleListener == null) {
            this.shuffleListener = new NamedKeyStrokeListener(e -> {
                this.gameModule.sendAndLog(this.shuffle());
                this.repaintMap();
            });
            this.gameModule.addKeyStrokeListener(this.shuffleListener);
            this.shuffleListener.setKeyStroke(this.getShuffleKey());
        }
        if (this.reshuffleListener == null) {
            this.reshuffleListener = new NamedKeyStrokeListener(e -> {
                this.gameModule.sendAndLog(this.sendToDeck());
                this.repaintMap();
            });
            this.gameModule.addKeyStrokeListener(this.reshuffleListener);
            this.reshuffleListener.setKeyStroke(this.getReshuffleKey());
        }
        if (this.reverseListener == null) {
            this.reverseListener = new NamedKeyStrokeListener(e -> {
                this.gameModule.sendAndLog(this.reverse());
                this.repaintMap();
            });
            this.gameModule.addKeyStrokeListener(this.reverseListener);
            this.reverseListener.setKeyStroke(this.getReverseKey());
        }
        if (this.faceUpListener == null) {
            this.faceUpListener = new NamedKeyStrokeListener(e -> this.doFaceUp());
            this.gameModule.addKeyStrokeListener(this.faceUpListener);
            this.faceUpListener.setKeyStroke(this.getFaceUpKey());
        }
        if (this.faceDownListener == null) {
            this.faceDownListener = new NamedKeyStrokeListener(e -> this.doFaceDown());
            this.gameModule.addKeyStrokeListener(this.faceDownListener);
            this.faceDownListener.setKeyStroke(this.getFaceDownKey());
        }
        if (this.faceFlipListener == null) {
            this.faceFlipListener = new NamedKeyStrokeListener(e -> this.doFaceFlip());
            this.gameModule.addKeyStrokeListener(this.faceFlipListener);
            this.faceFlipListener.setKeyStroke(this.getFaceFlipKey());
        }
        if (this.saveListener == null) {
            this.saveListener = new NamedKeyStrokeListener(e -> this.doSaveDeck());
            this.gameModule.addKeyStrokeListener(this.saveListener);
            this.saveListener.setKeyStroke(this.getSaveKey());
        }
        if (this.loadListener == null) {
            this.loadListener = new NamedKeyStrokeListener(e -> this.doLoadDeck());
            this.gameModule.addKeyStrokeListener(this.loadListener);
            this.loadListener.setKeyStroke(this.getLoadKey());
        }
        if (this.myPile != null) {
            for (DeckKeyCommand dkc : this.myPile.getDeckKeyCommands()) {
                dkc.registerListeners(this);
            }
        }
        this.gameModule.addSideChangeListenerToPlayerRoster(this);
    }

    public void removeListeners() {
        if (this.shuffleListener != null) {
            this.gameModule.removeKeyStrokeListener(this.shuffleListener);
            this.shuffleListener = null;
        }
        if (this.reshuffleListener != null) {
            this.gameModule.removeKeyStrokeListener(this.reshuffleListener);
            this.reshuffleListener = null;
        }
        if (this.reverseListener != null) {
            this.gameModule.removeKeyStrokeListener(this.reverseListener);
            this.reverseListener = null;
        }
        if (this.faceUpListener != null) {
            this.gameModule.removeKeyStrokeListener(this.faceUpListener);
            this.faceUpListener = null;
        }
        if (this.faceDownListener != null) {
            this.gameModule.removeKeyStrokeListener(this.faceDownListener);
            this.faceDownListener = null;
        }
        if (this.faceFlipListener != null) {
            this.gameModule.removeKeyStrokeListener(this.faceFlipListener);
            this.faceFlipListener = null;
        }
        if (this.saveListener != null) {
            this.gameModule.removeKeyStrokeListener(this.saveListener);
            this.saveListener = null;
        }
        if (this.loadListener != null) {
            this.gameModule.removeKeyStrokeListener(this.loadListener);
            this.loadListener = null;
        }
        if (this.myPile != null) {
            for (DeckKeyCommand dkc : this.myPile.getDeckKeyCommands()) {
                dkc.deregisterListeners();
            }
        }
        this.gameModule.removeSideChangeListenerFromPlayerRoster(this);
    }

    public void myRefreshType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.drawOutline = st.nextBoolean(true);
        this.outlineColor = ColorConfigurer.stringToColor(st.nextToken("0,0,0"));
        this.size.setSize(st.nextInt(40), st.nextInt(40));
        this.faceDownOption = st.nextToken(ALWAYS);
        this.shuffleOption = st.nextToken(ALWAYS);
        this.allowMultipleDraw = st.nextBoolean(true);
        this.allowSelectDraw = st.nextBoolean(true);
        this.reversible = st.nextBoolean(true);
        this.reshuffleCommand = st.nextToken("");
        this.reshuffleTarget = st.nextToken("");
        this.reshuffleMsgFormat = st.nextToken("");
        this.setDeckName(st.nextToken(Resources.getString("Deck.deck")));
        this.shuffleMsgFormat = st.nextToken("");
        this.reverseMsgFormat = st.nextToken("");
        this.faceDownMsgFormat = st.nextToken("");
        this.drawFaceUp = st.nextBoolean(false);
        this.persistable = st.nextBoolean(false);
        this.shuffleKey = st.nextNamedKeyStroke(null);
        this.reshuffleKey = st.nextNamedKeyStroke(null);
        this.maxStack = st.nextInt(10);
        this.setCountExpressions(st.nextStringArray(0));
        this.expressionCounting = st.nextBoolean(false);
        this.setGlobalCommands(st.nextStringArray(0));
        this.hotkeyOnEmpty = st.nextBoolean(false);
        this.emptyKey = st.nextNamedKeyStroke(null);
        this.selectDisplayProperty.setFormat(st.nextToken("$BasicName$"));
        this.selectSortProperty = st.nextToken("");
        this.restrictOption = st.nextBoolean(false);
        this.restrictExpression.setExpression(st.nextToken(""));
        this.shuffleCommand = st.nextToken(Resources.getString("Deck.shuffle"));
        this.reverseCommand = st.nextToken(Resources.getString("Deck.reverse"));
        this.reverseKey = st.nextNamedKeyStroke(null);
        this.drawMultipleMessage = st.nextToken(Resources.getString("Deck.draw_multiple"));
        this.drawSpecificMessage = st.nextToken(Resources.getString("Deck.draw_specific"));
        this.faceUpMessage = st.nextToken(Resources.getString("Deck.face_up"));
        this.faceDownMessage = st.nextToken(Resources.getString("Deck.face_down"));
        this.faceUpKey = st.nextNamedKeyStroke(null);
        this.faceUpMsgFormat = st.nextToken("");
        this.faceFlipKey = st.nextNamedKeyStroke(null);
        this.faceDownKey = st.nextNamedKeyStroke(null);
        this.saveMessage = st.nextToken(Resources.getString("Editor.Deck.save_deck"));
        this.saveKey = st.nextNamedKeyStroke(null);
        this.saveReport = st.nextToken(Resources.getString("Deck.deck_saved"));
        this.loadMessage = st.nextToken(Resources.getString("Editor.Deck.load_deck"));
        this.loadKey = st.nextNamedKeyStroke(null);
        this.loadReport = st.nextToken(Resources.getString("Deck.deck_loaded"));
        this.restrictAccess = st.nextBoolean(false);
        this.owners = st.nextStringArray(0);
        this.commands = null;
    }

    protected void mySetType(String type) {
        this.myRefreshType(type);
        this.myPile = DrawPile.findDrawPile(this.getDeckName());
        if (this.myPile != null && !GameModule.getGameModule().getGameState().isGameStarted()) {
            this.myPile.setDeck(this);
        }
    }

    public String getFaceDownOption() {
        return this.faceDownOption;
    }

    public boolean isDrawFaceUp() {
        return this.drawFaceUp;
    }

    public void setDrawFaceUp(boolean drawFaceUp) {
        this.drawFaceUp = drawFaceUp;
    }

    public void setFaceDownOption(String faceDownOption) {
        this.faceDownOption = faceDownOption;
        this.faceDown = !faceDownOption.equals(NEVER) && !faceDownOption.equals(USE_MENU_UP);
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size.setSize(size);
    }

    public String getShuffleOption() {
        return this.shuffleOption;
    }

    public void setShuffleOption(String shuffleOption) {
        this.shuffleOption = shuffleOption;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    @Override
    public int getMaximumVisiblePieceCount() {
        return Math.min(this.pieceCount, this.maxStack);
    }

    public String[] getCountExpressions() {
        String[] fullstrings = new String[this.countExpressions.length];
        for (int index = 0; index < this.countExpressions.length; ++index) {
            fullstrings[index] = this.countExpressions[index].getFullString();
        }
        return fullstrings;
    }

    public boolean doesExpressionCounting() {
        return this.expressionCounting;
    }

    public String getFaceDownMsgFormat() {
        return this.faceDownMsgFormat;
    }

    public void setFaceDownMsgFormat(String faceDownMsgFormat) {
        this.faceDownMsgFormat = faceDownMsgFormat;
    }

    public String getReverseMsgFormat() {
        return this.reverseMsgFormat;
    }

    public void setReverseMsgFormat(String reverseMsgFormat) {
        this.reverseMsgFormat = reverseMsgFormat;
    }

    public String getReverseCommand() {
        return this.reverseCommand;
    }

    public void setReverseCommand(String s) {
        this.reverseCommand = s;
    }

    public NamedKeyStroke getReverseKey() {
        return this.reverseKey;
    }

    public void setReverseKey(NamedKeyStroke reverseKey) {
        this.reverseKey = reverseKey;
    }

    public String getShuffleMsgFormat() {
        return this.shuffleMsgFormat;
    }

    public void setShuffleMsgFormat(String shuffleMsgFormat) {
        this.shuffleMsgFormat = shuffleMsgFormat;
    }

    public NamedKeyStroke getShuffleKey() {
        return this.shuffleKey;
    }

    public void setShuffleKey(NamedKeyStroke shuffleKey) {
        this.shuffleKey = shuffleKey;
    }

    public String getShuffleCommand() {
        return this.shuffleCommand;
    }

    public void setShuffleCommand(String s) {
        this.shuffleCommand = s;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public boolean isAllowMultipleDraw() {
        return this.allowMultipleDraw;
    }

    public void setAllowMultipleDraw(boolean allowMultipleDraw) {
        this.allowMultipleDraw = allowMultipleDraw;
    }

    public boolean isAllowSelectDraw() {
        return this.allowSelectDraw;
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public void setCountExpressions(String[] countExpressionsString) {
        CountExpression[] c = new CountExpression[countExpressionsString.length];
        int goodExpressionCount = 0;
        for (int index = 0; index < countExpressionsString.length; ++index) {
            CountExpression n = new CountExpression(countExpressionsString[index]);
            if (n.getName() == null) continue;
            c[index] = n;
            ++goodExpressionCount;
        }
        this.countExpressions = Arrays.copyOf(c, goodExpressionCount);
        while (this.countExpressions.length > this.expressionProperties.size()) {
            this.expressionProperties.add(new MutableProperty.Impl("", this));
        }
        for (int i = 0; i < this.countExpressions.length; ++i) {
            this.expressionProperties.get(i).setPropertyName(this.deckName + "_" + this.countExpressions[i].getName());
        }
    }

    public void setExpressionCounting(boolean expressionCounting) {
        this.expressionCounting = expressionCounting;
    }

    public void setAllowSelectDraw(boolean allowSelectDraw) {
        this.allowSelectDraw = allowSelectDraw;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    public void setDeckName(String n) {
        if (Localization.getInstance().isTranslationInProgress()) {
            this.localizedDeckName = n;
        } else {
            this.deckName = n;
        }
        this.countProperty.setPropertyName(this.deckName + "_numPieces");
        for (int i = 0; i < this.countExpressions.length; ++i) {
            this.expressionProperties.get(i).setPropertyName(this.deckName + "_" + this.countExpressions[i].getName());
        }
    }

    public String getDeckName() {
        return this.deckName;
    }

    public String getLocalizedDeckName() {
        return this.localizedDeckName == null ? this.deckName : this.localizedDeckName;
    }

    public String getReshuffleCommand() {
        return this.reshuffleCommand;
    }

    public void setReshuffleCommand(String reshuffleCommand) {
        this.reshuffleCommand = reshuffleCommand;
    }

    public NamedKeyStroke getReshuffleKey() {
        return this.reshuffleKey;
    }

    public void setReshuffleKey(NamedKeyStroke reshuffleKey) {
        this.reshuffleKey = reshuffleKey;
    }

    public String getReshuffleTarget() {
        return this.reshuffleTarget;
    }

    public void setReshuffleTarget(String reshuffleTarget) {
        this.reshuffleTarget = reshuffleTarget;
    }

    public String getReshuffleMsgFormat() {
        return this.reshuffleMsgFormat;
    }

    public void setReshuffleMsgFormat(String reshuffleMsgFormat) {
        this.reshuffleMsgFormat = reshuffleMsgFormat;
    }

    public String getDrawMultipleMessage() {
        return this.drawMultipleMessage;
    }

    public void setDrawMultipleMessage(String m) {
        this.drawMultipleMessage = m;
    }

    public String getDrawSpecificMessage() {
        return this.drawSpecificMessage;
    }

    public void setDrawSpecificMessage(String m) {
        this.drawSpecificMessage = m;
    }

    public String getFaceUpMessage() {
        return this.faceUpMessage;
    }

    public void setFaceUpMessage(String m) {
        this.faceUpMessage = m;
    }

    public String getFaceDownMessage() {
        return this.faceDownMessage;
    }

    public void setFaceDownMessage(String m) {
        this.faceDownMessage = m;
    }

    public String getFaceUpMsgFormat() {
        return this.faceUpMsgFormat;
    }

    public void setFaceUpMsgFormat(String m) {
        this.faceUpMsgFormat = m;
    }

    public NamedKeyStroke getFaceUpKey() {
        return this.faceUpKey;
    }

    public void setFaceUpKey(NamedKeyStroke k) {
        this.faceUpKey = k;
    }

    public NamedKeyStroke getFaceDownKey() {
        return this.faceDownKey;
    }

    public void setFaceDownKey(NamedKeyStroke k) {
        this.faceDownKey = k;
    }

    public NamedKeyStroke getFaceFlipKey() {
        return this.faceFlipKey;
    }

    public void setFaceFlipKey(NamedKeyStroke k) {
        this.faceFlipKey = k;
    }

    public String getSaveMessage() {
        return this.saveMessage;
    }

    public void setSaveMessage(String s) {
        this.saveMessage = s;
    }

    public String getLoadMessage() {
        return this.loadMessage;
    }

    public void setLoadMessage(String s) {
        this.loadMessage = s;
    }

    public NamedKeyStroke getSaveKey() {
        return this.saveKey;
    }

    public void setSaveKey(NamedKeyStroke k) {
        this.saveKey = k;
    }

    public NamedKeyStroke getLoadKey() {
        return this.loadKey;
    }

    public void setLoadKey(NamedKeyStroke k) {
        this.loadKey = k;
    }

    public String getSaveReport() {
        return this.saveReport;
    }

    public void setSaveReport(String s) {
        this.saveReport = s;
    }

    public String getLoadReport() {
        return this.loadReport;
    }

    public void setLoadReport(String s) {
        this.loadReport = s;
    }

    public boolean isHotkeyOnEmpty() {
        return this.hotkeyOnEmpty;
    }

    public void setHotkeyOnEmpty(boolean b) {
        this.hotkeyOnEmpty = b;
    }

    public NamedKeyStroke getNamedEmptyKey() {
        return this.emptyKey;
    }

    public void setEmptyKey(NamedKeyStroke k) {
        this.emptyKey = k;
    }

    public void setRestrictOption(boolean restrictOption) {
        this.restrictOption = restrictOption;
    }

    public boolean isRestrictOption() {
        return this.restrictOption;
    }

    public void setRestrictExpression(PropertyExpression restrictExpression) {
        this.restrictExpression = restrictExpression;
    }

    public PropertyExpression getRestrictExpression() {
        return this.restrictExpression;
    }

    public boolean mayContain(GamePiece piece) {
        if (!this.restrictOption || this.restrictExpression.isNull()) {
            return true;
        }
        return this.restrictExpression.accept(piece);
    }

    @Override
    public String getType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.drawOutline).append(ColorConfigurer.colorToString(this.outlineColor)).append(String.valueOf(this.size.width)).append(String.valueOf(this.size.height)).append(this.faceDownOption).append(this.shuffleOption).append(String.valueOf(this.allowMultipleDraw)).append(String.valueOf(this.allowSelectDraw)).append(String.valueOf(this.reversible)).append(this.reshuffleCommand).append(this.reshuffleTarget).append(this.reshuffleMsgFormat).append(this.deckName).append(this.shuffleMsgFormat).append(this.reverseMsgFormat).append(this.faceDownMsgFormat).append(this.drawFaceUp).append(this.persistable).append(this.shuffleKey).append(this.reshuffleKey).append(String.valueOf(this.maxStack)).append(this.getCountExpressions()).append(this.expressionCounting).append(this.getGlobalCommands()).append(this.hotkeyOnEmpty).append(this.emptyKey).append(this.selectDisplayProperty.getFormat()).append(this.selectSortProperty).append(this.restrictOption).append(this.restrictExpression).append(this.shuffleCommand).append(this.reverseCommand).append(this.reverseKey).append(this.drawMultipleMessage).append(this.drawSpecificMessage).append(this.faceUpMessage).append(this.faceDownMessage).append(this.faceUpKey).append(this.faceUpMsgFormat).append(this.faceFlipKey).append(this.faceDownKey).append(this.saveMessage).append(this.saveKey).append(this.saveReport).append(this.loadMessage).append(this.loadKey).append(this.loadReport).append(this.restrictAccess).append(this.owners);
        return ID + se.getValue();
    }

    public Command shuffle() {
        GamePiece[] a = new GamePiece[this.pieceCount];
        System.arraycopy(this.contents, 0, a, 0, this.pieceCount);
        List<GamePiece> l = Arrays.asList(a);
        DragBuffer.getBuffer().clear();
        Collections.shuffle(l, this.gameModule.getRNG());
        Command c = this.setContents(l);
        if (Map.isChangeReportingEnabled()) {
            c = c.append(this.reportCommand(this.shuffleMsgFormat, Resources.getString("Deck.shuffle")));
        }
        return c;
    }

    public List<GamePiece> getOrderedPieces() {
        List<GamePiece> pieces = this.asList();
        if (ALWAYS.equals(this.shuffleOption)) {
            Collections.shuffle(pieces, GameModule.getGameModule().getRNG());
        } else {
            Collections.reverse(pieces);
        }
        return pieces;
    }

    public PieceIterator drawCards() {
        Iterator<GamePiece> it;
        if (this.nextDraw != null) {
            it = this.nextDraw.iterator();
        } else if (this.getPieceCount() == 0) {
            it = Collections.emptyIterator();
        } else {
            int count = Math.max(this.dragCount, Math.min(1, this.getPieceCount()));
            ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
            if (ALWAYS.equals(this.shuffleOption)) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < this.getPieceCount(); ++i) {
                    indices.add(i);
                }
                Random rng = this.gameModule.getRNG();
                while (count-- > 0 && !indices.isEmpty()) {
                    int i = rng.nextInt(indices.size());
                    int index = (Integer)indices.get(i);
                    indices.remove(i);
                    GamePiece p = this.getPieceAt(index);
                    pieces.add(p);
                }
            } else {
                Iterator<GamePiece> i = this.getPiecesReverseIterator();
                while (count-- > 0 && i.hasNext()) {
                    pieces.add(i.next());
                }
            }
            it = pieces.iterator();
        }
        this.dragCount = 0;
        this.nextDraw = null;
        return new PieceIterator(it){

            @Override
            public GamePiece nextPiece() {
                GamePiece p = super.nextPiece();
                p.setProperty("ObscuredPreDraw", p.getProperty("obs;"));
                if (Deck.this.faceDown) {
                    p.setProperty("obs;", Deck.NO_USER);
                }
                return p;
            }
        };
    }

    public Command setContents(Collection<GamePiece> c) {
        ChangeTracker track = new ChangeTracker(this);
        this.removeAll();
        for (GamePiece child : c) {
            this.insertChild(child, this.pieceCount);
        }
        return track.getChangeCommand();
    }

    @Override
    public String getState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getMap() == null ? "null" : this.getMap().getIdentifier()).append(this.getPosition().x).append(this.getPosition().y);
        se.append(this.faceDown);
        SequenceEncoder se2 = new SequenceEncoder(',');
        this.asList().forEach(gamePiece -> se2.append(gamePiece.getId()));
        if (se2.getValue() != null) {
            se.append(se2.getValue());
        }
        return se.getValue();
    }

    @Override
    public void setState(String state) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(state, ';');
        String mapId = st.nextToken();
        this.setPosition(new Point(st.nextInt(0), st.nextInt(0)));
        Map m = null;
        if (!"null".equals(mapId) && (m = Map.getMapById(mapId)) == null) {
            ErrorDialog.dataWarning(new BadDataReport("No such map", mapId, null));
        }
        if (m != this.getMap()) {
            if (m != null) {
                m.addPiece(this);
            } else {
                this.setMap(null);
            }
        }
        this.faceDown = "true".equals(st.nextToken());
        ArrayList<GamePiece> l = new ArrayList<GamePiece>();
        if (st.hasMoreTokens()) {
            SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(st.nextToken(), ',');
            while (st2.hasMoreTokens()) {
                GamePiece p = this.gameModule.getGameState().getPieceForId(st2.nextToken());
                if (p == null) continue;
                l.add(p);
            }
        }
        this.setContents(l);
        this.commands = null;
    }

    public Command setContentsFaceDown(boolean value) {
        Command c = new NullCommand();
        if (this.faceDown == value) {
            return c;
        }
        ChangeTracker t = new ChangeTracker(this);
        this.faceDown = value;
        this.commands = null;
        if (Map.isChangeReportingEnabled()) {
            c = c.append(this.reportCommand(this.faceDown ? this.faceDownMsgFormat : this.faceUpMsgFormat, value ? Resources.getString("Deck.face_down") : Resources.getString("Deck.face_up")));
        }
        return t.getChangeCommand().append(c);
    }

    public Command reverse() {
        ArrayList<GamePiece> list = new ArrayList<GamePiece>();
        Iterator<GamePiece> i = this.getPiecesReverseIterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        Command c = this.setContents(list);
        if (Map.isChangeReportingEnabled()) {
            c = c.append(this.reportCommand(this.reverseMsgFormat, Resources.getString("Deck.reverse")));
        }
        return c;
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public void setDrawOutline(boolean drawOutline) {
        this.drawOutline = drawOutline;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public boolean isFaceDown() {
        return this.faceDown;
    }

    @Override
    public Command pieceAdded(GamePiece p) {
        return null;
    }

    @Override
    public Command pieceRemoved(GamePiece p) {
        ChangeTracker tracker = new ChangeTracker(p);
        p.setProperty("ObscuredToOthers", this.isFaceDown() && !this.isDrawFaceUp());
        return tracker.getChangeCommand();
    }

    public void setFaceDown(boolean faceDown) {
        this.faceDown = faceDown;
        this.commands = null;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        GamePiece top;
        int count = Math.min(this.getPieceCount(), this.maxStack);
        GamePiece gamePiece = top = this.nextDraw != null && !this.nextDraw.isEmpty() ? this.nextDraw.get(0) : this.topPiece();
        if (top != null) {
            Object owner = top.getProperty("obs;");
            top.setProperty("obs;", this.faceDown ? NO_USER : null);
            Color blankColor = this.getBlankColor();
            Rectangle r = top.getShape().getBounds();
            r.setLocation(x + (int)(zoom * (double)r.x), y + (int)(zoom * (double)r.y));
            r.setSize((int)(zoom * (double)r.width), (int)(zoom * (double)r.height));
            for (int i = 0; i < count - 1; ++i) {
                if (blankColor != null) {
                    g.setColor(blankColor);
                    g.fillRect(r.x + (int)(zoom * 2.0 * (double)i), r.y - (int)(zoom * 2.0 * (double)i), r.width, r.height);
                    g.setColor(Color.black);
                    g.drawRect(r.x + (int)(zoom * 2.0 * (double)i), r.y - (int)(zoom * 2.0 * (double)i), r.width, r.height);
                    continue;
                }
                if (this.faceDown) {
                    top.draw(g, x + (int)(zoom * 2.0 * (double)i), y - (int)(zoom * 2.0 * (double)i), obs, zoom);
                    continue;
                }
                this.getPieceAt(count - i - 1).draw(g, x + (int)(zoom * 2.0 * (double)i), y - (int)(zoom * 2.0 * (double)i), obs, zoom);
            }
            top.draw(g, x + (int)(zoom * 2.0 * (double)(count - 1)), y - (int)(zoom * 2.0 * (double)(count - 1)), obs, zoom);
            top.setProperty("obs;", owner);
        } else if (this.drawOutline) {
            Rectangle r = this.boundingBox();
            r.setLocation(x + (int)(zoom * (double)r.x), y + (int)(zoom * (double)r.y));
            r.setSize((int)(zoom * (double)r.width), (int)(zoom * (double)r.height));
            g.setColor(this.outlineColor);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    protected Color getBlankColor() {
        Color c = Color.white;
        if (this.getMap() != null) {
            c = this.getMap().getStackMetrics().getBlankColor();
        }
        return c;
    }

    @Override
    public StackMetrics getStackMetrics() {
        return deckStackMetrics;
    }

    @Override
    public Rectangle boundingBox() {
        GamePiece top = this.topPiece();
        Dimension d = top == null ? this.size : top.getShape().getBounds().getSize();
        Rectangle r = new Rectangle(new Point(), d);
        r.translate(-r.width / 2, -r.height / 2);
        int n = this.getMaximumVisiblePieceCount();
        for (int i = 0; i < n; ++i) {
            r.y -= 2;
            r.height += 2;
            r.width += 2;
        }
        return r;
    }

    @Override
    public Shape getShape() {
        return this.boundingBox();
    }

    @Override
    public Object getProperty(Object key) {
        KeyCommand[] value = null;
        if ("NoStack".equals(key)) {
            value = Boolean.TRUE;
        } else if ("KeyCommands".equals(key)) {
            value = this.getKeyCommands();
        }
        return value;
    }

    protected void doFaceDown() {
        Command c = this.setContentsFaceDown(true);
        this.gameModule.sendAndLog(c);
        this.repaintMap();
    }

    protected void doFaceUp() {
        Command c = this.setContentsFaceDown(false);
        this.gameModule.sendAndLog(c);
        this.repaintMap();
    }

    protected void doFaceFlip() {
        Command c = this.setContentsFaceDown(!this.faceDown);
        this.gameModule.sendAndLog(c);
        this.repaintMap();
    }

    protected void doSaveDeck() {
        Command c = new NullCommand();
        if (this.saveDeck() && Map.isChangeReportingEnabled()) {
            c = c.append(this.reportCommand(this.saveReport, Resources.getString("General.save")));
        }
        this.gameModule.sendAndLog(c);
        this.repaintMap();
    }

    protected void doLoadDeck() {
        Command c = this.loadDeck();
        if (c != null) {
            if (!c.isNull() && Map.isChangeReportingEnabled()) {
                c = c.append(this.reportCommand(this.loadReport, Resources.getString("General.load")));
            }
            this.gameModule.sendAndLog(c);
            this.repaintMap();
        }
    }

    protected KeyCommand[] getKeyCommands() {
        if (this.commands == null) {
            KeyCommand c;
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            if (USE_MENU.equals(this.shuffleOption)) {
                c = new KeyCommand(this.shuffleCommand, this.getShuffleKey(), this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.gameModule.sendAndLog(Deck.this.shuffle());
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
            }
            if (this.reshuffleCommand.length() > 0) {
                c = new KeyCommand(this.reshuffleCommand, this.getReshuffleKey(), this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Deck.this.gameModule.sendAndLog(Deck.this.sendToDeck());
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
            }
            if (USE_MENU.equals(this.faceDownOption) || USE_MENU_UP.equals(this.faceDownOption)) {
                KeyCommand faceFlipAction = new KeyCommand(this.faceDown ? this.faceUpMessage : this.faceDownMessage, this.getFaceFlipKey(), this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.doFaceFlip();
                    }
                };
                l.add(faceFlipAction);
                KeyCommand faceDownAction = new KeyCommand("", this.getFaceDownKey(), this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.doFaceDown();
                    }
                };
                l.add(faceDownAction);
                KeyCommand faceUpAction = new KeyCommand("", this.getFaceUpKey(), this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.doFaceUp();
                    }
                };
                l.add(faceUpAction);
            }
            if (this.reversible) {
                c = new KeyCommand(this.reverseCommand, NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Command c = Deck.this.reverse();
                        Deck.this.gameModule.sendAndLog(c);
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
            }
            if (this.allowMultipleDraw) {
                c = new KeyCommand(this.drawMultipleMessage, NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.promptForDragCount();
                    }
                };
                l.add(c);
            }
            if (this.allowSelectDraw) {
                c = new KeyCommand(this.drawSpecificMessage, NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.promptForNextDraw();
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
            }
            if (this.persistable) {
                c = new KeyCommand(this.saveMessage, this.saveKey, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.doSaveDeck();
                    }
                };
                l.add(c);
                c = new KeyCommand(this.loadMessage, this.loadKey, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.doLoadDeck();
                    }
                };
                l.add(c);
            }
            for (DeckGlobalKeyCommand cmd : this.globalCommands) {
                l.add(cmd.getKeyCommand(this));
            }
            if (this.myPile != null) {
                for (DeckKeyCommand dkc : this.myPile.getDeckKeyCommands()) {
                    for (KeyCommand kc : dkc.getKeyCommands(this)) {
                        l.add(kc);
                    }
                }
            }
            this.commands = l.toArray(new KeyCommand[0]);
        }
        for (KeyCommand command : this.commands) {
            if (this.faceUpMessage.equals(command.getValue("Name")) && !this.faceDown) {
                command.putValue("Name", this.faceDownMessage);
                continue;
            }
            if (!this.faceDownMessage.equals(command.getValue("Name")) || !this.faceDown) continue;
            command.putValue("Name", this.faceUpMessage);
        }
        return this.isAccessible() ? this.commands : null;
    }

    protected Command reportCommand(String format, String commandName) {
        FormattedString reportFormat = new FormattedString(format);
        return this.reportCommand(reportFormat, commandName);
    }

    protected Command reportCommand(FormattedString reportFormat, String commandName) {
        reportFormat.setProperty("deckName", this.getLocalizedDeckName());
        reportFormat.setProperty("commandName", commandName);
        String rep = reportFormat.getLocalizedText(this, commandName);
        Chatter.DisplayText c = null;
        if (rep.length() > 0) {
            c = new Chatter.DisplayText(this.gameModule.getChatter(), "* " + rep);
            c.execute();
        }
        return c;
    }

    public void promptForDragCount() {
        String s;
        while ((s = JOptionPane.showInputDialog(GameModule.getGameModule().getPlayerWindow(), (Object)Resources.getString("Deck.enter_the_number"))) != null) {
            try {
                this.dragCount = Integer.parseInt(s);
                this.dragCount = Math.min(this.dragCount, this.getPieceCount());
                if (this.dragCount < 0) continue;
                break;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
    }

    protected void promptForNextDraw() {
        JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.map.getView()), true);
        d.setTitle(Resources.getString("Deck.draw"));
        d.setLayout(new BoxLayout(d.getContentPane(), 1));
        class AvailablePiece
        implements Comparable<AvailablePiece> {
            private final GamePiece piece;

            public AvailablePiece(GamePiece piece) {
                this.piece = piece;
            }

            @Override
            public int compareTo(AvailablePiece other) {
                if (other == null) {
                    return 1;
                }
                String otherProperty = (String)other.piece.getProperty(Deck.this.selectSortProperty);
                if (otherProperty == null) {
                    return 1;
                }
                String myProperty = (String)this.piece.getProperty(Deck.this.selectSortProperty);
                if (myProperty == null) {
                    return -1;
                }
                return -otherProperty.compareTo(myProperty);
            }

            public String toString() {
                return Deck.this.selectDisplayProperty.getText((PropertySource)this.piece, (Auditable)Deck.this, "Editor.DrawPile.list_cards");
            }

            public boolean equals(Object o) {
                if (!(o instanceof AvailablePiece)) {
                    return false;
                }
                return ((AvailablePiece)o).piece.equals(this.piece);
            }
        }
        Object[] pieces = new AvailablePiece[this.getPieceCount()];
        for (int i = 0; i < pieces.length; ++i) {
            pieces[pieces.length - i - 1] = new AvailablePiece(this.getPieceAt(i));
        }
        if (this.selectSortProperty != null && this.selectSortProperty.length() > 0) {
            Arrays.sort(pieces);
        }
        JList<AvailablePiece> list = new JList<AvailablePiece>(pieces);
        list.setSelectionMode(2);
        d.add(new ScrollPane(list));
        d.add(new JLabel(Resources.getString("Deck.select_cards")));
        d.add(new JLabel(Resources.getString("Deck.then_click")));
        Box box = Box.createHorizontalBox();
        JButton okButton = new JButton(Resources.getString("General.ok"));
        okButton.addActionListener(arg_0 -> this.lambda$promptForNextDraw$10(list, (AvailablePiece[])pieces, d, arg_0));
        box.add(okButton);
        JButton cancelButton = new JButton(Resources.getString("General.cancel"));
        cancelButton.addActionListener(e -> d.dispose());
        box.add(cancelButton);
        d.add(box);
        SwingUtils.setDefaultButtons(d.getRootPane(), okButton, cancelButton);
        d.pack();
        d.setLocationRelativeTo(d.getOwner());
        d.setVisible(true);
    }

    public Command sendToDeck() {
        Command c = null;
        this.nextDraw = null;
        DrawPile target = DrawPile.findDrawPile(this.reshuffleTarget);
        if (target != null) {
            int cnt;
            if (this.reshuffleMsgFormat.length() > 0 && Map.isChangeReportingEnabled()) {
                c = this.reportCommand(this.reshuffleMsgFormat, this.reshuffleCommand);
                if (c == null) {
                    c = new NullCommand();
                }
            } else {
                c = new NullCommand();
            }
            for (int i = cnt = this.getPieceCount() - 1; i >= 0; --i) {
                GamePiece p = this.getPieceAt(i);
                c = p.prepareMove(c, false);
                c = c.append(target.addToContents(p));
                c = p.finishMove(c, false, false);
            }
        }
        return c;
    }

    public Command extendedSend(DeckSendKeyCommand dkc) {
        int sendLimit;
        Object data;
        String targetDeckName;
        Command c = new NullCommand();
        if (dkc.isVariableDeck()) {
            targetDeckName = dkc.getDeckExpression().getText(this.propertySource, (Auditable)dkc, "Editor.DeckSendKeyCommand.deck_expression");
            data = targetDeckName + " from expression " + String.valueOf(dkc.getDeckExpression());
        } else {
            targetDeckName = dkc.getTargetDeck();
            data = targetDeckName;
        }
        DrawPile target = DrawPile.findDrawPile(targetDeckName);
        if (target == null) {
            ErrorDialog.dataWarning(new BadDataReport(dkc, Resources.getString("Editor.DeckSendKeyCommand.error_no_target"), (String)data));
            return c;
        }
        if (dkc.isLimitTotal()) {
            try {
                sendLimit = Integer.parseInt(dkc.getLimitExpression().getText((PropertySource)this, (Auditable)dkc, "Editor.DeckSendKeyCommand.limit_expression"));
            }
            catch (Exception ex) {
                ErrorDialog.dataWarning(new BadDataReport(dkc, Resources.getString("Editor.Editor.DeckSendKeyCommand.error_invalid_send_limit"), dkc.getLimitExpression().getFormat()));
                sendLimit = -1;
            }
        } else {
            sendLimit = -1;
        }
        ArrayList<GamePiece> sending = new ArrayList<GamePiece>();
        List<GamePiece> drawing = this.getOrderedPieces();
        for (GamePiece nextCard : drawing) {
            String result;
            if (dkc.isSendMatching() && !"true".equals(result = dkc.getMatchExpression().getText((PropertySource)nextCard, (Auditable)dkc, "Editor.DeckSendKeyCommand.send_expression"))) continue;
            if (dkc.isStop() && "true".equals(result = dkc.getStopExpresson().getText((PropertySource)nextCard, (Auditable)dkc, "Editor.DeckSendKeyCommand.stop_expression"))) {
                if (!dkc.isStopInclude()) break;
                sending.add(nextCard);
                break;
            }
            sending.add(nextCard);
            if (sendLimit <= 0 || sending.size() < sendLimit) continue;
            break;
        }
        for (GamePiece piece : sending) {
            c = piece.prepareMove(c, false);
            c = c.append(target.addToContents(piece));
            c = piece.finishMove(c, dkc.isApplyOnMove() && this.map != null, false);
            if (!dkc.isApplyOnMove() || this.map == null) continue;
            this.map.repaint();
        }
        if (!dkc.getReportFormat().getFormat().isEmpty() && Map.isChangeReportingEnabled()) {
            FormattedString report = dkc.getReportFormat();
            report.setProperty("sentCount", String.valueOf(sending.size()));
            report.setProperty("targetDeck", targetDeckName);
            c = c.append(this.reportCommand(report, dkc.getConfigureName()));
        }
        return c;
    }

    @Override
    public boolean isExpanded() {
        return false;
    }

    public boolean isAccessibleTo(String playerSide) {
        if (!this.isRestrictAccess()) {
            return true;
        }
        for (String owner : this.owners) {
            if (!owner.equals(playerSide)) continue;
            return true;
        }
        return false;
    }

    public boolean isAccessible() {
        return this.isAccessibleTo(PlayerRoster.getMySide());
    }

    public boolean isPersistable() {
        return this.persistable;
    }

    public void setPersistable(boolean persistable) {
        this.persistable = persistable;
    }

    private File getSaveFileName() {
        Object name;
        int index;
        FileChooser fc = this.gameModule.getFileChooser();
        File sf = fc.getSelectedFile();
        if (sf != null && (index = ((String)(name = sf.getPath())).lastIndexOf(46)) > 0) {
            name = ((String)name).substring(0, index) + ".sav";
            fc.setSelectedFile(new File((String)name));
        }
        if (fc.showSaveDialog(this.map.getView()) != 0) {
            return null;
        }
        File outputFile = fc.getSelectedFile();
        if (outputFile != null && outputFile.exists() && this.shouldConfirmOverwrite() && 1 == JOptionPane.showConfirmDialog(this.gameModule.getPlayerWindow(), Resources.getString("Deck.overwrite", outputFile.getName()), Resources.getString("Deck.file_exists"), 0)) {
            outputFile = null;
        }
        return outputFile;
    }

    private boolean shouldConfirmOverwrite() {
        return System.getProperty("os.name").trim().equalsIgnoreCase("linux");
    }

    private boolean saveDeck() {
        boolean result = false;
        this.gameModule.warn(Resources.getString("Deck.saving_deck"));
        File saveFile = this.getSaveFileName();
        try {
            if (saveFile != null) {
                this.saveDeck(saveFile);
                result = true;
            } else {
                this.gameModule.warn(Resources.getString("Deck.save_canceled"));
            }
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, saveFile);
        }
        return result;
    }

    public void saveDeck(File f) throws IOException {
        Command comm = new LoadDeckCommand(null);
        for (GamePiece p : this.asList()) {
            p.setMap(null);
            comm = comm.append(new AddPiece(p));
        }
        try (BufferedWriter w = Files.newBufferedWriter(f.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.gameModule.addCommandEncoder(this.commandEncoder);
            w.write(this.gameModule.encode(comm));
            this.gameModule.removeCommandEncoder(this.commandEncoder);
        }
    }

    private File getLoadFileName() {
        FileChooser fc = this.gameModule.getFileChooser();
        fc.selectDotSavFile();
        if (fc.showOpenDialog(this.map.getView()) != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private Command loadDeck() {
        Command c = new NullCommand();
        this.gameModule.warn(Resources.getString("Deck.loading_deck"));
        File loadFile = this.getLoadFileName();
        try {
            if (loadFile != null) {
                c = this.loadDeck(loadFile);
            } else {
                this.gameModule.warn(Resources.getString("Deck.load_canceled"));
            }
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, loadFile);
        }
        catch (NoSuchElementException e) {
            JOptionPane.showMessageDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("Deck.load_failed_title"), Resources.getString("Deck.load_failed_text", loadFile != null ? loadFile.getName() : ""), 0);
        }
        return c;
    }

    public Command loadDeck(File f) throws IOException {
        String ds = Files.readString(f.toPath(), StandardCharsets.UTF_8);
        this.gameModule.addCommandEncoder(this.commandEncoder);
        Command c = this.gameModule.decode(ds);
        this.gameModule.removeCommandEncoder(this.commandEncoder);
        if (c instanceof LoadDeckCommand) {
            ChangeTracker t = new ChangeTracker(this);
            c.execute();
            Command[] sub = c.getSubCommands();
            c = new NullCommand();
            for (Command command : sub) {
                c = c.append(command);
            }
            c = c.append(t.getChangeCommand());
            this.updateCountsAll();
        } else {
            this.gameModule.warn(Resources.getString("Deck.not_a_saved_deck", f.getName()));
            c = null;
        }
        return c;
    }

    public int getDragCount() {
        return this.dragCount;
    }

    public void setDragCount(int dragCount) {
        this.dragCount = dragCount;
    }

    public void setSelectDisplayProperty(String promptDisplayProperty) {
        this.selectDisplayProperty.setFormat(promptDisplayProperty);
    }

    public void setSelectSortProperty(String promptSortProperty) {
        this.selectSortProperty = promptSortProperty;
    }

    public String getSelectDisplayProperty() {
        return this.selectDisplayProperty.getFormat();
    }

    public String getSelectSortProperty() {
        return this.selectSortProperty;
    }

    public void repaintMap() {
        if (this.map != null) {
            this.map.repaint();
        }
    }

    public Command sort(List<SortParameter> sortParameters, FormattedString reportFormat, String menuCommand) {
        Command c = new NullCommand();
        if (sortParameters == null || sortParameters.isEmpty() || sortParameters.get(0).getSortProperty().isEmpty()) {
            return c;
        }
        ArrayList<GamePiece> pieces = new ArrayList<GamePiece>(Arrays.asList(this.contents).subList(0, this.pieceCount));
        Collections.sort(pieces, new SortParameterComparator(sortParameters));
        c = c.append(this.setContents(pieces));
        if (Map.isChangeReportingEnabled() && !reportFormat.getFormat().isEmpty()) {
            c = c.append(this.reportCommand(reportFormat, menuCommand));
        }
        return c;
    }

    private /* synthetic */ void lambda$promptForNextDraw$10(JList list, 1AvailablePiece[] pieces, JDialog d, ActionEvent e) {
        int[] selection = list.getSelectedIndices();
        if (selection.length > 0) {
            this.nextDraw = new ArrayList<GamePiece>();
            for (int value : selection) {
                this.nextDraw.add(pieces[value].piece);
            }
        } else {
            this.nextDraw = null;
        }
        d.dispose();
    }

    public static class CountExpression {
        private final String fullstring;
        private final String name;
        private final String expression;

        public CountExpression(String expressionString) {
            String[] split = expressionString.split("\\s*:\\s*", 2);
            if (split.length == 2) {
                this.name = split[0];
                this.expression = split[1];
                this.fullstring = expressionString;
            } else {
                this.fullstring = null;
                this.expression = null;
                this.name = null;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getFullString() {
            return this.fullstring;
        }
    }

    protected static class LoadDeckCommand
    extends Command {
        public static final String PREFIX = "DECK\t";
        private final Deck target;

        public LoadDeckCommand(Deck target) {
            this.target = target;
        }

        @Override
        protected void executeCommand() {
            Command[] sub;
            this.target.removeAll();
            for (Command command : sub = this.getSubCommands()) {
                if (!(command instanceof AddPiece)) continue;
                GamePiece p = ((AddPiece)command).getTarget();
                p.setId(null);
                this.target.add(p);
            }
        }

        public String getTargetId() {
            return this.target == null ? "" : this.target.getId();
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

