/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.node.AsynchronousServerNode;
import VASSAL.chat.node.Node;
import VASSAL.tools.PropertiesEncoder;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class StatusReporter
implements Runnable {
    private final HttpRequestWrapper reportStatus;
    private String lastReportedContents;
    private String currentContents;
    private long sleepInterval = 2000L;
    private static final long MIN_SLEEP = 2000L;
    private static final long MAX_SLEEP = 0x6DDD00L;
    private final AsynchronousServerNode server;

    public StatusReporter(HttpRequestWrapper reportStatus, AsynchronousServerNode server) {
        this.reportStatus = reportStatus;
        this.server = server;
        new Thread((Runnable)this, "status reporter").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContents(Node[] players) {
        if (this.reportStatus == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        for (Node pl : players) {
            Node mod = this.server.getModule(pl);
            try {
                String name = new PropertiesEncoder(pl.getInfo()).getProperties().getProperty("name");
                if (name == null) continue;
                buffer.append(mod.getId()).append('\t').append(pl.getParent().getId()).append('\t').append(name).append('\n');
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        StatusReporter statusReporter = this;
        synchronized (statusReporter) {
            this.currentContents = buffer.toString();
        }
    }

    private synchronized void sendContents() {
        if (this.currentContents != null && !this.currentContents.equals(this.lastReportedContents)) {
            try {
                Properties props = new Properties();
                props.put("STATUS", this.currentContents);
                this.reportStatus.doPost("updateConnections", props);
                this.sleepInterval = 2000L;
            }
            catch (IOException e) {
                this.sleepInterval = Math.min(2L * this.sleepInterval, 0x6DDD00L);
            }
            this.lastReportedContents = this.currentContents;
            System.err.println("----" + String.valueOf(new Date()));
            System.err.println(this.currentContents);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.sleepInterval);
                    this.sendContents();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

