/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.command.Command;
import VASSAL.counters.GamePiece;
import VASSAL.property.PersistentPropertyContainer;

public class SetPersistentPropertyCommand
extends Command {
    public static final String COMMAND_PREFIX = "SPP\t";
    protected Object key;
    protected Object oldValue;
    protected Object newValue;
    protected String id;

    public SetPersistentPropertyCommand(String id, Object key, Object oldValue, Object newValue) {
        this.setKey(key);
        this.setOldValue(oldValue);
        this.setNewValue(newValue);
        this.setId(id);
    }

    @Override
    protected void executeCommand() {
        GamePiece target = GameModule.getGameModule().getGameState().getPieceForId(this.id);
        if (target != null && target instanceof PersistentPropertyContainer) {
            ((PersistentPropertyContainer)((Object)target)).setPersistentProperty(this.getKey(), this.getNewValue());
        }
    }

    @Override
    protected Command myUndoCommand() {
        return new SetPersistentPropertyCommand(this.id, this.key, this.newValue, this.oldValue);
    }

    @Override
    public String getDetails() {
        return "id=" + this.id + ",key=" + String.valueOf(this.key) + ",old=" + String.valueOf(this.oldValue) + ",new=" + String.valueOf(this.newValue);
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

