/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Configurable;
import VASSAL.i18n.Resources;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JDialog;

public abstract class Configurer {
    public static final String NAME_PROPERTY = "Configurer.name";
    protected String key;
    protected String name;
    protected Object value;
    protected PropertyChangeSupport changeSupport;
    protected boolean noUpdate = false;
    protected boolean frozen = false;
    protected String hint = "";
    private boolean highlighted = false;
    public static final Color LIST_ENTRY_HIGHLIGHT_COLOR = new Color(255, 230, 230);

    public Configurer(String key, String name) {
        this(key, name, null);
    }

    public Configurer(String key, String name, Object val) {
        this.key = key;
        this.name = name == null ? "" : name;
        this.changeSupport = new PropertyChangeSupport(this);
        this.setValue(val);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        String oldName = this.name;
        this.name = s;
        if (!this.frozen) {
            this.changeSupport.firePropertyChange(NAME_PROPERTY, oldName, this.name);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public abstract String getValueString();

    public void setValue(Object o) {
        Object oldValue = this.getValue();
        this.value = o;
        if (!this.frozen) {
            this.changeSupport.firePropertyChange(this.key, oldValue, this.value);
        }
    }

    public void setFrozen(boolean val) {
        this.frozen = val;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void fireUpdate() {
        this.changeSupport.firePropertyChange(this.key, null, this.value);
    }

    public abstract void setValue(String var1);

    public abstract Component getControls();

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    protected void repack() {
        this.repack(this.getControls());
    }

    protected void repack(Component controls) {
        SwingUtils.repack(controls);
    }

    protected Dimension getScreenSize() {
        return SwingUtils.getScreenSize();
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void setHintKey(String hintKey) {
        this.hint = Resources.getString(hintKey);
    }

    public void setLabelVisible(boolean visible) {
    }

    @Deprecated(since="2023-01-14", forRemoval=true)
    public void setLabelVisibile(boolean visible) {
        this.setLabelVisible(visible);
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void addFocusListener(FocusListener listener) {
    }

    public void removeFocusListener(FocusListener listener) {
    }

    public void requestFocus() {
    }

    public void initCustomControls(JDialog d, Configurable target) {
    }
}

