/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AutoConfigurable;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;

public class TextConfigurer
extends Configurer
implements ConfigurerFactory {
    private JTextArea textArea;
    private JPanel p;
    private boolean wordWrap;
    private long lastUpdate = System.currentTimeMillis();
    private String updatedValue;
    private boolean updateQueued = false;
    private static final long updateFrequency = 1000L;

    public TextConfigurer() {
        this(null, null, null);
    }

    public TextConfigurer(String key, String name) {
        this(key, name, "");
    }

    public TextConfigurer(String key, String name, String val) {
        super(key, name, val);
    }

    public TextConfigurer(String key, String name, String val, boolean wrap) {
        this(key, name, val);
        this.setWordWrap(wrap);
    }

    @Override
    public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
        this.key = key;
        this.name = name;
        return this;
    }

    @Override
    public String getValueString() {
        return TextConfigurer.escapeNewlines((String)this.getValue());
    }

    public void setWordWrap(boolean b) {
        this.wordWrap = b;
    }

    public static String escapeNewlines(String s) {
        SequenceEncoder se = new SequenceEncoder('|');
        StringTokenizer st = new StringTokenizer(s, "\n\r", true);
        boolean wasNewLine = true;
        block4: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (token.charAt(0)) {
                case '\n': {
                    if (wasNewLine) {
                        se.append("");
                    }
                    wasNewLine = true;
                    continue block4;
                }
                case '\r': {
                    continue block4;
                }
            }
            se.append(token);
            wasNewLine = false;
        }
        return se.getValue() == null ? "" : se.getValue();
    }

    @Override
    public void setValue(String s) {
        String text = TextConfigurer.restoreNewlines(s);
        this.setValue((Object)text);
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (!this.noUpdate && this.textArea != null) {
            this.textArea.setText((String)o);
        }
    }

    public static String restoreNewlines(String s) {
        return StringUtils.join((Iterator)new SequenceEncoder.Decoder(s, '|'), (char)'\n');
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.textArea.requestFocus();
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            this.textArea = new JTextArea(6, 20);
            if (this.wordWrap) {
                this.textArea.setLineWrap(true);
                this.textArea.setWrapStyleWord(true);
            }
            this.textArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    TextConfigurer.this.queueForUpdate(TextConfigurer.this.textArea.getText());
                }
            });
            this.textArea.setText((String)this.getValue());
            SwingUtils.allowUndo(this.textArea);
            ScrollPane scroll = new ScrollPane(this.textArea);
            if (this.name != null) {
                scroll.setBorder(new TitledBorder(this.name));
            }
            this.p.add(scroll);
        }
        return this.p;
    }

    private void queueForUpdate(String s) {
        this.updatedValue = s;
        if (System.currentTimeMillis() > this.lastUpdate + 1000L) {
            this.executeUpdate();
        } else if (!this.updateQueued) {
            this.updateQueued = true;
            Runnable delayedUpdate = () -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(this::executeUpdate);
            };
            new Thread(delayedUpdate).start();
        }
    }

    private void executeUpdate() {
        this.noUpdate = true;
        this.setValue((Object)this.updatedValue);
        this.lastUpdate = System.currentTimeMillis();
        this.updateQueued = false;
        this.noUpdate = false;
    }
}

