/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Objects;
import javax.swing.KeyStroke;

public class BasicName
extends Decorator
implements TranslatablePiece {
    public static final String ID = "basicName;";
    protected String name;
    protected String localizedName = null;

    public BasicName() {
        this("basicName;;", null);
    }

    public BasicName(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.name = st.nextToken();
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.name);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public Object getProperty(Object key) {
        if ("BasicName".equals(key)) {
            return this.name;
        }
        if ("LocalizedBasicName".equals(key)) {
            return this.getLocalizedProperty("BasicName");
        }
        return super.getProperty(key);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("BasicName".equals(key)) {
            if (this.localizedName != null) {
                return this.localizedName;
            }
            this.localizedName = this.getI18nData().translate(this.name);
            return this.localizedName;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.name}, new String[]{Resources.getString("Editor.BasicName.trait_description")});
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.BasicName.trait_description", this.name);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.BasicName.trait_description");
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof BasicName)) {
            return false;
        }
        BasicName c = (BasicName)o;
        return Objects.equals(this.name, c.name);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("BasicName.html");
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer descInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();

        public Ed(BasicName p) {
            this.descInput = new StringConfigurer(p.name);
            this.descInput.setHintKey("Editor.BasicName.hint");
            this.controls.add("Editor.name_label", (Configurer)this.descInput);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.descInput.getValueString());
            return BasicName.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

