/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DeckSelectionConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.AuditableException;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;

public class ReturnToDeck
extends Decorator
implements TranslatablePiece {
    public static final String ID = "return;";
    public static final int RtDversion = 2;
    protected String deckId;
    protected String returnCommand;
    protected String selectDeckPrompt = Resources.getString("Editor.ReturnToDeck.select_destination");
    protected NamedKeyStroke returnKey;
    protected DrawPile deck;
    protected KeyCommand[] commands;
    protected KeyCommand myCommand;
    protected String description = "";
    protected String deckName;
    protected boolean deckSelect = true;
    protected FormattedString deckExpression = new FormattedString("");

    public ReturnToDeck() {
        this(ID + Resources.getString("Editor.ReturnToDeck.default_command") + ";R;", null);
    }

    public ReturnToDeck(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        Mat mat;
        if (this.commands == null) {
            this.myCommand = new KeyCommand(this.returnCommand, this.returnKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.returnCommand.length() > 0 && this.returnKey != null && !this.returnKey.isNull() ? new KeyCommand[]{this.myCommand} : KeyCommand.NONE;
        }
        this.myCommand.setEnabled((mat = (Mat)Decorator.getDecorator(Decorator.getOutermost(this), Mat.class)) == null || mat.getCargoCount() == 0);
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetType(String s) {
        if (s.startsWith(ID)) {
            s = s.substring(ID.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
            this.returnCommand = st.nextToken();
            this.returnKey = st.nextNamedKeyStroke(null);
            this.deckId = st.nextToken("");
            this.selectDeckPrompt = st.nextToken(this.selectDeckPrompt);
            this.description = st.nextToken("");
            int version = st.nextInt(0);
            if (version < 2) {
                this.deckSelect = this.deckId == null || this.deckId.isEmpty();
                this.deckExpression.setFormat(this.deckId);
            } else {
                this.deckSelect = st.nextBoolean(true);
                this.deckExpression.setFormat(st.nextToken(""));
            }
        }
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        return ID + se.append(this.returnCommand).append(this.returnKey).append(this.deckId).append(this.selectDeckPrompt).append(this.description).append(2).append(this.deckSelect).append(this.deckExpression.getFormat()).getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        Command comm = null;
        if (this.myCommand.matches(stroke)) {
            Map m;
            DrawPile pile;
            if (this.deckSelect) {
                pile = this.promptForDrawPile();
            } else {
                AuditTrail audit = AuditTrail.create((Auditable)this, this.deckExpression, Resources.getString("Editor.ReturnToDeck.deck_name"));
                String evalName = this.deckExpression.getText((PropertySource)Decorator.getOutermost(this), (Auditable)this, audit);
                pile = DrawPile.findDrawPile(evalName);
                if (pile == null) {
                    ReturnToDeck.reportDataError(this, "Deck Not Found for Return-to-Deck trait: " + evalName, this.deckExpression.getFormat(), new AuditableException(this, audit));
                }
            }
            if (pile == null) {
                return null;
            }
            Map preMap = this.getMap();
            Point prePos = this.getPosition();
            comm = this.prepareMove(new NullCommand(), false);
            comm = comm.append(pile.addToContents(Decorator.getOutermost(this)));
            MatCargo cargo = (MatCargo)Decorator.getDecorator(Decorator.getOutermost(this), MatCargo.class);
            if (cargo != null && cargo.getMat() != null) {
                comm = comm.append(cargo.makeClearMatCommand());
            }
            comm = this.finishMove(comm, (m = pile.getMap()) != null && m.getMoveKey() != null && (m != preMap || !this.getPosition().equals(prePos)), false);
            if (m != null) {
                m.repaint();
            }
        }
        return comm;
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    private DrawPile promptForDrawPile() {
        JDialog d = new JDialog((Frame)GameModule.getGameModule().getPlayerWindow(), true);
        d.setTitle(Decorator.getInnermost(this).getName());
        d.setLayout(new BoxLayout(d.getContentPane(), 1));
        List<DrawPile> piles = GameModule.getGameModule().getAllDescendantComponentsOf(DrawPile.class);
        if (piles.isEmpty()) {
            ReturnToDeck.reportDataError(this, "No decks in module.");
            return null;
        }
        class AvailableDeck {
            private final DrawPile pile;

            public AvailableDeck(DrawPile pile) {
                this.pile = pile;
            }

            public String toString() {
                return this.pile.getConfigureName();
            }
        }
        AvailableDeck[] decks = new AvailableDeck[piles.size()];
        int i = 0;
        for (DrawPile p : piles) {
            decks[i++] = new AvailableDeck(p);
        }
        JList<AvailableDeck> list = new JList<AvailableDeck>(decks);
        list.setSelectionMode(0);
        JLabel prompt = new JLabel(this.selectDeckPrompt);
        prompt.setAlignmentX(0.5f);
        d.add(prompt);
        d.add(new ScrollPane(list));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.5f);
        JButton okButton = new JButton(Resources.getString("General.ok"));
        okButton.addActionListener(e -> {
            AvailableDeck selection = (AvailableDeck)list.getSelectedValue();
            if (selection != null) {
                this.deck = selection.pile;
            }
            d.dispose();
        });
        box.add(okButton);
        JButton cancelButton = new JButton(Resources.getString("General.cancel"));
        cancelButton.addActionListener(e -> d.dispose());
        box.add(cancelButton);
        d.add(box);
        SwingUtils.setDefaultButtons(d.getRootPane(), okButton, cancelButton);
        d.pack();
        d.setLocationRelativeTo(d.getOwner());
        d.setVisible(true);
        DrawPile pile = this.deck;
        this.deck = null;
        return pile;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.ReturnToDeck.trait_description", this.deckSelect ? "" : this.deckExpression.getFormat(), this.description);
        s = (String)s + this.getCommandDesc(this.returnCommand, this.returnKey);
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.ReturnToDeck.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ReturnToDeck.html");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.returnCommand, Resources.getString("Editor.ReturnToDeck.return_to_deck_command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof ReturnToDeck)) {
            return false;
        }
        ReturnToDeck c = (ReturnToDeck)o;
        if (!Objects.equals(this.returnCommand, c.returnCommand)) {
            return false;
        }
        if (!Objects.equals(this.returnKey, c.returnKey)) {
            return false;
        }
        if (!Objects.equals(this.deckExpression, c.deckExpression)) {
            return false;
        }
        if (!Objects.equals(this.deckSelect, c.deckSelect)) {
            return false;
        }
        if (!Objects.equals(this.deckId, c.deckId)) {
            return false;
        }
        return Objects.equals(this.selectDeckPrompt, c.selectDeckPrompt);
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.deckExpression.getFormat());
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Collections.singletonList(this.returnKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.returnCommand);
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.selectDeckPrompt);
    }

    private static class Ed
    implements PieceEditor {
        private final StringConfigurer menuName;
        private final NamedHotKeyConfigurer menuKey;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final String deckId;
        private final JLabel promptLabel;
        private final StringConfigurer promptText;
        private final BooleanConfigurer prompt;
        private final JLabel selectLabel;
        private final StringConfigurer description;
        private final DeckSelectionConfigurer deckExp;

        public Ed(ReturnToDeck p) {
            this.deckId = p.deckId;
            this.description = new StringConfigurer(p.description);
            this.description.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.description);
            this.menuName = new StringConfigurer(p.returnCommand);
            this.menuName.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.menuName);
            this.menuKey = new NamedHotKeyConfigurer(p.returnKey);
            this.controls.add("Editor.keyboard_command", (Configurer)this.menuKey);
            this.prompt = new BooleanConfigurer(p.deckSelect);
            this.prompt.addPropertyChangeListener(e -> this.updateVisibility());
            this.controls.add("Editor.ReturnToDeck.choose_destination_deck_at_game_time", (Configurer)this.prompt);
            this.selectLabel = new JLabel(Resources.getString("Editor.ReturnToDeck.deck_name"));
            this.deckExp = new DeckSelectionConfigurer(p.deckExpression.getFormat(), p);
            this.controls.add(this.selectLabel);
            this.controls.add(this.deckExp.getControls(), "split 2");
            this.promptLabel = new JLabel(Resources.getString("Editor.ReturnToDeck.prompt_for_destination_deck"));
            this.promptText = new StringConfigurer(p.selectDeckPrompt);
            this.controls.add(this.promptLabel, (Configurer)this.promptText);
            this.updateVisibility();
        }

        private void updateVisibility() {
            this.promptLabel.setVisible(this.prompt.getValueBoolean());
            this.promptText.getControls().setVisible(this.prompt.getValueBoolean());
            this.deckExp.getControls().setVisible(!this.prompt.getValueBoolean());
            this.selectLabel.setVisible(!this.prompt.getValueBoolean());
            Decorator.repack(this.controls);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.menuName.getValueString()).append(this.menuKey.getValueString()).append(this.deckId).append(this.promptText.getValueString()).append(this.description.getValueString()).append(2).append(this.prompt.getValueBoolean()).append(this.deckExp.getValueString());
            return ReturnToDeck.ID + se.getValue();
        }
    }
}

