/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.InputStream;
import java.io.OutputStream;
import org.litesoft.p2pchat.ActivePeersSupport;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.NewPeersSupport;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PeerReader;
import org.litesoft.p2pchat.PeerWriter;
import org.litesoft.p2pchat.UserDialog;

public class ActivePeer
extends Thread {
    public static final String CHAT = "CHAT ";
    public static final String HELO = "HELO ";
    public static final String PMSG = "PMSG ";
    public static final String NAME = "NAME ";
    public static final String PEER = "PEER ";
    public static final String DONE = "DONE ";
    private MyInfo zMyInfo;
    private UserDialog zUserDialog;
    private ActivePeersSupport zActivePeersSupport;
    private NewPeersSupport zNewPeersSupport;
    private PeerInfo zPeerInfo;
    private PeerReader zReader;
    private PeerWriter zWriter;

    public ActivePeer(MyInfo pMyInfo, UserDialog pUserDialog, ActivePeersSupport pActivePeersSupport, NewPeersSupport pNewPeersSupport, PeerInfo pPeerInfo, InputStream pIs, OutputStream pOs) {
        this(pMyInfo, pUserDialog, pActivePeersSupport, pNewPeersSupport, pPeerInfo, new PeerReader(pIs), new PeerWriter(pOs));
    }

    public ActivePeer(MyInfo pMyInfo, UserDialog pUserDialog, ActivePeersSupport pActivePeersSupport, NewPeersSupport pNewPeersSupport, PeerInfo pPeerInfo, PeerReader reader, PeerWriter writer) {
        this.zMyInfo = pMyInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        this.zUserDialog = pUserDialog;
        IllegalArgument.ifNull("UserDialog", this.zUserDialog);
        this.zActivePeersSupport = pActivePeersSupport;
        IllegalArgument.ifNull("ActivePeersSupport", this.zActivePeersSupport);
        this.zNewPeersSupport = pNewPeersSupport;
        IllegalArgument.ifNull("NewPeersSupport", this.zNewPeersSupport);
        this.zPeerInfo = pPeerInfo;
        IllegalArgument.ifNull("PeerInfo", this.zPeerInfo);
        this.zReader = reader;
        this.zWriter = writer;
        this.setName("Active Peer Thread");
        this.start();
    }

    public PeerInfo getPeerInfo() {
        return this.zPeerInfo;
    }

    public void sendNAME() {
        this.send(this.formatNAME());
    }

    public void sendPMSG(String pMessage) {
        IllegalArgument.ifNull("Message", pMessage);
        this.send(this.formatPMSG(pMessage));
    }

    public void sendCHAT(String pMessage) {
        IllegalArgument.ifNull("Message", pMessage);
        this.send(this.formatCHAT(pMessage));
    }

    public void finish() {
        this.send(DONE);
    }

    @Override
    public void run() {
        String line;
        this.send(this.formatHELO());
        while (null != (line = this.zReader.readLine())) {
            this.processCommand(line);
            if (!line.equals(DONE)) continue;
        }
        this.close();
        this.zActivePeersSupport.removeActivePeer(this);
        this.zUserDialog.showDisconnect(this.zPeerInfo);
    }

    public synchronized void close() {
        this.zReader.close();
        this.zWriter.close();
    }

    private void processCommand(String pLine) {
        if (pLine.trim().length() == 0) {
            return;
        }
        try {
            String cmdParams = this.checkForCommand(pLine, CHAT);
            if (null != cmdParams) {
                this.processCHAT(cmdParams);
                return;
            }
            cmdParams = this.checkForCommand(pLine, HELO);
            if (null != cmdParams) {
                this.processHELO(cmdParams);
                return;
            }
            cmdParams = this.checkForCommand(pLine, PMSG);
            if (null != cmdParams) {
                this.processPMSG(cmdParams);
                return;
            }
            cmdParams = this.checkForCommand(pLine, NAME);
            if (null != cmdParams) {
                this.processNAME(cmdParams);
                return;
            }
            cmdParams = this.checkForCommand(pLine, PEER);
            if (null != cmdParams) {
                this.processPEER(cmdParams);
                return;
            }
        }
        catch (Exception e) {
            System.err.println("Caught " + e.getClass().getName() + " processing command " + pLine);
            e.printStackTrace();
            return;
        }
        if ("BYE".equals(pLine)) {
            this.zWriter.close();
            return;
        }
        this.zUserDialog.showUnrecognized(this.zPeerInfo, pLine);
    }

    private String checkForCommand(String pLine, String pCmd) {
        return pLine.startsWith(pCmd) ? pLine.substring(pCmd.length()).trim() : null;
    }

    private void send(String pMessage) {
        this.zWriter.writeLine(pMessage);
    }

    private String formatCHAT(String pMessage) {
        return CHAT + pMessage;
    }

    private void processCHAT(String pCmdParams) {
        this.zUserDialog.showCHAT(this.zPeerInfo, pCmdParams);
    }

    private String formatPMSG(String pMessage) {
        return PMSG + pMessage;
    }

    private void processPMSG(String pCmdParams) {
        this.zUserDialog.showPMSG(this.zPeerInfo, pCmdParams);
    }

    private String formatNAME() {
        return NAME + this.zMyInfo.getChatName();
    }

    private void processNAME(String pCmdParams) {
        if (!pCmdParams.equals(this.zPeerInfo.getChatName())) {
            this.zPeerInfo.setChatName(pCmdParams);
            this.zUserDialog.showNAME(this.zPeerInfo);
        }
    }

    private String formatHELO() {
        return HELO + this.zMyInfo.format();
    }

    private void processHELO(String pCmdParams) {
        PeerInfo pi = PeerInfo.deFormat(pCmdParams);
        if (pi != null) {
            this.zPeerInfo.updateWith(pi);
            PeerInfo[] peers = this.zActivePeersSupport.getPeerInfos();
            int i = peers.length;
            while (i-- > 0) {
                if (this.zPeerInfo.equals(peers[i])) continue;
                this.send(this.formatPEER(peers[i]));
            }
            this.zUserDialog.showHELO(this.zPeerInfo);
        }
    }

    private String formatPEER(PeerInfo pPeerInfo) {
        return PEER + pPeerInfo.format();
    }

    private void processPEER(String pCmdParams) {
        PeerInfo pi = PeerInfo.deFormat(pCmdParams);
        if (pi != null) {
            this.zNewPeersSupport.addNewPeer(pi);
        }
    }
}

