/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.build.Buildable;
import VASSAL.build.module.map.boardPicker.board.HexGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.RegularGridNumbering;
import VASSAL.i18n.Resources;
import VASSAL.tools.image.LabelUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.ArrayUtils;

public class HexGridNumbering
extends RegularGridNumbering {
    private HexGrid grid;
    private boolean stagger = true;
    public static final String STAGGER = "stagger";

    @Override
    public void addTo(Buildable parent) {
        this.grid = (HexGrid)parent;
        this.grid.setGridNumbering(this);
    }

    public HexGrid getGrid() {
        return this.grid;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.add((Object[])super.getAttributeDescriptions(), (Object)Resources.getString("Editor.HexGridNumbering.stagger"));
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.add((Object[])super.getAttributeNames(), (Object)STAGGER);
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.add((Object[])super.getAttributeTypes(), Boolean.class);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (STAGGER.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.stagger = (Boolean)value;
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (STAGGER.equals(key)) {
            return String.valueOf(this.stagger);
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public void draw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        if (this.visible) {
            this.forceDraw(g, bounds, visibleRect, scale, reversed);
        }
    }

    public void forceDraw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        int size = (int)(scale * (double)this.fontSize + 0.5);
        if (size < 5) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform oldT = g2d.getTransform();
        if (reversed) {
            AffineTransform t = AffineTransform.getRotateInstance(Math.PI, (double)bounds.x + 0.5 * (double)bounds.width, (double)bounds.y + 0.5 * (double)bounds.height);
            g2d.transform(t);
            visibleRect = t.createTransformedShape(visibleRect).getBounds();
        }
        if (!bounds.intersects(visibleRect)) {
            return;
        }
        Rectangle region = bounds.intersection(visibleRect);
        Shape oldClip = g.getClip();
        if (oldClip != null) {
            Area clipArea = new Area(oldClip);
            clipArea.intersect(new Area(region));
            g.setClip(clipArea);
        }
        double deltaX = scale * this.grid.getHexWidth();
        double deltaY = scale * this.grid.getHexSize();
        if (this.grid.isSideways()) {
            bounds = new Rectangle(bounds.y, bounds.x, bounds.height, bounds.width);
            region = new Rectangle(region.y, region.x, region.height, region.width);
        }
        int minCol = 2 * (int)Math.floor(((double)(region.x - bounds.x) - scale * (double)this.grid.getOrigin().x) / (2.0 * deltaX));
        double xmin = (double)bounds.x + scale * (double)this.grid.getOrigin().x + deltaX * (double)minCol;
        double xmax = (double)(region.x + region.width) + deltaX;
        int minRow = (int)Math.floor(((double)(region.y - bounds.y) - scale * (double)this.grid.getOrigin().y) / deltaY);
        double ymin = (double)bounds.y + scale * (double)this.grid.getOrigin().y + deltaY * (double)minRow;
        double ymax = (double)(region.y + region.height) + deltaY;
        Font f = new Font("Dialog", 0, size);
        int alignment = 3;
        int offset = -((int)Math.round(deltaY / 2.0));
        if (this.grid.isSideways() || this.rotateTextDegrees != 0) {
            alignment = 0;
            offset = 0;
        }
        Point p = new Point();
        Point gridp = new Point();
        Point centerPoint = null;
        double radians = 0.0;
        if (this.rotateTextDegrees != 0) {
            radians = Math.toRadians(this.rotateTextDegrees);
            g2d.rotate(radians);
        }
        for (double x = xmin; x < xmax; x += 2.0 * deltaX) {
            for (double y = ymin; y < ymax; y += deltaY) {
                p.setLocation((int)Math.round(x), (int)Math.round(y) + offset);
                gridp.setLocation(p.x, p.y - offset);
                this.grid.rotateIfSideways(p);
                gridp.translate(-bounds.x, -bounds.y);
                this.grid.rotateIfSideways(gridp);
                gridp.x = (int)Math.round((double)gridp.x / scale);
                gridp.y = (int)Math.round((double)gridp.y / scale);
                centerPoint = this.offsetLabelCenter(p, scale);
                LabelUtils.drawLabel(g2d, this.getName(this.getRow(gridp), this.getColumn(gridp)), centerPoint.x, centerPoint.y, f, 0, alignment, this.color, null, null);
                p.setLocation((int)Math.round(x + deltaX), (int)Math.round(y + deltaY / 2.0) + offset);
                gridp.setLocation(p.x, p.y - offset);
                this.grid.rotateIfSideways(p);
                gridp.translate(-bounds.x, -bounds.y);
                this.grid.rotateIfSideways(gridp);
                gridp.x = (int)Math.round((double)gridp.x / scale);
                gridp.y = (int)Math.round((double)gridp.y / scale);
                centerPoint = this.offsetLabelCenter(p, scale);
                LabelUtils.drawLabel(g2d, this.getName(this.getRow(gridp), this.getColumn(gridp)), centerPoint.x, centerPoint.y, f, 0, alignment, this.color, null, null);
            }
        }
        if (this.rotateTextDegrees != 0) {
            g2d.rotate(-radians);
        }
        g.setClip(oldClip);
        g2d.setTransform(oldT);
    }

    @Override
    public Point getCenterPoint(int col, int row) {
        if (this.stagger) {
            if (this.grid.isSideways()) {
                if (col % 2 != 0) {
                    row = this.hDescending ? ++row : --row;
                }
            } else if (col % 2 != 0) {
                row = this.vDescending ? ++row : --row;
            }
        }
        if (this.grid.isSideways()) {
            if (this.vDescending) {
                col = this.getMaxRows() - col;
            }
            if (this.hDescending) {
                row = this.getMaxColumns() - row;
            }
        } else {
            if (this.hDescending) {
                col = this.getMaxColumns() - col;
            }
            if (this.vDescending) {
                row = this.getMaxRows() - row;
            }
        }
        Point p = new Point();
        p.x = (int)((double)col * this.grid.getHexWidth());
        p.x += this.grid.getOrigin().x;
        p.y = col % 2 == 0 ? (int)((double)row * this.grid.getHexSize()) : (int)((double)row * this.grid.getHexSize() + this.grid.getHexSize() / 2.0);
        p.y += this.grid.getOrigin().y;
        this.grid.rotateIfSideways(p);
        return p;
    }

    @Override
    public int getColumn(Point p) {
        int x = this.getRawColumn(p);
        if (this.vDescending && this.grid.isSideways()) {
            x = this.getMaxRows() - x;
        }
        if (this.hDescending && !this.grid.isSideways()) {
            x = this.getMaxColumns() - x;
        }
        return x;
    }

    public int getRawColumn(Point p) {
        return this.grid.getRawColumn(p);
    }

    @Override
    protected JComponent getGridVisualizer() {
        if (this.visualizer == null) {
            this.visualizer = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
                    AffineTransform orig_t = g2d.getTransform();
                    g2d.setTransform(SwingUtils.descaleTransform(orig_t));
                    double orig_grid_size = HexGridNumbering.this.grid.getHexSize();
                    double orig_grid_width = HexGridNumbering.this.grid.getHexWidth();
                    HexGridNumbering.this.grid.setHexSize(100.0);
                    Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    bounds.x = (int)((double)bounds.x * os_scale);
                    bounds.y = (int)((double)bounds.y * os_scale);
                    bounds.width = (int)((double)bounds.width * os_scale);
                    bounds.height = (int)((double)bounds.height * os_scale);
                    g.clearRect(0, 0, bounds.width, bounds.height);
                    HexGridNumbering.this.grid.forceDraw(g, bounds, bounds, os_scale, false);
                    HexGridNumbering.this.forceDraw(g, bounds, bounds, os_scale, false);
                    g2d.setTransform(orig_t);
                    HexGridNumbering.this.grid.setHexSize(orig_grid_size);
                    HexGridNumbering.this.grid.setHexWidth(orig_grid_width);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(600, 400);
                }
            };
        }
        return this.visualizer;
    }

    @Override
    public int getRow(Point p) {
        int ny = this.getRawRow(p);
        if (this.vDescending && !this.grid.isSideways()) {
            ny = this.getMaxRows() - ny;
        }
        if (this.hDescending && this.grid.isSideways()) {
            ny = this.getMaxColumns() - ny;
        }
        if (this.stagger) {
            if (this.grid.isSideways()) {
                if (this.getRawColumn(p) % 2 != 0) {
                    ny = this.hDescending ? --ny : ++ny;
                }
            } else if (this.getRawColumn(p) % 2 != 0) {
                ny = this.vDescending ? --ny : ++ny;
            }
        }
        return ny;
    }

    public int getRawRow(Point p) {
        return this.grid.getRawRow(p);
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.grid.setGridNumbering(null);
    }

    protected int getMaxRows() {
        return (int)Math.floor((double)this.grid.getContainer().getSize().height / this.grid.getHexWidth() + 0.5);
    }

    protected int getMaxColumns() {
        return (int)Math.floor((double)this.grid.getContainer().getSize().width / this.grid.getHexSize() + 0.5);
    }
}

