/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.deck;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AbstractFolder;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.deck.DeckKeyCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedExpressionConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import java.util.List;

public abstract class AbstractDeckKeyCommand
extends AbstractConfigurable
implements DeckKeyCommand {
    public static final String DESCRIPTION = "description";
    public static final String MENU_TEXT = "menuText";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String HOTKEY = "hotkey";
    public static final String COMMAND_NAME = "commandName";
    public static final String DECK_NAME = "deckName";
    protected String description = "";
    protected NamedKeyStroke keyStroke = NamedKeyStroke.NULL_KEYSTROKE;
    protected FormattedString reportFormat = new FormattedString();

    public String getDescription() {
        return this.description;
    }

    public NamedKeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public FormattedString getReportFormat() {
        return this.reportFormat;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{DESCRIPTION, MENU_TEXT, HOTKEY, REPORT_FORMAT};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (DESCRIPTION.equals(key)) {
            this.description = (String)value;
        } else if (HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.keyStroke = (NamedKeyStroke)value;
        } else if (MENU_TEXT.equals(key)) {
            this.setConfigureName((String)value);
        } else if (REPORT_FORMAT.equals(key)) {
            if (value instanceof String) {
                this.reportFormat.setFormat((String)value);
            } else {
                this.reportFormat = (FormattedString)value;
            }
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (DESCRIPTION.equals(key)) {
            return this.description;
        }
        if (HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.keyStroke);
        }
        if (MENU_TEXT.equals(key)) {
            return this.getConfigureName();
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        return null;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.menu_command"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.report_format")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, NamedKeyStroke.class, DeckReportFormatConfig.class};
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
    }

    @Override
    public void removeFrom(Buildable parent) {
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return List.of(this.keyStroke);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.getComponentName());
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.reportFormat.getFormat());
    }

    @Override
    public String[] getAdditionalReportProperties() {
        return new String[]{DECK_NAME, COMMAND_NAME};
    }

    public static class DeckReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedExpressionConfigurer(key, name, ((DeckKeyCommand)((Object)c)).getAdditionalReportProperties());
        }
    }
}

