/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.deck;

import VASSAL.build.module.map.deck.SortParameter;
import VASSAL.build.module.map.deck.SortParameterConfigurer;
import VASSAL.configure.AbstractConfigurableListEntry;
import VASSAL.configure.ConfigurableList;
import VASSAL.configure.ConfigurableListController;
import VASSAL.configure.ConfigurableListEntry;
import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class SortParameterArrayConfigurer
extends Configurer
implements ConfigurableList {
    private JPanel controls;
    private JPanel panel;
    private int selectedEntryIndex = -1;
    private ConfigurableListController controller;
    private final List<SortParameterEntry> entries = new ArrayList<SortParameterEntry>();

    public SortParameterArrayConfigurer(String key, String name) {
        this(key, name, null);
    }

    public SortParameterArrayConfigurer(String key, String name, Object val) {
        super(key, name, val);
    }

    @Override
    public void moveEntryUp() {
        if (this.getSelectedEntryIndex() < 0) {
            return;
        }
        int pos = this.getSelectedEntryIndex();
        List<Object> params = this.getValue() == null ? new ArrayList() : this.getSortParameterListValue();
        SortParameter moving = (SortParameter)params.remove(pos);
        params.add(pos - 1, moving);
        this.setValue(params);
        this.setSelectedEntryIndex(pos - 1);
        this.rebuildControls();
    }

    @Override
    public void moveEntryDown() {
        if (this.getSelectedEntryIndex() < 0) {
            return;
        }
        int pos = this.getSelectedEntryIndex();
        List<Object> params = this.getValue() == null ? new ArrayList() : this.getSortParameterListValue();
        SortParameter moving = (SortParameter)params.remove(pos);
        params.add(pos + 1, moving);
        this.setValue(params);
        this.setSelectedEntryIndex(pos + 1);
        this.rebuildControls();
    }

    @Override
    public void addEntry() {
        int newEntry;
        List<Object> params;
        int pos = this.getSelectedEntryIndex();
        List<Object> list = params = this.getValue() == null ? new ArrayList() : this.getSortParameterListValue();
        if (this.entries.isEmpty() || this.getSelectedEntryIndex() < 0) {
            params.add(new SortParameter());
            this.setValue(params);
            newEntry = this.getSortParameterListValue().size() - 1;
        } else {
            newEntry = pos + 1;
            params.add(pos, new SortParameter());
            this.setValue(params);
        }
        this.setSelectedEntryIndex(newEntry);
        this.rebuildControls(newEntry);
    }

    @Override
    public void deleteEntry(ConfigurableListEntry entry) {
        int pos = this.entries.indexOf(entry);
        List<Object> params = this.getValue() == null ? new ArrayList() : this.getSortParameterListValue();
        params.remove(pos);
        this.setValue(params);
        this.setSelectedEntryIndex(Math.min(pos, this.entries.size() - 1));
        if (this.selectedEntryIndex >= 0) {
            this.entries.get(this.selectedEntryIndex).requestFocus();
        }
    }

    @Override
    public JComponent getListController() {
        if (this.controller == null) {
            this.controller = new ConfigurableListController(this);
        }
        return this.controller;
    }

    @Override
    public void selectEntry(ConfigurableListEntry entry) {
        this.setSelectedEntryIndex(entry == null ? -1 : this.entries.indexOf(entry));
        this.updateControls();
    }

    public static List<SortParameter> decode(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<SortParameter> l = new ArrayList<SortParameter>();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ',');
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.isEmpty()) continue;
            l.add(new SortParameter(token));
        }
        return l;
    }

    public static String encode(List<SortParameter> params) {
        if (params == null) {
            return null;
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (SortParameter param : params) {
            se.append(param.toString());
        }
        return se.getValue() != null ? se.getValue() : "";
    }

    @Override
    public String getValueString() {
        return SortParameterArrayConfigurer.encode(this.getSortParameterListValue());
    }

    @Override
    public void setValue(String s) {
        this.setValue(SortParameterArrayConfigurer.decode(s));
    }

    @Override
    public void setValue(Object o) {
        ArrayList<SortParameter> newParams;
        ArrayList<SortParameter> arrayList = newParams = o == null ? new ArrayList<SortParameter>() : new ArrayList((List)o);
        if (o == null) {
            newParams.add(new SortParameter());
        }
        super.setValue(newParams);
        if (this.controls != null) {
            this.rebuildControls();
        }
    }

    private void setParameterValue(int pos, SortParameter param) {
        this.getSortParameterListValue().get(pos).setValue(param);
        this.fireUpdate();
    }

    public List<SortParameter> getSortParameterListValue() {
        return (List)this.getValue();
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel((LayoutManager)new MigLayout("ins 0,gapy 4", "[grow,fill][]"));
            this.controls = new JPanel((LayoutManager)new MigLayout("gapy 4", "[grow,fill][]"));
            this.controls.setBorder(BorderFactory.createEtchedBorder());
            this.panel.add((Component)this.controls, "grow");
            this.panel.add((Component)this.getListController(), "growy 0,aligny center");
            this.rebuildControls();
        }
        return this.panel;
    }

    private void rebuildControls(int focus) {
        this.rebuildControls();
        this.entries.get(focus).requestFocus();
    }

    private void rebuildControls() {
        this.entries.clear();
        this.controls.removeAll();
        List<SortParameter> params = this.getSortParameterListValue();
        for (SortParameter param : params) {
            SortParameterEntry entry = new SortParameterEntry(this, param);
            this.controls.add(entry.getConfigurer().getControls());
            this.controls.add((Component)entry.getRemoveButton(), "growx 0,wrap");
            this.entries.add(entry);
        }
        this.updateControls();
        this.repack();
    }

    private void updateControls() {
        int i = 0;
        for (SortParameterEntry entry : this.entries) {
            entry.setHighlighted(i++ == this.getSelectedEntryIndex());
        }
        this.getListController();
        this.controller.setCanMoveUp(this.getSelectedEntryIndex() > 0);
        this.controller.setCanMoveDown(this.getSelectedEntryIndex() >= 0 && this.getSelectedEntryIndex() < this.entries.size() - 1);
        this.controls.repaint();
    }

    @Override
    public void repack() {
        this.repack(this.panel);
    }

    @Override
    public void setSelectedEntryIndex(int index) {
        this.selectedEntryIndex = Math.min(index, this.entries.size() - 1);
        this.updateControls();
    }

    @Override
    public int getSelectedEntryIndex() {
        return this.selectedEntryIndex;
    }

    @Override
    public void entryChanged(ConfigurableListEntry entry) {
        this.setParameterValue(this.entries.indexOf(entry), (SortParameter)entry.getConfigurer().getValue());
    }

    static class SortParameterEntry
    extends AbstractConfigurableListEntry {
        public SortParameterEntry(ConfigurableList parentConfig, Object value) {
            super(parentConfig, value);
        }

        @Override
        public Configurer buildChildConfigurer(Object value) {
            SortParameterConfigurer c = new SortParameterConfigurer();
            ((Configurer)c).setFrozen(true);
            ((Configurer)c).setValue(value);
            ((Configurer)c).setFrozen(false);
            return c;
        }

        @Override
        public void setHighlighted(boolean b) {
            this.getConfigurer().setHighlighted(b);
        }
    }
}

