/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.build.GameModule;
import VASSAL.chat.HttpRequestWrapper;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class HttpMessageServer
implements MessageBoard,
WelcomeMessageServer {
    private final HttpRequestWrapper welcomeURL;
    private final HttpRequestWrapper getMessagesURL;
    private final HttpRequestWrapper postMessageURL;
    private final PeerPoolInfo info;

    public HttpMessageServer(PeerPoolInfo info) {
        this("https://vassalengine.org/util/getMessages", "https://vassalengine.org/util/postMessage", "https://vassalengine.org/util/motd", info);
    }

    public HttpMessageServer(String getMessagesURL, String postMessageURL, String welcomeURL, PeerPoolInfo info) {
        this.getMessagesURL = new HttpRequestWrapper(getMessagesURL);
        this.welcomeURL = new HttpRequestWrapper(welcomeURL);
        this.postMessageURL = new HttpRequestWrapper(postMessageURL);
        this.info = info;
    }

    @Override
    public Command getWelcomeMessage() {
        Command motd = new NullCommand();
        try {
            if (GameModule.getGameModule() != null) {
                for (String s : this.welcomeURL.doGet(this.prepareInfo())) {
                    motd = motd.append(GameModule.getGameModule().decode(s));
                }
            }
        }
        catch (IOException e) {
            System.err.println("IOException retrieving welcome message from " + this.welcomeURL);
        }
        return motd;
    }

    @Override
    public Message[] getMessages() {
        ArrayList<Message> msgList = new ArrayList<Message>();
        try {
            for (String msg : this.getMessagesURL.doGet(this.prepareInfo())) {
                try {
                    Date created;
                    StringTokenizer st = new StringTokenizer(msg, "&");
                    String s = st.nextToken();
                    String sender = s.substring(s.indexOf(61) + 1);
                    String date = st.nextToken();
                    date = date.substring(date.indexOf(61) + 1);
                    s = st.nextToken("");
                    String content = StringUtils.join((Iterator)new SequenceEncoder.Decoder(s.substring(s.indexOf(61) + 1), '|'), (char)'\n');
                    content = this.restorePercent(content);
                    try {
                        long time = Long.parseLong(date);
                        TimeZone t = TimeZone.getDefault();
                        created = new Date(time += (long)t.getOffset(0, 1, 2, 6, 7, 14));
                    }
                    catch (NumberFormatException e1) {
                        created = new Date();
                    }
                    msgList.add(new Message(sender, content, created));
                }
                catch (NoSuchElementException ex) {
                    System.err.println("Badly formatted message in HttpMessageServer:  " + msg);
                }
            }
        }
        catch (IOException ex) {
            System.err.println("IOException retrieving messages from " + this.getMessagesURL);
        }
        return msgList.toArray(new Message[0]);
    }

    private Properties prepareInfo() {
        Properties p = new Properties();
        p.put("module", this.info.getModuleName());
        return p;
    }

    private String removePercent(String input) {
        StringBuilder buff = new StringBuilder();
        StringTokenizer st = new StringTokenizer(input, "%#", true);
        block4: while (st.hasMoreTokens()) {
            String s = st.nextToken();
            switch (s.charAt(0)) {
                case '%': {
                    buff.append("/#/");
                    continue block4;
                }
                case '#': {
                    buff.append("/##/");
                    continue block4;
                }
            }
            buff.append(s);
        }
        return buff.toString();
    }

    private String restorePercent(String input) {
        int i = ((String)input).indexOf("/#/");
        while (i >= 0) {
            input = ((String)input).substring(0, i) + "%" + ((String)input).substring(i + 3);
            i = ((String)input).indexOf("/#/");
        }
        i = ((String)input).indexOf("/##/");
        while (i >= 0) {
            input = ((String)input).substring(0, i) + "#" + ((String)input).substring(i + 4);
            i = ((String)input).indexOf("/##/");
        }
        return input;
    }

    @Override
    public void postMessage(String content) {
        if (content == null || content.length() == 0) {
            return;
        }
        content = this.removePercent(content);
        SequenceEncoder se = new SequenceEncoder('|');
        StringTokenizer st = new StringTokenizer(content, "\n\r");
        while (st.hasMoreTokens()) {
            se.append(st.nextToken());
        }
        Properties p = this.prepareInfo();
        p.put("sender", this.info.getUserName());
        p.put("content", se.getValue());
        try {
            this.postMessageURL.doPost(p);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

