/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.hex;

import java.util.ArrayList;
import java.util.List;

public class Hex {
    public final int q;
    public final int r;
    public final int s;
    public static final List<Hex> directions = new ArrayList<Hex>(){
        {
            this.add(new Hex(1, 0, -1));
            this.add(new Hex(1, -1, 0));
            this.add(new Hex(0, -1, 1));
            this.add(new Hex(-1, 0, 1));
            this.add(new Hex(-1, 1, 0));
            this.add(new Hex(0, 1, -1));
        }
    };
    public static final List<Hex> diagonals = new ArrayList<Hex>(){
        {
            this.add(new Hex(2, -1, -1));
            this.add(new Hex(1, -2, 1));
            this.add(new Hex(-1, -1, 2));
            this.add(new Hex(-2, 1, 1));
            this.add(new Hex(-1, 2, -1));
            this.add(new Hex(1, 1, -2));
        }
    };

    public Hex(int q, int r, int s) {
        this.q = q;
        this.r = r;
        this.s = s;
        if (q + r + s != 0) {
            throw new IllegalArgumentException("q + r + s must be 0");
        }
    }

    public Hex add(Hex b) {
        return new Hex(this.q + b.q, this.r + b.r, this.s + b.s);
    }

    public Hex subtract(Hex b) {
        return new Hex(this.q - b.q, this.r - b.r, this.s - b.s);
    }

    public Hex scale(int k) {
        return new Hex(this.q * k, this.r * k, this.s * k);
    }

    public Hex rotateLeft() {
        return new Hex(-this.s, -this.q, -this.r);
    }

    public Hex rotateRight() {
        return new Hex(-this.r, -this.s, -this.q);
    }

    public static Hex direction(int direction) {
        return directions.get(direction);
    }

    public Hex neighbor(int direction) {
        return this.add(Hex.direction(direction));
    }

    public Hex diagonalNeighbor(int direction) {
        return this.add(diagonals.get(direction));
    }

    public int length() {
        return (Math.abs(this.q) + Math.abs(this.r) + Math.abs(this.s)) / 2;
    }

    public int distance(Hex b) {
        return this.subtract(b).length();
    }
}

