/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.AddPiece;
import VASSAL.command.AlertCommand;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.command.RemovePiece;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Mat;
import VASSAL.counters.MatHolder;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.swing.FlowLabel;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GameRefresher
implements CommandEncoder,
GameComponent {
    private static final Logger logger = LoggerFactory.getLogger(GameRefresher.class);
    private static final char DELIMITER = '\t';
    public static final String COMMAND_PREFIX = "DECKREPOS\t";
    private Action refreshAction;
    private final GpIdSupport gpIdSupport;
    private GpIdChecker gpIdChecker;
    private RefreshDialog dialog;
    private int updatedCount;
    private int notFoundCount;
    private int noStackCount;
    private int noMapCount;
    private final GameModule theModule;
    private final Set<String> options = new HashSet<String>();
    private List<Deck> decks;

    public List<DrawPile> getModuleDrawPiles() {
        return this.theModule.getAllDescendantComponentsOf(DrawPile.class);
    }

    public GameRefresher(GpIdSupport gpIdSupport) {
        this.gpIdSupport = gpIdSupport;
        this.theModule = GameModule.getGameModule();
    }

    @Override
    public String encode(Command c) {
        return null;
    }

    @Override
    public Command decode(String s) {
        return null;
    }

    public void addTo(AbstractConfigurable parent) {
        this.refreshAction = new AbstractAction(Resources.getString("GameRefresher.refresh_counters")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicLogger bl = GameModule.getGameModule().getBasicLogger();
                if (bl != null && bl.isReplaying()) {
                    AlertCommand ac = new AlertCommand(Resources.getString("GameRefresher.game_is_replaying"));
                    ac.execute();
                } else {
                    new GameRefresher(GameRefresher.this.gpIdSupport).start();
                }
            }
        };
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(this);
        this.refreshAction.setEnabled(false);
    }

    public Action getRefreshAction() {
        return this.refreshAction;
    }

    public boolean isTestMode() {
        return this.options.contains("TestMode");
    }

    public boolean isDeleteNoMap() {
        return this.options.contains("DeleteNoMap");
    }

    public void start() {
        this.dialog = new RefreshDialog(this);
        this.dialog.setVisible(true);
        this.dialog = null;
    }

    public void log(String message) {
        GameModule.getGameModule().warn(message);
        logger.info(message);
    }

    public List<GamePiece> getCurrentGameRefresherPieces() {
        this.decks = new ArrayList<Deck>();
        ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
        int totalCount = 0;
        int notOwnedCount = 0;
        int notVisibleCount = 0;
        for (GamePiece piece : this.theModule.getGameState().getAllPieces()) {
            if (piece instanceof Deck) {
                Deck deck = (Deck)piece;
                this.decks.add(deck);
                totalCount += deck.getPieceCount();
                continue;
            }
            if (piece instanceof Stack) {
                Iterator<GamePiece> i = ((Stack)piece).getPiecesInVisibleOrderIterator();
                while (i.hasNext()) {
                    GamePiece p = i.next();
                    if (!Boolean.TRUE.equals(p.getProperty("Invisible")) && !Boolean.TRUE.equals(p.getProperty("Obscured"))) {
                        ++totalCount;
                        pieces.add(0, p);
                        continue;
                    }
                    if (Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                        ++notVisibleCount;
                        continue;
                    }
                    ++notOwnedCount;
                }
                continue;
            }
            if (piece.getParent() != null) continue;
            if (!Boolean.TRUE.equals(piece.getProperty("Invisible")) && !Boolean.TRUE.equals(piece.getProperty("Obscured"))) {
                ++totalCount;
                pieces.add(0, piece);
                continue;
            }
            if (Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                ++notVisibleCount;
                continue;
            }
            ++notOwnedCount;
        }
        this.log(Resources.getString("GameRefresher.get_all_pieces"));
        this.log(Resources.getString("GameRefresher.counters_total", totalCount));
        this.log(Resources.getString("GameRefresher.counters_kept", totalCount - notOwnedCount - notVisibleCount));
        this.log(Resources.getString("GameRefresher.counters_not_owned", notOwnedCount));
        this.log(Resources.getString("GameRefresher.counters_not_visible", notVisibleCount));
        this.log("-");
        return pieces;
    }

    private boolean isGameActive() {
        GameModule gm = GameModule.getGameModule();
        BasicLogger logger = gm.getBasicLogger();
        return gm.isMultiplayerConnected() || logger != null && logger.isLogging();
    }

    public void execute(Set<String> options, Command command) throws IllegalBuildException {
        if (command == null) {
            command = new NullCommand();
        }
        if (!options.isEmpty()) {
            this.options.addAll(options);
        }
        this.notFoundCount = 0;
        this.updatedCount = 0;
        this.noMapCount = 0;
        this.noStackCount = 0;
        if (Objects.isNull(this.gpIdChecker)) {
            this.gpIdChecker = new GpIdChecker(options);
            for (PieceSlot slot : this.theModule.getAllDescendantComponentsOf(PieceSlot.class)) {
                this.gpIdChecker.add(slot);
            }
            for (PrototypesContainer pc : this.theModule.getComponentsOf(PrototypesContainer.class)) {
                pc.getDefinitions().forEach(this.gpIdChecker::add);
            }
            if (this.gpIdChecker.hasErrors()) {
                this.gpIdChecker = null;
                this.log(Resources.getString("GameRefresher.gpid_error_message"));
                return;
            }
        }
        List<GamePiece> pieces = this.getCurrentGameRefresherPieces();
        if (GameModule.getGameModule().isMatSupport()) {
            Iterator<Deck> otherPieces = new ArrayList();
            ArrayList<GamePiece> cargo = new ArrayList<GamePiece>();
            ArrayList<MatRefresher> mats = new ArrayList<MatRefresher>();
            for (GamePiece piece : pieces) {
                if (Boolean.TRUE.equals(piece.getProperty("IsCargo"))) {
                    cargo.add(piece);
                    continue;
                }
                if (piece.getProperty("MatID") != null) {
                    mats.add(new MatRefresher(piece));
                    continue;
                }
                otherPieces.add((Deck)piece);
            }
            for (MatRefresher mh : mats) {
                mh.grabCargo(cargo);
            }
            Iterator<GamePiece> iterator = otherPieces.iterator();
            while (iterator.hasNext()) {
                GamePiece piece;
                piece = iterator.next();
                this.processGamePiece(piece, command);
            }
            for (GamePiece piece : cargo) {
                this.processGamePiece(piece, command);
            }
            for (MatRefresher mh : mats) {
                mh.refresh(command);
            }
        } else {
            for (GamePiece piece : pieces) {
                this.processGamePiece(piece, command);
            }
        }
        for (Deck deck : this.decks) {
            this.processDeck(deck, command);
        }
        this.decks = null;
        this.log(Resources.getString("GameRefresher.run_refresh_counters_v3", this.theModule.getGameVersion()));
        this.log(Resources.getString("GameRefresher.counters_refreshed", this.updatedCount));
        this.log(Resources.getString("GameRefresher.counters_not_found", this.notFoundCount));
        this.log(Resources.getString("GameRefresher.counters_no_map", this.noMapCount));
        this.log("----------");
        this.log(Resources.getString("GameRefresher.counters_no_stack", this.noStackCount));
        this.log("----------");
        if (options.contains("RefreshDecks")) {
            if (this.isGameActive()) {
                this.log(Resources.getString("GameRefresher.deck_refresh_during_multiplayer"));
            } else {
                ArrayList<Deck> decksToDelete = new ArrayList<Deck>();
                List<DrawPile> drawPiles = this.getModuleDrawPiles();
                ArrayList<DrawPile> foundDrawPiles = new ArrayList<DrawPile>();
                ArrayList<DrawPile> decksToAdd = new ArrayList<DrawPile>();
                int refreshable = 0;
                int deletable = 0;
                int addable = 0;
                this.log("----------");
                this.log(Resources.getString("GameRefresher.refreshing_decks"));
                this.log("----------");
                for (Map map : Map.getMapList()) {
                    for (GamePiece pieceOrStack : map.getPieces()) {
                        if (!(pieceOrStack instanceof Deck)) continue;
                        Deck deck = (Deck)pieceOrStack;
                        boolean deckFound = false;
                        for (DrawPile drawPile : drawPiles) {
                            String deckName = deck.getDeckName();
                            if (!deckName.equals(drawPile.getAttributeValueString("name")) || drawPile.getOwningBoardName() != null && (map.getBoardByName(drawPile.getOwningBoardName()) == null || drawPile.getMap().getBoardByName(drawPile.getOwningBoardName()) == null)) continue;
                            deckFound = true;
                            foundDrawPiles.add(drawPile);
                            String drawPileName = drawPile.getAttributeValueString("name");
                            this.log(Resources.getString("GameRefresher.refreshing_deck", deckName, drawPileName));
                            deck.removeListeners();
                            deck.myRefreshType(drawPile.getDeckType());
                            deck.addListeners();
                            Point pt = drawPile.getPosition();
                            Map newMap = drawPile.getMap();
                            if (newMap != map) {
                                map.removePiece(deck);
                                newMap.addPiece(deck);
                            }
                            deck.setPosition(pt);
                            for (GamePiece piece : deck.asList()) {
                                piece.setMap(newMap);
                                piece.setPosition(pt);
                            }
                            ++refreshable;
                            break;
                        }
                        if (deckFound) continue;
                        ++deletable;
                        decksToDelete.add(deck);
                    }
                }
                if (options.contains("DeleteOldDecks")) {
                    for (Deck deck : decksToDelete) {
                        this.log(Resources.getString("GameRefresher.deleting_old_deck", deck.getDeckName()));
                        Stack newStack = new Stack();
                        newStack.setMap(deck.getMap());
                        for (GamePiece piece : deck.asList()) {
                            newStack.add(piece);
                        }
                        newStack.setPosition(deck.getPosition());
                        deck.removeAll();
                        if (deck.getMap() != null) {
                            deck.removeListeners();
                            deck.getMap().removePiece(deck);
                            deck.setMap(null);
                        }
                        if (newStack.getPieceCount() <= 0 || newStack.getMap() == null) continue;
                        GameModule.getGameModule().getGameState().addPiece(newStack);
                        newStack.getMap().placeAt(newStack, newStack.getPosition());
                    }
                } else if (!decksToDelete.isEmpty()) {
                    this.log(Resources.getString("GameRefresher.deletable_with_option"));
                    for (Deck deck : decksToDelete) {
                        this.log(deck.getDeckName());
                    }
                }
                for (DrawPile drawPile : drawPiles) {
                    boolean matchFound = false;
                    Map map = drawPile.getMap();
                    Collection<Board> boards = map.getBoards();
                    String boardName = drawPile.getOwningBoardName();
                    Board board = drawPile.getConfigureBoard(true);
                    if (boardName != null && !boards.contains(board)) continue;
                    for (DrawPile drawPile2 : foundDrawPiles) {
                        if (!drawPile.getAttributeValueString("name").equals(drawPile2.getAttributeValueString("name"))) continue;
                        matchFound = true;
                        break;
                    }
                    if (matchFound) continue;
                    decksToAdd.add(drawPile);
                    ++addable;
                }
                if (!decksToAdd.isEmpty()) {
                    if (options.contains("AddNewDecks")) {
                        for (DrawPile drawPile : decksToAdd) {
                            this.log(Resources.getString("GameRefresher.adding_new_deck", drawPile.getAttributeValueString("name")));
                            Deck newDeck = drawPile.makeDeck();
                            Map newMap = drawPile.getMap();
                            if (newMap == null) continue;
                            drawPile.setDeck(newDeck);
                            GameModule.getGameModule().getGameState().addPiece(newDeck);
                            newMap.placeAt(newDeck, drawPile.getPosition());
                            if (!GameModule.getGameModule().getGameState().isGameStarted()) continue;
                            newDeck.addListeners();
                        }
                    } else {
                        this.log(Resources.getString("GameRefresher.addable_with_option"));
                        for (DrawPile drawPile : decksToAdd) {
                            this.log(drawPile.getAttributeValueString("name"));
                        }
                    }
                }
                this.log("----------");
                this.log(Resources.getString("GameRefresher.refreshable_decks", refreshable));
                this.log(Resources.getString(options.contains("DeleteOldDecks") ? "GameRefresher.deletable_decks" : "GameRefresher.deletable_decks_2", deletable));
                this.log(Resources.getString(options.contains("AddNewDecks") ? "GameRefresher.addable_decks" : "GameRefresher.addable_decks_2", addable));
            }
        }
    }

    private GamePiece processGamePiece(GamePiece piece, Command command) {
        GamePiece newPiece;
        Map map = piece.getMap();
        if (map == null) {
            ++this.noMapCount;
            this.log(Resources.getString("GameRefresher.refresh_error_nomap1", piece.getName(), piece.getId()));
            if (this.isDeleteNoMap()) {
                this.log(Resources.getString("GameRefresher.refresh_error_nomap2", piece.getName(), piece.getId()));
                RemovePiece remove = new RemovePiece(Decorator.getOutermost(piece));
                remove.execute();
                command.append(remove);
            }
            return piece;
        }
        Stack oldStack = piece.getParent();
        if (oldStack == null && !Boolean.TRUE.equals(Decorator.getOutermost(piece).getProperty("NoStack"))) {
            ++this.noStackCount;
            this.log(Resources.getString("GameRefresher.refresh_error_nostack", piece.getName(), piece.getId()));
        }
        if ((newPiece = this.gpIdChecker.createUpdatedPiece(piece)) == null) {
            ++this.notFoundCount;
            this.log(Resources.getString("GameRefresher.refresh_error_nomatch_pieceslot", piece.getName(), piece.getId()));
            return piece;
        }
        ++this.updatedCount;
        if (this.isTestMode()) {
            RemovePiece remove = new RemovePiece(Decorator.getOutermost(newPiece));
            remove.execute();
            command.append(remove);
        } else {
            int newPos;
            Point piecePosition = piece.getPosition();
            Point hiddenPosition = new Point(-100, -100);
            Point tempPosition = piecePosition;
            int oldStackIndex = oldStack == null ? 0 : oldStack.indexOf(piece);
            RemovePiece remove = new RemovePiece(Decorator.getOutermost(piece));
            remove.execute();
            command.append(remove);
            Command place = map.placeOrMerge(newPiece, hiddenPosition);
            command.append(place);
            place = map.placeOrMerge(newPiece, tempPosition);
            command.append(place);
            Stack newStack = newPiece.getParent();
            if (newStack != null && newStack == oldStack && (newPos = newStack.indexOf(newPiece)) >= 0 && oldStackIndex >= 0 && newPos != oldStackIndex) {
                String oldState = newStack.getState();
                newStack.insert(newPiece, oldStackIndex);
                command.append(new ChangePiece(newStack.getId(), oldState, newStack.getState()));
            }
        }
        return newPiece;
    }

    private void processDeck(Deck deck, Command command) {
        List<GamePiece> pieces = deck.asList();
        ArrayList<GamePiece> newPieces = new ArrayList<GamePiece>();
        for (GamePiece piece : pieces) {
            RemovePiece remove = new RemovePiece(piece);
            remove.execute();
            command.append(remove);
            GamePiece newPiece = this.gpIdChecker.createUpdatedPiece(piece);
            if (newPiece == null) {
                ++this.notFoundCount;
                this.log(Resources.getString("GameRefresher.refresh_error_nomatch_pieceslot", piece.getName(), piece.getId()));
                newPiece = piece;
            } else {
                ++this.updatedCount;
            }
            newPieces.add(newPiece);
            AddPiece add = new AddPiece(newPiece);
            add.execute();
            command.append(add);
        }
        for (GamePiece piece : newPieces) {
            command.append(deck.getMap().placeOrMerge(piece, deck.getPosition()));
        }
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean gameStarting) {
        this.refreshAction.setEnabled(gameStarting);
    }

    static class RefreshDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private final GameRefresher refresher;
        private JTextArea results;
        private JCheckBox nameCheck;
        private JCheckBox testModeOn;
        private JCheckBox labelerNameCheck;
        private JCheckBox layerNameCheck;
        private JCheckBox deletePieceNoMap;
        private JCheckBox refreshDecks;
        private JCheckBox deleteOldDecks;
        private JCheckBox addNewDecks;
        private final Set<String> options = new HashSet<String>();
        JButton runButton;
        private boolean hasAlreadyRun = false;

        RefreshDialog(GameRefresher refresher) {
            super(GameModule.getGameModule().getPlayerWindow());
            this.refresher = refresher;
            this.setTitle(Resources.getString("GameRefresher.refresh_counters"));
            this.setModal(true);
            this.initComponents();
        }

        protected void initComponents() {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    this.exit();
                }
            });
            this.setLayout((LayoutManager)new MigLayout("wrap 1", "[fill]"));
            JPanel panel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1,gapy 4", "[fill]"));
            panel.setBorder(BorderFactory.createEtchedBorder());
            FlowLabel header = new FlowLabel(Resources.getString("GameRefresher.header"));
            panel.add(header);
            JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
            this.runButton = new JButton(Resources.getString("General.run"));
            this.runButton.addActionListener(e -> this.run());
            JButton exitButton = new JButton(Resources.getString("General.cancel"));
            exitButton.addActionListener(e -> this.exit());
            JButton helpButton = new JButton(Resources.getString("General.help"));
            helpButton.addActionListener(e -> this.help());
            buttonPanel.add((Component)this.runButton, "tag ok,sg 1");
            buttonPanel.add((Component)exitButton, "tag cancel,sg 1");
            buttonPanel.add((Component)helpButton, "tag help,sg 1");
            this.nameCheck = new JCheckBox(Resources.getString("GameRefresher.use_basic_name"));
            panel.add(this.nameCheck);
            this.labelerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_labeler_descr"));
            panel.add(this.labelerNameCheck);
            this.layerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_layer_descr"));
            panel.add(this.layerNameCheck);
            this.testModeOn = new JCheckBox(Resources.getString("GameRefresher.test_mode"));
            panel.add(this.testModeOn);
            this.deletePieceNoMap = new JCheckBox(Resources.getString("GameRefresher.delete_piece_no_map"));
            this.deletePieceNoMap.setSelected(true);
            panel.add(this.deletePieceNoMap);
            this.refreshDecks = new JCheckBox(Resources.getString("GameRefresher.refresh_decks"));
            this.refreshDecks.setSelected(false);
            this.refreshDecks.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    deleteOldDecks.setVisible(refreshDecks.isSelected());
                    addNewDecks.setVisible(refreshDecks.isSelected());
                }
            });
            panel.add(this.refreshDecks);
            this.deleteOldDecks = new JCheckBox(Resources.getString("GameRefresher.delete_old_decks"));
            this.deleteOldDecks.setSelected(false);
            panel.add(this.deleteOldDecks);
            this.addNewDecks = new JCheckBox(Resources.getString("GameRefresher.add_new_decks"));
            this.addNewDecks.setSelected(false);
            panel.add(this.addNewDecks);
            if (this.refresher.isGameActive()) {
                this.refreshDecks.setSelected(false);
                this.refreshDecks.setEnabled(false);
                this.deleteOldDecks.setEnabled(false);
                this.addNewDecks.setEnabled(false);
                FlowLabel nope = new FlowLabel(Resources.getString("GameRefresher.but_game_is_active"));
                panel.add(nope);
            }
            panel.add((Component)buttonPanel, "grow");
            this.add((Component)panel, "grow");
            SwingUtils.repack(this);
            this.deleteOldDecks.setVisible(this.refreshDecks.isSelected());
            this.addNewDecks.setVisible(this.refreshDecks.isSelected());
        }

        protected void setOptions() {
            this.options.clear();
            if (this.nameCheck.isSelected()) {
                this.options.add("UseName");
            }
            if (this.labelerNameCheck.isSelected()) {
                this.options.add("UseLabelerName");
            }
            if (this.layerNameCheck.isSelected()) {
                this.options.add("UseLayerName");
            }
            if (this.testModeOn.isSelected()) {
                this.options.add("TestMode");
            }
            if (this.deletePieceNoMap.isSelected()) {
                this.options.add("DeleteNoMap");
            }
            if (this.refreshDecks.isSelected()) {
                this.options.add("RefreshDecks");
                if (this.deleteOldDecks.isSelected()) {
                    this.options.add("DeleteOldDecks");
                }
                if (this.addNewDecks.isSelected()) {
                    this.options.add("AddNewDecks");
                }
            }
        }

        protected void exit() {
            this.setVisible(false);
        }

        protected void run() {
            BasicLogger log;
            if (this.hasAlreadyRun) {
                return;
            }
            this.hasAlreadyRun = true;
            GameModule g = GameModule.getGameModule();
            NullCommand command = new NullCommand();
            String player = GlobalOptions.getInstance().getPlayerId();
            this.setOptions();
            if (this.refresher.isTestMode()) {
                this.refresher.log(Resources.getString("GameRefresher.refresh_counters_test_mode"));
            } else {
                Chatter.DisplayText msg = new Chatter.DisplayText(g.getChatter(), Resources.getString("GameRefresher.run_refresh_counters_v2", player, g.getGameVersion()));
                msg.execute();
                command.append(msg);
            }
            this.refresher.execute(this.options, command);
            g.sendAndLog(command);
            if (this.options.contains("RefreshDecks") && !this.refresher.isGameActive() && (log = GameModule.getGameModule().getBasicLogger()) != null) {
                log.blockUndo(1);
            }
            this.exit();
        }

        protected void help() {
            File dir = Documentation.getDocumentationBaseDir();
            dir = new File(dir, "ReferenceManual");
            File theFile = new File(dir, "GameRefresher.html");
            HelpFile h = null;
            try {
                h = new HelpFile(null, theFile, "#top");
            }
            catch (MalformedURLException e) {
                ErrorDialog.bug(e);
            }
            BrowserSupport.openURL(h.getContents().toString());
        }

        public void addMessage(String mess) {
            this.results.setText(this.results.getText() + "\n" + mess);
        }
    }

    private class MatRefresher
    extends MatHolder {
        public MatRefresher(GamePiece piece) {
            super(piece);
        }

        public void refresh(Command command) {
            command.append(this.getMat().makeRemoveAllCargoCommand());
            GamePiece newMatPiece = GameRefresher.this.processGamePiece(this.getMatPiece(), command);
            for (GamePiece c : this.getCargo()) {
                GamePiece newCargo = GameRefresher.this.processGamePiece(c, command);
                command.append(((Mat)Decorator.getDecorator(newMatPiece, Mat.class)).makeAddCargoCommand(newCargo));
            }
        }
    }
}

