/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GlobalKeyCommand;
import VASSAL.build.module.KeyNamer;
import VASSAL.build.module.Plugin;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.map.DeckGlobalKeyCommand;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.GlobalTranslatableMessage;
import VASSAL.build.module.properties.ZoneProperty;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ComponentDescription;
import VASSAL.configure.EditContainedPiecesAction;
import VASSAL.configure.EditPropertiesAction;
import VASSAL.configure.ExtensionTree;
import VASSAL.configure.HintTextField;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.MassPieceLoader;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslateAction;
import VASSAL.launch.EditorWindow;
import VASSAL.preferences.Prefs;
import VASSAL.search.SearchTarget;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ConfigureTree
extends JTree
implements PropertyChangeListener,
MouseListener,
MouseMotionListener,
TreeSelectionListener,
TreeExpansionListener {
    private static final long serialVersionUID = 1L;
    protected Map<Configurable, DefaultMutableTreeNode> nodes = new HashMap<Configurable, DefaultMutableTreeNode>();
    protected DefaultMutableTreeNode copyData;
    protected DefaultMutableTreeNode cutData;
    protected HelpWindow helpWindow;
    protected EditorWindow editorWindow;
    protected Configurable selected;
    protected int selectedRow;
    protected String searchCmd;
    protected String moveCmd;
    protected String deleteCmd;
    protected String pasteCmd;
    protected String copyCmd;
    protected String cutCmd;
    protected String helpCmd;
    protected String propertiesCmd;
    protected String translateCmd;
    protected String duplicateCmd;
    protected KeyStroke cutKey;
    protected KeyStroke copyKey;
    protected KeyStroke pasteKey;
    protected KeyStroke deleteKey;
    protected KeyStroke moveKey;
    protected KeyStroke searchKey;
    protected KeyStroke helpKey;
    protected KeyStroke propertiesKey;
    protected KeyStroke translateKey;
    protected KeyStroke duplicateKey;
    protected Action cutAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action deleteAction;
    protected Action moveAction;
    protected Action searchAction;
    protected Action propertiesAction;
    protected Action translateAction;
    protected Action helpAction;
    protected Action duplicateAction;
    protected JDialog searchDialog;
    protected JTextField searchField;
    protected JCheckBox searchAdvanced;
    private final SearchParameters searchParameters;
    protected static Chatter chatter;
    public static final Font POPUP_MENU_FONT;
    protected static final List<AdditionalComponent> additionalComponents;

    public ConfigureTree(Configurable root, HelpWindow helpWindow) {
        this(root, helpWindow, null);
    }

    public ConfigureTree(Configurable root, HelpWindow helpWindow, EditorWindow editorWindow) {
        this.toggleClickCount = 3;
        this.helpWindow = helpWindow;
        this.editorWindow = editorWindow;
        this.setShowsRootHandles(true);
        this.setModel(new DefaultTreeModel(this.buildTreeNode(root)));
        this.setCellRenderer(this.buildRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this.searchCmd = Resources.getString("Editor.search");
        this.moveCmd = Resources.getString("Editor.move");
        this.deleteCmd = Resources.getString("Editor.delete");
        this.pasteCmd = Resources.getString("Editor.paste");
        this.copyCmd = Resources.getString("Editor.copy");
        this.cutCmd = Resources.getString("Editor.cut");
        this.propertiesCmd = Resources.getString("Editor.properties");
        this.translateCmd = Resources.getString("Editor.ModuleEditor.translate");
        this.helpCmd = Resources.getString("Editor.ModuleEditor.component_help");
        this.duplicateCmd = Resources.getString("Editor.duplicate");
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.cutKey = KeyStroke.getKeyStroke(88, mask);
        this.copyKey = KeyStroke.getKeyStroke(67, mask);
        this.pasteKey = KeyStroke.getKeyStroke(86, mask);
        this.deleteKey = KeyStroke.getKeyStroke(127, 0);
        this.moveKey = KeyStroke.getKeyStroke(77, mask);
        this.searchKey = KeyStroke.getKeyStroke(70, mask);
        this.propertiesKey = KeyStroke.getKeyStroke(80, mask);
        this.translateKey = KeyStroke.getKeyStroke(84, mask);
        this.helpKey = KeyStroke.getKeyStroke(112, 0);
        this.duplicateKey = KeyStroke.getKeyStroke(68, mask);
        this.copyAction = new KeyAction(this.copyCmd, this.copyKey);
        this.pasteAction = new KeyAction(this.pasteCmd, this.pasteKey);
        this.cutAction = new KeyAction(this.cutCmd, this.cutKey);
        this.deleteAction = new KeyAction(this.deleteCmd, this.deleteKey);
        this.moveAction = new KeyAction(this.moveCmd, this.moveKey);
        this.searchAction = new KeyAction(this.searchCmd, this.searchKey);
        this.propertiesAction = new KeyAction(this.propertiesCmd, this.propertiesKey);
        this.translateAction = new KeyAction(this.translateCmd, this.translateKey);
        this.helpAction = new KeyAction(this.helpCmd, this.helpKey);
        this.duplicateAction = new KeyAction(this.duplicateCmd, this.duplicateKey);
        this.getInputMap().put(this.cutKey, this.cutCmd);
        this.getInputMap().put(this.copyKey, this.copyCmd);
        this.getInputMap().put(this.pasteKey, this.pasteCmd);
        this.getInputMap().put(this.deleteKey, this.deleteCmd);
        this.getInputMap().put(this.duplicateKey, this.duplicateCmd);
        this.getActionMap().put(this.cutCmd, this.cutAction);
        this.getActionMap().put(this.copyCmd, this.copyAction);
        this.getActionMap().put(this.pasteCmd, this.pasteAction);
        this.getActionMap().put(this.deleteCmd, this.deleteAction);
        this.getActionMap().put(this.duplicateCmd, this.duplicateAction);
        this.getSelectionModel().setSelectionMode(1);
        this.searchParameters = new SearchParameters();
        TreePath path = new TreePath(((DefaultMutableTreeNode)this.getModel().getRoot()).getPath());
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
        chatter = GameModule.getGameModule().getChatter();
        this.createKeyBindings();
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(new TreeTransferHandler());
    }

    protected static String noHTML(String text) {
        return text.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    protected static void chat(String text) {
        if (chatter != null) {
            chatter.show("- " + text);
        }
    }

    protected JDialog getSearchDialog() {
        return this.searchDialog;
    }

    protected void setSearchDialog(JDialog searchDialog) {
        this.searchDialog = searchDialog;
    }

    protected JTextField getSearchField() {
        return this.searchField;
    }

    protected void setSearchField(JTextField searchField) {
        this.searchField = searchField;
    }

    protected void setSearchAdvanced(JCheckBox searchAdvanced) {
        this.searchAdvanced = searchAdvanced;
    }

    protected JCheckBox getSearchAdvanced() {
        return this.searchAdvanced;
    }

    public JFrame getFrame() {
        return this.editorWindow;
    }

    private void createKeyBindings() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.getActionMap().put("Enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreePath path = ConfigureTree.this.getSelectionPath();
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (ConfigureTree.this.isExpanded(path) || node.getChildCount() == 0) {
                    Action a;
                    Configurable target = (Configurable)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (target != null && target.getConfigurer() != null && (a = ConfigureTree.this.buildEditAction(target)) != null) {
                        a.actionPerformed(new ActionEvent(ae.getSource(), 1001, "Edit"));
                    }
                } else {
                    ConfigureTree.this.setExpandedState(path, true);
                }
            }
        });
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        ConfigureTreeNode node = (ConfigureTreeNode)event.getPath().getLastPathComponent();
        node.resetChildEditFlags();
    }

    protected Renderer buildRenderer() {
        return new Renderer();
    }

    protected void notifyStateChanged(boolean changed) {
        if (this.editorWindow != null) {
            this.editorWindow.treeStateChanged(changed);
        }
    }

    protected Configurable getTarget(int x, int y) {
        TreePath path = this.getPathForLocation(x, y);
        Configurable target = null;
        if (path != null) {
            target = (Configurable)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        return target;
    }

    protected DefaultMutableTreeNode buildTreeNode(Configurable c) {
        Configurable[] children;
        c.addPropertyChangeListener(this);
        ConfigureTreeNode node = new ConfigureTreeNode(c);
        for (Configurable child : children = c.getConfigureComponents()) {
            if (child instanceof Plugin) continue;
            node.add(this.buildTreeNode(child));
        }
        this.nodes.put(c, node);
        return node;
    }

    protected void addAction(JPopupMenu menu, Action a) {
        if (a != null) {
            menu.add(a).setFont(POPUP_MENU_FONT);
        }
    }

    protected void addSubMenu(JPopupMenu menu, String name, List<Action> l) {
        if (l != null && !l.isEmpty()) {
            JMenu subMenu = new JMenu(name);
            for (Action a : l) {
                subMenu.add(a).setFont(POPUP_MENU_FONT);
            }
            menu.add(subMenu).setFont(POPUP_MENU_FONT);
            l.clear();
        }
    }

    private void addActionGroup(JPopupMenu menu, List<Action> l) {
        boolean empty = true;
        for (Action a : l) {
            if (a == null) continue;
            menu.add(a).setFont(POPUP_MENU_FONT);
            empty = false;
        }
        if (!empty) {
            menu.addSeparator();
        }
        l.clear();
    }

    protected JPopupMenu buildPopupMenu(Configurable target) {
        JPopupMenu popup = new JPopupMenu();
        ArrayList<Action> l = new ArrayList<Action>();
        l.add(this.buildEditAction(target));
        l.add(this.buildEditPiecesAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildTranslateAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildHelpAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildSearchAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildDeleteAction(target));
        l.add(this.buildCutAction(target));
        l.add(this.buildCopyAction(target));
        l.add(this.buildPasteAction(target));
        l.add(this.buildMoveAction(target));
        this.addActionGroup(popup, l);
        ArrayList<Action> inserts = new ArrayList<Action>();
        List<Action> adds = this.buildAddActionsFor(target, inserts);
        for (Action a : adds) {
            this.addAction(popup, a);
        }
        this.addSubMenu(popup, Resources.getString("Editor.ConfigureTree.insert"), inserts);
        if (this.hasChild(target, PieceSlot.class) || this.hasChild(target, CardSlot.class)) {
            this.addAction(popup, this.buildMassPieceLoaderAction(target));
        }
        this.addAction(popup, this.buildImportAction(target));
        return popup;
    }

    private List<DefaultMutableTreeNode> getSearchNodes(DefaultMutableTreeNode root) {
        ArrayList<DefaultMutableTreeNode> searchNodes = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = root.preorderEnumeration();
        while (e.hasMoreElements()) {
            searchNodes.add((DefaultMutableTreeNode)e.nextElement());
        }
        return searchNodes;
    }

    protected Action buildSearchAction(Configurable target) {
        SearchAction a = new SearchAction(this, this.searchParameters);
        a.setEnabled(true);
        return a;
    }

    protected Action buildMoveAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(this.moveCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), true);
                    d.setTitle((String)(target.getConfigureName() == null ? ConfigureTree.this.moveCmd : ConfigureTree.this.moveCmd + " " + target.getConfigureName()));
                    d.setLayout(new BoxLayout(d.getContentPane(), 1));
                    Box box = Box.createHorizontalBox();
                    box.add(new JLabel(Resources.getString("Editor.ConfigureTree.move_to_position")));
                    box.add(Box.createHorizontalStrut(10));
                    JComboBox<CallSite> select = new JComboBox<CallSite>();
                    TreeNode parentNode = ConfigureTree.this.getTreeNode(target).getParent();
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        Configurable c = (Configurable)((DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject();
                        String name = (c.getConfigureName() != null ? c.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(c.getClass()) + "]";
                        select.addItem((CallSite)((Object)(i + 1 + ":  " + name)));
                    }
                    DefaultMutableTreeNode targetNode = ConfigureTree.this.getTreeNode(target);
                    int currentIndex = targetNode.getParent().getIndex(targetNode);
                    select.setSelectedIndex(currentIndex);
                    box.add(select);
                    JButton ok = new JButton(Resources.getString("General.ok"));
                    ok.addActionListener(e1 -> {
                        Configurable parent;
                        int index = select.getSelectedIndex();
                        if (currentIndex != index && ConfigureTree.this.remove(parent = ConfigureTree.this.getParent(targetNode), target)) {
                            ConfigureTree.this.insert(parent, target, index);
                        }
                        d.dispose();
                    });
                    d.add(box);
                    d.add(ok);
                    SwingUtils.repack(d);
                    d.setLocationRelativeTo(d.getParent());
                    d.setVisible(true);
                }
            };
        }
        return a;
    }

    protected Action buildCutAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(this.cutCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureTree.this.cutData = ConfigureTree.this.getTreeNode(target);
                    ConfigureTree.this.copyData = null;
                    ConfigureTree.this.updateEditMenu();
                }
            };
        }
        return a;
    }

    protected Action buildCopyAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(this.copyCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureTree.this.copyData = ConfigureTree.this.getTreeNode(target);
                    ConfigureTree.this.cutData = null;
                    ConfigureTree.this.updateEditMenu();
                }
            };
        }
        return a;
    }

    private void postPasteFixups(Configurable target) {
        SetupStack ss;
        String owning;
        if (target instanceof SetupStack && (owning = (ss = (SetupStack)target).getOwningBoardName()) != null && !ss.getValidOwningBoards().contains(owning)) {
            ConfigureTree.chat(Resources.getString("Editor.convert_setupstack_or_deck", target instanceof DrawPile ? DrawPile.getConfigureTypeName() : SetupStack.getConfigureTypeName(), ss.getConfigureName(), owning));
            ss.setOwningBoardName(null);
        }
    }

    protected Action buildPasteAction(final Configurable target) {
        AbstractAction a = new AbstractAction(this.pasteCmd){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureTree.this.cutData != null) {
                    DefaultMutableTreeNode targetNode = ConfigureTree.this.getTreeNode(target);
                    if (targetNode.isNodeAncestor(ConfigureTree.this.cutData)) {
                        ConfigureTree.chat(Resources.getString("Editor.cant_cut_ancestor_to_child"));
                        return;
                    }
                    Configurable cutObj = (Configurable)ConfigureTree.this.cutData.getUserObject();
                    Configurable convertedCutObj = ConfigureTree.this.convertChild(target, cutObj);
                    if (ConfigureTree.this.getParent(ConfigureTree.this.cutData) == null || ConfigureTree.this.remove(ConfigureTree.this.getParent(ConfigureTree.this.cutData), cutObj)) {
                        ConfigureTree.this.insert(target, convertedCutObj, targetNode.getChildCount());
                        ConfigureTree.this.postPasteFixups(convertedCutObj);
                    }
                    ConfigureTree.this.copyData = ConfigureTree.this.getTreeNode(convertedCutObj);
                } else if (ConfigureTree.this.copyData != null) {
                    Configurable copyBase = (Configurable)ConfigureTree.this.copyData.getUserObject();
                    Buildable clone = null;
                    try {
                        clone = ConfigureTree.this.convertChild(target, (Configurable)copyBase.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Throwable t) {
                        ReflectionUtils.handleNewInstanceFailure(t, copyBase.getClass());
                    }
                    if (clone != null) {
                        clone.build(copyBase.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(target, (Configurable)clone, ConfigureTree.this.getTreeNode(target).getChildCount());
                        ConfigureTree.this.updateGpIds((Configurable)clone);
                        ConfigureTree.this.postPasteFixups((Configurable)clone);
                    }
                }
                ConfigureTree.this.cutData = null;
                ConfigureTree.this.updateEditMenu();
            }
        };
        a.setEnabled(this.isValidPasteTarget(target));
        return a;
    }

    protected boolean isValidPasteTarget(Configurable target, DefaultMutableTreeNode sourceNode) {
        if (sourceNode == null) {
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)sourceNode.getParent();
        if (parent != null && parent.getUserObject().equals(target)) {
            return true;
        }
        return this.isValidParent(target, (Configurable)sourceNode.getUserObject());
    }

    protected boolean isValidPasteTarget(Configurable target) {
        return this.isValidPasteTarget(target, this.cutData) || this.isValidPasteTarget(target, this.copyData);
    }

    protected Configurable convertChild(Configurable parent, Configurable child) {
        if (child.getClass() == PieceSlot.class && this.isAllowedChildClass(parent, CardSlot.class)) {
            return new CardSlot((PieceSlot)child);
        }
        if (child.getClass() == CardSlot.class && this.isAllowedChildClass(parent, PieceSlot.class)) {
            return new PieceSlot((CardSlot)child);
        }
        if (MassKeyCommand.class.isAssignableFrom(child.getClass())) {
            if (this.isAllowedChildClass(parent, DeckGlobalKeyCommand.class)) {
                return child instanceof DeckGlobalKeyCommand ? child : new DeckGlobalKeyCommand((MassKeyCommand)child);
            }
            if (this.isAllowedChildClass(parent, GlobalKeyCommand.class)) {
                return child instanceof GlobalKeyCommand ? child : new GlobalKeyCommand((MassKeyCommand)child);
            }
            if (this.isAllowedChildClass(parent, MassKeyCommand.class)) {
                return child.getClass().equals(MassKeyCommand.class) ? child : new MassKeyCommand((MassKeyCommand)child);
            }
        }
        return child;
    }

    protected boolean isAllowedChildClass(Configurable parent, Class<?> childClass) {
        Class[] allowableClasses;
        for (Class allowableClass : allowableClasses = parent.getAllowableConfigureComponents()) {
            if (allowableClass != childClass) continue;
            return true;
        }
        return false;
    }

    public void updateGpIds(Configurable c) {
        if (c instanceof PieceSlot) {
            ((PieceSlot)c).updateGpId(GameModule.getGameModule());
        } else {
            for (Configurable comp : c.getConfigureComponents()) {
                this.updateGpIds(comp);
            }
        }
    }

    protected Action buildImportAction(final Configurable target) {
        return new AbstractAction(Resources.getString("Editor.ConfigureTree.add_imported_class")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                final Configurable child = ConfigureTree.this.importConfigurable();
                if (child != null) {
                    try {
                        child.build(null);
                        if (child.getConfigurer() != null) {
                            PropertiesWindow w = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), false, child, ConfigureTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                @Override
                                public void save() {
                                    super.save();
                                    ConfigureTree.this.insert(target, child, ConfigureTree.this.getTreeNode(target).getChildCount());
                                }

                                @Override
                                public void cancel() {
                                    this.dispose();
                                }
                            };
                            w.setVisible(true);
                        } else {
                            ConfigureTree.this.insert(target, child, ConfigureTree.this.getTreeNode(target).getChildCount());
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ConfigureTree.this.getTopLevelAncestor(), "Error adding " + ConfigureTree.getConfigureName(child) + " to " + ConfigureTree.getConfigureName(target) + "\n" + ex.getMessage(), "Illegal configuration", 0);
                    }
                }
            }
        };
    }

    protected Action buildMassPieceLoaderAction(final Configurable target) {
        AbstractAction a = null;
        final ConfigureTree tree = this;
        if (this.getTreeNode(target).getParent() != null) {
            Resources.getString("Editor.ConfigureTree.add_cards");
            String desc = this.hasChild(target, CardSlot.class) ? Resources.getString("Editor.ConfigureTree.add_cards") : Resources.getString("Editor.ConfigureTree.add_pieces");
            a = new AbstractAction(desc){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    new MassPieceLoader(tree, target).load();
                }
            };
        }
        return a;
    }

    protected boolean hasChild(Configurable parent, Class<?> childClass) {
        for (Class c : parent.getAllowableConfigureComponents()) {
            if (!c.equals(childClass)) continue;
            return true;
        }
        return false;
    }

    protected List<Action> buildAddActionsFor(Configurable target) {
        return this.buildAddActionsFor(target, null);
    }

    protected List<Action> buildAddActionsFor(Configurable target, List<Action> peerInserts) {
        DefaultMutableTreeNode parentNode;
        DefaultMutableTreeNode targetNode;
        ArrayList<Action> l = new ArrayList<Action>();
        if (target instanceof AbstractConfigurable && (targetNode = this.getTreeNode(target)) != null && (parentNode = (DefaultMutableTreeNode)targetNode.getParent()) != null) {
            l.add(this.buildAddAction((Configurable)parentNode.getUserObject(), target.getClass(), "Editor.ConfigureTree.add_duplicate", parentNode.getIndex(targetNode) + 1, target));
            if (peerInserts != null) {
                Configurable parent = (Configurable)parentNode.getUserObject();
                for (Class newConfig : parent.getAllowableConfigureComponents()) {
                    peerInserts.add(this.buildAddAction(parent, newConfig, "Editor.ConfigureTree.add_peer", parentNode.getIndex(targetNode), null));
                }
            }
        }
        for (Class newConfig : target.getAllowableConfigureComponents()) {
            l.add(this.buildAddAction(target, newConfig));
        }
        for (AdditionalComponent add : additionalComponents) {
            if (!target.getClass().equals(add.getParent())) continue;
            Class<? extends Buildable> newConfig = add.getChild();
            l.add(this.buildAddAction(target, newConfig));
        }
        return l;
    }

    protected Action buildAddAction(Configurable target, Class<? extends Buildable> newConfig) {
        return this.buildAddAction(target, newConfig, "Editor.ConfigureTree.add_component", -1, null);
    }

    protected Action buildAddAction(final Configurable target, final Class<? extends Buildable> newConfig, String key, final int index, final Configurable duplicate) {
        return new AbstractAction(Resources.getString(key, ConfigureTree.getConfigureName(newConfig))){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configurable ch = null;
                try {
                    ch = (Configurable)newConfig.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, newConfig);
                }
                if (ch != null) {
                    int finalIndex;
                    final Configurable child = ch;
                    if (ch instanceof AbstractBuildable) {
                        ((AbstractBuildable)((Object)ch)).setAncestor(target);
                    }
                    child.build(duplicate != null ? duplicate.getBuildElement(Builder.createNewDocument()) : null);
                    if (child instanceof PieceSlot) {
                        ((PieceSlot)child).updateGpId(GameModule.getGameModule());
                    }
                    int n = finalIndex = index < 0 ? ConfigureTree.this.getTreeNode(target).getChildCount() : ConfigureTree.this.checkMinimumIndex(ConfigureTree.this.getTreeNode(target), index);
                    if (child.getConfigurer() != null) {
                        if (ConfigureTree.this.insert(target, child, finalIndex)) {
                            if (duplicate != null) {
                                ConfigureTree.this.updateGpIds(child);
                            }
                            TreePath path = new TreePath(ConfigureTree.this.getTreeNode(child).getPath());
                            ConfigureTree.this.expandPath(path);
                            PropertiesWindow w = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), false, child, ConfigureTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                @Override
                                public void cancel() {
                                    DefaultMutableTreeNode currentParent = (DefaultMutableTreeNode)ConfigureTree.this.getTreeNode(child).getParent();
                                    if (currentParent != null) {
                                        ConfigureTree.this.remove((Configurable)currentParent.getUserObject(), child);
                                    }
                                    this.dispose();
                                }

                                @Override
                                public void save() {
                                    DefaultMutableTreeNode node;
                                    if (duplicate != null && (node = ConfigureTree.this.getTreeNode(child)) != null) {
                                        TreePath path = new TreePath(node.getPath());
                                        ConfigureTree.this.setSelectionPath(path);
                                        ConfigureTree.this.scrollPathToVisible(path);
                                    }
                                    super.save();
                                }
                            };
                            w.setVisible(true);
                        }
                    } else {
                        ConfigureTree.this.insert(target, child, finalIndex);
                        if (duplicate != null) {
                            ConfigureTree.this.updateGpIds(child);
                        }
                    }
                }
            }
        };
    }

    protected Action buildHelpAction(Configurable target) {
        ShowHelpAction showHelp;
        HelpFile helpFile = target.getHelpFile();
        if (helpFile == null) {
            showHelp = new ShowHelpAction(null, null);
            showHelp.setEnabled(false);
        } else {
            showHelp = new ShowHelpAction(helpFile.getContents(), null);
        }
        return showHelp;
    }

    protected Action buildCloneAction(final Configurable target) {
        final DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        if (targetNode.getParent() != null) {
            return new AbstractAction(Resources.getString("Editor.ConfigureTree.clone")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Configurable clone = null;
                    try {
                        clone = (Configurable)target.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable t) {
                        ReflectionUtils.handleNewInstanceFailure(t, target.getClass());
                    }
                    if (clone != null) {
                        clone.build(target.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(ConfigureTree.this.getParent(targetNode), clone, targetNode.getParent().getIndex(targetNode) + 1);
                    }
                }
            };
        }
        return null;
    }

    protected Configurable getParent(DefaultMutableTreeNode targetNode) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        return parentNode == null ? null : (Configurable)parentNode.getUserObject();
    }

    protected Action buildDeleteAction(final Configurable target) {
        DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        final Configurable parent = this.getParent(targetNode);
        if (targetNode.getParent() != null) {
            return new AbstractAction(this.deleteCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int row = ConfigureTree.this.selectedRow;
                    ConfigureTree.this.remove(parent, target);
                    if (row < ConfigureTree.this.getRowCount()) {
                        ConfigureTree.this.setSelectionRow(row);
                    } else {
                        ConfigureTree.this.setSelectionRow(row - 1);
                    }
                }
            };
        }
        return null;
    }

    protected Action buildEditPiecesAction(Configurable target) {
        if (this.canContainGamePiece(target)) {
            return new EditContainedPiecesAction(target);
        }
        return null;
    }

    protected Action buildEditAction(Configurable target) {
        return new EditPropertiesAction(target, this.helpWindow, (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), this);
    }

    protected Action buildTranslateAction(Configurable target) {
        TranslateAction a = new TranslateAction(target, this.helpWindow, this);
        a.setEnabled(target.getI18nData().isTranslatable());
        return a;
    }

    public boolean canContainGamePiece(Configurable target) {
        boolean canContainPiece = false;
        for (Class c : target.getAllowableConfigureComponents()) {
            if (!PieceSlot.class.isAssignableFrom(c)) continue;
            canContainPiece = true;
            break;
        }
        return canContainPiece;
    }

    protected boolean remove(Configurable parent, Configurable child) {
        try {
            child.removeFrom(parent);
            parent.remove(child);
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(this.getTreeNode(child));
            this.notifyStateChanged(true);
            return true;
        }
        catch (IllegalBuildException err) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Cannot delete " + ConfigureTree.getConfigureName(child) + " from " + ConfigureTree.getConfigureName(parent) + "\n" + err.getMessage(), "Illegal configuration", 0);
            return false;
        }
    }

    protected boolean insert(Configurable parent, Configurable child, int index) {
        Configurable theChild = child;
        if (parent.getClass() == GlobalProperties.class && child.getClass() == ZoneProperty.class) {
            theChild = new GlobalProperty((GlobalProperty)child);
        }
        if (parent.getClass() == Zone.class && child.getClass() == GlobalProperty.class) {
            theChild = new ZoneProperty((GlobalProperty)child);
        }
        DefaultMutableTreeNode childNode = this.buildTreeNode(theChild);
        DefaultMutableTreeNode parentNode = this.getTreeNode(parent);
        Configurable[] oldContents = parent.getConfigureComponents();
        ArrayList<Configurable> moveToBack = new ArrayList<Configurable>();
        for (int i = index; i < oldContents.length; ++i) {
            try {
                parent.remove(oldContents[i]);
            }
            catch (IllegalBuildException err) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't insert " + ConfigureTree.getConfigureName(theChild) + " before " + ConfigureTree.getConfigureName(oldContents[i]), "Illegal configuration", 0);
                for (int j = index; j < i; ++j) {
                    parent.add(oldContents[j]);
                }
                return false;
            }
            moveToBack.add(oldContents[i]);
        }
        boolean succeeded = true;
        try {
            theChild.addTo(parent);
            parent.add(theChild);
            parentNode.insert(childNode, index);
            int[] childI = new int[]{index};
            ((DefaultTreeModel)this.getModel()).nodesWereInserted(parentNode, childI);
        }
        catch (IllegalBuildException err) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't add " + ConfigureTree.getConfigureName(child) + "\n" + err.getMessage(), "Illegal configuration", 0);
            succeeded = false;
        }
        for (Configurable c : moveToBack) {
            parent.add(c);
        }
        this.notifyStateChanged(true);
        return succeeded;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DefaultMutableTreeNode newValue = this.getTreeNode((Configurable)evt.getSource());
        ((DefaultTreeModel)this.getModel()).nodeChanged(newValue);
    }

    public static String getConfigureName(Class<?> c) {
        try {
            return (String)c.getMethod("getConfigureTypeName", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
            ErrorDialog.bug(e);
        }
        return c.getName().substring(c.getName().lastIndexOf(".") + 1);
    }

    public static String getConfigureName(Configurable c) {
        if (c.getConfigureName() != null && c.getConfigureName().length() > 0) {
            return c.getConfigureName();
        }
        return ConfigureTree.getConfigureName(c.getClass());
    }

    protected Configurable importConfigurable() {
        String className = JOptionPane.showInputDialog(this.getTopLevelAncestor(), (Object)Resources.getString("Editor.ConfigureTree.java_name"));
        if (className == null) {
            return null;
        }
        Object o = null;
        try {
            o = GameModule.getGameModule().getDataArchive().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleImportClassFailure(t, className);
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Configurable) {
            return o;
        }
        ErrorDialog.show("Error.not_a_configurable", className);
        return null;
    }

    protected void maybePopup(MouseEvent e) {
        Configurable target = this.getTarget(e.getX(), e.getY());
        if (target == null) {
            return;
        }
        this.setSelectionRow(this.getClosestRowForLocation(e.getX(), e.getY()));
        JPopupMenu popup = this.buildPopupMenu(target);
        popup.show(this, e.getX(), e.getY());
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                ConfigureTree.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ConfigureTree.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.maybePopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.maybePopup(e);
        } else if (e.getClickCount() == 2 && SwingUtils.isMainMouseButtonDown(e)) {
            Action a;
            Configurable target = this.getTarget(e.getX(), e.getY());
            if (target == null) {
                return;
            }
            if (target.getConfigurer() != null && (a = this.buildEditAction(target)) != null) {
                a.actionPerformed(new ActionEvent(e.getSource(), 1001, "Edit", e.getModifiersEx()));
            }
        }
    }

    public DefaultMutableTreeNode getTreeNode(Configurable target) {
        return this.nodes.get(target);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    protected boolean isValidParent(Configurable parent, Configurable child) {
        if (parent != null && child != null) {
            Class[] c;
            for (Class aClass : c = parent.getAllowableConfigureComponents()) {
                if (!(aClass.isAssignableFrom(child.getClass()) || aClass == CardSlot.class && child.getClass() == PieceSlot.class || aClass == ZoneProperty.class && child.getClass() == GlobalProperty.class) && (!MassKeyCommand.class.isAssignableFrom(aClass) || !MassKeyCommand.class.isAssignableFrom(child.getClass()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void nodeUpdated(Configurable target) {
        DefaultMutableTreeNode node = this.getTreeNode(target);
        Configurable parent = this.getParent(node);
        if (this.remove(parent, target)) {
            this.insert(parent, target, 0);
        }
        ((DefaultTreeModel)this.getModel()).nodeChanged(node);
    }

    public void externalInsert(Configurable parent, Configurable child) {
        this.insert(parent, child, this.getTreeNode(parent).getChildCount());
    }

    public Action getHelpAction() {
        return this.helpAction;
    }

    public void populateEditMenu(EditorWindow ew) {
        MenuManager mm = MenuManager.getInstance();
        mm.addAction("Editor.delete", this.deleteAction);
        mm.addAction("Editor.cut", this.cutAction);
        mm.addAction("Editor.copy", this.copyAction);
        mm.addAction("Editor.paste", this.pasteAction);
        mm.addAction("Editor.move", this.moveAction);
        mm.addAction("Editor.search", this.searchAction);
        mm.addAction("Editor.properties", this.propertiesAction);
        mm.addAction("Editor.ModuleEditor.translate", this.translateAction);
        mm.addAction("Editor.duplicate", this.duplicateAction);
        this.updateEditMenu();
    }

    protected void doKeyAction(String action) {
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (targetNode != null) {
            DefaultMutableTreeNode parentNode;
            DefaultMutableTreeNode targetNode2;
            Configurable target = (Configurable)targetNode.getUserObject();
            Action a = null;
            if (this.cutCmd.equals(action)) {
                a = this.buildCutAction(target);
            } else if (this.copyCmd.equals(action)) {
                a = this.buildCopyAction(target);
            } else if (this.pasteCmd.equals(action) || action.equals(String.valueOf(this.pasteKey.getKeyChar()))) {
                a = this.buildPasteAction(target);
            } else if (this.deleteCmd.equals(action)) {
                a = this.buildDeleteAction(target);
            } else if (this.moveCmd.equals(action)) {
                a = this.buildMoveAction(target);
            } else if (this.searchCmd.equals(action)) {
                a = this.buildSearchAction(target);
            } else if (this.propertiesCmd.equals(action)) {
                a = this.buildEditAction(target);
            } else if (this.translateCmd.equals(action)) {
                a = this.buildTranslateAction(target);
            } else if (this.helpCmd.equals(action)) {
                a = this.buildHelpAction(target);
            } else if (this.duplicateCmd.equals(action) && (targetNode2 = this.getTreeNode(target)) != null && (parentNode = (DefaultMutableTreeNode)targetNode2.getParent()) != null) {
                a = this.buildAddAction((Configurable)parentNode.getUserObject(), target.getClass(), Resources.getString("Editor.duplicate"), parentNode.getIndex(targetNode2) + 1, target);
            }
            if (a != null) {
                a.actionPerformed(null);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.selected = null;
        TreePath path = e.getPath();
        if (path != null) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.selected = (Configurable)selectedNode.getUserObject();
            this.selectedRow = this.getRowForPath(path);
            this.updateEditMenu();
            ((DefaultTreeModel)this.getModel()).nodeChanged(selectedNode);
        }
    }

    protected void updateEditMenu() {
        this.deleteAction.setEnabled(this.selected != null);
        this.cutAction.setEnabled(this.selected != null);
        this.copyAction.setEnabled(this.selected != null);
        this.pasteAction.setEnabled(this.selected != null && this.isValidPasteTarget(this.selected));
        this.moveAction.setEnabled(this.selected != null);
        this.duplicateAction.setEnabled(this.selected != null);
        this.searchAction.setEnabled(true);
        this.propertiesAction.setEnabled(this.selected != null && this.selected.getConfigurer() != null);
        this.translateAction.setEnabled(this.selected != null);
    }

    protected Configurable getParent(Configurable target) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getTreeNode(target).getParent();
        return (Configurable)parentNode.getUserObject();
    }

    public String getSearchCmd() {
        return this.searchCmd;
    }

    public static void addAdditionalComponent(Class<? extends Buildable> parent, Class<? extends Buildable> child) {
        additionalComponents.add(new AdditionalComponent(parent, child));
    }

    public void nodeEdited(Configurable target) {
        ConfigureTreeNode node = (ConfigureTreeNode)this.getTreeNode(target);
        node.setEdited(true);
        ((DefaultTreeModel)this.getModel()).nodeChanged(node);
    }

    public int checkMinimumIndex(DefaultMutableTreeNode targetNode, int index) {
        return index;
    }

    static {
        POPUP_MENU_FONT = new Font("Dialog", 0, 11);
        additionalComponents = new ArrayList<AdditionalComponent>();
    }

    static class Renderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private Font plainFont;
        private Font italicFont;

        Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.plainFont == null) {
                this.plainFont = label.getFont();
            }
            if (value instanceof ConfigureTreeNode) {
                ConfigureTreeNode c = (ConfigureTreeNode)value;
                if (c.isEdited()) {
                    if (this.italicFont == null) {
                        Font f = label.getFont();
                        this.italicFont = new Font(f.getFontName(), 2, f.getSize());
                    }
                    label.setFont(this.italicFont);
                } else {
                    label.setFont(this.plainFont);
                }
            }
            return label;
        }
    }

    class KeyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected String actionName;

        public KeyAction(String name, KeyStroke key) {
            super(name);
            this.actionName = name;
            this.putValue("AcceleratorKey", key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigureTree.this.doKeyAction(this.actionName);
        }
    }

    private static class SearchParameters {
        public static final String SEARCH_STRING = "searchString";
        public static final String MATCH_CASE = "matchCase";
        public static final String MATCH_NAMES = "matchNames";
        public static final String MATCH_TYPES = "matchTypes";
        public static final String MATCH_ADVANCED = "matchAdvanced";
        public static final String MATCH_TRAITS = "matchTraits";
        public static final String MATCH_EXPRESSIONS = "matchExpressions";
        public static final String MATCH_PROPERTIES = "matchProperties";
        public static final String MATCH_KEYS = "matchKeys";
        public static final String MATCH_MENUS = "matchMenus";
        public static final String MATCH_MESSAGES = "matchMessages";
        private String searchString;
        private boolean matchCase;
        private boolean matchNames;
        private boolean matchTypes;
        private boolean matchAdvanced;
        private boolean matchTraits;
        private boolean matchExpressions;
        private boolean matchProperties;
        private boolean matchKeys;
        private boolean matchMenus;
        private boolean matchMessages;
        private static Prefs prefs;

        public SearchParameters() {
            prefs = GameModule.getGameModule().getPrefs();
            prefs.addOption(null, new StringConfigurer(SEARCH_STRING, null, ""));
            prefs.addOption(null, new BooleanConfigurer(MATCH_CASE, null, false));
            prefs.addOption(null, new BooleanConfigurer(MATCH_NAMES, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_TYPES, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_ADVANCED, null, false));
            prefs.addOption(null, new BooleanConfigurer(MATCH_TRAITS, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_EXPRESSIONS, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_PROPERTIES, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_KEYS, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_MENUS, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_MESSAGES, null, true));
            this.searchString = (String)prefs.getValue(SEARCH_STRING);
            this.matchCase = (Boolean)prefs.getValue(MATCH_CASE);
            this.matchNames = (Boolean)prefs.getValue(MATCH_NAMES);
            this.matchTypes = (Boolean)prefs.getValue(MATCH_TYPES);
            this.matchAdvanced = (Boolean)prefs.getValue(MATCH_ADVANCED);
            this.matchTraits = (Boolean)prefs.getValue(MATCH_TRAITS);
            this.matchExpressions = (Boolean)prefs.getValue(MATCH_EXPRESSIONS);
            this.matchProperties = (Boolean)prefs.getValue(MATCH_PROPERTIES);
            this.matchKeys = (Boolean)prefs.getValue(MATCH_KEYS);
            this.matchMenus = (Boolean)prefs.getValue(MATCH_MENUS);
            this.matchMessages = (Boolean)prefs.getValue(MATCH_MESSAGES);
        }

        public SearchParameters(String searchString, boolean matchCase, boolean matchNames, boolean matchTypes, boolean matchAdvanced, boolean matchTraits, boolean matchExpressions, boolean matchProperties, boolean matchKeys, boolean matchMenus, boolean matchMessages) {
            this.searchString = searchString;
            this.matchCase = matchCase;
            this.matchNames = matchNames;
            this.matchTypes = matchTypes;
            this.matchAdvanced = matchAdvanced;
            this.matchTraits = matchTraits;
            this.matchExpressions = matchExpressions;
            this.matchProperties = matchProperties;
            this.matchKeys = matchKeys;
            this.matchMenus = matchMenus;
            this.matchMessages = matchMessages;
        }

        public String getSearchString() {
            return this.searchString;
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString;
            this.writePrefs();
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public void setMatchCase(boolean matchCase) {
            this.matchCase = matchCase;
            this.writePrefs();
        }

        public boolean isMatchNames() {
            return this.matchNames;
        }

        public void setMatchNames(boolean matchNames) {
            this.matchNames = matchNames;
            this.writePrefs();
        }

        public boolean isMatchTypes() {
            return this.matchTypes;
        }

        public void setMatchTypes(boolean matchTypes) {
            this.matchTypes = matchTypes;
            this.writePrefs();
        }

        public boolean isMatchAdvanced() {
            return this.matchAdvanced;
        }

        public void setMatchAdvanced(boolean matchAdvanced) {
            this.matchAdvanced = matchAdvanced;
            this.writePrefs();
        }

        public boolean isMatchTraits() {
            return this.matchTraits;
        }

        public void setMatchTraits(boolean matchTraits) {
            this.matchTraits = matchTraits;
            this.writePrefs();
        }

        public boolean isMatchExpressions() {
            return this.matchExpressions;
        }

        public void setMatchExpressions(boolean matchExpressions) {
            this.matchExpressions = matchExpressions;
            this.writePrefs();
        }

        public boolean isMatchProperties() {
            return this.matchProperties;
        }

        public void setMatchProperties(boolean matchProperties) {
            this.matchProperties = matchProperties;
            this.writePrefs();
        }

        public boolean isMatchKeys() {
            return this.matchKeys;
        }

        public void setMatchKeys(boolean matchKeys) {
            this.matchKeys = matchKeys;
            this.writePrefs();
        }

        public boolean isMatchMenus() {
            return this.matchMenus;
        }

        public void setMatchMenus(boolean matchMenus) {
            this.matchMenus = matchMenus;
            this.writePrefs();
        }

        public boolean isMatchMessages() {
            return this.matchMessages;
        }

        public void setMatchMessages(boolean matchMessages) {
            this.matchMessages = matchMessages;
            this.writePrefs();
        }

        public void setFrom(SearchParameters searchParameters) {
            this.searchString = searchParameters.getSearchString();
            this.matchCase = searchParameters.isMatchCase();
            this.matchNames = searchParameters.isMatchNames();
            this.matchTypes = searchParameters.isMatchTypes();
            this.matchAdvanced = searchParameters.isMatchAdvanced();
            this.matchTraits = searchParameters.isMatchTraits();
            this.matchExpressions = searchParameters.isMatchExpressions();
            this.matchProperties = searchParameters.isMatchProperties();
            this.matchKeys = searchParameters.isMatchKeys();
            this.matchMenus = searchParameters.isMatchMenus();
            this.matchMessages = searchParameters.isMatchMessages();
            this.writePrefs();
        }

        public void writePrefs() {
            if (prefs != null) {
                prefs.setValue(SEARCH_STRING, this.searchString);
                prefs.setValue(MATCH_CASE, this.matchCase);
                prefs.setValue(MATCH_NAMES, this.matchNames);
                prefs.setValue(MATCH_TYPES, this.matchTypes);
                prefs.setValue(MATCH_ADVANCED, this.matchAdvanced);
                prefs.setValue(MATCH_TRAITS, this.matchTraits);
                prefs.setValue(MATCH_EXPRESSIONS, this.matchExpressions);
                prefs.setValue(MATCH_PROPERTIES, this.matchProperties);
                prefs.setValue(MATCH_KEYS, this.matchKeys);
                prefs.setValue(MATCH_MENUS, this.matchMenus);
                prefs.setValue(MATCH_MESSAGES, this.matchMessages);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchParameters that = (SearchParameters)o;
            return this.isMatchCase() == that.isMatchCase() && this.isMatchNames() == that.isMatchNames() && this.isMatchTypes() == that.isMatchTypes() && this.isMatchTraits() == that.isMatchTraits() && this.isMatchAdvanced() == that.isMatchAdvanced() && this.isMatchExpressions() == that.isMatchExpressions() && this.isMatchProperties() == that.isMatchProperties() && this.isMatchKeys() == that.isMatchKeys() && this.isMatchMenus() == that.isMatchMenus() && this.isMatchMessages() == that.isMatchMessages() && this.getSearchString().equals(that.getSearchString());
        }

        public int hashCode() {
            return Objects.hash(this.getSearchString(), this.isMatchCase(), this.isMatchNames(), this.isMatchTypes(), this.isMatchAdvanced(), this.isMatchTraits(), this.isMatchExpressions(), this.isMatchProperties(), this.isMatchKeys(), this.isMatchMenus(), this.isMatchMessages());
        }
    }

    class TreeTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        DataFlavor nodesFlavor;
        DataFlavor[] flavors = new DataFlavor[1];

        public TreeTransferHandler() {
            try {
                String mimeType = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
                this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
            }
            catch (ClassNotFoundException e) {
                System.out.println("Class Not Found: " + e.getMessage());
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            ExtensionTree xTree;
            if (!support.isDrop()) {
                return false;
            }
            support.setShowDropLocation(true);
            if (!support.isDataFlavorSupported(this.nodesFlavor)) {
                return false;
            }
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            JTree tree = (JTree)support.getComponent();
            int dropRow = tree.getRowForPath(dl.getPath());
            int[] selRows = tree.getSelectionRows();
            if (selRows == null) {
                return false;
            }
            for (int selRow : selRows) {
                if (selRow != dropRow) continue;
                return false;
            }
            TreePath dest = dl.getPath();
            DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)dest.getLastPathComponent();
            TreePath path = tree.getPathForRow(selRows[0]);
            DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Configurable target = (Configurable)targetNode.getUserObject();
            if (!ConfigureTree.this.isValidPasteTarget(target, firstNode)) {
                return false;
            }
            if (tree instanceof ExtensionTree && !(xTree = (ExtensionTree)tree).isEditable(firstNode)) {
                return false;
            }
            int action = support.getDropAction();
            if (action == 2) {
                return !targetNode.isNodeAncestor(firstNode);
            }
            return true;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTree tree = (JTree)c;
            TreePath[] paths = tree.getSelectionPaths();
            if (paths != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[]{node};
                return new NodesTransferable(nodes);
            }
            return null;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            DefaultMutableTreeNode[] nodes = null;
            try {
                Transferable t = support.getTransferable();
                nodes = (DefaultMutableTreeNode[])t.getTransferData(this.nodesFlavor);
            }
            catch (UnsupportedFlavorException ufe) {
                System.out.println("Unsupported Flavor: " + ufe.getMessage());
            }
            catch (IOException ioe) {
                System.out.println("I/O error: " + ioe.getMessage());
            }
            if (nodes == null) {
                return false;
            }
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            TreePath dest = dl.getPath();
            DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)dest.getLastPathComponent();
            Configurable target = (Configurable)targetNode.getUserObject();
            DefaultMutableTreeNode sourceNode = nodes[0];
            int childIndex = dl.getChildIndex();
            if (childIndex < 0) {
                childIndex = sourceNode.getParent() == targetNode ? 0 : targetNode.getChildCount();
            }
            if ((childIndex = ConfigureTree.this.checkMinimumIndex(targetNode, childIndex)) > targetNode.getChildCount()) {
                childIndex = targetNode.getChildCount();
            }
            if ((support.getDropAction() & 2) == 2) {
                if (!targetNode.isNodeAncestor(sourceNode)) {
                    Configurable cutObj = (Configurable)sourceNode.getUserObject();
                    Configurable convertedCutObj = ConfigureTree.this.convertChild(target, cutObj);
                    if (sourceNode.getParent() == targetNode) {
                        int oldIndex = targetNode.getIndex(sourceNode);
                        if (childIndex > oldIndex) {
                            --childIndex;
                        }
                        if (childIndex == oldIndex) {
                            return true;
                        }
                    }
                    if (ConfigureTree.this.remove(ConfigureTree.this.getParent(sourceNode), cutObj)) {
                        ConfigureTree.this.insert(target, convertedCutObj, childIndex);
                    }
                }
            } else {
                Configurable copyBase = (Configurable)sourceNode.getUserObject();
                Buildable clone = null;
                try {
                    clone = ConfigureTree.this.convertChild(target, (Configurable)copyBase.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, copyBase.getClass());
                }
                if (clone != null) {
                    clone.build(copyBase.getBuildElement(Builder.createNewDocument()));
                    ConfigureTree.this.insert(target, (Configurable)clone, childIndex);
                    ConfigureTree.this.updateGpIds((Configurable)clone);
                }
            }
            return true;
        }

        public String toString() {
            return this.getClass().getName();
        }

        public class NodesTransferable
        implements Transferable {
            DefaultMutableTreeNode[] nodes;

            public NodesTransferable(DefaultMutableTreeNode[] nodes) {
                this.nodes = nodes;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return this.nodes;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return TreeTransferHandler.this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return TreeTransferHandler.this.nodesFlavor.equals(flavor);
            }
        }
    }

    private static class ConfigureTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private boolean edited = false;

        public ConfigureTreeNode(Object userObject) {
            super(userObject);
        }

        @Override
        public String toString() {
            Object description = "";
            Configurable c = (Configurable)this.getUserObject();
            if (c != null) {
                String desc;
                Object object = description = c.getConfigureName() != null ? c.getConfigureName() : "";
                if (c instanceof GlobalProperty && !(desc = ((GlobalProperty)c).getDescription()).isEmpty()) {
                    description = (String)description + " - " + desc;
                }
                if (c instanceof GlobalTranslatableMessage && !(desc = ((GlobalTranslatableMessage)c).getDescription()).isEmpty()) {
                    description = (String)description + " - " + desc;
                }
                description = (String)description + " [" + ConfigureTree.getConfigureName(c.getClass()) + "]";
                if (c instanceof ComponentDescription && (desc = ((ComponentDescription)((Object)c)).getDescription()) != null && !desc.isEmpty()) {
                    description = (String)description + " - " + desc;
                }
            }
            return description;
        }

        public boolean isEdited() {
            return this.edited;
        }

        public void setEdited(boolean edited) {
            this.edited = edited;
        }

        private void resetEditFlags() {
            this.setEdited(false);
            this.resetChildEditFlags();
        }

        public void resetChildEditFlags() {
            if (this.getChildCount() > 0) {
                for (TreeNode node : this.children) {
                    ((ConfigureTreeNode)node).resetEditFlags();
                }
            }
        }
    }

    private static class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ConfigureTree configureTree;
        private final SearchParameters searchParameters;

        public SearchAction(ConfigureTree configureTree, SearchParameters searchParameters) {
            super(configureTree.getSearchCmd());
            this.configureTree = configureTree;
            this.searchParameters = searchParameters;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField search;
            JDialog d = this.configureTree.getSearchDialog();
            if (d != null) {
                search = this.configureTree.getSearchField();
                search.selectAll();
            } else {
                d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.configureTree), false);
                this.configureTree.setSearchDialog(d);
                d.setTitle(this.configureTree.getSearchCmd());
                search = new HintTextField(32, Resources.getString("Editor.search_string"));
                search.setText(this.searchParameters.getSearchString());
                this.configureTree.setSearchField(search);
                search.selectAll();
                JCheckBox sensitive = new JCheckBox(Resources.getString("Editor.search_case"), this.searchParameters.isMatchCase());
                JCheckBox advanced = new JCheckBox(Resources.getString("Editor.search_advanced"), this.searchParameters.isMatchAdvanced());
                JCheckBox names = new JCheckBox(Resources.getString("Editor.search_names"), this.searchParameters.isMatchNames());
                JCheckBox types = new JCheckBox(Resources.getString("Editor.search_types"), this.searchParameters.isMatchTypes());
                JCheckBox traits = new JCheckBox(Resources.getString("Editor.search_traits"), this.searchParameters.isMatchTraits());
                JCheckBox expressions = new JCheckBox(Resources.getString("Editor.search_expressions"), this.searchParameters.isMatchExpressions());
                JCheckBox properties = new JCheckBox(Resources.getString("Editor.search_properties"), this.searchParameters.isMatchProperties());
                JCheckBox keys = new JCheckBox(Resources.getString("Editor.search_keys"), this.searchParameters.isMatchKeys());
                JCheckBox menus = new JCheckBox(Resources.getString("Editor.search_menus"), this.searchParameters.isMatchMenus());
                JCheckBox messages = new JCheckBox(Resources.getString("Editor.search_messages"), this.searchParameters.isMatchMessages());
                Consumer<Boolean> visSetter = visible -> {
                    names.setVisible((boolean)visible);
                    types.setVisible((boolean)visible);
                    traits.setVisible((boolean)visible);
                    expressions.setVisible((boolean)visible);
                    properties.setVisible((boolean)visible);
                    keys.setVisible((boolean)visible);
                    menus.setVisible((boolean)visible);
                    messages.setVisible((boolean)visible);
                };
                advanced.addChangeListener(l -> {
                    visSetter.accept(advanced.isSelected());
                    SwingUtils.repack(this.configureTree.getSearchDialog());
                });
                visSetter.accept(advanced.isSelected());
                this.configureTree.setSearchAdvanced(advanced);
                JButton find = new JButton(Resources.getString("Editor.search_next"));
                find.addActionListener(e12 -> {
                    boolean anyChanges;
                    SearchParameters parametersSetInDialog = new SearchParameters(search.getText(), sensitive.isSelected(), names.isSelected(), types.isSelected(), true, traits.isSelected(), expressions.isSelected(), properties.isSelected(), keys.isSelected(), menus.isSelected(), messages.isSelected());
                    boolean bl = anyChanges = !this.searchParameters.equals(parametersSetInDialog);
                    if (anyChanges) {
                        this.searchParameters.setFrom(parametersSetInDialog);
                    }
                    if (!(this.searchParameters.isMatchNames() || this.searchParameters.isMatchTypes() || !this.searchParameters.isMatchAdvanced() || this.searchParameters.isMatchTraits() || this.searchParameters.isMatchExpressions() || this.searchParameters.isMatchProperties() || this.searchParameters.isMatchKeys() || this.searchParameters.isMatchMenus() || this.searchParameters.isMatchMessages())) {
                        this.searchParameters.setMatchNames(true);
                        names.setSelected(true);
                        ConfigureTree.chat(Resources.getString("Editor.search_all_off"));
                    }
                    if (!this.searchParameters.getSearchString().isEmpty()) {
                        DefaultMutableTreeNode node;
                        if (anyChanges) {
                            int matches = this.getNumMatches(this.searchParameters.getSearchString());
                            ConfigureTree.chat(matches + " " + Resources.getString("Editor.search_count") + ConfigureTree.noHTML(this.searchParameters.getSearchString()));
                        }
                        if ((node = this.findNode(this.searchParameters.getSearchString())) != null) {
                            TreePath path = new TreePath(node.getPath());
                            this.configureTree.setSelectionPath(path);
                            this.configureTree.scrollPathToVisible(path);
                            if (this.searchParameters.isMatchAdvanced()) {
                                this.showHitList(node, this.searchParameters.getSearchString());
                            }
                        } else {
                            ConfigureTree.chat(Resources.getString("Editor.search_none_found") + ConfigureTree.noHTML(this.searchParameters.getSearchString()));
                        }
                    }
                });
                JButton cancel = new JButton(Resources.getString("General.cancel"));
                cancel.addActionListener(e1 -> this.configureTree.getSearchDialog().setVisible(false));
                JButton help = new JButton(Resources.getString("General.help"));
                help.addActionListener(e2 -> this.showSearchHelp());
                d.setLayout((LayoutManager)new MigLayout("", "[fill]"));
                JPanel panel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1,gapy 4", "[fill]"));
                panel.setBorder(BorderFactory.createEtchedBorder());
                panel.add(search);
                panel.add(sensitive);
                panel.add(advanced);
                panel.add(names);
                panel.add(types);
                panel.add(traits);
                panel.add(expressions);
                panel.add(properties);
                panel.add(keys);
                panel.add(menus);
                panel.add(messages);
                JPanel bPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
                bPanel.add((Component)find, "tag ok,sg 1");
                bPanel.add((Component)cancel, "tag cancel,sg 1");
                bPanel.add((Component)help, "tag help,sg 1");
                panel.add((Component)bPanel, "grow");
                d.add((Component)panel, "grow");
                d.getRootPane().setDefaultButton(find);
                KeyStroke k = KeyStroke.getKeyStroke(27, 0);
                d.getRootPane().registerKeyboardAction(ee -> this.configureTree.getSearchDialog().setVisible(false), k, 2);
            }
            search.requestFocus();
            if (!d.isVisible()) {
                d.setLocationRelativeTo(d.getParent());
                SwingUtils.repack(d);
                d.setVisible(true);
            }
        }

        private void showSearchHelp() {
        }

        private DefaultMutableTreeNode findNode(String searchString) {
            List<DefaultMutableTreeNode> searchNodes = this.configureTree.getSearchNodes((DefaultMutableTreeNode)this.configureTree.getModel().getRoot());
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)this.configureTree.getLastSelectedPathComponent();
            int bookmark = -1;
            if (currentNode != null) {
                bookmark = IntStream.range(0, searchNodes.size()).filter(i -> searchNodes.get(i) == currentNode).findFirst().orElse(-1);
            }
            Predicate<DefaultMutableTreeNode> nodeMatchesSearchString = node -> this.checkNode((DefaultMutableTreeNode)node, searchString);
            DefaultMutableTreeNode foundNode = searchNodes.stream().skip(bookmark + 1).filter(nodeMatchesSearchString).findFirst().orElse(null);
            if (foundNode != null) {
                return foundNode;
            }
            return searchNodes.stream().limit(bookmark + 1).filter(nodeMatchesSearchString).findFirst().orElse(null);
        }

        private int getNumMatches(String searchString) {
            List<DefaultMutableTreeNode> searchNodes = this.configureTree.getSearchNodes((DefaultMutableTreeNode)this.configureTree.getModel().getRoot());
            return (int)searchNodes.stream().filter(node -> this.checkNode((DefaultMutableTreeNode)node, searchString)).count();
        }

        private boolean checkSearchTarget(SearchTarget st, String searchString) {
            List<String> msgs;
            List<String> menus;
            List<NamedKeyStroke> keys;
            List<String> props;
            List<String> exps;
            if (this.searchParameters.isMatchExpressions() && (exps = st.getExpressionList()) != null) {
                for (String s : exps) {
                    if (StringUtils.isEmpty((CharSequence)s) || !this.checkString(s, searchString)) continue;
                    return true;
                }
            }
            if (this.searchParameters.isMatchProperties() && (props = st.getPropertyList()) != null) {
                for (String s : props) {
                    if (StringUtils.isEmpty((CharSequence)s) || !this.checkString(s, searchString)) continue;
                    return true;
                }
            }
            if (this.searchParameters.isMatchKeys() && (keys = st.getNamedKeyStrokeList()) != null) {
                for (NamedKeyStroke k : keys) {
                    String s;
                    if (k == null || StringUtils.isEmpty((CharSequence)(s = k.isNamed() ? k.getName() : KeyNamer.getKeyString(k.getStroke()))) || !this.checkString(s, searchString)) continue;
                    return true;
                }
            }
            if (this.searchParameters.isMatchMenus() && (menus = st.getMenuTextList()) != null) {
                for (String s : menus) {
                    if (StringUtils.isEmpty((CharSequence)s) || !this.checkString(s, searchString)) continue;
                    return true;
                }
            }
            if (this.searchParameters.isMatchMessages() && (msgs = st.getFormattedStringList()) != null) {
                for (String s : msgs) {
                    if (StringUtils.isEmpty((CharSequence)s) || !this.checkString(s, searchString)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkNode(DefaultMutableTreeNode node, String searchString) {
            boolean protoskip;
            GamePiece p;
            String desc;
            String className;
            String objectName;
            Configurable c = (Configurable)node.getUserObject();
            if ((this.searchParameters.isMatchNames() || !this.searchParameters.isMatchAdvanced()) && (objectName = c.getConfigureName()) != null && this.checkString(objectName, searchString)) {
                return true;
            }
            if ((this.searchParameters.isMatchTypes() || !this.searchParameters.isMatchAdvanced()) && (className = ConfigureTree.getConfigureName(c.getClass())) != null && this.checkString(className, searchString)) {
                return true;
            }
            if ((this.searchParameters.isMatchNames() && this.searchParameters.isMatchTypes() || !this.searchParameters.isMatchAdvanced()) && c instanceof ComponentDescription && (desc = ((ComponentDescription)((Object)c)).getDescription()) != null && this.checkString(desc, searchString)) {
                return true;
            }
            if (!this.searchParameters.isMatchAdvanced()) {
                return false;
            }
            if (c instanceof GamePiece) {
                p = (GamePiece)((Object)c);
                protoskip = false;
            } else if (c instanceof PieceSlot) {
                p = ((PieceSlot)c).getPiece();
                protoskip = false;
            } else if (c instanceof PrototypeDefinition) {
                p = ((PrototypeDefinition)c).getPiece();
                protoskip = true;
            } else {
                if (c instanceof SearchTarget) {
                    return this.checkSearchTarget((SearchTarget)((Object)c), searchString);
                }
                return false;
            }
            ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
            pieces.add(p);
            while (p instanceof Decorator) {
                p = ((Decorator)p).getInner();
                pieces.add(p);
            }
            Collections.reverse(pieces);
            for (GamePiece piece : pieces) {
                if (!protoskip) {
                    String desc2;
                    if (this.searchParameters.isMatchTraits() && piece instanceof EditablePiece && (desc2 = ((EditablePiece)piece).getDescription()) != null && this.checkString(desc2, searchString)) {
                        return true;
                    }
                    if (piece instanceof SearchTarget && this.checkSearchTarget((SearchTarget)((Object)piece), searchString)) {
                        return true;
                    }
                }
                protoskip = false;
            }
            return false;
        }

        private void hitCheck(String s, String searchString, String matchString, String item, String desc, String show, TargetProgress progress) {
            if (!StringUtils.isEmpty((CharSequence)s) && this.checkString(s, searchString)) {
                progress.checkShowTrait(matchString, item, desc);
                ConfigureTree.chat("&nbsp;&nbsp;&nbsp;&nbsp;{" + show + "} " + ConfigureTree.noHTML(s));
            }
        }

        private void stringListHits(Boolean flag, List<String> strings, String searchString, String matchString, String item, String desc, String show, TargetProgress progress) {
            if (!flag.booleanValue() || strings == null) {
                return;
            }
            for (String s : strings) {
                this.hitCheck(s, searchString, matchString, item, desc, show, progress);
            }
        }

        private void keyListHits(Boolean flag, List<NamedKeyStroke> keys, String searchString, String matchString, String item, String desc, String show, TargetProgress progress) {
            if (!flag.booleanValue() || keys == null) {
                return;
            }
            for (NamedKeyStroke k : keys) {
                if (k == null) continue;
                String s = k.isNamed() ? k.getName() : KeyNamer.getKeyString(k.getStroke());
                this.hitCheck(s, searchString, matchString, item, desc, show, progress);
            }
        }

        private void showConfigurableHitList(DefaultMutableTreeNode node, String searchString) {
            Configurable c = (Configurable)node.getUserObject();
            if (!(c instanceof SearchTarget)) {
                return;
            }
            String name = (c.getConfigureName() != null ? c.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(c.getClass()) + "]";
            String matchString = "<b><u>Matches for " + ConfigureTree.noHTML(name) + ": </u></b>";
            SearchTarget st = (SearchTarget)((Object)c);
            String item = ConfigureTree.getConfigureName(c.getClass());
            TargetProgress progress = new TargetProgress();
            this.stringListHits(this.searchParameters.isMatchNames() || !this.searchParameters.isMatchAdvanced(), Arrays.asList(c.getConfigureName()), searchString, matchString, item, "", "Name", progress);
            this.stringListHits(this.searchParameters.isMatchTypes() || !this.searchParameters.isMatchAdvanced(), Arrays.asList(item), searchString, matchString, item, "", "Type", progress);
            if (c instanceof ComponentDescription) {
                this.stringListHits(this.searchParameters.isMatchNames() && this.searchParameters.isMatchTypes() || !this.searchParameters.isMatchAdvanced(), Arrays.asList(((ComponentDescription)((Object)c)).getDescription()), searchString, matchString, item, "", "Description", progress);
            }
            this.stringListHits(this.searchParameters.isMatchExpressions(), st.getExpressionList(), searchString, matchString, item, "", "Expression", progress);
            this.stringListHits(this.searchParameters.isMatchProperties(), st.getPropertyList(), searchString, matchString, item, "", "Property", progress);
            this.stringListHits(this.searchParameters.isMatchMenus(), st.getMenuTextList(), searchString, matchString, item, "", "UI Text", progress);
            this.stringListHits(this.searchParameters.isMatchMessages(), st.getFormattedStringList(), searchString, matchString, item, "", "Message/Field", progress);
            this.keyListHits(this.searchParameters.isMatchKeys(), st.getNamedKeyStrokeList(), searchString, matchString, item, "", "KeyCommand", progress);
        }

        private void showHitList(DefaultMutableTreeNode node, String searchString) {
            boolean protoskip;
            GamePiece p;
            Configurable c = (Configurable)node.getUserObject();
            if (c instanceof GamePiece) {
                p = (GamePiece)((Object)c);
                protoskip = false;
            } else if (c instanceof PieceSlot) {
                p = ((PieceSlot)c).getPiece();
                protoskip = false;
            } else if (c instanceof PrototypeDefinition) {
                p = ((PrototypeDefinition)c).getPiece();
                protoskip = true;
            } else {
                this.showConfigurableHitList(node, searchString);
                return;
            }
            String name = (c.getConfigureName() != null ? c.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(c.getClass()) + "]";
            TargetProgress progress = new TargetProgress();
            String matchString = "<b><u>Matches for " + name + ": </u></b>";
            this.stringListHits(this.searchParameters.isMatchNames(), Arrays.asList(c.getConfigureName()), searchString, matchString, protoskip ? "Prototype Definition" : "Game Piece", "", "Name", progress);
            this.stringListHits(this.searchParameters.isMatchTypes(), Arrays.asList(ConfigureTree.getConfigureName(c.getClass())), searchString, matchString, protoskip ? "Prototype Definition" : "Game Piece", "", "Type", progress);
            ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
            pieces.add(p);
            while (p instanceof Decorator) {
                p = ((Decorator)p).getInner();
                pieces.add(p);
            }
            Collections.reverse(pieces);
            for (GamePiece piece : pieces) {
                if (!protoskip && piece instanceof EditablePiece && piece instanceof Decorator) {
                    String desc = ((EditablePiece)piece).getDescription();
                    Decorator d = (Decorator)piece;
                    progress.startNewTrait();
                    if (this.searchParameters.isMatchTraits() && desc != null && this.checkString(desc, searchString)) {
                        progress.checkShowTrait(matchString, "Trait", desc);
                    }
                    this.stringListHits(this.searchParameters.isMatchExpressions(), d.getExpressionList(), searchString, matchString, "Trait", desc, "Expression", progress);
                    this.stringListHits(this.searchParameters.isMatchProperties(), d.getPropertyList(), searchString, matchString, "Trait", desc, "Property", progress);
                    this.stringListHits(this.searchParameters.isMatchMenus(), d.getMenuTextList(), searchString, matchString, "Trait", desc, "UI Text", progress);
                    this.stringListHits(this.searchParameters.isMatchMessages(), d.getFormattedStringList(), searchString, matchString, "Trait", desc, "Message/Field", progress);
                    this.keyListHits(this.searchParameters.isMatchKeys(), d.getNamedKeyStrokeList(), searchString, matchString, "Trait", desc, "KeyCommand", progress);
                }
                protoskip = false;
            }
        }

        private boolean checkString(String target, String searchString) {
            if (this.searchParameters.isMatchCase()) {
                return target.contains(searchString);
            }
            return target.toLowerCase().contains(searchString.toLowerCase());
        }

        private static class TargetProgress {
            public boolean targetShown = false;
            public boolean traitShown = false;

            private TargetProgress() {
            }

            void startNewTrait() {
                this.traitShown = false;
            }

            void checkShowPiece(String matchString) {
                if (!this.targetShown) {
                    this.targetShown = true;
                    ConfigureTree.chat(matchString);
                }
            }

            void checkShowTrait(String matchString, String idString, String desc) {
                this.checkShowPiece(matchString);
                if (!this.traitShown) {
                    this.traitShown = true;
                    ConfigureTree.chat("&nbsp;&nbsp;{" + idString + "} " + (desc != null ? desc : ""));
                }
            }
        }
    }

    protected static class AdditionalComponent {
        Class<? extends Buildable> parent;
        Class<? extends Buildable> child;

        public AdditionalComponent(Class<? extends Buildable> p, Class<? extends Buildable> c) {
            this.parent = p;
            this.child = c;
        }

        public Class<? extends Buildable> getParent() {
            return this.parent;
        }

        public Class<? extends Buildable> getChild() {
            return this.child;
        }
    }

    public static interface Mutable {
    }
}

