/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.Info;
import VASSAL.build.GameModule;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.stream.Stream;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class BugUtils {
    private BugUtils() {
    }

    public static void sendBugReport(String email, String description, String errorLog, Throwable t) throws IOException {
        block14: {
            MultipartEntityBuilder b = MultipartEntityBuilder.create();
            b.setCharset(StandardCharsets.UTF_8);
            b.addTextBody("version", Info.getReportableVersion());
            b.addTextBody("email", email);
            b.addTextBody("summary", BugUtils.getSummary(t));
            b.addTextBody("description", BugUtils.getDescription(description, errorLog));
            b.addBinaryBody("log", errorLog.getBytes(StandardCharsets.UTF_8), ContentType.TEXT_PLAIN, Info.getErrorLogPath().getName());
            String url = "https://vassalengine.org/util/abr";
            HttpPost httpPost = new HttpPost("https://vassalengine.org/util/abr");
            httpPost.setEntity(b.build());
            try (CloseableHttpClient client = HttpClients.createDefault();
                 CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpPost);){
                if (response.getCode() == 201) break block14;
                String msg = "Bug report failed: " + response.getCode();
                String responseText = null;
                try {
                    responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (ParseException e) {
                    throw new IOException(msg, e);
                }
                throw new IOException(msg + ": " + responseText);
            }
        }
    }

    private static String getDescription(String description, String errorLog) {
        GameModule g = GameModule.getGameModule();
        return description + "\n\n" + (String)(g == null ? "" : g.getGameName() + " v" + g.getGameModule().getGameVersion() + " ") + Info.getVersion() + "\n\n" + BugUtils.getStackTraceSummary(errorLog);
    }

    private static String getStackTraceSummary(String errorLog) {
        StringBuilder summary = new StringBuilder();
        Stream<String> log = errorLog.substring(errorLog.lastIndexOf("ERROR VASSAL.tools.ErrorDialog")).lines();
        log.skip(1L).limit(5L).forEach(l -> summary.append(l.replace('\t', ' ')).append('\n'));
        return summary.toString();
    }

    private static String getSummary(Throwable t) {
        Object summary;
        GameModule g = GameModule.getGameModule();
        Object object = summary = g == null ? "" : "[" + g.getGameName() + "] ";
        if (t == null) {
            summary = (String)summary + "Automated Bug Report";
        } else {
            String tc = t.getClass().getName();
            summary = (String)summary + tc.substring(tc.lastIndexOf(46) + 1);
            if (t.getMessage() != null) {
                summary = (String)summary + ": " + t.getMessage();
            }
        }
        return summary;
    }

    public static String getErrorLog() {
        File f = Info.getErrorLogPath();
        try {
            return Files.readString(f.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
    }
}

