/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameState;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.Replace;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.ComponentPathBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SavedGameUpdater {
    public Properties getPieceSlotsMap() {
        Properties p = new Properties();
        ArrayList<Configurable> l = new ArrayList<Configurable>();
        this.findPieceSlots(l, p);
        return p;
    }

    public void updateSavedGame(Properties pieceSlot, File savedGame) throws IOException {
        GamePiece[] gp_array;
        GameState gs = GameModule.getGameModule().getGameState();
        gs.setup(false, true);
        gs.loadGameInBackground(savedGame);
        while (!gs.isGameStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (GamePiece p : gp_array = gs.getAllPieces().toArray(new GamePiece[0])) {
            if (p instanceof Stack) continue;
            String slotId = pieceSlot.getProperty(p.getType());
            if (slotId != null) {
                Configurable[] path = null;
                try {
                    PieceSlot slot;
                    path = ComponentPathBuilder.getInstance().getPath(slotId);
                    if (path == null || path.length <= 0 || !(path[path.length - 1] instanceof PieceSlot) || (slot = (PieceSlot)path[path.length - 1]).getPiece().getType().equals(p.getType())) continue;
                    if (!(p instanceof Decorator)) {
                        GameModule.getGameModule().getChatter().show(Resources.getString("Editor.SavedGameUpdater.basic_only", p.getName()));
                        continue;
                    }
                    ReplaceTrait r = new ReplaceTrait(p, slot.getPiece());
                    r.replacePiece();
                }
                catch (ComponentPathBuilder.PathFormatException ex) {
                    GameModule.getGameModule().getChatter().show(Resources.getString("Editor.SavedGameUpdater.unable", p.getName(), ex.getMessage()));
                }
                continue;
            }
            GameModule.getGameModule().getChatter().show(Resources.getString("Editor.SavedGameUpdater.no_slot", p.getName()));
            GameModule.getGameModule().getChatter().show(p.getType());
        }
        gs.saveGame(savedGame);
        gs.updateDone();
    }

    protected void findPieceSlots(List<Configurable> l, Properties p) {
        GameModule last;
        Configurable configurable = last = l.isEmpty() ? GameModule.getGameModule() : l.get(l.size() - 1);
        if (last instanceof PieceSlot) {
            PieceSlot slot = (PieceSlot)((Object)last);
            GamePiece clone = PieceCloner.getInstance().clonePiece(slot.getPiece());
            p.setProperty(clone.getType(), ComponentPathBuilder.getInstance().getId(l.toArray(new Configurable[0])));
        } else {
            Configurable[] children;
            for (Configurable child : children = last.getConfigureComponents()) {
                l.add(child);
                this.findPieceSlots(l, p);
                l.remove(child);
            }
        }
    }

    private static class ReplaceTrait
    extends Replace {
        private final GamePiece replacement;

        public ReplaceTrait(GamePiece original, GamePiece replacement) {
            super("replace;Replace;R;dummy;;0;0;true", original);
            this.setProperty("Outer", original);
            original.setProperty("Outer", null);
            this.replacement = replacement;
        }

        @Override
        public GamePiece createMarker() {
            GamePiece marker = PieceCloner.getInstance().clonePiece(this.replacement);
            if (this.matchRotation) {
                this.matchTraits(this.getInner(), marker);
            }
            return marker;
        }

        @Override
        public Command replacePiece() {
            return super.replacePiece();
        }
    }
}

