/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.configure.HintTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LayerUI;

public class StringConfigurer
extends Configurer {
    protected JPanel p;
    protected JTextField nameField;
    protected int length;
    protected static final int DEFAULT_LENGTH = 16;
    @Deprecated(since="2021-12-04", forRemoval=true)
    protected static final int DEFAULT_LENGHTH = 16;

    public StringConfigurer(String key, String name, int length, String hint, String val) {
        super(key, name, val);
        this.length = length > 0 ? length : 16;
        this.hint = hint;
    }

    public StringConfigurer(String key, String name, String val) {
        this(key, name, 16, "", val);
    }

    public StringConfigurer(String key, String name, int length) {
        this(key, name, length, "", "");
    }

    public StringConfigurer(String key, String name) {
        this(key, name, "");
    }

    public StringConfigurer(String val) {
        this(null, "", val);
    }

    @Override
    public String getValueString() {
        return (String)this.value;
    }

    @Override
    public void setValue(String s) {
        if (!this.noUpdate && this.nameField != null) {
            this.nameField.setText(s);
        }
        this.setValue((Object)s);
    }

    protected String getGrowthConstraint() {
        return "growx";
    }

    @Override
    public void requestFocus() {
        if (this.nameField != null) {
            this.nameField.requestFocus();
        }
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new ConfigurerPanel(this.getName(), "[fill,grow]0[0]", "[][fill,grow][]");
            this.nameField = this.buildTextField();
            this.nameField.setMaximumSize(new Dimension(this.nameField.getMaximumSize().width, this.nameField.getPreferredSize().height));
            this.nameField.setText(this.getValueString());
            ConfigLayerUI layerUI = new ConfigLayerUI(this);
            JLayer<JTextField> layer = new JLayer<JTextField>(this.nameField, layerUI);
            this.p.add(layer, this.getGrowthConstraint());
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                private void update() {
                    StringConfigurer.this.noUpdate = true;
                    StringConfigurer.this.setValue(StringConfigurer.this.nameField.getText());
                    StringConfigurer.this.noUpdate = false;
                }
            });
        }
        return this.p;
    }

    protected JTextField buildTextField() {
        return new HintTextField(this.length, this.hint);
    }

    public void updateHint(String hint) {
        this.setHint(hint);
        ((HintTextField)this.nameField).setHint(hint);
    }

    @Override
    public void setLabelVisibile(boolean visible) {
        if (this.p instanceof ConfigurerPanel) {
            ((ConfigurerPanel)this.p).setLabelVisibility(visible);
        }
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.getControls();
        this.nameField.setBackground(highlighted ? LIST_ENTRY_HIGHLIGHT_COLOR : Color.white);
        this.nameField.repaint();
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.getControls();
        this.nameField.addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.getControls();
        this.nameField.removeFocusListener(listener);
    }

    private static class ConfigLayerUI
    extends LayerUI<JTextField> {
        private static final long serialVersionUID = 1L;
        private final Configurer parent;

        public ConfigLayerUI(Configurer parent) {
            this.parent = parent;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            Object cc = ((JLayer)c).getView();
            if (this.parent.isHighlighted()) {
                Dimension d = ((Component)cc).getSize();
                g.setColor(Color.red);
                g.drawRect(0, 0, d.width - 2, d.height - 2);
            }
        }
    }
}

