/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.Configurable;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceDefiner;
import VASSAL.counters.PieceEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MassPieceDefiner
extends PieceDefiner {
    private static final long serialVersionUID = 1L;
    protected List<Entry> definers = new ArrayList<Entry>();

    public MassPieceDefiner(Configurable top) {
        this.changed = false;
        this.init(top);
        if (!this.definers.isEmpty()) {
            this.setPiece(this.definers.get((int)0).slot.getPiece());
            List<Class<? extends GamePiece>> template = this.getTemplate();
            for (int i = 0; i < this.definers.size(); ++i) {
                GamePiece p = this.definers.get((int)i).definer.getPiece();
                if (this.matchesTemplate(p, template)) continue;
                this.definers.remove(i--);
            }
        }
    }

    private void init(Configurable c) {
        Configurable[] child;
        if (c instanceof PieceSlot) {
            Def def = new Def();
            def.setPiece(((PieceSlot)c).getPiece());
            this.definers.add(new Entry((PieceSlot)c, def));
        }
        for (Configurable configurable : child = c.getConfigureComponents()) {
            this.init(configurable);
        }
    }

    private List<Class<? extends GamePiece>> getTemplate() {
        GamePiece p = this.definers.get((int)0).definer.getPiece();
        ArrayList<Class<? extends GamePiece>> types = new ArrayList<Class<? extends GamePiece>>();
        while (p instanceof Decorator) {
            types.add(p.getClass());
            p = ((Decorator)p).piece;
        }
        types.add(p.getClass());
        return types;
    }

    private boolean matchesTemplate(GamePiece p, List<Class<? extends GamePiece>> template) {
        Iterator<Class<? extends GamePiece>> i = template.iterator();
        while (p instanceof Decorator && i.hasNext()) {
            if (p.getClass() != i.next()) {
                return false;
            }
            p = ((Decorator)p).piece;
        }
        return i.hasNext() && p.getClass() == i.next() && !i.hasNext();
    }

    @Override
    protected void addTrait(Decorator c) {
        super.addTrait(c);
        for (Entry e : this.definers) {
            e.definer.addTrait(c);
        }
    }

    @Override
    protected void addTrait(Decorator c, int insertIndex) {
        super.addTrait(c, insertIndex);
        for (Entry e : this.definers) {
            e.definer.addTrait(c, insertIndex);
        }
    }

    @Override
    protected void removeTrait(int index) {
        super.removeTrait(index);
        for (Entry e : this.definers) {
            e.definer.removeTrait(index);
        }
    }

    @Override
    protected void moveDecoratorUp(int index) {
        super.moveDecoratorUp(index);
        for (Entry e : this.definers) {
            e.definer.moveDecoratorUp(index);
        }
    }

    @Override
    protected void moveDecoratorDown(int index) {
        super.moveDecoratorDown(index);
        for (Entry e : this.definers) {
            e.definer.moveDecoratorDown(index);
        }
    }

    @Override
    protected void paste() {
        super.paste();
        for (Entry e : this.definers) {
            e.definer.paste();
        }
    }

    @Override
    protected boolean edit(int index) {
        boolean result = super.edit(index);
        for (Entry e : this.definers) {
            e.definer.edit(index);
        }
        return result;
    }

    public void save() {
        for (Entry e : this.definers) {
            e.slot.setPiece(e.definer.getPiece());
        }
    }

    private static class Entry {
        private final PieceSlot slot;
        private final PieceDefiner definer;

        private Entry(PieceSlot slot, PieceDefiner definer) {
            this.slot = slot;
            this.definer = definer;
        }
    }

    private class Def
    extends PieceDefiner {
        private static final long serialVersionUID = 1L;

        private Def() {
        }

        @Override
        protected boolean edit(int index) {
            Object o = MassPieceDefiner.this.inUseModel.elementAt(index);
            if (!(o instanceof EditablePiece)) {
                return false;
            }
            PieceEditor template = ((EditablePiece)o).getEditor();
            EditablePiece myPiece = (EditablePiece)this.inUseModel.elementAt(index);
            myPiece.mySetType(template.getType());
            if (myPiece instanceof Decorator) {
                ((Decorator)myPiece).mySetState(template.getState());
            } else {
                myPiece.setState(template.getState());
            }
            return true;
        }
    }
}

