/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class TableInfo
extends Decorator
implements TranslatablePiece {
    public static final String ID = "table;";
    protected String values;
    protected String oldState;
    protected int nRows;
    protected int nCols;
    protected String command;
    protected NamedKeyStroke launchKey;
    protected KeyCommand launch;
    protected JTable table;
    protected JDialog frame;
    protected String description = "";

    public TableInfo() {
        this("table;2;2;" + Resources.getString("Editor.TableInfo.default_command") + ";S", null);
    }

    public TableInfo(String type, GamePiece p) {
        this.mySetType(type);
        this.setInner(p);
    }

    public int getRowCount() {
        return this.nRows;
    }

    public int getColumnCount() {
        return this.nCols;
    }

    @Override
    public void mySetType(String s) {
        s = s.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        this.nRows = st.nextInt(2);
        this.nCols = st.nextInt(2);
        this.command = st.nextToken(Resources.getString("Editor.TableInfo.default_command"));
        this.launchKey = st.nextNamedKeyStroke(null);
        this.description = st.nextToken("");
        this.frame = null;
        this.table = null;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String myGetState() {
        if (this.table == null) {
            return this.values;
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nCols; ++col) {
                String s = (String)this.table.getValueAt(row, col);
                se.append(s == null ? "" : s);
            }
        }
        return se.getValue();
    }

    @Override
    public void mySetState(String state) {
        if (this.table == null) {
            this.values = state;
        } else {
            this.setValues(state);
        }
    }

    private void setValues(String val) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(val, ',');
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nCols; ++col) {
                this.table.setValueAt(st.nextToken(), row, col);
            }
        }
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.nRows).append(this.nCols).append(this.command).append(this.launchKey).append(this.description);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.launch == null) {
            this.launch = new KeyCommand(this.command, this.launchKey, Decorator.getOutermost(this), (TranslatablePiece)this);
        }
        return new KeyCommand[]{this.launch};
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (!this.launch.matches(stroke)) {
            return null;
        }
        if (this.frame == null) {
            JComponent view;
            this.frame = new JDialog((Frame)GameModule.getGameModule().getPlayerWindow(), false);
            this.table = new JTable(this.nRows, this.nCols);
            this.setValues(this.values);
            this.table.setTableHeader(null);
            ScrollPane scroll = new ScrollPane(this.table);
            scroll.getViewport().setPreferredSize(this.table.getPreferredSize());
            this.frame.add(scroll);
            Point p = GameModule.getGameModule().getPlayerWindow().getLocation();
            Map map = this.getMap();
            if (map != null && (view = map.getView()).isShowing()) {
                p = view.getLocationOnScreen();
                Point p2 = map.mapToComponent(this.getPosition());
                p.translate(p2.x, p2.y);
            }
            this.frame.setLocation(p.x, p.y);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    TableInfo.this.table.editingStopped(null);
                    GamePiece outer = Decorator.getOutermost(TableInfo.this);
                    if (outer.getId() != null) {
                        GameModule.getGameModule().sendAndLog(new ChangePiece(outer.getId(), TableInfo.this.oldState, outer.getState()));
                    }
                }
            });
            this.frame.pack();
        }
        this.frame.setTitle(this.getName());
        this.oldState = Decorator.getOutermost(this).getState();
        this.frame.setVisible(true);
        return null;
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.TableInfo.trait_description", this.description);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.TableInfo.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Spreadsheet.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, Resources.getString("Editor.TableInfo.table_info_command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof TableInfo)) {
            return false;
        }
        TableInfo c = (TableInfo)o;
        if (!Objects.equals(this.nRows, c.nRows)) {
            return false;
        }
        if (!Objects.equals(this.nCols, c.nCols)) {
            return false;
        }
        if (!Objects.equals(this.command, c.command)) {
            return false;
        }
        if (!Objects.equals(this.launchKey, c.launchKey)) {
            return false;
        }
        return Objects.equals(this.values, c.values);
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.table != null) {
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nCols; ++col) {
                    l.add((String)this.table.getValueAt(row, col));
                }
            }
        } else {
            l.add(this.values);
        }
        return l;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Collections.singletonList(this.launchKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.command);
    }

    private static class Ed
    implements PieceEditor {
        private final IntConfigurer rowConfig;
        private final IntConfigurer colConfig;
        private final StringConfigurer commandConfig;
        private final NamedHotKeyConfigurer keyConfig;
        private final TraitConfigPanel panel = new TraitConfigPanel();
        private final StringConfigurer descInput;

        public Ed(TableInfo p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.panel.add("Editor.description_label", (Configurer)this.descInput);
            this.commandConfig = new StringConfigurer(p.command);
            this.commandConfig.setHintKey("Editor.menu_command_hint");
            this.panel.add("Editor.menu_command", (Configurer)this.commandConfig);
            this.keyConfig = new NamedHotKeyConfigurer(p.launchKey);
            this.panel.add("Editor.keyboard_command", (Configurer)this.keyConfig);
            this.rowConfig = new IntConfigurer(p.nRows);
            this.panel.add("Editor.TableInfo.number_of_rows", (Configurer)this.rowConfig);
            this.colConfig = new IntConfigurer(p.nCols);
            this.panel.add("Editor.TableInfo.number_of_columns", (Configurer)this.colConfig);
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.rowConfig.getValueString()).append(this.colConfig.getValueString()).append(this.commandConfig.getValueString()).append(this.keyConfig.getValueString()).append(this.descInput.getValueString());
            return TableInfo.ID + se.getValue();
        }

        @Override
        public String getState() {
            StringBuilder buf = new StringBuilder();
            int n = (Integer)this.rowConfig.getValue() * (Integer)this.colConfig.getValue();
            while (--n > 0) {
                buf.append(',');
            }
            return buf.toString();
        }
    }
}

