/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.i18n.Translatable;

public class TranslatableAttribute {
    Translatable component;
    String attributeName;
    String originalValue;

    public TranslatableAttribute(Translatable t, String name, String value) {
        this.component = t;
        this.attributeName = name;
        this.originalValue = value;
    }

    public void applyTranslation(String translation) {
        if (translation != null && translation.length() > 0) {
            this.component.getI18nData().applyTranslation(this.attributeName, translation);
        }
    }

    public String getUntranslatedValue() {
        return this.originalValue;
    }

    public String getKey() {
        return this.component.getI18nData().getFullPrefix() + this.attributeName;
    }

    public boolean isTranslatable() {
        return this.component.getI18nData().isAttributeTranslatable(this.attributeName);
    }
}

