/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.NamedKeyManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class KeyStrokeListener {
    private ActionListener l;
    private KeyStroke key;
    private final List<KeyStrokeSource> sources = new ArrayList<KeyStrokeSource>();

    public KeyStrokeListener(ActionListener l, KeyStroke key) {
        this.l = l;
        this.setKeyStroke(key);
    }

    public KeyStrokeListener(ActionListener l) {
        this(l, null);
    }

    public void setKeyStroke(KeyStroke newKey) {
        KeyStroke sysKey;
        if (newKey != null && newKey.getKeyCode() == 0) {
            newKey = null;
        }
        if (this.key != null && !NamedKeyManager.isNamed(this.key)) {
            sysKey = SwingUtils.genericToSystem(this.key);
            for (KeyStrokeSource s : this.sources) {
                KeyStrokeListener.unregisterKey(this.l, s, sysKey);
            }
        }
        this.key = newKey;
        if (this.key != null && !NamedKeyManager.isNamed(this.key)) {
            sysKey = SwingUtils.genericToSystem(this.key);
            for (KeyStrokeSource s : this.sources) {
                KeyStrokeListener.registerKey(this.l, s, sysKey);
            }
        }
    }

    public KeyStroke getKeyStroke() {
        return this.key;
    }

    public void keyPressed(KeyStroke stroke) {
        if (stroke != null && this.key != null && stroke.equals(SwingUtils.genericToSystem(this.key))) {
            this.l.actionPerformed(new ActionEvent(this, 0, "Direct Invocation"));
        }
    }

    private static void registerKey(ActionListener l, KeyStrokeSource s, KeyStroke k) {
        JComponent c = s.getComponent();
        InputMap imap = c.getInputMap(s.getMode());
        ActionMap amap = c.getActionMap();
        Object o = imap.get(k);
        if (o == null) {
            o = new Object();
            imap.put(k, o);
        }
        amap.put(o, ActionChain.add(amap.get(o), l));
    }

    private static void unregisterKey(ActionListener l, KeyStrokeSource s, KeyStroke k) {
        JComponent c = s.getComponent();
        InputMap imap = c.getInputMap(s.getMode());
        Object o = imap.get(k);
        if (o != null) {
            ActionMap amap = c.getActionMap();
            ActionChain a = ActionChain.remove(amap.get(o), l);
            if (a == null) {
                imap.remove(k);
            }
            amap.put(o, a);
        }
    }

    public void addKeyStrokeSource(KeyStrokeSource src) {
        if (!this.sources.contains(src)) {
            this.sources.add(src);
            if (this.key != null && !NamedKeyManager.isNamed(this.key)) {
                KeyStrokeListener.registerKey(this.l, src, SwingUtils.genericToSystem(this.key));
            }
        }
    }

    public void removeKeyStrokeSource(KeyStrokeSource src) {
        if (this.sources.remove(src) && this.key != null && !NamedKeyManager.isNamed(this.key)) {
            KeyStrokeListener.unregisterKey(this.l, src, SwingUtils.genericToSystem(this.key));
        }
    }

    private static class ActionChain
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ActionListener l;

        public ActionChain(ActionListener l) {
            this.l = l;
        }

        public static ActionChain add(ActionListener l, ActionListener r) {
            ActionChain c = l instanceof ActionChain ? (ActionChain)l : new ActionChain(l);
            c.l = AWTEventMulticaster.add(c.l, r);
            return c;
        }

        public static ActionChain remove(ActionListener l, ActionListener r) {
            if (l instanceof ActionChain) {
                ActionChain c = (ActionChain)l;
                c.l = AWTEventMulticaster.remove(c.l, r);
                return c.l == null ? null : c;
            }
            return (l = AWTEventMulticaster.remove(l, r)) == null ? null : new ActionChain(l);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.l.actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            if (this.l instanceof Action) {
                return ((Action)this.l).isEnabled();
            }
            if (this.l instanceof AWTEventMulticaster) {
                return Arrays.stream((ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.l, ActionListener.class)).anyMatch(el -> !(el instanceof Action) || ((Action)el).isEnabled());
            }
            return true;
        }
    }
}

