/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.Info;
import VASSAL.tools.concurrent.CountingReadWriteLock;
import VASSAL.tools.io.FileArchive;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ZipArchive
implements FileArchive {
    private final Path archive;
    private ZipFile zipFile;
    private boolean modified = false;
    private boolean closed = true;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private final ReadWriteLock rwl = new CountingReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    public ZipArchive(String path) throws IOException {
        this(path, false);
    }

    public ZipArchive(File file) throws IOException {
        this(file, false);
    }

    public ZipArchive(String path, boolean truncate) throws IOException {
        this(Path.of(path, new String[0]), truncate);
    }

    public ZipArchive(File file, boolean truncate) throws IOException {
        this(file.toPath(), truncate);
    }

    public ZipArchive(Path path, boolean truncate) throws IOException {
        this.archive = Objects.requireNonNull(path);
        if (truncate) {
            Files.deleteIfExists(this.archive);
        }
    }

    public ZipArchive(FileArchive src, String dst) throws IOException {
        this(src, Path.of(dst, new String[0]));
    }

    public ZipArchive(FileArchive src, File dst) throws IOException {
        this(src, dst.toPath());
    }

    public ZipArchive(FileArchive src, Path dst) throws IOException {
        this(dst, true);
        byte[] buf = new byte[8192];
        for (String name : src.getFiles()) {
            InputStream in = src.getInputStream(name);
            try {
                OutputStream out = this.getOutputStream(name);
                try {
                    IOUtils.copyLarge((InputStream)in, (OutputStream)out, (byte[])buf);
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        this.flush();
    }

    @Override
    public String getName() {
        return this.archive.toString();
    }

    @Override
    public File getFile() {
        return this.archive.toFile();
    }

    public Path getPath() {
        return this.archive;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry e = this.entries.get(path);
            if (e == null) {
                throw new FileNotFoundException(path + " not in archive");
            }
            InputStream in = null;
            if (e.file != null) {
                in = Files.newInputStream(e.file.toPath(), new OpenOption[0]);
            } else if (this.zipFile != null) {
                in = this.zipFile.getInputStream(e.ze);
            }
            if (in == null) {
                throw new FileNotFoundException(path + " not in archive");
            }
            return new ZipArchiveInputStream(in);
        }
        catch (IOException ex) {
            this.r.unlock();
            throw ex;
        }
    }

    @Override
    public OutputStream getOutputStream(String path) throws IOException {
        return this.getOutputStream(path, true);
    }

    public OutputStream getOutputStream(String path, boolean compress) throws IOException {
        this.w.lock();
        try {
            this.openIfClosed();
            this.modified = true;
            ZipEntry ze = new ZipEntry(path);
            ze.setMethod(compress ? 8 : 0);
            File tf = ZipArchive.makeTempFileFor(path);
            Entry e = new Entry(ze, tf);
            Entry old = this.entries.put(path, e);
            this.deleteEntryTempFile(old);
            return new ZipArchiveOutputStream(Files.newOutputStream(e.file.toPath(), new OpenOption[0]), new CRC32(), e.ze);
        }
        catch (IOException ex) {
            this.w.unlock();
            throw ex;
        }
    }

    @Override
    public void add(String path, String extPath) throws IOException {
        this.add(path, new File(extPath));
    }

    @Override
    public void add(String path, File extPath) throws IOException {
        try (InputStream in = Files.newInputStream(extPath.toPath(), new OpenOption[0]);){
            this.add(path, in);
        }
    }

    @Override
    public void add(String path, byte[] bytes) throws IOException {
        this.add(path, new ByteArrayInputStream(bytes));
    }

    @Override
    public void add(String path, InputStream in) throws IOException {
        try (OutputStream out = this.getOutputStream(path);){
            in.transferTo(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String path) throws IOException {
        this.w.lock();
        try {
            this.openIfClosed();
            Entry e = this.entries.remove(path);
            if (e != null) {
                this.modified = true;
                this.deleteEntryTempFile(e);
            }
            boolean bl = e != null;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void revert() throws IOException {
        this.w.lock();
        try {
            if (!this.modified) {
                return;
            }
            this.deleteEntryTempFiles();
            this.modified = false;
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.w.lock();
        try {
            if (this.modified) {
                this.writeToDisk();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.w.lock();
        try {
            if (this.closed) {
                return;
            }
            if (this.modified) {
                this.writeToDisk();
            } else if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
                this.closed = true;
                this.entries.clear();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private static String extensionOf(String path) {
        int dot = path.lastIndexOf(46);
        return dot == -1 ? "" : path.substring(dot);
    }

    private static boolean illegalFilenameChar(int c) {
        return c < 32 || c == 34 || c == 37 || c == 42 || c == 58 || c == 60 || c == 62 || c == 63 || c == 124;
    }

    private static String escapeFilenameChar(int c) {
        return String.format("%%%1$02X", c);
    }

    private static String sanitize(String filename) {
        int len = filename.length();
        StringBuilder b = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = filename.charAt(i);
            b.append(ZipArchive.illegalFilenameChar(c) ? ZipArchive.escapeFilenameChar(c) : Character.valueOf(c));
        }
        return b.toString();
    }

    private static File makeTempFileFor(String path) throws IOException {
        return ZipArchive.makeTempFileFor(path, Info.getTempDir().toPath());
    }

    private static File makeTempFileFor(String path, Path tmpDir) throws IOException {
        String base = FilenameUtils.getBaseName((String)ZipArchive.sanitize(path)) + "_";
        String ext = ZipArchive.extensionOf(path);
        Files.createDirectories(tmpDir, new FileAttribute[0]);
        try {
            return Files.createTempFile(tmpDir, base, ext, new FileAttribute[0]).toFile();
        }
        catch (IllegalArgumentException e) {
            throw new IOException("failed to create temp file for " + path + " at " + tmpDir.toString() + ", with base " + base + ", ext " + ext, e);
        }
    }

    private static OutputStream openNew(Path p) throws IOException {
        return Files.newOutputStream(p, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }

    private void writeToZip(Path oldArchive, OutputStream out) throws IOException {
        try (BufferedOutputStream bout = new BufferedOutputStream(out);
             ZipOutputStream zout = new ZipOutputStream(bout);){
            zout.setLevel(9);
            if (oldArchive != null) {
                this.writeOldEntries(oldArchive, zout);
            }
            this.writeNewEntries(zout);
        }
    }

    private void writeToDisk() throws IOException {
        boolean zipWasOpen;
        boolean bl = zipWasOpen = this.zipFile != null;
        if (zipWasOpen) {
            this.zipFile.close();
            this.zipFile = null;
        }
        Path bak = null;
        try {
            if (Files.exists(this.archive, new LinkOption[0])) {
                bak = this.archive.resolveSibling(this.archive.getFileName().toString() + ".bak");
                Files.move(this.archive, bak, new CopyOption[0]);
            }
            try (OutputStream out = ZipArchive.openNew(this.archive);){
                this.writeToZip(bak, out);
            }
            catch (IOException e) {
                if (bak == null) {
                    Files.deleteIfExists(this.archive);
                } else {
                    Files.move(bak, this.archive, StandardCopyOption.REPLACE_EXISTING);
                }
                throw e;
            }
        }
        catch (IOException e) {
            if (zipWasOpen) {
                this.zipFile = new ZipFile(this.archive.toFile());
            }
            throw e;
        }
        this.writeCleanup();
        if (bak != null) {
            Files.deleteIfExists(bak);
        }
    }

    private void writeNewEntries(ZipOutputStream zout) throws IOException {
        for (Entry e : this.entries.values()) {
            if (e == null || e.file == null) continue;
            e.ze.setTime(e.file.lastModified());
            zout.putNextEntry(e.ze);
            Files.copy(e.file.toPath(), zout);
        }
    }

    private void writeOldEntries(Path oldArchive, ZipOutputStream zout) throws IOException {
        try (InputStream fin = Files.newInputStream(oldArchive, new OpenOption[0]);
             BufferedInputStream bin = new BufferedInputStream(fin);
             ZipInputStream in = new ZipInputStream(bin);){
            byte[] buf = new byte[8192];
            ZipEntry ze = null;
            while ((ze = in.getNextEntry()) != null) {
                Entry e = this.entries.get(ze.getName());
                if (e == null || e.file != null) continue;
                if (ze.getMethod() == 8) {
                    ZipEntry nze = new ZipEntry(ze.getName());
                    nze.setTime(ze.getTime());
                    ze = nze;
                }
                zout.putNextEntry(ze);
                IOUtils.copyLarge((InputStream)in, (OutputStream)zout, (byte[])buf);
            }
        }
    }

    private void writeCleanup() {
        this.deleteEntryTempFiles();
        this.entries.clear();
        this.closed = true;
        this.modified = false;
    }

    private void deleteEntryTempFile(Entry e) {
        if (e != null && e.file != null) {
            e.file.delete();
        }
    }

    private void deleteEntryTempFiles() {
        this.entries.values().forEach(e -> this.deleteEntryTempFile((Entry)e));
    }

    @Override
    public boolean contains(String path) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            boolean bl = this.entries.containsKey(path);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize(String path) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry e = this.entries.get(path);
            if (e == null) {
                throw new FileNotFoundException(path + " not in archive");
            }
            long l = e.file == null ? e.ze.getSize() : e.file.length();
            return l;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompressedSize(String path) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry e = this.entries.get(path);
            if (e == null) {
                throw new FileNotFoundException(path + " not in archive");
            }
            long l = e.file == null ? e.ze.getCompressedSize() : e.file.length();
            return l;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMTime(String path) throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            Entry e = this.entries.get(path);
            if (e == null) {
                throw new FileNotFoundException(path + " not in archive");
            }
            long l = e.file == null ? e.ze.getTime() : e.file.lastModified();
            return l;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public List<String> getFiles() throws IOException {
        this.r.lock();
        try {
            this.openIfClosed();
            ArrayList<String> arrayList = new ArrayList<String>(this.entries.keySet());
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFiles(String root) throws IOException {
        if (((String)root).length() == 0) {
            return this.getFiles();
        }
        this.r.lock();
        try {
            this.openIfClosed();
            root = (String)root + "/";
            ArrayList<String> names = new ArrayList<String>();
            for (String n : this.entries.keySet()) {
                if (!n.startsWith((String)root)) continue;
                names.add(n);
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    private synchronized void readEntries() throws IOException {
        this.entries.clear();
        if (Files.exists(this.archive, new LinkOption[0]) && Files.size(this.archive) > 0L) {
            this.zipFile = new ZipFile(this.archive.toFile());
            this.zipFile.stream().filter(e -> !e.isDirectory()).forEach(e -> this.entries.put(e.getName(), new Entry((ZipEntry)e, null)));
        }
    }

    private synchronized void openIfClosed() throws IOException {
        if (this.closed) {
            this.readEntries();
            this.modified = false;
            this.closed = false;
        }
    }

    private static class Entry {
        public ZipEntry ze;
        public File file;

        public Entry(ZipEntry ze, File file) {
            this.ze = ze;
            this.file = file;
        }

        public String toString() {
            return this.getClass().getName() + "[file=\"" + this.file + "\", ze=\"" + this.ze + "\"]";
        }
    }

    private class ZipArchiveInputStream
    extends FilterInputStream {
        private boolean closed;

        public ZipArchiveInputStream(InputStream in) {
            super(Objects.requireNonNull(in));
            this.closed = false;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                super.close();
            }
            finally {
                ZipArchive.this.r.unlock();
                this.closed = true;
            }
        }
    }

    private class ZipArchiveOutputStream
    extends CheckedOutputStream {
        private final ZipEntry entry;
        private long count;
        private boolean closed;

        public ZipArchiveOutputStream(OutputStream out, Checksum cksum, ZipEntry e) {
            super(Objects.requireNonNull(out), Objects.requireNonNull(cksum));
            this.count = 0L;
            this.closed = false;
            this.entry = Objects.requireNonNull(e);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            super.write(bytes, off, len);
            this.count += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            ++this.count;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.entry.setSize(this.count);
            this.entry.setCrc(this.getChecksum().getValue());
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                super.close();
            }
            finally {
                ZipArchive.this.w.unlock();
                this.closed = true;
            }
        }
    }
}

