/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Console;
import VASSAL.build.module.GlobalOptions;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.FontConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.QuickColors;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.swing.DataArchiveHTMLEditorKit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Chatter
extends JPanel
implements CommandEncoder,
Buildable,
DropTargetListener {
    private static final long serialVersionUID = 1L;
    protected JTextPane conversationPane;
    protected HTMLDocument doc;
    protected HTMLEditorKit kit;
    protected StyleSheet style;
    protected JTextField input;
    protected JScrollPane scroll = new ScrollPane(22, 30);
    protected JScrollPane scroll2 = new ScrollPane(22, 30);
    protected static final String MY_CHAT_COLOR = "HTMLChatColor";
    protected static final String OTHER_CHAT_COLOR = "HTMLotherChatColor";
    protected static final String GAME_MSG1_COLOR = "HTMLgameMessage1Color";
    protected static final String GAME_MSG2_COLOR = "HTMLgameMessage2Color";
    protected static final String GAME_MSG3_COLOR = "HTMLgameMessage3Color";
    protected static final String GAME_MSG4_COLOR = "HTMLgameMessage4Color";
    protected static final String GAME_MSG5_COLOR = "HTMLgameMessage5Color";
    protected static final String SYS_MSG_COLOR = "HTMLsystemMessageColor";
    protected Font myFont;
    protected Color gameMsg;
    protected Color gameMsg2;
    protected Color gameMsg3;
    protected Color gameMsg4;
    protected Color gameMsg5;
    protected Color systemMsg;
    protected Color myChat;
    protected Color otherChat;
    protected boolean needUpdate;
    protected DropTarget dt;
    protected JTextArea conversation;

    public static String getAnonymousUserName() {
        return Resources.getString("Chat.anonymous");
    }

    public Chatter() {
        this.setLayout(new BoxLayout(this, 1));
        this.conversation = new JTextArea();
        this.conversationPane = new JTextPane();
        this.conversationPane.setContentType("text/html");
        this.kit = new DataArchiveHTMLEditorKit(GameModule.getGameModule().getDataArchive());
        this.conversationPane.setEditorKit(this.kit);
        this.doc = (HTMLDocument)this.conversationPane.getDocument();
        this.style = this.kit.getStyleSheet();
        this.myFont = new Font("SansSerif", 0, 12);
        try {
            for (int i = 0; i < 30; ++i) {
                this.kit.insertHTML(this.doc, this.doc.getLength(), "<br>", 0, 0, null);
            }
        }
        catch (IOException | BadLocationException ble) {
            ErrorDialog.bug(ble);
        }
        this.conversationPane.setEditable(false);
        this.conversationPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Chatter.this.scroll.getVerticalScrollBar().setValue(Chatter.this.scroll.getVerticalScrollBar().getMaximum());
            }
        });
        this.input = new JTextField(60);
        this.input.setFocusTraversalKeysEnabled(false);
        this.input.addActionListener(e -> {
            this.send(this.formatChat(e.getActionCommand()), e.getActionCommand());
            this.input.setText("");
        });
        this.input.setMaximumSize(new Dimension(this.input.getMaximumSize().width, this.input.getPreferredSize().height));
        this.input.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int code = e.getKeyCode();
                Console console = GameModule.getGameModule().getConsole();
                String newCommand = null;
                switch (code) {
                    case 38: {
                        newCommand = console.commandsUp();
                        break;
                    }
                    case 40: {
                        newCommand = console.commandsDown();
                        break;
                    }
                    case 33: 
                    case 36: {
                        newCommand = console.commandsTop();
                        break;
                    }
                    case 34: 
                    case 35: {
                        newCommand = console.commandsBottom();
                    }
                }
                if (newCommand != null) {
                    Chatter.this.input.setText(newCommand);
                }
            }
        });
        FontMetrics fm = this.getFontMetrics(this.myFont);
        int fontHeight = fm.getHeight();
        this.conversationPane.setPreferredSize(new Dimension(this.input.getMaximumSize().width, fontHeight * 10));
        this.scroll.setViewportView(this.conversationPane);
        this.scroll.getVerticalScrollBar().setUnitIncrement(this.input.getPreferredSize().height);
        this.add(this.scroll);
        this.add(this.input);
        DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
        copyAction.putValue("Name", Resources.getString("General.copy"));
        final JPopupMenu pm = new JPopupMenu();
        pm.add(copyAction);
        this.conversationPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e);
                }
            }

            protected void doPopup(MouseEvent e) {
                pm.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        DefaultEditorKit.CutAction cutAction = new DefaultEditorKit.CutAction();
        cutAction.putValue("Name", Resources.getString("General.cut"));
        DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
        pasteAction.putValue("Name", Resources.getString("General.paste"));
        final JPopupMenu pm2 = new JPopupMenu();
        pm2.add(cutAction);
        pm2.add(copyAction);
        pm2.add(pasteAction);
        this.input.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e);
                }
            }

            protected void doPopup(MouseEvent e) {
                pm2.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.setPreferredSize(new Dimension(this.input.getMaximumSize().width, this.input.getPreferredSize().height + this.conversationPane.getPreferredSize().height));
        this.dt = new DropTarget(this.conversationPane, this);
    }

    protected void setChatterVisible(boolean vis) {
        this.conversationPane.setVisible(vis);
        this.input.setVisible(vis);
        this.scroll.setVisible(vis);
    }

    protected String formatChat(String text) {
        String id = GlobalOptions.getInstance().getPlayerId();
        return String.format("&lt;%s&gt; - %s", id.isEmpty() ? "(" + Chatter.getAnonymousUserName() + ")" : id, text);
    }

    public JTextField getInputField() {
        return this.input;
    }

    protected String getChatStyle(String s) {
        return s.startsWith(this.formatChat("").trim()) ? "mychat" : "other";
    }

    public boolean consoleHook(String s, String style, boolean html_allowed) {
        return GameModule.getGameModule().getConsole().exec(s, style, html_allowed);
    }

    public void show(String s) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doShow(s);
        } else {
            SwingUtilities.invokeLater(() -> this.doShow(s));
        }
    }

    private void doShow(String s) {
        String keystring;
        String replace;
        String style;
        boolean html_allowed;
        if (!(s = s.trim()).isEmpty()) {
            if (s.startsWith("*")) {
                html_allowed = QuickColors.getQuickColor(s, "*") >= 0 || GlobalOptions.getInstance().chatterHTMLSupport();
                style = QuickColors.getQuickColorHTMLStyle(s, "*");
                s = QuickColors.stripQuickColorTag(s, "*");
            } else if (s.startsWith("-")) {
                html_allowed = true;
                style = QuickColors.getQuickColor(s, "-") >= 0 ? QuickColors.getQuickColorHTMLStyle(s, "-") : "sys";
                s = QuickColors.stripQuickColorTag(s, "-");
            } else {
                style = this.getChatStyle(s);
                html_allowed = false;
            }
        } else {
            style = "msg";
            html_allowed = false;
        }
        if (!html_allowed) {
            s = s.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        if (!(replace = (keystring = Resources.getString("PlayerRoster.observer")).replace("<", "&lt;").replace(">", "&gt;")).equals(keystring)) {
            s = s.replace(keystring, replace);
        }
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength(), "\n<div class=" + style + ">" + s + "</div>", 0, 0, null);
        }
        catch (IOException | BadLocationException ble) {
            ErrorDialog.bug(ble);
        }
        this.conversationPane.repaint();
    }

    protected void addStyle(String s, Font f, Color c, String font_weight, int size) {
        if (this.style == null || c == null) {
            return;
        }
        this.style.addRule(s + " {color:" + String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue()) + "; font-family:" + f.getFamily() + "; font-size:" + (size > 0 ? size : f.getSize()) + "; " + (String)(!font_weight.isBlank() ? "font-weight:" + font_weight + "; " : "") + "}");
        this.style.addRule(s + "color {color:" + String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue()) + "; }");
    }

    protected void makeStyleSheet(Font f) {
        if (this.style == null) {
            return;
        }
        if (f == null) {
            if (this.myFont == null) {
                this.myFont = f = new Font("SansSerif", 0, 12);
            } else {
                f = this.myFont;
            }
        }
        this.addStyle(".msg", f, this.gameMsg, "", 0);
        this.addStyle(".msg2", f, this.gameMsg2, "", 0);
        this.addStyle(".msg3", f, this.gameMsg3, "", 0);
        this.addStyle(".msg4", f, this.gameMsg4, "", 0);
        this.addStyle(".msg5", f, this.gameMsg5, "", 0);
        this.addStyle(".mychat", f, this.myChat, "bold", 0);
        this.addStyle(".other ", f, this.otherChat, "bold", 0);
        this.addStyle(".sys", f, this.systemMsg, "", 0);
    }

    @Override
    public void setFont(Font f) {
        this.myFont = f;
        if (this.input != null) {
            if (this.input.getText().isEmpty()) {
                this.input.setText("XXX");
                this.input.setFont(f);
                this.input.setText("");
            } else {
                this.input.setFont(f);
            }
        }
        if (this.conversationPane != null) {
            this.conversationPane.setFont(f);
        }
        this.makeStyleSheet(f);
    }

    @Override
    public void build(Element e) {
    }

    @Override
    public Element getBuildElement(Document doc) {
        return doc.createElement(this.getClass().getName());
    }

    @Override
    public void addTo(Buildable b) {
        GameModule mod = (GameModule)b;
        mod.setChatter(this);
        mod.addCommandEncoder(this);
        mod.addKeyStrokeSource(new KeyStrokeSource(this, 1));
        FontConfigurer chatFont = new FontConfigurer("ChatFont", Resources.getString("Chatter.chat_font_preference"));
        chatFont.addPropertyChangeListener(evt -> this.setFont((Font)evt.getNewValue()));
        mod.getPlayerWindow().addChatter(this);
        chatFont.fireUpdate();
        mod.getPrefs().addOption(Resources.getString("Chatter.chat_window"), chatFont);
        Prefs globalPrefs = Prefs.getGlobalPrefs();
        ColorConfigurer gameMsgColor = new ColorConfigurer(GAME_MSG1_COLOR, Resources.getString("Chatter.game_messages_preference"), Color.black);
        gameMsgColor.addPropertyChangeListener(e -> {
            this.gameMsg = (Color)e.getNewValue();
            this.makeStyleSheet(null);
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), gameMsgColor);
        this.gameMsg = (Color)globalPrefs.getValue(GAME_MSG1_COLOR);
        ColorConfigurer gameMsg2Color = new ColorConfigurer(GAME_MSG2_COLOR, Resources.getString("Chatter.game_messages_preference_2"), new Color(0, 153, 51));
        gameMsg2Color.addPropertyChangeListener(e -> {
            this.gameMsg2 = (Color)e.getNewValue();
            this.makeStyleSheet(null);
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), gameMsg2Color);
        this.gameMsg2 = (Color)globalPrefs.getValue(GAME_MSG2_COLOR);
        ColorConfigurer gameMsg3Color = new ColorConfigurer(GAME_MSG3_COLOR, Resources.getString("Chatter.game_messages_preference_3"), new Color(255, 102, 102));
        gameMsg3Color.addPropertyChangeListener(e -> {
            this.gameMsg3 = (Color)e.getNewValue();
            this.makeStyleSheet(null);
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), gameMsg3Color);
        this.gameMsg3 = (Color)globalPrefs.getValue(GAME_MSG3_COLOR);
        ColorConfigurer gameMsg4Color = new ColorConfigurer(GAME_MSG4_COLOR, Resources.getString("Chatter.game_messages_preference_4"), new Color(255, 0, 0));
        gameMsg4Color.addPropertyChangeListener(e -> {
            this.gameMsg4 = (Color)e.getNewValue();
            this.makeStyleSheet(null);
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), gameMsg4Color);
        this.gameMsg4 = (Color)globalPrefs.getValue(GAME_MSG4_COLOR);
        ColorConfigurer gameMsg5Color = new ColorConfigurer(GAME_MSG5_COLOR, Resources.getString("Chatter.game_messages_preference_5"), new Color(153, 0, 153));
        gameMsg5Color.addPropertyChangeListener(e -> {
            this.gameMsg5 = (Color)e.getNewValue();
            this.makeStyleSheet(null);
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), gameMsg5Color);
        this.gameMsg5 = (Color)globalPrefs.getValue(GAME_MSG5_COLOR);
        ColorConfigurer systemMsgColor = new ColorConfigurer(SYS_MSG_COLOR, Resources.getString("Chatter.system_message_preference"), new Color(160, 160, 160));
        systemMsgColor.addPropertyChangeListener(e -> {
            this.systemMsg = (Color)e.getNewValue();
            this.makeStyleSheet(null);
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), systemMsgColor);
        this.systemMsg = (Color)globalPrefs.getValue(SYS_MSG_COLOR);
        ColorConfigurer myChatColor = new ColorConfigurer(MY_CHAT_COLOR, Resources.getString("Chatter.my_text_preference"), new Color(9, 32, 229));
        myChatColor.addPropertyChangeListener(e -> {
            this.myChat = (Color)e.getNewValue();
            this.makeStyleSheet(null);
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), myChatColor);
        this.myChat = (Color)globalPrefs.getValue(MY_CHAT_COLOR);
        ColorConfigurer otherChatColor = new ColorConfigurer(OTHER_CHAT_COLOR, Resources.getString("Chatter.other_text_preference"), new Color(0, 153, 255));
        otherChatColor.addPropertyChangeListener(e -> {
            this.otherChat = (Color)e.getNewValue();
            this.makeStyleSheet(null);
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), otherChatColor);
        this.otherChat = (Color)globalPrefs.getValue(OTHER_CHAT_COLOR);
        this.makeStyleSheet(this.myFont);
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public Command decode(String s) {
        if (!s.startsWith("CHAT")) {
            return null;
        }
        return new DisplayText(this, s.substring("CHAT".length()));
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof DisplayText)) {
            return null;
        }
        return "CHAT" + ((DisplayText)c).getMessage();
    }

    public void send(String msg) {
        if (msg != null && !msg.isEmpty()) {
            this.show(msg);
            GameModule.getGameModule().sendAndLog(new DisplayText(this, msg));
        }
    }

    public void send(String msg, String console) {
        if (!this.consoleHook(console, "", false)) {
            this.send(msg);
        }
    }

    public static void warning(String msg) {
        Chatter chatter = GameModule.getGameModule().getChatter();
        chatter.send(msg);
    }

    public void keyCommand(KeyStroke e) {
        if (!(e.getKeyCode() != 0 && e.getKeyCode() != 65535 || Character.isISOControl(e.getKeyChar()))) {
            if ((e.getModifiers() & 0x2280) != 0) {
                return;
            }
            this.input.setText(this.input.getText() + e.getKeyChar());
        } else if (e.isOnKeyRelease()) {
            switch (e.getKeyCode()) {
                case 10: {
                    if (!this.input.getText().isEmpty()) {
                        this.send(this.formatChat(this.input.getText()), this.input.getText());
                    }
                    this.input.setText("");
                    break;
                }
                case 8: 
                case 127: {
                    String s = this.input.getText();
                    if (s.isEmpty()) break;
                    this.input.setText(s.substring(0, s.length() - 1));
                }
            }
        }
    }

    public static void main(String[] args) {
        Chatter chat = new Chatter();
        JFrame f = new JFrame();
        f.add(chat);
        f.pack();
        f.setVisible(true);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public String getHandle() {
        return GlobalOptions.getInstance().getPlayerId();
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        GameModule.getGameModule().getGameState().dropFile(dtde);
    }

    public static class DisplayText
    extends Command {
        public static final String PREFIX = "CHAT";
        private String msg;
        private final Chatter c;

        public DisplayText(Chatter c, String s) {
            this.c = c;
            this.msg = s;
            this.msg = this.msg.startsWith("<>") ? "&lt;(" + Chatter.getAnonymousUserName() + ")&gt;" + s.substring(2) : s;
        }

        @Override
        public void executeCommand() {
            this.c.show(this.msg);
        }

        @Override
        public Command myUndoCommand() {
            return new DisplayText(this.c, Resources.getString("Chatter.undo_message", this.msg));
        }

        public String getMessage() {
            return this.msg;
        }

        @Override
        public String getDetails() {
            return this.msg;
        }
    }
}

